/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble.Worker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_SharedData;
import com.PecosCore.Refraction.IRefractionStaticsProject;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class EnsembleWorker_Sequence
extends GenericObjectListener
implements GenericObjectListener.Listener,
Serializable {
    protected SequenceType m_type = SequenceType.Interactive;
    public boolean IsInputSequence = false;
    protected boolean m_bIsDirty = false;
    public MessageDataStruct MessageData = new MessageDataStruct();
    public boolean DoNotEmitMessages = false;
    public EnsembleWorker_SharedData SharedData = new EnsembleWorker_SharedData();
    protected ArrayList<EnsembleWorker_Base> m_sequence = new ArrayList();
    public boolean ErrorOccurred = false;
    protected int m_selectedIndex = -1;
    protected boolean m_wasLMOApplied = false;
    protected boolean m_wasMoveoutTrendApplied = false;
    protected boolean m_wasDelayTimeModelApplied = false;
    protected PickPlaneEnum m_pickPlane;
    protected double m_sparseCmpX;
    protected double m_sparseCmpY;

    public EnsembleWorker_Sequence(SequenceType type) {
        this.m_type = type;
    }

    public EnsembleWorker_Sequence newClone(boolean mustBeOn) {
        try {
            EnsembleWorker_Sequence sequence = new EnsembleWorker_Sequence(this.m_type);
            for (EnsembleWorker_Base worker : this.m_sequence) {
                if (!worker.WorkerTurnedOn && mustBeOn) continue;
                sequence.add(worker.cloneWithParameterTree());
            }
            return sequence;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void setDistanceUnits(String sUnits) {
        try {
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.DistanceUnits = sUnits;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setRefractionStaticsProject(IRefractionStaticsProject project) {
        try {
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.setRefractionStaticsProject(project);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setInteractiveMode(boolean bInteractive) {
        try {
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.InteractiveMode = bInteractive;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public SequenceType getType() {
        return this.m_type;
    }

    public void setIsInputSequence(boolean isInputSequence) {
        try {
            this.IsInputSequence = isInputSequence;
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.BelongsToInputSequence = this.IsInputSequence;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean isDirty() {
        return this.m_bIsDirty;
    }

    public void setDirty(boolean dirty) {
        this.m_bIsDirty = dirty;
    }

    public void emit(MessageType message, Object data) {
        try {
            if (this.DoNotEmitMessages) {
                return;
            }
            this.MessageData.Type = message;
            this.MessageData.ExtraData = data;
            this.MessageData.SelectedChanged = this.MessageData.Type == MessageType.SelectedChanged;
            this.MessageData.JustProcessed = this.MessageData.Type == MessageType.JustProcessed;
            this.MessageData.SequenceModified = this.MessageData.Type == MessageType.SequenceModified;
            this.MessageData.MessageFromWorker = this.MessageData.Type == MessageType.MessageFromWorker;
            this.broadcast(this, this.MessageData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void setSelectedIndex(int index) {
        try {
            this.m_selectedIndex = Math.max(index, 0);
            this.m_selectedIndex = Math.min(index, this.size() - 1);
            this.emit(MessageType.SelectedChanged, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean wasLMOApplied() {
        return this.m_wasLMOApplied;
    }

    public boolean wasMoveoutTrendApplied() {
        return this.m_wasMoveoutTrendApplied;
    }

    public boolean wasDelayTimeModelApplied() {
        return this.m_wasDelayTimeModelApplied;
    }

    public void getParametersFromWidgets() {
        try {
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.getParametersFromWidget();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public EnsembleWorker_Base getSelectedWorker() {
        try {
            if (this.m_selectedIndex < 0 || this.m_selectedIndex >= this.m_sequence.size()) {
                return null;
            }
            return this.m_sequence.get(this.m_selectedIndex);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void runSequenceInProcessMode() {
        try {
            if (this.m_type != SequenceType.Processing) {
                throw new Exception("Type != SequenceType.Processing");
            }
            if (this.m_sequence.size() < 1) {
                return;
            }
            EnsembleWorker_Base source = this.m_sequence.get(0);
            if (!source.isEnsembleSource()) {
                return;
            }
            if (this.SharedData.InputEnsemble == null) {
                return;
            }
            this.SharedData.Type = SequenceType.Processing;
            Ensemble ensemble = this.SharedData.InputEnsemble.clone();
            this.m_wasLMOApplied = false;
            this.m_wasDelayTimeModelApplied = false;
            this.m_wasMoveoutTrendApplied = false;
            for (int n = 1; n < this.m_sequence.size(); ++n) {
                EnsembleWorker_Base worker = this.m_sequence.get(n);
                if (!worker.WorkerTurnedOn) continue;
                worker.performWork(ensemble);
                if (worker.outputValid(0)) {
                    ensemble = worker.output(0);
                }
                this.m_wasLMOApplied = this.m_wasLMOApplied || worker.uniqueID().equalsIgnoreCase("EnsembleWorker_ApplyLinearMoveout");
                this.m_wasMoveoutTrendApplied = this.m_wasMoveoutTrendApplied || worker.uniqueID().equalsIgnoreCase("EnsembleWorker_ApplyMoveoutTrend");
                this.m_wasDelayTimeModelApplied = this.m_wasDelayTimeModelApplied || worker.uniqueID().equalsIgnoreCase("EnsembleWorker_DelayTimeShifts");
            }
            this.emit(MessageType.JustProcessed, null);
            this.SharedData.OutputEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (this.m_type == SequenceType.Processing) {
                this.runSequenceInProcessMode();
                return;
            }
            if (this.m_type == SequenceType.Interactive) {
                for (EnsembleWorker_Base worker : this.m_sequence) {
                    if (sender != worker || data == null || !(data instanceof String)) continue;
                    String message = (String)data;
                    if (message.equalsIgnoreCase("Modified")) {
                        this.emit(MessageType.SequenceModified, null);
                    }
                    if (message.equalsIgnoreCase("SendMessageToOwner")) {
                        this.emit(MessageType.MessageFromWorker, worker);
                    }
                    this.m_bIsDirty = true;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clear() {
        this.m_sequence.clear();
    }

    public void toggle_unlocked() {
        try {
            boolean changed = false;
            for (int n = 0; n < this.m_sequence.size(); ++n) {
                EnsembleWorker_Base worker = this.m_sequence.get(n);
                if (worker.WorkerToggleLocked) continue;
                worker.WorkerTurnedOn = !worker.WorkerTurnedOn;
                changed = true;
            }
            boolean bl = this.m_bIsDirty = this.m_bIsDirty || changed;
            if (changed) {
                this.emit(MessageType.SequenceModified, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void toggleSelected() {
        try {
            if (this.m_selectedIndex < 0 || this.m_selectedIndex >= this.m_sequence.size()) {
                return;
            }
            EnsembleWorker_Base worker = this.m_sequence.get(this.m_selectedIndex);
            boolean bl = worker.WorkerTurnedOn = !worker.WorkerTurnedOn;
            if (worker.uniqueID().equals("EnsembleWorker_shot_correl_fb_pick")) {
                this.emit(MessageType.SequenceModified, "EnsembleWorker_shot_correl_fb_pick");
            } else {
                this.emit(MessageType.SequenceModified, null);
            }
            this.m_bIsDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void moveEarlier() {
        try {
            if (this.m_selectedIndex < 1 || this.m_selectedIndex >= this.m_sequence.size()) {
                return;
            }
            if (this.m_selectedIndex == 1 && this.m_sequence.get(0).isEnsembleSource()) {
                return;
            }
            EnsembleWorker_Base worker = this.m_sequence.remove(this.m_selectedIndex);
            this.m_sequence.add(this.m_selectedIndex - 1, worker);
            this.setSelectedIndex(this.m_selectedIndex - 1);
            this.emit(MessageType.SequenceModified, null);
            this.m_bIsDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void moveLater() {
        try {
            if (this.m_selectedIndex < 0 || this.m_selectedIndex >= this.m_sequence.size() - 1) {
                return;
            }
            if (this.m_selectedIndex == 0 && this.m_sequence.get(0).isEnsembleSource()) {
                return;
            }
            EnsembleWorker_Base worker = this.m_sequence.remove(this.m_selectedIndex);
            this.m_sequence.add(this.m_selectedIndex + 1, worker);
            this.setSelectedIndex(this.m_selectedIndex + 1);
            this.emit(MessageType.SequenceModified, null);
            this.m_bIsDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int size() {
        return this.m_sequence.size();
    }

    public EnsembleWorker_Base worker(int index) {
        return this.m_sequence.get(index);
    }

    public void remove() {
        try {
            if (this.m_selectedIndex >= 0 && this.m_selectedIndex < this.m_sequence.size()) {
                this.m_sequence.remove(this.m_selectedIndex);
            }
            this.setSelectedIndex(0);
            this.emit(MessageType.SequenceModified, null);
            this.m_bIsDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasEnsembleSource() {
        try {
            for (EnsembleWorker_Base worker : this.m_sequence) {
                if (!worker.isEnsembleSource()) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected void addBasic(EnsembleWorker_Base worker) {
        try {
            this.m_sequence.add(worker);
            worker.SharedData = this.SharedData;
            worker.addListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void add(EnsembleWorker_Base worker, boolean emitSignal) {
        try {
            this.add(worker, emitSignal, true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void add(EnsembleWorker_Base worker, boolean emitSignal, boolean connectWorkerListener) {
        try {
            if (worker == null) {
                return;
            }
            worker.BelongsToInputSequence = this.IsInputSequence;
            if (worker.isEnsembleSource() && this.m_type == SequenceType.Interactive) {
                JOptionPane.showMessageDialog(null, "Sequence cannot have an ensemble source", "Cannot add worker", 0);
                return;
            }
            if (worker.isEnsembleSource() && this.hasEnsembleSource()) {
                JOptionPane.showMessageDialog(null, "Sequence already has a source", "Cannot add worker", 0);
                return;
            }
            if (worker.isEnsembleSource() && this.m_type == SequenceType.Interactive) {
                JOptionPane.showMessageDialog(null, "Sequence cannot have an ensemble source", "Cannot add worker", 0);
                return;
            }
            if (worker.isEnsembleSource()) {
                if (this.m_sequence.size() >= 1) {
                    this.m_sequence.add(0, worker);
                } else {
                    this.m_sequence.add(worker);
                }
                this.setSelectedIndex(0);
            } else {
                this.m_sequence.add(worker);
                this.setSelectedIndex(this.size() - 1);
            }
            worker.SharedData = this.SharedData;
            if (connectWorkerListener) {
                worker.addListener(this);
            }
            worker.setPickPlane(this.m_pickPlane);
            if (emitSignal) {
                this.emit(MessageType.SequenceModified, null);
            }
            this.m_bIsDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void add(EnsembleWorker_Base worker) {
        try {
            this.add(worker, true);
            worker.SharedData = this.SharedData;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean requiresTraceTableColumns() {
        try {
            for (EnsembleWorker_Base worker : this.m_sequence) {
                if (!worker.WorkerTurnedOn || !worker.requiresTraceTableColumns()) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void workInPlace(Ensemble ensemble) throws Exception {
        try {
            if (this.m_type != SequenceType.Interactive) {
                throw new Exception("Type != SequenceType.Interactive");
            }
            this.SharedData.InputEnsemble = ensemble;
            this.SharedData.Type = SequenceType.Interactive;
            this.m_wasLMOApplied = false;
            this.m_wasDelayTimeModelApplied = false;
            this.m_wasMoveoutTrendApplied = false;
            for (EnsembleWorker_Base worker : this.m_sequence) {
                if (!worker.WorkerTurnedOn) continue;
                worker.performWork(ensemble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Ensemble work(Ensemble ensemble) throws Exception {
        try {
            if (this.m_type != SequenceType.Interactive) {
                throw new Exception("Type != SequenceType.Interactive");
            }
            this.SharedData.InputEnsemble = ensemble;
            this.SharedData.Type = SequenceType.Interactive;
            this.m_wasLMOApplied = false;
            this.m_wasDelayTimeModelApplied = false;
            this.m_wasMoveoutTrendApplied = false;
            for (EnsembleWorker_Base worker : this.m_sequence) {
                if (!worker.WorkerTurnedOn) continue;
                worker.performWork(ensemble);
                if (worker.outputValid(0)) {
                    ensemble = worker.output(0);
                }
                this.m_wasLMOApplied = this.m_wasLMOApplied || worker.uniqueID().equalsIgnoreCase("EnsembleWorker_ApplyLinearMoveout");
                this.m_wasMoveoutTrendApplied = this.m_wasMoveoutTrendApplied || worker.uniqueID().equalsIgnoreCase("EnsembleWorker_ApplyMoveoutTrend");
                this.m_wasDelayTimeModelApplied = this.m_wasDelayTimeModelApplied || worker.uniqueID().equalsIgnoreCase("EnsembleWorker_DelayTimeShifts");
            }
            this.emit(MessageType.JustProcessed, null);
            this.SharedData.OutputEnsemble = ensemble;
            return ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane) {
        try {
            this.m_pickPlane = pickPlane;
            System.out.println("EnsembleWorker_Sequence setPickPlane(): " + String.valueOf((Object)pickPlane));
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.setPickPlane(pickPlane);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSparseCmpX(double x) {
        try {
            this.m_sparseCmpX = x;
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.setSparseCmpX(x);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSparseCmpY(double y) {
        try {
            this.m_sparseCmpY = y;
            for (EnsembleWorker_Base worker : this.m_sequence) {
                worker.setSparseCmpY(y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static enum SequenceType {
        Interactive,
        Processing;

    }

    public class MessageDataStruct {
        public MessageType Type = MessageType.SequenceModified;
        public Object ExtraData = null;
        public boolean SelectedChanged;
        public boolean JustProcessed;
        public boolean SequenceModified;
        public boolean MessageFromWorker;
    }

    public static enum MessageType {
        SelectedChanged,
        JustProcessed,
        SequenceModified,
        MessageFromWorker;

    }
}

