/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.Column_Double;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Color;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class EnsembleTrace
implements Serializable {
    protected FloatArrayWrapper m_data = null;
    protected Column_Abstract m_header = null;
    protected HashMap<String, FloatArrayWrapper> m_supplementalHash;
    protected AutoPickData m_pickData;
    public byte[] RawSegyHeader;
    protected DelayTimePickError m_dtPickErrorData;
    protected GeometryError m_geomErrorData;
    public PaintInfo PlotData = new PaintInfo();
    public boolean ShotKilled = false;
    public boolean ReceiverKilled = false;
    public boolean TraceKilled = false;
    public boolean AzimuthAccepted = true;
    public double AnalysisTimeMin = 0.0;
    public double AnalysisTimeMax = 0.0;
    public int AnalysisTimePixelMin;
    public int AnalysisTimePixelMax;
    public float StretchMuteTime = 0.0f;
    public boolean Removed = false;
    public boolean TooNoisy = false;
    public boolean DC_Biased = false;
    public boolean PureDC = false;
    public boolean Marker = false;
    public boolean SelectedFlag = false;
    public boolean FlaggedForInputEnsemble = true;
    public boolean SelectedUsingControlPoints = false;
    public ByteBuffer RawByteBuffer = null;
    public int StackTraceID = -9999;
    public boolean ShiftsOK = false;
    public float ShiftVel = 10000.0f;
    public float ShiftTT = 0.0f;
    public float ShiftDT = 0.0f;
    public float ShiftUpholeCorrection = 0.0f;

    public boolean hasSupplementalData(String key) {
        try {
            if (this.m_supplementalHash == null) {
                this.m_supplementalHash = new HashMap();
            }
            return this.m_supplementalHash.containsKey(key);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public FloatArrayWrapper getSupplementalData(String key) {
        try {
            if (this.m_supplementalHash == null) {
                this.m_supplementalHash = new HashMap();
            }
            if (this.m_supplementalHash.containsKey(key)) {
                return this.m_supplementalHash.get(key);
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void putSupplementalData(String key, FloatArrayWrapper data) {
        try {
            if (this.m_supplementalHash == null) {
                this.m_supplementalHash = new HashMap();
            }
            if (this.m_supplementalHash.containsKey(key)) {
                this.m_supplementalHash.remove(key);
            }
            if (data != null) {
                this.m_supplementalHash.put(key, data);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void putSupplementalData(String key, float[] data, float digi, float t0) {
        try {
            if (data == null) {
                return;
            }
            if (data.length < 2) {
                return;
            }
            FloatArrayWrapper tempWrapper = new FloatArrayWrapper();
            tempWrapper.insertArray(data, data.length);
            tempWrapper.setSampleInterval(digi);
            tempWrapper.setFirstSampleCoord(t0);
            if (this.m_supplementalHash == null) {
                this.m_supplementalHash = new HashMap();
            }
            if (this.m_supplementalHash.containsKey(key)) {
                this.m_supplementalHash.remove(key);
            }
            if (data != null) {
                this.m_supplementalHash.put(key, tempWrapper);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public AutoPickData pickData() {
        if (this.m_pickData == null) {
            this.m_pickData = new AutoPickData();
        }
        return this.m_pickData;
    }

    public void insertRawSegyHeaderBytes(byte[] header) {
        try {
            if (header == null) {
                return;
            }
            if (header.length < 1) {
                return;
            }
            if (this.RawSegyHeader == null) {
                this.RawSegyHeader = new byte[header.length];
            }
            for (int n = 0; n < this.RawSegyHeader.length; ++n) {
                this.RawSegyHeader[n] = header[n];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public DelayTimePickError delayTimePickErrorData() {
        if (this.m_dtPickErrorData == null) {
            this.m_dtPickErrorData = new DelayTimePickError();
        }
        return this.m_dtPickErrorData;
    }

    public GeometryError geometryErrorData() {
        if (this.m_geomErrorData == null) {
            this.m_geomErrorData = new GeometryError();
        }
        return this.m_geomErrorData;
    }

    public CubicTraceInterpolator getCubicTraceInterpolator() {
        try {
            CubicTraceInterpolator cti = new CubicTraceInterpolator();
            cti.prepareInput(this);
            return cti;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public boolean traceOkay() {
        boolean killed = this.ShotKilled || this.ReceiverKilled || this.TraceKilled;
        return this.AzimuthAccepted && !killed && !this.Removed && !this.TooNoisy && !this.DC_Biased && !this.PureDC;
    }

    public EnsembleTrace() throws Exception {
        try {
            this.m_header = new Column_Double("TraceHeader", 30);
            this.m_data = new FloatArrayWrapper();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public EnsembleTrace(int initialHeaderSize) throws Exception {
        try {
            initialHeaderSize = Math.max(initialHeaderSize, 20);
            this.m_header = new Column_Double("TraceHeader", initialHeaderSize);
            this.m_data = new FloatArrayWrapper();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected EnsembleTrace(Column_Abstract header, FloatArrayWrapper data) throws Exception {
        try {
            this.m_header = header.createExactCopy();
            this.m_data = data.createExactCopy();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public EnsembleTrace createExactCopy() throws Exception {
        try {
            EnsembleTrace newTrace = new EnsembleTrace(this.m_header, this.m_data);
            newTrace.AzimuthAccepted = this.AzimuthAccepted;
            newTrace.Removed = this.Removed;
            newTrace.PureDC = this.PureDC;
            newTrace.DC_Biased = this.DC_Biased;
            newTrace.TooNoisy = this.TooNoisy;
            newTrace.ShotKilled = this.ShotKilled;
            newTrace.ReceiverKilled = this.ReceiverKilled;
            newTrace.TraceKilled = this.TraceKilled;
            newTrace.SelectedUsingControlPoints = this.SelectedUsingControlPoints;
            if (this.RawSegyHeader != null) {
                newTrace.RawSegyHeader = new byte[this.RawSegyHeader.length];
                for (int n = 0; n < this.RawSegyHeader.length; ++n) {
                    newTrace.RawSegyHeader[n] = this.RawSegyHeader[n];
                }
            }
            return newTrace;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean hasData() {
        if (this.m_data == null) {
            return false;
        }
        return this.m_data.length() >= 1;
    }

    public FloatArrayWrapper data() {
        return this.m_data;
    }

    public Column_Abstract header() {
        return this.m_header;
    }

    public float[] normalize() throws Exception {
        try {
            if (!this.hasData()) {
                throw new Exception("EnsembleTrace.normalize() no data!");
            }
            if (!this.traceOkay()) {
                throw new Exception("EnsembleTrace.normalize() trace killed!");
            }
            double sum = 0.0;
            for (int n = 0; n < this.m_data.length(); ++n) {
                sum += (double)this.m_data.getSample(n);
            }
            double mean = sum / (double)this.m_data.length();
            double[] temp = new double[this.m_data.length()];
            double sqSum = 1.0E-20;
            for (int n = 0; n < this.m_data.length(); ++n) {
                double diff;
                temp[n] = diff = (double)this.m_data.getSample(n) - mean;
                sqSum += diff * diff;
            }
            double stdev = Math.sqrt(sqSum / (double)(this.m_data.length() - 1));
            if (this.m_data.length() == 1) {
                stdev = 1.0;
            }
            float[] normalized = new float[this.m_data.length()];
            for (int n = 0; n < this.m_data.length(); ++n) {
                normalized[n] = (float)(temp[n] / stdev);
            }
            return normalized;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static class AutoPickData
    implements Serializable {
        public boolean GoodEdge = false;
        public boolean PickValid = false;
        public boolean SetToKilled = false;
    }

    public static class DelayTimePickError
    implements Serializable {
        public float PickError = -9999.0f;
        public int Branch = 0;
    }

    public static class GeometryError
    implements Serializable {
        public boolean Killed = false;
        public boolean CoordsOK = false;
        public double ShotX = 0.0;
        public double ShotY = 0.0;
        public double ReceiverX = 0.0;
        public double ReceiverY = 0.0;
        public double Offset = 0.0;
        public double Azimuth = 0.0;
        public int Branch = 0;
        public float Pick = -9999.0f;
        public float[] ShotDelayTime = new float[10];
        public float[] ReceiverDelayTime = new float[10];
        public double ShotDeltaX = 0.0;
        public double ShotDeltaY = 0.0;
        public double ReceiverDeltaX = 0.0;
        public double ReceiverDeltaY = 0.0;
        public double InitialShotDeltaX = 0.0;
        public double InitialShotDeltaY = 0.0;
        public double InitialReceiverDeltaX = 0.0;
        public double InitialReceiverDeltaY = 0.0;
        public int ErrorStickPixelX = -9999;
        public int ErrorStickPixelY = -9999;

        public void clear() {
            this.Killed = false;
            this.ShotDeltaX = 0.0;
            this.ShotDeltaY = 0.0;
            this.ReceiverDeltaX = 0.0;
            this.ReceiverDeltaY = 0.0;
        }

        public void prepOffAz() {
            this.CoordsOK = true;
            double dx = this.ReceiverX - this.ShotX;
            double dy = this.ReceiverY - this.ShotY;
            this.Offset = Math.sqrt(dx * dx + dy * dy + 1.0E-40);
            this.Azimuth = 0.0;
            if (this.Offset > 0.01) {
                this.Azimuth = Math.atan2(dy, dx);
            }
        }
    }

    public static class PaintInfo
    implements Serializable {
        public float WiggleScalar = 1.0f;
        public double WorldX;
        public int PixelX = -999999;
        public boolean Visible = false;
        public boolean DataOK = false;
        public boolean InsideViewport = false;
        public boolean ShowBranch = false;
        public boolean IsInBranch = true;
        public boolean ShowTrace = true;
        public double ScaleY;
        public double ShiftY;
        public double InverseScaleY;
        public double InverseShiftY;
        public boolean ColorOverride = false;
        public Color OverrideColor = null;
    }
}

