/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.AzimuthSelector;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import java.awt.Color;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Ensemble
implements Serializable {
    public static final int Magic = 8899123;
    protected ParameterTree m_parameterTree = new ParameterTree();
    protected ArrayList<EnsembleTrace> m_list = new ArrayList();
    protected int m_usedTraceCount = 0;
    protected EnsembleHeaderDictionary m_dictionary = new EnsembleHeaderDictionary();
    protected transient EnsembleFirstBreakPickPlotData m_fpbPlotData = null;
    protected boolean m_bChildEnsemble = false;
    public boolean CrudePositionEstimateValid = false;
    public double CrudePositionEstimateX = 0.0;
    public double CrudePositionEstimateY = 0.0;
    public double CrudePositionEstimateDistance = 0.0;
    public double CrudePositionEstimateAzimuth = 0.0;
    public boolean ColorBackground = false;
    public Color BackColor = new Color(255, 255, 128);
    public String BackColorTable = "Receiver";
    public String BackColorColumn = "LineNumber";
    protected PredictedCoordinates m_predictedCoordinates;
    public int NearestShotID = -9999;
    public int NearestReceiverID = -9999;
    protected TraceSorter_Double m_sorterDouble = null;
    protected TraceSorter_Long m_sorterLong = null;
    protected TraceSorter_Int m_sorterInt = null;
    protected int m_maxBranchIndex = 8;
    public int[] HeaderIndex_ShotDTAnisAz = new int[this.m_maxBranchIndex];
    public int[] HeaderIndex_ShotDTAnisMag = new int[this.m_maxBranchIndex];
    public int[] HeaderIndex_ShotDT = new int[this.m_maxBranchIndex];
    public int[] HeaderIndex_ShotVel = new int[this.m_maxBranchIndex];
    public int HeaderIndex_ShotX;
    public int HeaderIndex_ShotY;
    public int[] HeaderIndex_RecDTAnisAz = new int[this.m_maxBranchIndex];
    public int[] HeaderIndex_RecDTAnisMag = new int[this.m_maxBranchIndex];
    public int[] HeaderIndex_RecDT = new int[this.m_maxBranchIndex];
    public int[] HeaderIndex_RecVel = new int[this.m_maxBranchIndex];
    public int HeaderIndex_RecX;
    public int HeaderIndex_RecY;
    public int[] HeaderIndex_TravelTime = new int[this.m_maxBranchIndex];

    public ParameterTree parameterTree() {
        return this.m_parameterTree;
    }

    public void setParameterTree(ParameterTree tree) {
        if (tree != null) {
            this.m_parameterTree = tree;
        }
    }

    public void cmp_SetTwoDim(double x, double y, int bin, int r) {
        try {
            this.m_parameterTree.bool_put("CMP_Valid", true);
            this.m_parameterTree.bool_put("CMP_TwoDim", true);
            this.m_parameterTree.bool_put("CMP_ThreeDim", false);
            this.m_parameterTree.int_put("CMP_Bin2D", bin);
            this.m_parameterTree.int_put("CMP_Inline", -999999);
            this.m_parameterTree.int_put("CMP_Crossline", -999999);
            this.m_parameterTree.int_put("CMP_Radius", r);
            this.m_parameterTree.double_put("CMP_WorldX", x);
            this.m_parameterTree.double_put("CMP_WorldY", y);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void cmp_SetThreeDim(double x, double y, int i, int c, int r) {
        try {
            this.m_parameterTree.bool_put("CMP_Valid", true);
            this.m_parameterTree.bool_put("CMP_TwoDim", false);
            this.m_parameterTree.bool_put("CMP_ThreeDim", true);
            this.m_parameterTree.int_put("CMP_Bin2D", -999999);
            this.m_parameterTree.int_put("CMP_Inline", i);
            this.m_parameterTree.int_put("CMP_Crossline", c);
            this.m_parameterTree.int_put("CMP_Radius", r);
            this.m_parameterTree.double_put("CMP_WorldX", x);
            this.m_parameterTree.double_put("CMP_WorldY", y);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public PredictedCoordinates predictedCoordinates() {
        if (this.m_predictedCoordinates == null) {
            this.m_predictedCoordinates = new PredictedCoordinates();
        }
        return this.m_predictedCoordinates;
    }

    public Ensemble() {
    }

    public Ensemble(EnsembleHeaderDictionary dict) {
        this.m_dictionary = dict;
    }

    public Ensemble(EnsembleHeaderDictionary dict, ArrayList<EnsembleTrace> list) {
        this.m_dictionary = dict;
        this.m_list = list;
        this.m_usedTraceCount = list.size();
        this.m_bChildEnsemble = true;
    }

    public void filterAzimuth(AzimuthSelector as) {
        try {
            if (!this.m_dictionary.containsEntry("Trace", "Azimuth")) {
                return;
            }
            int startListSize = this.m_list.size();
            int index = this.m_dictionary.getEntryIndex("Trace", "Azimuth");
            ArrayList<EnsembleTrace> deadList = new ArrayList<EnsembleTrace>();
            int numOkay = 0;
            for (int n = this.m_usedTraceCount - 1; n >= 0; --n) {
                EnsembleTrace trace = this.m_list.get(n);
                double az = this.m_list.get(n).header().getDouble(index);
                if (!as.accept(az)) {
                    deadList.add(trace);
                    this.m_list.remove(n);
                    continue;
                }
                ++numOkay;
            }
            this.m_usedTraceCount = numOkay;
            for (EnsembleTrace trace : deadList) {
                this.m_list.add(trace);
            }
            int endListSize = this.m_list.size();
            if (endListSize != startListSize) {
                throw new Exception("endListSize != startListSize");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void filter(String table, String column, double min, double max) {
        try {
            if (!this.m_dictionary.containsEntry(table, column)) {
                return;
            }
            int startListSize = this.m_list.size();
            int index = this.m_dictionary.getEntryIndex(table, column);
            ArrayList<EnsembleTrace> deadList = new ArrayList<EnsembleTrace>();
            int numOkay = 0;
            for (int n = this.m_usedTraceCount - 1; n >= 0; --n) {
                EnsembleTrace trace = this.m_list.get(n);
                double v = this.m_list.get(n).header().getDouble(index);
                if (v < min || v > max) {
                    deadList.add(trace);
                    this.m_list.remove(n);
                    continue;
                }
                ++numOkay;
            }
            this.m_usedTraceCount = numOkay;
            for (EnsembleTrace trace : deadList) {
                this.m_list.add(trace);
            }
            int endListSize = this.m_list.size();
            if (endListSize != startListSize) {
                throw new Exception("endListSize != startListSize");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void filter_inside(String table, String column, double min, double max) {
        try {
            if (!this.m_dictionary.containsEntry(table, column)) {
                return;
            }
            int startListSize = this.m_list.size();
            int index = this.m_dictionary.getEntryIndex(table, column);
            ArrayList<EnsembleTrace> deadList = new ArrayList<EnsembleTrace>();
            int numOkay = 0;
            for (int n = this.m_usedTraceCount - 1; n >= 0; --n) {
                EnsembleTrace trace = this.m_list.get(n);
                double v = this.m_list.get(n).header().getDouble(index);
                if (v > min && v < max) {
                    deadList.add(trace);
                    this.m_list.remove(n);
                    continue;
                }
                ++numOkay;
            }
            this.m_usedTraceCount = numOkay;
            for (EnsembleTrace trace : deadList) {
                this.m_list.add(trace);
            }
            int endListSize = this.m_list.size();
            if (endListSize != startListSize) {
                throw new Exception("endListSize != startListSize");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeSmallCoordTraces(double max) {
        try {
            this.filter_inside("Shot", "Easting", -10.0, 10.0);
            this.filter_inside("Shot", "Northing", -10.0, 10.0);
            this.filter_inside("Receiver", "Easting", -10.0, 10.0);
            this.filter_inside("Receiver", "Northing", -10.0, 10.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void decimate(int decimation) {
        try {
            if (decimation <= 1) {
                return;
            }
            if (decimation > 10000) {
                return;
            }
            if (this.m_usedTraceCount < 1) {
                return;
            }
            ArrayList<EnsembleTrace> decList = new ArrayList<EnsembleTrace>();
            for (int n = this.m_usedTraceCount - 1; n >= 0; n -= decimation) {
                EnsembleTrace trace = this.m_list.remove(n);
                decList.add(trace);
            }
            for (EnsembleTrace trace : decList) {
                this.m_list.add(0, trace);
            }
            this.m_usedTraceCount = decList.size();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void decimate_using_receiver_counts(int decimation, HashMap_Integers<Integer> fold_map, int defaultLineNumber, int defaultPointIndex) {
        try {
            if (decimation <= 1) {
                return;
            }
            if (decimation > 10000) {
                return;
            }
            if (this.m_usedTraceCount < 1) {
                return;
            }
            int headerIndex_Point = this.m_dictionary.getEntryIndex("Receiver", "PointNumber");
            int headerIndex_Line = -9999;
            int headerIndex_Index = -9999;
            if (this.m_dictionary.containsEntry("Receiver", "LineNumber")) {
                headerIndex_Line = this.m_dictionary.getEntryIndex("Receiver", "LineNumber");
            }
            if (this.m_dictionary.containsEntry("Receiver", "PointIndex")) {
                headerIndex_Index = this.m_dictionary.getEntryIndex("Receiver", "PointIndex");
            }
            int num_chunks_to_check = 1 + this.m_usedTraceCount / decimation;
            ArrayList<EnsembleTrace> decList = new ArrayList<EnsembleTrace>();
            for (int chunk = num_chunks_to_check; chunk >= 0; --chunk) {
                int start = chunk * decimation;
                int end = Math.min(start + decimation, this.m_usedTraceCount);
                int min_fold = 10000000;
                int min_fold_line = start;
                int min_fold_point = start;
                int min_fold_index = start;
                int min_fold_n = start;
                boolean min_fold_found = false;
                for (int n = start; n < end; ++n) {
                    Column_Abstract header = this.trace(n).header();
                    int line = defaultLineNumber;
                    int index = defaultPointIndex;
                    int point = header.getInt(headerIndex_Point);
                    if (headerIndex_Line >= 0) {
                        line = header.getInt(headerIndex_Line);
                    }
                    if (headerIndex_Index >= 0) {
                        index = header.getInt(headerIndex_Index);
                    }
                    min_fold_found = true;
                    if (fold_map.containsKey(line, point, index)) {
                        int fold = fold_map.get(line, point, index);
                        if (fold >= min_fold) continue;
                        min_fold = fold;
                        min_fold_n = n;
                        min_fold_line = line;
                        min_fold_point = point;
                        min_fold_index = index;
                        continue;
                    }
                    min_fold = 0;
                    min_fold_n = n;
                    min_fold_line = line;
                    min_fold_point = point;
                    min_fold_index = index;
                }
                if (!min_fold_found) continue;
                EnsembleTrace trace = this.m_list.remove(min_fold_n);
                --this.m_usedTraceCount;
                decList.add(trace);
                if (fold_map.containsKey(min_fold_line, min_fold_point, min_fold_index)) {
                    int fold = fold_map.get(min_fold_line, min_fold_point, min_fold_index);
                    fold_map.put(new Integer(fold + 1), min_fold_line, min_fold_point, min_fold_index);
                    continue;
                }
                fold_map.put(new Integer(1), min_fold_line, min_fold_point, min_fold_index);
            }
            for (EnsembleTrace trace : decList) {
                this.m_list.add(0, trace);
            }
            this.m_usedTraceCount = decList.size();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setKilledFlag(boolean[] killed) {
        try {
            int index = this.m_dictionary.getEntryIndex("Trace", "Killed");
            for (int n = this.m_usedTraceCount - 1; n >= 0; --n) {
                EnsembleTrace trace = this.m_list.get(n);
                trace.header().putBool(index, killed[n]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeKilledTraces() {
        try {
            if (!this.m_dictionary.containsEntry("Trace", "Killed")) {
                return;
            }
            int startListSize = this.m_list.size();
            int index = this.m_dictionary.getEntryIndex("Trace", "Killed");
            ArrayList<EnsembleTrace> deadList = new ArrayList<EnsembleTrace>();
            int numOkay = 0;
            for (int n = this.m_usedTraceCount - 1; n >= 0; --n) {
                EnsembleTrace trace = this.m_list.get(n);
                boolean killed = trace.header().getBool(index);
                double v = this.m_list.get(n).header().getDouble(index);
                if (killed) {
                    deadList.add(trace);
                    this.m_list.remove(n);
                    continue;
                }
                ++numOkay;
            }
            this.m_usedTraceCount = numOkay;
            for (EnsembleTrace trace : deadList) {
                this.m_list.add(trace);
            }
            int endListSize = this.m_list.size();
            if (endListSize != startListSize) {
                throw new Exception("endListSize != startListSize");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public EnsembleTrace getNearestTrace_Pixel(int pixel) {
        try {
            this.NearestReceiverID = -9999;
            this.NearestShotID = -9999;
            int minDist = 300;
            int nearest = -9999;
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                int dist;
                if (!this.trace((int)n).PlotData.Visible || (dist = Math.abs(this.trace((int)n).PlotData.PixelX - pixel)) >= minDist) continue;
                nearest = n;
                minDist = dist;
            }
            if (nearest >= 0) {
                EnsembleTrace trace = this.trace(nearest);
                if (this.dictionary().containsEntry("Shot", "ShotID") && this.dictionary().containsEntry("Receiver", "ReceiverID")) {
                    int indexShotID = this.dictionary().getEntryIndex("Shot", "ShotID");
                    int indexReceiverID = this.dictionary().getEntryIndex("Receiver", "ReceiverID");
                    this.NearestReceiverID = trace.header().getInt(indexReceiverID);
                    this.NearestShotID = trace.header().getInt(indexShotID);
                }
                return this.trace(nearest);
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void resetAllKillFlags() {
        try {
            this.killDcBiasFlags();
            this.killNoiseFlags();
            this.resetRemoveFlags();
            this.resetAzimuthFlag();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void resetStartTimes() {
        try {
            for (EnsembleTrace trace : this.m_list) {
                trace.data().resetFirstSampleCoord();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void resetAzimuthFlag() {
        try {
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                this.trace((int)n).AzimuthAccepted = true;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void resetRemoveFlags() {
        try {
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                this.trace((int)n).Removed = false;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void killDcBiasFlags() {
        try {
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                this.trace((int)n).DC_Biased = false;
                this.trace((int)n).PureDC = false;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void killNoiseFlags() {
        try {
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                this.trace((int)n).TooNoisy = false;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void setSelectedFlag(boolean flag) {
        try {
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                this.trace((int)n).SelectedFlag = flag;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void expandTimeRange(Range_Double range) {
        try {
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                EnsembleTrace trace = this.trace(n);
                if (!trace.hasData()) continue;
                double t1 = trace.data().getFirstSampleCoord_WithShifts();
                double t2 = t1 + (double)((float)trace.data().length() * trace.data().getSampleInterval());
                range.expandRange(t1);
                range.expandRange(t2);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void resetDictionary(EnsembleHeaderDictionary dict) {
        this.m_dictionary = dict;
    }

    public Ensemble clone() {
        try {
            Ensemble e = new Ensemble();
            this.copyToOtherEnsemble(e);
            return e;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void copyToOtherEnsemble(Ensemble otherEnsemble) throws Exception {
        try {
            this.copyToOtherEnsemble(otherEnsemble, 1);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setAllHeadersToDefaultValue(EnsembleTrace trace, double dDefaultValue) throws Exception {
        Column_Abstract thisHeader = trace.header();
        int numHeaders = this.m_dictionary.size();
        for (int h = 0; h < numHeaders; ++h) {
            thisHeader.putDouble(h, dDefaultValue);
        }
    }

    public void copyHeadersToOtherEnsemble(EnsembleTrace thisTrace, EnsembleTrace otherTrace) throws Exception {
        otherTrace.AzimuthAccepted = thisTrace.AzimuthAccepted;
        otherTrace.Removed = thisTrace.Removed;
        otherTrace.DC_Biased = thisTrace.DC_Biased;
        otherTrace.TooNoisy = thisTrace.TooNoisy;
        otherTrace.ShotKilled = thisTrace.ShotKilled;
        otherTrace.ReceiverKilled = thisTrace.ReceiverKilled;
        otherTrace.TraceKilled = thisTrace.TraceKilled;
        Column_Abstract thisHeader = thisTrace.header();
        Column_Abstract otherHeader = otherTrace.header();
        int numHeaders = this.m_dictionary.size();
        for (int h = 0; h < numHeaders; ++h) {
            double v = thisHeader.getDouble(h);
            otherHeader.putDouble(h, v);
        }
    }

    public void mergeDictionaryIntoOtherEnsemble(Ensemble otherEnsemble) throws Exception {
        try {
            int nThisDictionarySize = this.m_dictionary.size();
            int nOtherDictionarySize = otherEnsemble.m_dictionary.size();
            if (nOtherDictionarySize >= nThisDictionarySize) {
                boolean bOtherDictionaryContainsAllEntries = true;
                for (int i = 0; i < nThisDictionarySize; ++i) {
                    EnsembleHeaderDictionary.Entry thisEntry = this.m_dictionary.getEntry(i);
                    EnsembleHeaderDictionary.Entry otherEntry = otherEnsemble.m_dictionary.getEntry(i);
                    if (!thisEntry.Table.equals(otherEntry.Table)) {
                        bOtherDictionaryContainsAllEntries = false;
                    }
                    if (thisEntry.Column.equals(otherEntry.Column)) continue;
                    bOtherDictionaryContainsAllEntries = false;
                }
                if (bOtherDictionaryContainsAllEntries) {
                    return;
                }
            }
            otherEnsemble.resetDictionary(this.m_dictionary.createExactCopy());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void copyToOtherEnsemble(Ensemble otherEnsemble, int numDupTraces) throws Exception {
        try {
            numDupTraces = Math.max(numDupTraces, 1);
            numDupTraces = Math.min(numDupTraces, 51);
            otherEnsemble.setParameterTree(this.m_parameterTree.createExactCopy());
            otherEnsemble.clearTraces(false);
            if (!this.m_dictionary.compare(otherEnsemble.dictionary())) {
                otherEnsemble.resetDictionary(this.m_dictionary.createExactCopy());
            }
            int numHeaders = this.m_dictionary.size();
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                EnsembleTrace trace = this.trace(n);
                for (int nd = 0; nd < numDupTraces; ++nd) {
                    EnsembleTrace otherTrace = otherEnsemble.addTrace();
                    otherTrace.AzimuthAccepted = trace.AzimuthAccepted;
                    otherTrace.Removed = trace.Removed;
                    otherTrace.DC_Biased = trace.DC_Biased;
                    otherTrace.TooNoisy = trace.TooNoisy;
                    otherTrace.ShotKilled = trace.ShotKilled;
                    otherTrace.ReceiverKilled = trace.ReceiverKilled;
                    otherTrace.TraceKilled = trace.TraceKilled;
                    Column_Abstract header = trace.header();
                    Column_Abstract otherHeader = otherTrace.header();
                    for (int h = 0; h < numHeaders; ++h) {
                        double v = header.getDouble(h);
                        otherHeader.putDouble(h, v);
                    }
                    FloatArrayWrapper data = trace.data();
                    FloatArrayWrapper otherData = otherTrace.data();
                    data.copyToFloatArrayWrapper(otherData);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void copyToOtherEnsemble_IntLimits(Ensemble otherEnsemble, String table1, String column1, int min1, int max1, String table2, String column2, int min2, int max2) throws Exception {
        try {
            boolean headerOkay;
            otherEnsemble.setParameterTree(this.m_parameterTree.createExactCopy());
            boolean bl = headerOkay = this.m_dictionary.containsEntry(table1, column1) && this.m_dictionary.containsEntry(table2, column2);
            if (!headerOkay) {
                this.copyToOtherEnsemble(otherEnsemble);
                return;
            }
            int index1 = this.m_dictionary.getEntryIndex(table1, column1);
            int index2 = this.m_dictionary.getEntryIndex(table2, column2);
            otherEnsemble.clearTraces(false);
            if (!this.m_dictionary.compare(otherEnsemble.dictionary())) {
                otherEnsemble.resetDictionary(this.m_dictionary.createExactCopy());
            }
            int numHeaders = this.m_dictionary.size();
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                EnsembleTrace trace = this.trace(n);
                int v1 = trace.header().getInt(index1);
                int v2 = trace.header().getInt(index2);
                if (v1 < min1 || v1 > max1 || v2 < min2 || v2 > max2) continue;
                EnsembleTrace otherTrace = otherEnsemble.addTrace();
                otherTrace.AzimuthAccepted = trace.AzimuthAccepted;
                otherTrace.Removed = trace.Removed;
                otherTrace.DC_Biased = trace.DC_Biased;
                otherTrace.TooNoisy = trace.TooNoisy;
                otherTrace.ShotKilled = trace.ShotKilled;
                otherTrace.ReceiverKilled = trace.ReceiverKilled;
                otherTrace.TraceKilled = trace.TraceKilled;
                Column_Abstract header = trace.header();
                Column_Abstract otherHeader = otherTrace.header();
                for (int h = 0; h < numHeaders; ++h) {
                    double v = header.getDouble(h);
                    otherHeader.putDouble(h, v);
                }
                FloatArrayWrapper data = trace.data();
                FloatArrayWrapper otherData = otherTrace.data();
                data.copyToFloatArrayWrapper(otherData);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void copyToOtherEnsemble_IntLimits(Ensemble otherEnsemble, String table1, String column1, int min1, int max1) throws Exception {
        try {
            otherEnsemble.setParameterTree(this.m_parameterTree.createExactCopy());
            boolean headerOkay = this.m_dictionary.containsEntry(table1, column1);
            if (!headerOkay) {
                this.copyToOtherEnsemble(otherEnsemble);
                return;
            }
            int index1 = this.m_dictionary.getEntryIndex(table1, column1);
            otherEnsemble.clearTraces(false);
            if (!this.m_dictionary.compare(otherEnsemble.dictionary())) {
                otherEnsemble.resetDictionary(this.m_dictionary.createExactCopy());
            }
            int numHeaders = this.m_dictionary.size();
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                EnsembleTrace trace = this.trace(n);
                int v1 = trace.header().getInt(index1);
                if (v1 < min1 || v1 > max1) continue;
                EnsembleTrace otherTrace = otherEnsemble.addTrace();
                otherTrace.AzimuthAccepted = trace.AzimuthAccepted;
                otherTrace.Removed = trace.Removed;
                otherTrace.DC_Biased = trace.DC_Biased;
                otherTrace.TooNoisy = trace.TooNoisy;
                otherTrace.ShotKilled = trace.ShotKilled;
                otherTrace.ReceiverKilled = trace.ReceiverKilled;
                otherTrace.TraceKilled = trace.TraceKilled;
                Column_Abstract header = trace.header();
                Column_Abstract otherHeader = otherTrace.header();
                for (int h = 0; h < numHeaders; ++h) {
                    double v = header.getDouble(h);
                    otherHeader.putDouble(h, v);
                }
                FloatArrayWrapper data = trace.data();
                FloatArrayWrapper otherData = otherTrace.data();
                data.copyToFloatArrayWrapper(otherData);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean isChildEnsemble() {
        return this.m_bChildEnsemble;
    }

    public void sortDouble(int startIndex, String table, String column) {
        try {
            startIndex = Math.max(startIndex, 0);
            if (!this.m_dictionary.containsEntry(table, column)) {
                return;
            }
            ArrayList<EnsembleTrace> tempList = new ArrayList<EnsembleTrace>();
            for (int n = startIndex; n < this.m_usedTraceCount; ++n) {
                tempList.add(this.m_list.get(n));
            }
            if (tempList.size() <= 1) {
                return;
            }
            if (this.m_sorterDouble == null) {
                this.m_sorterDouble = new TraceSorter_Double();
            }
            this.m_sorterDouble.HeaderIndex = this.m_dictionary.getEntryIndex(table, column);
            int lenBefore = this.m_list.size();
            Collections.sort(tempList, this.m_sorterDouble);
            for (int n = startIndex; n < this.m_usedTraceCount; ++n) {
                this.m_list.set(n, (EnsembleTrace)tempList.get(n));
            }
            int lenAfter = this.m_list.size();
            if (lenAfter != lenBefore) {
                System.err.println("lenAfter != lenBefore");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void sortLong(int startIndex, String table1, String column1, String table2, String column2) {
        try {
            startIndex = Math.max(startIndex, 0);
            if (!this.m_dictionary.containsEntry(table1, column1)) {
                return;
            }
            if (!this.m_dictionary.containsEntry(table2, column2)) {
                return;
            }
            ArrayList<EnsembleTrace> tempList = new ArrayList<EnsembleTrace>();
            for (int n = startIndex; n < this.m_usedTraceCount; ++n) {
                tempList.add(this.m_list.get(n));
            }
            if (tempList.size() <= 1) {
                return;
            }
            if (this.m_sorterLong == null) {
                this.m_sorterLong = new TraceSorter_Long();
            }
            this.m_sorterLong.HeaderIndex1 = this.m_dictionary.getEntryIndex(table1, column1);
            this.m_sorterLong.HeaderIndex2 = this.m_dictionary.getEntryIndex(table2, column2);
            int lenBefore = this.m_list.size();
            Collections.sort(tempList, this.m_sorterLong);
            for (int n = startIndex; n < this.m_usedTraceCount; ++n) {
                this.m_list.set(n, (EnsembleTrace)tempList.get(n));
            }
            int lenAfter = this.m_list.size();
            if (lenAfter != lenBefore) {
                System.err.println("lenAfter != lenBefore");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void sortInt(int startIndex, String table1, String column1, String table2, String column2) {
        try {
            startIndex = Math.max(startIndex, 0);
            if (!this.m_dictionary.containsEntry(table1, column1)) {
                return;
            }
            if (!this.m_dictionary.containsEntry(table2, column2)) {
                return;
            }
            ArrayList<EnsembleTrace> tempList = new ArrayList<EnsembleTrace>();
            for (int n = startIndex; n < this.m_usedTraceCount; ++n) {
                tempList.add(this.m_list.get(n));
            }
            if (tempList.size() <= 1) {
                return;
            }
            if (this.m_sorterInt == null) {
                this.m_sorterInt = new TraceSorter_Int();
            }
            this.m_sorterInt.HeaderIndex1 = this.m_dictionary.getEntryIndex(table1, column1);
            this.m_sorterInt.HeaderIndex2 = this.m_dictionary.getEntryIndex(table2, column2);
            int lenBefore = this.m_list.size();
            Collections.sort(tempList, this.m_sorterInt);
            for (int n = startIndex; n < this.m_usedTraceCount; ++n) {
                this.m_list.set(n, (EnsembleTrace)tempList.get(n));
            }
            int lenAfter = this.m_list.size();
            if (lenAfter != lenBefore) {
                System.err.println("lenAfter != lenBefore");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public EnsembleTrace addTrace() throws Exception {
        try {
            if (this.m_bChildEnsemble) {
                throw new Exception("Cannot add to child ensemble");
            }
            if (this.m_usedTraceCount < this.m_list.size()) {
                ++this.m_usedTraceCount;
                EnsembleTrace trace = this.m_list.get(this.m_usedTraceCount - 1);
                trace.AzimuthAccepted = true;
                trace.Removed = false;
                trace.PureDC = false;
                trace.TooNoisy = false;
                trace.DC_Biased = false;
                trace.TraceKilled = false;
                trace.ShotKilled = false;
                trace.ReceiverKilled = false;
                trace.Marker = false;
                trace.data().resetPolarity();
                trace.data().clear();
                return trace;
            }
            EnsembleTrace trace = new EnsembleTrace(this.m_dictionary.size() + 20);
            this.m_list.add(trace);
            this.m_usedTraceCount = this.m_list.size();
            return trace;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void removeTrace(int index) throws Exception {
        try {
            if (index < 0 || index >= this.m_usedTraceCount) {
                throw new Exception("((index < 0) || (index >= m_usedTraceCount))");
            }
            if (this.m_usedTraceCount > this.m_list.size()) {
                throw new Exception("m_usedTraceCount > m_list.size()");
            }
            EnsembleTrace trace = this.m_list.remove(index);
            this.m_list.add(trace);
            --this.m_usedTraceCount;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public EnsembleTrace trace(int index) throws Exception {
        try {
            if (index < 0 || index >= this.m_usedTraceCount) {
                throw new Exception("((index < 0) || (index >= m_usedTraceCount))");
            }
            if (this.m_usedTraceCount > this.m_list.size()) {
                throw new Exception("m_usedTraceCount > m_list.size()");
            }
            return this.m_list.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clearDictionary() throws Exception {
        try {
            if (this.m_bChildEnsemble) {
                throw new Exception("Cannot modify dict of child ensemble");
            }
            this.m_dictionary.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clearTraces(boolean bClearArray) throws Exception {
        try {
            this.CrudePositionEstimateValid = false;
            if (this.m_bChildEnsemble) {
                throw new Exception("Cannot clear tracs of child ensemble");
            }
            this.resetAllKillFlags();
            this.m_usedTraceCount = 0;
            if (bClearArray) {
                this.m_list.clear();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int traceCount() {
        return this.m_usedTraceCount;
    }

    public int traceCount_Okay() {
        try {
            int numOkay = 0;
            for (int n = 0; n < this.m_usedTraceCount; ++n) {
                if (!this.m_list.get(n).traceOkay()) continue;
                ++numOkay;
            }
            return numOkay;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public EnsembleHeaderDictionary dictionary() {
        return this.m_dictionary;
    }

    public EnsembleFirstBreakPickPlotData pickPlotData() throws Exception {
        try {
            if (this.m_fpbPlotData == null) {
                this.m_fpbPlotData = new EnsembleFirstBreakPickPlotData();
            }
            return this.m_fpbPlotData;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepDelayTimeAnalysisIndices() {
        try {
            this.HeaderIndex_ShotX = this.m_dictionary.getEntryIndex("Shot", "Easting");
            this.HeaderIndex_ShotY = this.m_dictionary.getEntryIndex("Shot", "Northing");
            this.HeaderIndex_RecX = this.m_dictionary.getEntryIndex("Receiver", "Easting");
            this.HeaderIndex_RecY = this.m_dictionary.getEntryIndex("Receiver", "Northing");
            for (int n = 0; n < this.m_maxBranchIndex; ++n) {
                this.HeaderIndex_TravelTime[n] = -9999;
                String colName = "TravelTime" + Integer.toString(n);
                if (!this.m_dictionary.containsEntry("Trace", colName)) continue;
                this.HeaderIndex_TravelTime[n] = this.m_dictionary.getEntryIndex("Trace", colName);
            }
            for (int b = 1; b < this.m_maxBranchIndex; ++b) {
                String colNameVel;
                String colNameDT;
                String colNameDTAnisAz;
                this.HeaderIndex_ShotVel[b] = -9999;
                this.HeaderIndex_ShotDT[b] = -9999;
                this.HeaderIndex_ShotDTAnisAz[b] = -9999;
                this.HeaderIndex_ShotDTAnisMag[b] = -9999;
                this.HeaderIndex_RecVel[b] = -9999;
                this.HeaderIndex_RecDT[b] = -9999;
                this.HeaderIndex_RecDTAnisAz[b] = -9999;
                this.HeaderIndex_RecDTAnisMag[b] = -9999;
                String colNameDTAnisMag = Pecos.getColNameDtAnisMag(b);
                if (this.m_dictionary.containsEntry("Shot", colNameDTAnisMag)) {
                    this.HeaderIndex_ShotDTAnisMag[b] = this.m_dictionary.getEntryIndex("Shot", colNameDTAnisMag);
                }
                if (this.m_dictionary.containsEntry("Receiver", colNameDTAnisMag)) {
                    this.HeaderIndex_RecDTAnisMag[b] = this.m_dictionary.getEntryIndex("Receiver", colNameDTAnisMag);
                }
                if (this.m_dictionary.containsEntry("Shot", colNameDTAnisAz = Pecos.getColNameDtAnisAz(b))) {
                    this.HeaderIndex_ShotDTAnisAz[b] = this.m_dictionary.getEntryIndex("Shot", colNameDTAnisAz);
                }
                if (this.m_dictionary.containsEntry("Receiver", colNameDTAnisAz)) {
                    this.HeaderIndex_RecDTAnisAz[b] = this.m_dictionary.getEntryIndex("Receiver", colNameDTAnisAz);
                }
                if (this.m_dictionary.containsEntry("Shot", colNameDT = Pecos.getColNameDT(b))) {
                    this.HeaderIndex_ShotDT[b] = this.m_dictionary.getEntryIndex("Shot", colNameDT);
                }
                if (this.m_dictionary.containsEntry("Receiver", colNameDT)) {
                    this.HeaderIndex_RecDT[b] = this.m_dictionary.getEntryIndex("Receiver", colNameDT);
                }
                if (this.m_dictionary.containsEntry("Shot", colNameVel = Pecos.getColNameVel(b))) {
                    this.HeaderIndex_ShotVel[b] = this.m_dictionary.getEntryIndex("Shot", colNameVel);
                }
                if (!this.m_dictionary.containsEntry("Receiver", colNameVel)) continue;
                this.HeaderIndex_RecVel[b] = this.m_dictionary.getEntryIndex("Receiver", colNameVel);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void readFromDatabaseBytes(byte[] bytes, boolean bIgnoreText) throws Exception {
        this.m_list.clear();
        this.m_dictionary = null;
        this.m_usedTraceCount = 0;
        this.m_bChildEnsemble = false;
        if (bytes == null) {
            throw new Exception("Null bytes");
        }
        EnsembleHeaderDictionary ensembleHeaderDictionary = new EnsembleHeaderDictionary();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int magic = buffer.getInt();
        if (magic != 8899123) {
            throw new Exception("Invalid magic");
        }
        int nHeaders = buffer.getInt();
        int nTraces = buffer.getInt();
        int nSamplesPerTrace = buffer.getInt();
        float[] sampleArray = new float[nSamplesPerTrace];
        float fSampleInterval = (float)buffer.getDouble();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (int iHeader = 0; iHeader < nHeaders; ++iHeader) {
            int iDataType = buffer.getInt();
            int nTableNameLength = buffer.getInt();
            DataType dataType = DataType.typeFromTypeIndex(iDataType);
            dataTypes.add(dataType);
            StringBuilder sb = new StringBuilder();
            for (int iChar = 0; iChar < nTableNameLength; ++iChar) {
                char c = buffer.getChar();
                sb.append(c);
            }
            String sTableName = sb.toString();
            sTableName = sTableName.trim();
            int nColumnNameLength = buffer.getInt();
            sb = new StringBuilder();
            for (int iChar = 0; iChar < nColumnNameLength; ++iChar) {
                char c = buffer.getChar();
                sb.append(c);
            }
            String sColumnName = sb.toString();
            sColumnName = sColumnName.trim();
            ensembleHeaderDictionary.addEntry(sTableName, sColumnName, dataType);
        }
        this.m_dictionary = ensembleHeaderDictionary;
        for (int iTrace = 0; iTrace < nTraces; ++iTrace) {
            EnsembleTrace trace = this.addTrace();
            Column_Abstract headers = trace.header();
            FloatArrayWrapper samples = trace.data();
            samples.setSampleInterval(fSampleInterval);
            for (int iHeader = 0; iHeader < nHeaders; ++iHeader) {
                EnsembleHeaderDictionary.Entry entry = ensembleHeaderDictionary.getEntry(iHeader);
                double dVal = buffer.getDouble();
                headers.putDouble(iHeader, dVal);
            }
            int nsamp = buffer.getInt();
            for (int iSample = 0; iSample < nsamp; ++iSample) {
                float fSample;
                sampleArray[iSample] = fSample = buffer.getFloat();
            }
            samples.insertArray(sampleArray, nSamplesPerTrace);
        }
    }

    public static class PredictedCoordinates {
        public double CurrentX;
        public double ShiftX;
        public double CurrentY;
        public double ShiftY;
        public int ElementID = -9999;
        public boolean Valid = false;
    }

    public static class TraceSorter_Double
    implements Comparator<EnsembleTrace> {
        public int HeaderIndex = 0;

        @Override
        public int compare(EnsembleTrace t1, EnsembleTrace t2) {
            try {
                double h1 = t1.header().getDouble(this.HeaderIndex);
                double h2 = t2.header().getDouble(this.HeaderIndex);
                if (h1 > h2) {
                    return 1;
                }
                if (h1 < h2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }

    public static class TraceSorter_Long
    implements Comparator<EnsembleTrace> {
        public int HeaderIndex1 = 0;
        public int HeaderIndex2 = 0;

        @Override
        public int compare(EnsembleTrace t1, EnsembleTrace t2) {
            try {
                long h2_2;
                long h1_1 = t1.header().getLong(this.HeaderIndex1);
                long h2_1 = t2.header().getLong(this.HeaderIndex1);
                if (h1_1 > h2_1) {
                    return 1;
                }
                if (h1_1 < h2_1) {
                    return -1;
                }
                long h1_2 = t1.header().getLong(this.HeaderIndex2);
                if (h1_2 > (h2_2 = t2.header().getLong(this.HeaderIndex2))) {
                    return 1;
                }
                if (h1_2 < h2_2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }

    public static class TraceSorter_Int
    implements Comparator<EnsembleTrace> {
        public int HeaderIndex1 = 0;
        public int HeaderIndex2 = 0;

        @Override
        public int compare(EnsembleTrace t1, EnsembleTrace t2) {
            try {
                int h2_2;
                int h1_1 = t1.header().getInt(this.HeaderIndex1);
                int h2_1 = t2.header().getInt(this.HeaderIndex1);
                if (h1_1 > h2_1) {
                    return 1;
                }
                if (h1_1 < h2_1) {
                    return -1;
                }
                int h1_2 = t1.header().getInt(this.HeaderIndex2);
                if (h1_2 > (h2_2 = t2.header().getInt(this.HeaderIndex2))) {
                    return 1;
                }
                if (h1_2 < h2_2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }
}

