/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Synthetic;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class SyntheticCreator {
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected HashMap_Integer m_shotMap;
    protected HashMap_Integer m_receiverMap;
    protected int m_shotCount;
    protected int m_receiverCount;
    protected int m_shotFold;
    protected long m_traceCount;
    protected double m_shotSpacing;
    protected double m_shotLineSpacing;
    protected double m_receiverSpacing;
    protected double m_receiverLineSpacing;
    protected int m_shotsPerLine;
    protected int m_receiversPerLine;
    protected int m_shotLineCount;
    protected int m_receiverLineCount;
    protected double m_shotOriginX;
    protected double m_shotOriginY;
    protected double m_receiverOriginX;
    protected double m_receiverOriginY;
    protected double m_midpointX;
    protected double m_midpointY;
    protected double m_shotSpanX;
    protected double m_shotSpanY;
    protected double m_receiverSpanX;
    protected double m_receiverSpanY;
    protected int m_traceSpread;
    protected int m_traceLineSpread;
    protected double m_maxTime;
    protected double m_h0;
    protected double m_h1;
    protected double m_h2;
    protected double m_v0;
    protected double m_v1;
    protected double m_v2;
    protected double m_v3;
    public static final int SHOTCOUNT = 1000;
    public static final int RECEIVERCOUNT = 2000;
    public static final int SHOTFOLD = 500;
    public static final double SHOTSPACING = 100.0;
    public static final double SHOTLINESPACING = 800.0;
    public static final double RECEIVERSPACING = 100.0;
    public static final double RECEIVERLINESPACING = 800.0;
    public static final double MAXTIME = 2000.0;
    public static final double MIDX = 100000.0;
    public static final double MIDY = 100000.0;
    public static final double H0 = 300.0;
    public static final double H1 = 300.0;
    public static final double H2 = 300.0;
    public static final double V0 = 3000.0;
    public static final double V1 = 5000.0;
    public static final double V2 = 7000.0;
    public static final double V3 = 9000.0;

    public void createEnsemble(Ensemble ensemble, int shotID, boolean createData) {
        try {
            int[] receiverList;
            int indexHeaderShotPoint = ensemble.dictionary().addEntry("Shot", "PointNumber", DataType.Int);
            int indexHeaderShotLine = ensemble.dictionary().addEntry("Shot", "LineNumber", DataType.Int);
            int indexHeaderShotIndex = ensemble.dictionary().addEntry("Shot", "PointIndex", DataType.Int);
            int indexHeaderShotX = ensemble.dictionary().addEntry("Shot", "Easting", DataType.Double);
            int indexHeaderShotY = ensemble.dictionary().addEntry("Shot", "Northing", DataType.Double);
            int indexHeaderShotElev = ensemble.dictionary().addEntry("Shot", "Elevation", DataType.Double);
            int indexHeaderShotFFID = ensemble.dictionary().addEntry("Shot", "FFID", DataType.Int);
            int indexHeaderShotKilled = ensemble.dictionary().addEntry("Shot", "Killed", DataType.Bool);
            int indexHeaderReceiverPoint = ensemble.dictionary().addEntry("Receiver", "PointNumber", DataType.Int);
            int indexHeaderReceiverLine = ensemble.dictionary().addEntry("Receiver", "LineNumber", DataType.Int);
            int indexHeaderReceiverIndex = ensemble.dictionary().addEntry("Receiver", "PointIndex", DataType.Int);
            int indexHeaderReceiverX = ensemble.dictionary().addEntry("Receiver", "Easting", DataType.Double);
            int indexHeaderReceiverY = ensemble.dictionary().addEntry("Receiver", "Northing", DataType.Double);
            int indexHeaderReceiverElev = ensemble.dictionary().addEntry("Receiver", "Elevation", DataType.Double);
            int indexHeaderReceiverKilled = ensemble.dictionary().addEntry("Receiver", "Killed", DataType.Bool);
            int indexHeaderTraceCode = ensemble.dictionary().addEntry("Trace", "TraceCode", DataType.Int);
            int indexHeaderTraceCdpX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Double);
            int indexHeaderTraceCdpY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Double);
            int indexHeaderTraceInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
            int indexHeaderTraceCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
            int indexFBP = ensemble.dictionary().addEntry("Trace", "FBP_User", DataType.Int);
            int shotIndex = this.m_shotMap.get(shotID);
            int indexShotPoint = this.m_shotTable.column_indexOfColumn("PointNumber");
            int indexShotLine = this.m_shotTable.column_indexOfColumn("LineNumber");
            int indexShotIndex = this.m_shotTable.column_indexOfColumn("PointIndex");
            int indexShotX = this.m_shotTable.column_indexOfColumn("Easting");
            int indexShotY = this.m_shotTable.column_indexOfColumn("Northing");
            int indexShotFFID = this.m_shotTable.column_indexOfColumn("FFID");
            int indexShotKilled = this.m_shotTable.column_indexOfColumn("Killed");
            int indexReceiverPoint = this.m_receiverTable.column_indexOfColumn("PointNumber");
            int indexReceiverLine = this.m_receiverTable.column_indexOfColumn("LineNumber");
            int indexReceiverIndex = this.m_receiverTable.column_indexOfColumn("PointIndex");
            int indexReceiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            int indexReceiverKilled = this.m_receiverTable.column_indexOfColumn("Killed");
            int shotPoint = this.m_shotTable.getInt(shotIndex, indexShotPoint);
            int shotLine = this.m_shotTable.getInt(shotIndex, indexShotLine);
            int shotPIndex = this.m_shotTable.getInt(shotIndex, indexShotIndex);
            double shotX = this.m_shotTable.getDouble(shotIndex, indexShotX);
            double shotY = this.m_shotTable.getDouble(shotIndex, indexShotY);
            int ffid = this.m_shotTable.getInt(shotIndex, indexShotFFID);
            boolean shotKilled = this.m_shotTable.getBool(shotIndex, indexShotKilled);
            for (int rec : receiverList = this.findReceivers(shotID)) {
                EnsembleTrace trace = ensemble.addTrace();
                int receiverIndex = this.m_receiverMap.get(rec);
                int receiverPoint = this.m_receiverTable.getInt(receiverIndex, indexReceiverPoint);
                int receiverLine = this.m_receiverTable.getInt(receiverIndex, indexReceiverLine);
                int receiverPIndex = this.m_receiverTable.getInt(receiverIndex, indexReceiverIndex);
                double receiverX = this.m_receiverTable.getDouble(receiverIndex, indexReceiverX);
                double receiverY = this.m_receiverTable.getDouble(receiverIndex, indexReceiverY);
                boolean receiverKilled = this.m_receiverTable.getBool(receiverIndex, indexReceiverKilled);
                trace.header().putInt(indexHeaderTraceCode, 1);
                trace.header().putInt(indexHeaderShotPoint, shotPoint);
                trace.header().putInt(indexHeaderShotLine, shotLine);
                trace.header().putInt(indexHeaderShotIndex, shotPIndex);
                trace.header().putDouble(indexHeaderShotX, shotX);
                trace.header().putDouble(indexHeaderShotY, shotY);
                trace.header().putDouble(indexHeaderShotElev, 100.0);
                trace.header().putInt(indexHeaderShotFFID, ffid);
                trace.header().putBool(indexHeaderShotKilled, shotKilled);
                trace.header().putInt(indexHeaderReceiverPoint, receiverPoint);
                trace.header().putInt(indexHeaderReceiverLine, receiverLine);
                trace.header().putInt(indexHeaderReceiverIndex, receiverPIndex);
                trace.header().putDouble(indexHeaderReceiverX, receiverX);
                trace.header().putDouble(indexHeaderReceiverY, receiverY);
                trace.header().putDouble(indexHeaderReceiverElev, 100.0);
                trace.header().putBool(indexHeaderReceiverKilled, receiverKilled);
                double cdpX = (shotX + receiverX) / 2.0;
                double cdpY = (shotY + receiverY) / 2.0;
                int inline = (int)(cdpX / 100.0);
                int crossline = (int)(cdpY / 100.0);
                trace.header().putDouble(indexHeaderTraceCdpX, cdpX);
                trace.header().putDouble(indexHeaderTraceCdpY, cdpY);
                trace.header().putInt(indexHeaderTraceInline, inline);
                trace.header().putInt(indexHeaderTraceCrossline, crossline);
            }
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            if (createData) {
                double sampleInterval = 4.0;
                int sampleCount = (int)(0.5 + this.m_maxTime / sampleInterval);
                float[] data = new float[sampleCount];
                for (int t = 0; t < ensemble.traceCount(); ++t) {
                    EnsembleTrace trace = ensemble.trace(t);
                    double offset = trace.header().getDouble(indexOffset);
                    Arrays.fill(data, 0.0f);
                    double t0 = 1000.0 * offset / this.m_v0;
                    for (int s = 0; s < data.length; ++s) {
                        float dt = (float)Math.abs(0.001 * (t0 - (double)s * sampleInterval));
                        float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                        float v = 100.0f * exp;
                        data[s] = data[s] + v;
                    }
                    double dt1 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v1 * this.m_v1 - this.m_v0 * this.m_v0) / (this.m_v1 * this.m_v0);
                    double t1 = 2.0 * dt1 + 1000.0 * offset / this.m_v1;
                    for (int s = 0; s < data.length; ++s) {
                        float dt = (float)Math.abs(0.001 * (t1 - (double)s * sampleInterval));
                        float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                        float v = 100.0f * exp;
                        data[s] = data[s] + v;
                    }
                    double dt2 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v0 * this.m_v0) / (this.m_v2 * this.m_v0) + 1000.0 * this.m_h1 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v1 * this.m_v1) / (this.m_v2 * this.m_v1);
                    double t2 = 2.0 * dt2 + 1000.0 * offset / this.m_v2;
                    for (int s = 0; s < data.length; ++s) {
                        float dt = (float)Math.abs(0.001 * (t2 - (double)s * sampleInterval));
                        float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                        float v = 100.0f * exp;
                        data[s] = data[s] + v;
                    }
                    double dt3 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v0 * this.m_v0) / (this.m_v3 * this.m_v0) + 1000.0 * this.m_h1 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v1 * this.m_v1) / (this.m_v3 * this.m_v1) + 1000.0 * this.m_h2 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v2 * this.m_v2) / (this.m_v3 * this.m_v2);
                    double t3 = 2.0 * dt3 + 1000.0 * offset / this.m_v3;
                    for (int s = 0; s < data.length; ++s) {
                        float dt = (float)Math.abs(0.001 * (t3 - (double)s * sampleInterval));
                        float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                        float v = 100.0f * exp;
                        data[s] = data[s] + v;
                    }
                    double minTime01 = Math.min(t0, t1);
                    double minTime23 = Math.min(t2, t3);
                    double pickTime = Math.min(minTime01, minTime23);
                    trace.header().putInt(indexFBP, (int)pickTime);
                    trace.data().insertArray(data, sampleCount);
                    trace.data().setSampleInterval((float)sampleInterval);
                    trace.data().setFirstSampleCoord(0.0f);
                }
            } else {
                for (int t = 0; t < ensemble.traceCount(); ++t) {
                    EnsembleTrace trace = ensemble.trace(t);
                    float[] data = new float[1];
                    double offset = trace.header().getDouble(indexOffset);
                    double t0 = 1000.0 * offset / this.m_v0;
                    double dt1 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v1 * this.m_v1 - this.m_v0 * this.m_v0) / (this.m_v1 * this.m_v0);
                    double t1 = 2.0 * dt1 + 1000.0 * offset / this.m_v1;
                    double dt2 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v0 * this.m_v0) / (this.m_v2 * this.m_v0) + 1000.0 * this.m_h1 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v1 * this.m_v1) / (this.m_v2 * this.m_v1);
                    double t2 = 2.0 * dt2 + 1000.0 * offset / this.m_v2;
                    double dt3 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v0 * this.m_v0) / (this.m_v3 * this.m_v0) + 1000.0 * this.m_h1 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v1 * this.m_v1) / (this.m_v3 * this.m_v1) + 1000.0 * this.m_h2 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v2 * this.m_v2) / (this.m_v3 * this.m_v2);
                    double t3 = 2.0 * dt3 + 1000.0 * offset / this.m_v3;
                    double minTime01 = Math.min(t0, t1);
                    double minTime23 = Math.min(t2, t3);
                    double pickTime = Math.min(minTime01, minTime23);
                    trace.header().putInt(indexFBP, (int)pickTime);
                    trace.data().insertArray(data, 1);
                    trace.data().setSampleInterval(4.0f);
                    trace.data().setFirstSampleCoord(0.0f);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createGeometry(ParameterTree parameterTree) {
        try {
            double elevation;
            double northing;
            double easting;
            int pointNumber;
            int lineNumber;
            int point;
            int line;
            int id;
            this.m_shotCount = parameterTree.int_get("ShotCount", 1000);
            this.m_receiverCount = parameterTree.int_get("ReceiverCount", 2000);
            this.m_shotFold = parameterTree.int_get("ShotFold", 500);
            this.m_shotSpacing = parameterTree.double_get("ShotSpacing", 100.0);
            this.m_shotLineSpacing = parameterTree.double_get("ShotLineSpacing", 800.0);
            this.m_receiverSpacing = parameterTree.double_get("ReceiverSpacing", 100.0);
            this.m_receiverLineSpacing = parameterTree.double_get("ReceiverLineSpacing", 800.0);
            this.m_midpointX = parameterTree.double_get("MidpointX", 100000.0);
            this.m_midpointY = parameterTree.double_get("MidpointY", 100000.0);
            this.m_traceCount = this.m_shotCount * this.m_shotFold;
            this.m_maxTime = parameterTree.double_get("Time", 3000.0);
            this.m_shotTable.setName("Shot");
            this.m_receiverTable.setName("Receiver");
            int index_shotID = this.m_shotTable.column_append("ShotID", DataType.Int);
            int index_shotLine = this.m_shotTable.column_append("LineNumber", DataType.Int);
            int index_shotPoint = this.m_shotTable.column_append("PointNumber", DataType.Int);
            int index_shotIndex = this.m_shotTable.column_append("PointIndex", DataType.Int);
            int index_shotX = this.m_shotTable.column_append("Easting", DataType.Double);
            int index_shotY = this.m_shotTable.column_append("Northing", DataType.Double);
            int index_shotElevation = this.m_shotTable.column_append("Elevation", DataType.Double);
            int index_shotFFID = this.m_shotTable.column_append("FFID", DataType.Int);
            int index_shotKilled = this.m_shotTable.column_append("Killed", DataType.Bool);
            int index_receiverID = this.m_receiverTable.column_append("ReceiverID", DataType.Int);
            int index_receiverLine = this.m_receiverTable.column_append("LineNumber", DataType.Int);
            int index_receiverPoint = this.m_receiverTable.column_append("PointNumber", DataType.Int);
            int index_receiverIndex = this.m_receiverTable.column_append("PointIndex", DataType.Int);
            int index_receiverX = this.m_receiverTable.column_append("Easting", DataType.Double);
            int index_receiverY = this.m_receiverTable.column_append("Northing", DataType.Double);
            int index_receiverElevation = this.m_receiverTable.column_append("Elevation", DataType.Double);
            int index_receiverKilled = this.m_receiverTable.column_append("Killed", DataType.Bool);
            double y_sqrS = (double)this.m_shotCount * (this.m_shotLineSpacing / this.m_shotSpacing);
            double ySdouble = Math.sqrt(y_sqrS);
            this.m_shotsPerLine = (int)Math.sqrt(y_sqrS);
            double x_sqrR = (double)this.m_receiverCount * (this.m_receiverLineSpacing / this.m_receiverSpacing);
            double xRdouble = Math.sqrt(x_sqrR);
            this.m_receiversPerLine = (int)Math.sqrt(x_sqrR);
            this.m_shotLineCount = (int)Math.ceil((double)this.m_shotCount / ySdouble);
            this.m_receiverLineCount = (int)Math.ceil((double)this.m_receiverCount / xRdouble);
            this.m_shotSpanX = (double)(this.m_shotLineCount - 1) * this.m_shotLineSpacing;
            this.m_shotSpanY = (double)(this.m_shotsPerLine - 1) * this.m_shotSpacing;
            this.m_receiverSpanX = (double)(this.m_receiversPerLine - 1) * this.m_receiverSpacing;
            this.m_receiverSpanY = (double)(this.m_receiverLineCount - 1) * this.m_receiverLineSpacing;
            double spanX = Math.max(this.m_shotSpanX, this.m_receiverSpanX);
            double spanY = Math.max(this.m_shotSpanY, this.m_receiverSpanY);
            if (spanX / 2.0 >= this.m_midpointX) {
                this.m_midpointX = spanX / 2.0 + this.m_midpointX;
            }
            if (spanY / 2.0 >= this.m_midpointY) {
                this.m_midpointY = spanY / 2.0 + this.m_midpointY;
            }
            this.m_shotOriginX = this.m_midpointX - this.m_shotSpanX / 2.0;
            this.m_shotOriginY = this.m_midpointY - this.m_shotSpanY / 2.0;
            this.m_receiverOriginX = this.m_midpointX - this.m_receiverSpanX / 2.0;
            this.m_receiverOriginY = this.m_midpointY - this.m_receiverSpanY / 2.0;
            for (int shot = 0; shot < this.m_shotCount; ++shot) {
                id = shot + 1000;
                line = shot / this.m_shotsPerLine;
                point = shot % this.m_shotsPerLine;
                lineNumber = line + 100;
                pointNumber = point + 100;
                easting = (double)line * this.m_shotLineSpacing + this.m_shotOriginX;
                northing = (double)point * this.m_shotSpacing + this.m_shotOriginY;
                elevation = 100.0;
                int ffid = shot + 1;
                int row = this.m_shotTable.row_increment();
                this.m_shotTable.putInt(row, index_shotID, id);
                this.m_shotTable.putInt(row, index_shotLine, lineNumber);
                this.m_shotTable.putInt(row, index_shotPoint, pointNumber);
                this.m_shotTable.putInt(row, index_shotIndex, 1);
                this.m_shotTable.putDouble(row, index_shotX, easting);
                this.m_shotTable.putDouble(row, index_shotY, northing);
                this.m_shotTable.putDouble(row, index_shotElevation, elevation);
                this.m_shotTable.putInt(row, index_shotFFID, ffid);
                this.m_shotTable.putBool(row, index_shotKilled, false);
            }
            this.m_shotMap = this.m_shotTable.createMapID();
            for (int receiver = 0; receiver < this.m_receiverCount; ++receiver) {
                id = receiver + 1000;
                line = receiver / this.m_receiversPerLine;
                point = receiver % this.m_receiversPerLine;
                lineNumber = line + 100;
                pointNumber = point + 100;
                easting = (double)point * this.m_receiverSpacing + this.m_receiverOriginX;
                northing = (double)line * this.m_receiverLineSpacing + this.m_receiverOriginY;
                elevation = 100.0;
                int row = this.m_receiverTable.row_increment();
                this.m_receiverTable.putInt(row, index_receiverID, id);
                this.m_receiverTable.putInt(row, index_receiverLine, lineNumber);
                this.m_receiverTable.putInt(row, index_receiverPoint, pointNumber);
                this.m_receiverTable.putInt(row, index_receiverIndex, 1);
                this.m_receiverTable.putDouble(row, index_receiverX, easting);
                this.m_receiverTable.putDouble(row, index_receiverY, northing);
                this.m_receiverTable.putDouble(row, index_receiverElevation, elevation);
                this.m_receiverTable.putBool(row, index_receiverKilled, false);
            }
            this.m_receiverMap = this.m_receiverTable.createMapID();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int[] findReceivers(int shotID) {
        try {
            double x_sqr = (double)this.m_shotFold * (this.m_receiverLineSpacing / this.m_receiverSpacing);
            this.m_traceSpread = (int)Math.sqrt(x_sqr);
            double y_sqr = (double)this.m_shotFold * (this.m_receiverSpacing / this.m_receiverLineSpacing);
            this.m_traceLineSpread = (int)Math.sqrt(y_sqr);
            int[] receiverList = new int[this.m_shotFold];
            int shotRow = this.m_shotMap.get(shotID);
            int index_shotX = this.m_shotTable.column_indexOfColumn("Easting");
            int index_shotY = this.m_shotTable.column_indexOfColumn("Northing");
            double x = this.m_shotTable.getDouble(shotRow, index_shotX);
            double y = this.m_shotTable.getDouble(shotRow, index_shotY);
            int closestLine = (int)((y - this.m_receiverOriginY) / this.m_receiverLineSpacing);
            int closestPoint = (int)((x - this.m_receiverOriginX) / this.m_receiverSpacing);
            int lowerBoundLine = closestLine - this.m_traceLineSpread / 2;
            int upperBoundLine = closestLine + this.m_traceLineSpread / 2;
            int lowerBoundPoint = closestPoint - this.m_traceSpread / 2;
            int upperBoundPoint = closestPoint + this.m_traceSpread / 2;
            if (upperBoundLine >= this.m_receiverLineCount) {
                lowerBoundLine = this.m_receiverLineCount - this.m_traceLineSpread - 1;
                upperBoundLine = this.m_receiverLineCount - 1;
            }
            if (upperBoundPoint >= this.m_receiversPerLine) {
                lowerBoundPoint = this.m_receiversPerLine - this.m_traceSpread - 1;
                upperBoundLine = this.m_receiversPerLine - 1;
            }
            if (lowerBoundLine < 0) {
                lowerBoundLine = 0;
            }
            if (lowerBoundPoint < 0) {
                lowerBoundPoint = 0;
            }
            if (this.m_shotFold > this.m_receiverCount) {
                this.m_shotFold = this.m_receiverCount;
                this.m_traceSpread = this.m_receiversPerLine;
                this.m_traceLineSpread = this.m_receiverLineCount;
                lowerBoundPoint = 0;
                lowerBoundLine = 0;
            }
            int backIndex = 0;
            for (int rec = 0; rec < this.m_shotFold; ++rec) {
                int receiverID;
                int relPoint = rec % this.m_traceSpread;
                int point = lowerBoundPoint + relPoint;
                int relLine = rec / this.m_traceSpread;
                int line = lowerBoundLine + relLine;
                int receiver = point + line * this.m_receiversPerLine;
                if (receiver < 0) {
                    throw new Exception("Receiver number negative!  " + receiver);
                }
                if (receiver >= this.m_receiverCount) {
                    int receiverID3;
                    int receiverID2;
                    int receiver2;
                    int point2;
                    int line2;
                    boolean foo = false;
                    if (lowerBoundLine > 0) {
                        line2 = lowerBoundLine - 1;
                        point2 = lowerBoundPoint + backIndex;
                        receiver2 = point2 + line2 * this.m_receiversPerLine;
                        receiverList[rec] = receiverID2 = receiver2 + 1000;
                        ++backIndex;
                        continue;
                    }
                    if (lowerBoundPoint > 0) {
                        int receiverID32;
                        line2 = lowerBoundLine + backIndex;
                        point2 = lowerBoundPoint - 1;
                        if (line2 < this.m_receiverLineCount) {
                            receiver2 = point2 + line2 * this.m_receiversPerLine;
                            receiverList[rec] = receiverID2 = receiver2 + 1000;
                            ++backIndex;
                            continue;
                        }
                        int line3 = lowerBoundLine + backIndex - this.m_receiverLineCount;
                        int point3 = upperBoundPoint + 1;
                        int receiver3 = point3 + line3 * this.m_receiversPerLine;
                        receiverList[rec] = receiverID32 = receiver3 + 1000;
                        ++backIndex;
                        continue;
                    }
                    int line3 = lowerBoundLine + backIndex;
                    int point3 = upperBoundPoint + 1;
                    int receiver3 = point3 + line3 * this.m_receiversPerLine;
                    receiverList[rec] = receiverID3 = receiver3 + 1000;
                    ++backIndex;
                    continue;
                }
                receiverList[rec] = receiverID = receiver + 1000;
            }
            return receiverList;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void createBinaryPicks(ByteBuffer bb, FileChannel channel) throws Exception {
        long largepickcount = 0L;
        long pickcount = 0L;
        long printedpickcount = 0L;
        for (int shot = 0; shot < this.m_shotTable.row_count(); ++shot) {
            int[] receiverList;
            int indexShotID = this.m_shotTable.column_indexOfColumn("ShotID");
            int indexShotX = this.m_shotTable.column_indexOfColumn("Easting");
            int indexShotY = this.m_shotTable.column_indexOfColumn("Northing");
            int indexReceiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            int shotID = this.m_shotTable.getInt(shot, indexShotID);
            double shotX = this.m_shotTable.getDouble(shot, indexShotX);
            double shotY = this.m_shotTable.getDouble(shot, indexShotY);
            for (int rec : receiverList = this.findReceivers(shotID)) {
                double minTime23;
                int receiverIndex = this.m_receiverMap.get(rec);
                double receiverX = this.m_receiverTable.getDouble(receiverIndex, indexReceiverX);
                double receiverY = this.m_receiverTable.getDouble(receiverIndex, indexReceiverY);
                double offset = Math.sqrt((shotX - receiverX) * (shotX - receiverX) + (shotY - receiverY) * (shotY - receiverY));
                double t0 = 1000.0 * offset / this.m_v0;
                double dt1 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v1 * this.m_v1 - this.m_v0 * this.m_v0) / (this.m_v1 * this.m_v0);
                double t1 = 2.0 * dt1 + 1000.0 * offset / this.m_v1;
                double dt2 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v0 * this.m_v0) / (this.m_v2 * this.m_v0) + 1000.0 * this.m_h1 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v1 * this.m_v1) / (this.m_v2 * this.m_v1);
                double t2 = 2.0 * dt2 + 1000.0 * offset / this.m_v2;
                double dt3 = 1000.0 * this.m_h0 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v0 * this.m_v0) / (this.m_v3 * this.m_v0) + 1000.0 * this.m_h1 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v1 * this.m_v1) / (this.m_v3 * this.m_v1) + 1000.0 * this.m_h2 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v2 * this.m_v2) / (this.m_v3 * this.m_v2);
                double t3 = 2.0 * dt3 + 1000.0 * offset / this.m_v3;
                double minTime01 = Math.min(t0, t1);
                double pickTime = Math.min(minTime01, minTime23 = Math.min(t2, t3));
                if (!(pickTime > 0.0)) continue;
                bb.putInt(shotID);
                bb.putInt(rec);
                bb.putFloat((float)pickTime);
                if (pickTime > 1200.0) {
                    ++largepickcount;
                }
                if (++pickcount > 5000000L) {
                    System.out.println("Writing picks: " + (printedpickcount += 5000000L));
                    pickcount -= 5000000L;
                }
                bb.flip();
                channel.write(bb);
                bb.clear();
            }
        }
        System.out.println("Number of picks > 1200s: " + largepickcount);
    }

    public void setVelocityModel(ParameterTree paramTree) {
        try {
            this.m_h0 = paramTree.double_get("H0", 300.0);
            this.m_h1 = paramTree.double_get("H1", 300.0);
            this.m_h2 = paramTree.double_get("H2", 300.0);
            this.m_v0 = paramTree.double_get("V0", 3000.0);
            this.m_v1 = paramTree.double_get("V1", 5000.0);
            this.m_v2 = paramTree.double_get("V2", 7000.0);
            this.m_v3 = paramTree.double_get("V3", 9000.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int shotCount() {
        return this.m_shotCount;
    }

    public Table_Abstract getShotTable() {
        return this.m_shotTable;
    }

    public Table_Abstract getReceiverTable() {
        return this.m_receiverTable;
    }
}

