/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_XML;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterTree
implements Serializable {
    protected HashMap<String, String> m_hashString = new HashMap();
    protected HashSet<String> m_validStringHash = new HashSet();
    protected HashSet<String> m_validIntHash = new HashSet();
    protected HashSet<String> m_validLongHash = new HashSet();
    protected HashSet<String> m_validDoubleHash = new HashSet();
    protected HashSet<String> m_validBoolHash = new HashSet();
    protected HashSet<String> m_validDateHash = new HashSet();
    protected HashSet<String> m_validColorHash = new HashSet();
    protected HashMap<String, ArrayList<String>> m_hashStringList = new HashMap();
    protected HashMap<String, int[]> m_hashIntArray = new HashMap();
    protected HashMap<String, float[]> m_hashFloatArray = new HashMap();
    protected HashMap<String, ParameterTree> m_hashParameterTree = new HashMap();
    protected HashMap<String, Color> m_hashColor = new HashMap();

    public void print(int recursion) {
        try {
            Object prefix = "";
            for (int n = 0; n < recursion; ++n) {
                prefix = (String)prefix + "    ";
            }
            System.out.println("    ");
            System.out.println((String)prefix + "Tree output:");
            for (String key : this.m_hashString.keySet()) {
                System.out.println((String)prefix + "(key, val) = " + key + "," + this.m_hashString.get(key));
            }
            for (String key : this.m_hashStringList.keySet()) {
                ArrayList<String> list = this.m_hashStringList.get(key);
                System.out.println((String)prefix + "StringList: " + key);
                for (String v : list) {
                    System.out.println((String)prefix + "    " + v);
                }
            }
            for (String key : this.m_hashParameterTree.keySet()) {
                System.out.println((String)prefix + "Begin tree.print() for key = " + key);
                ParameterTree hasher = this.m_hashParameterTree.get(key);
                hasher.print(recursion + 1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public ParameterTree createExactCopy() {
        try {
            ParameterTree hash = new ParameterTree();
            for (String key : this.m_hashString.keySet()) {
                String v = this.m_hashString.get(key);
                hash.string_put(key, v);
            }
            for (String key : this.m_hashColor.keySet()) {
                Color c = this.m_hashColor.get(key);
                hash.color_put(key, c);
            }
            for (String key : this.m_hashStringList.keySet()) {
                ArrayList<String> list = this.m_hashStringList.get(key);
                ArrayList<String> newList = new ArrayList<String>();
                for (String s : list) {
                    newList.add(s);
                }
                hash.stringList_put(key, newList);
            }
            for (String key : this.m_hashParameterTree.keySet()) {
                ParameterTree hasher = this.m_hashParameterTree.get(key);
                ParameterTree newHasher = hasher.createExactCopy();
                hash.ParameterTree_put(key, newHasher);
            }
            return hash;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ParameterTree();
        }
    }

    public Set<String> getValidIntegerKeys() {
        return this.m_validIntHash;
    }

    public Set<String> getValidLongKeys() {
        return this.m_validLongHash;
    }

    public Set<String> getValidDoubleKeys() {
        return this.m_validDoubleHash;
    }

    public Set<String> getValidStringKeys() {
        return this.m_validStringHash;
    }

    public Set<String> getValidStringListKeys() {
        return this.m_hashStringList.keySet();
    }

    public Set<String> getValidBooleanKeys() {
        return this.m_validBoolHash;
    }

    public Set<String> getValidDateKeys() {
        return this.m_validDateHash;
    }

    public Set<String> getValidColorKeys() {
        return this.m_validColorHash;
    }

    public Set<String> getValidIntArrayKeys() {
        return this.m_hashIntArray.keySet();
    }

    public Set<String> getValidFloatArrayKeys() {
        return this.m_hashFloatArray.keySet();
    }

    public ArrayList<String> string_keyList() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (String key : this.m_hashString.keySet()) {
                list.add(key);
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public boolean string_exists(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            return this.m_hashString.containsKey(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setString(String key, String obj) throws Exception {
        this.string_put(key, obj);
        this.m_validStringHash.add(key);
    }

    public void string_put(String key, String obj) throws Exception {
        try {
            if (obj == null) {
                throw new Exception("obj == null");
            }
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (this.m_hashString.containsKey(key)) {
                this.m_hashString.remove(key);
            }
            this.m_hashString.put(key, obj);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public String string_get(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashString.containsKey(key)) {
                throw new Exception("Key not present");
            }
            return this.m_hashString.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public String string_get(String key, String defaultVal) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashString.containsKey(key)) {
                if (defaultVal.length() < 1) {
                    defaultVal = "Not set";
                }
                this.m_hashString.put(key, defaultVal);
            }
            return this.m_hashString.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void date_put(String key) throws Exception {
        try {
            Date date = new Date();
            this.string_put(key, date.toString());
            this.m_validDateHash.add(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean bool_exists(String key) throws Exception {
        try {
            return this.string_exists(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void bool_put(String key, boolean v) throws Exception {
        try {
            this.string_put(key, Boolean.toString(v));
            this.m_validBoolHash.add(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean bool_get(String key) throws Exception {
        try {
            String s = this.string_get(key);
            return Boolean.parseBoolean(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean bool_get(String key, boolean defaultVal) throws Exception {
        try {
            String s = this.string_get(key, Boolean.toString(defaultVal));
            return Boolean.parseBoolean(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean int_exists(String key) throws Exception {
        try {
            return this.string_exists(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void int_put(String key, int v) throws Exception {
        try {
            this.string_put(key, Integer.toString(v));
            this.m_validIntHash.add(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int int_get(String key) throws Exception {
        try {
            String s = this.string_get(key);
            return (int)Double.parseDouble(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int int_get(String key, int defaultVal) throws Exception {
        try {
            String s = this.string_get(key, Integer.toString(defaultVal));
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int int_get(JTextField txt, String key, int defaultVal) throws Exception {
        try {
            String s = this.string_get(key, Integer.toString(defaultVal));
            int v = Integer.parseInt(s);
            txt.setText(Integer.toString(v));
            return v;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean long_exists(String key) throws Exception {
        try {
            return this.string_exists(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void long_put(String key, long v) throws Exception {
        try {
            this.string_put(key, Long.toString(v));
            this.m_validLongHash.add(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public long long_get(String key) throws Exception {
        try {
            String s = this.string_get(key);
            return (long)Double.parseDouble(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean double_exists(String key) throws Exception {
        try {
            return this.string_exists(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void double_put(String key, double v) throws Exception {
        try {
            this.string_put(key, Double.toString(v));
            this.m_validDoubleHash.add(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double double_get(String key) throws Exception {
        try {
            String s = this.string_get(key);
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double double_get(String key, double defaultVal) throws Exception {
        try {
            String s = this.string_get(key, Double.toString(defaultVal));
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double double_get_range(String key, double defaultVal, double min, double max) throws Exception {
        try {
            String s = this.string_get(key, Double.toString(defaultVal));
            double v = Double.parseDouble(s);
            if (v < min) {
                v = min;
                this.string_put(key, Double.toString(v));
            }
            if (v > max) {
                v = max;
                this.string_put(key, Double.toString(v));
            }
            return v;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double double_get(JTextField txt, String key, double defaultVal) throws Exception {
        try {
            String s = this.string_get(key, Double.toString(defaultVal));
            double v = Double.parseDouble(s);
            txt.setText(Double.toString(v));
            return v;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean stringList_exists(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            return this.m_hashStringList.containsKey(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void stringList_put(String key, ArrayList<String> obj) throws Exception {
        try {
            if (obj == null) {
                throw new Exception("obj == null");
            }
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (this.m_hashStringList.containsKey(key)) {
                this.m_hashStringList.remove(key);
            }
            this.m_hashStringList.put(key, obj);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public ArrayList<String> stringList_get(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashStringList.containsKey(key)) {
                this.m_hashStringList.put(key, new ArrayList());
            }
            return this.m_hashStringList.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean intArray_exists(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            return this.m_hashIntArray.containsKey(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void intArray_put(String key, int[] obj) throws Exception {
        try {
            if (obj == null) {
                throw new Exception("obj == null");
            }
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (this.m_hashIntArray.containsKey(key)) {
                this.m_hashIntArray.remove(key);
            }
            this.m_hashIntArray.put(key, obj);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int[] intArray_get(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashIntArray.containsKey(key)) {
                this.m_hashIntArray.put(key, new int[0]);
            }
            return this.m_hashIntArray.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean floatArray_exists(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            return this.m_hashFloatArray.containsKey(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void floatArray_put(String key, float[] obj) throws Exception {
        try {
            if (obj == null) {
                throw new Exception("obj == null");
            }
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (this.m_hashFloatArray.containsKey(key)) {
                this.m_hashFloatArray.remove(key);
            }
            this.m_hashFloatArray.put(key, obj);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float[] floatArray_get(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashFloatArray.containsKey(key)) {
                this.m_hashFloatArray.put(key, new float[0]);
            }
            return this.m_hashFloatArray.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean ParameterTree_exists(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            return this.m_hashParameterTree.containsKey(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void ParameterTree_put(String key, ParameterTree obj) throws Exception {
        try {
            if (obj == null) {
                throw new Exception("obj == null");
            }
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (this.m_hashParameterTree.containsKey(key)) {
                this.m_hashParameterTree.remove(key);
            }
            this.m_hashParameterTree.put(key, obj);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public ParameterTree ParameterTree_get(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashParameterTree.containsKey(key)) {
                this.m_hashParameterTree.put(key, new ParameterTree());
            }
            return this.m_hashParameterTree.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean color_exists(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            return this.m_hashColor.containsKey(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void color_put(String key, Color obj) throws Exception {
        try {
            if (obj == null) {
                throw new Exception("obj == null");
            }
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (this.m_hashColor.containsKey(key)) {
                this.m_hashColor.remove(key);
            }
            this.m_hashColor.put(key, obj);
            this.m_validColorHash.add(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Color color_get(String key) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashColor.containsKey(key)) {
                throw new Exception("Key not present");
            }
            return this.m_hashColor.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Color color_get(String key, Color defaultVal) throws Exception {
        try {
            if (key.length() < 1) {
                throw new Exception("Bad key");
            }
            if (!this.m_hashColor.containsKey(key)) {
                if (defaultVal == null) {
                    throw new Exception("defaultVal = null");
                }
                this.m_hashColor.put(key, defaultVal);
            }
            return this.m_hashColor.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void readFromNode(Element node) throws Exception {
        try {
            String key;
            this.m_hashString.clear();
            Element subNode = Tools_XML.getChildWithTagName(node, "Strings", true);
            ArrayList<Element> nodes = Tools_XML.getChildListWithTagName(subNode, "Entry");
            for (Element element : nodes) {
                key = element.getAttribute("Key");
                String val = element.getAttribute("Value");
                this.string_put(key, val);
            }
            this.m_hashStringList.clear();
            subNode = Tools_XML.getChildWithTagName(node, "StringLists", true);
            nodes = Tools_XML.getChildListWithTagName(subNode, "Entry");
            for (Element element : nodes) {
                key = element.getAttribute("Key");
                if (key.equalsIgnoreCase("Attributes")) {
                    boolean val = false;
                }
                ArrayList<String> list = this.stringList_get(key);
                ArrayList<Element> entryList = Tools_XML.getChildListWithTagName(element, "ListEntry");
                for (Element listEntryElement : entryList) {
                    String val = listEntryElement.getAttribute("Value");
                    list.add(val);
                }
                this.stringList_put(key, list);
            }
            this.m_hashParameterTree.clear();
            subNode = Tools_XML.getChildWithTagName(node, "ParameterTrees", true);
            nodes = Tools_XML.getChildListWithTagName(subNode, "Entry");
            for (Element element : nodes) {
                key = element.getAttribute("Key");
                ParameterTree hash = this.ParameterTree_get(key);
                hash.readFromNode(element);
            }
            this.m_hashColor.clear();
            subNode = Tools_XML.getChildWithTagName(node, "Colors", true);
            nodes = Tools_XML.getChildListWithTagName(subNode, "Entry");
            for (Element element : nodes) {
                key = element.getAttribute("Key");
                String sr = element.getAttribute("Red");
                int r = Integer.parseInt(sr);
                String sg = element.getAttribute("Green");
                int g = Integer.parseInt(sg);
                String sb = element.getAttribute("Blue");
                int b = Integer.parseInt(sb);
                String sa = element.getAttribute("Alpha");
                int a = Integer.parseInt(sa);
                Color val = new Color(r, g, b, a);
                this.color_put(key, val);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void writeToNode(Element node) throws Exception {
        try {
            this.writeToNode(node, true, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract getStringTable() {
        try {
            Table_Memory table = new Table_Memory();
            int colKey = ((Table_Abstract)table).column_append("Key", DataType.Text);
            int colVal = ((Table_Abstract)table).column_append("Value", DataType.Text);
            for (String key : this.m_hashString.keySet()) {
                String v = this.m_hashString.get(key);
                int row = ((Table_Abstract)table).row_increment();
                ((Table_Abstract)table).putString(row, colKey, key);
                ((Table_Abstract)table).putString(row, colVal, v);
            }
            return table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void writeToNode(Element node, boolean comments, boolean outputEmptyNodes) throws Exception {
        try {
            Element valueNode;
            Element subNode;
            if (outputEmptyNodes || this.m_hashString.size() > 0) {
                if (comments) {
                    Tools_XML.addBlockComment(node, "Strings (int, double, bool)");
                }
                subNode = node.getOwnerDocument().createElement("Strings");
                node.appendChild(subNode);
                for (String key : this.m_hashString.keySet()) {
                    String v = this.m_hashString.get(key);
                    valueNode = node.getOwnerDocument().createElement("Entry");
                    valueNode.setAttribute("Key", key);
                    valueNode.setAttribute("Value", v);
                    subNode.appendChild(valueNode);
                }
            }
            if (outputEmptyNodes || this.m_hashColor.size() > 0) {
                if (comments) {
                    Tools_XML.addBlockComment(node, "Colors (RGBA)");
                }
                subNode = node.getOwnerDocument().createElement("Colors");
                node.appendChild(subNode);
                for (String key : this.m_hashColor.keySet()) {
                    Color c = this.m_hashColor.get(key);
                    valueNode = node.getOwnerDocument().createElement("Entry");
                    valueNode.setAttribute("Key", key);
                    valueNode.setAttribute("Red", Integer.toString(c.getRed()));
                    valueNode.setAttribute("Green", Integer.toString(c.getGreen()));
                    valueNode.setAttribute("Blue", Integer.toString(c.getBlue()));
                    valueNode.setAttribute("Alpha", Integer.toString(c.getAlpha()));
                    subNode.appendChild(valueNode);
                }
            }
            if (outputEmptyNodes || this.m_hashStringList.size() > 0) {
                if (comments) {
                    Tools_XML.addBlockComment(node, "String lists");
                }
                subNode = node.getOwnerDocument().createElement("StringLists");
                node.appendChild(subNode);
                for (String key : this.m_hashStringList.keySet()) {
                    ArrayList<String> list = this.m_hashStringList.get(key);
                    valueNode = node.getOwnerDocument().createElement("Entry");
                    valueNode.setAttribute("Key", key);
                    for (String s : list) {
                        Element leNode = node.getOwnerDocument().createElement("ListEntry");
                        leNode.setAttribute("Value", s);
                        valueNode.appendChild(leNode);
                    }
                    subNode.appendChild(valueNode);
                }
            }
            if (outputEmptyNodes || this.m_hashParameterTree.size() > 0) {
                if (comments) {
                    Tools_XML.addBlockComment(node, "ParameterTree (allows recursion!)");
                }
                subNode = node.getOwnerDocument().createElement("ParameterTrees");
                node.appendChild(subNode);
                for (String key : this.m_hashParameterTree.keySet()) {
                    ParameterTree hasher = this.m_hashParameterTree.get(key);
                    valueNode = node.getOwnerDocument().createElement("Entry");
                    valueNode.setAttribute("Key", key);
                    hasher.writeToNode(valueNode);
                    subNode.appendChild(valueNode);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save(String fileName) {
        boolean failed = true;
        try {
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("ParameterTree");
            document.appendChild(root);
            this.writeToNode(root);
            if (document != null && fileName != null) {
                Tools_XML.writeDocumentToFile(document, fileName);
            } else if (document != null) {
                JOptionPane.showMessageDialog(null, "File name null.", "Severe error", 0);
            } else if (fileName != null) {
                JOptionPane.showMessageDialog(null, "Document null.", "Severe error", 0);
            } else {
                JOptionPane.showMessageDialog(null, "Document and file name null.", "Severe error", 0);
            }
            failed = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (failed) {
                this.saveCoreToText(fileName);
                JOptionPane.showMessageDialog(null, "Please send the file ProjectDescription.xml_csv to XtremeGeo support", "Severe error", 0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void saveCoreToText(String fileName) {
        try {
            fileName = (String)fileName + "_csv";
            BufferedWriter writer = new BufferedWriter(new FileWriter((String)fileName));
            for (String key : this.m_hashString.keySet()) {
                String v = this.m_hashString.get(key);
                if (v.length() < 1) {
                    v = "";
                }
                String s = String.format("%s,%s", key, v);
                writer.write(s);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            this.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            this.readFromNode(root);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clear() throws Exception {
        try {
            this.m_hashColor.clear();
            this.m_hashParameterTree.clear();
            this.m_hashString.clear();
            this.m_hashStringList.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

