/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.FFT.FFT_Server;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_Strings;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.swing.table.AbstractTableModel;

public class FloatArrayWrapper
extends AbstractTableModel
implements Serializable {
    protected float[] m_array = null;
    protected int m_validSampleCount = 0;
    protected float m_max = 0.0f;
    protected float m_min = 0.0f;
    protected Range_Double m_totalRange = new Range_Double();
    protected int m_upCount = 4;
    protected float[] m_upArray = null;
    protected float m_sampleInterval = 4.0f;
    protected float m_firstSampleCoord_Initial = 0.0f;
    protected float m_firstSampleCoord_WithShifts = 0.0f;
    protected int m_currentPolarity = 1;

    public Range_Double totalRange() {
        return this.m_totalRange;
    }

    public float[] cloneData() {
        float[] arr = new float[this.m_array.length];
        for (int n = 0; n < this.m_array.length; ++n) {
            arr[n] = this.m_array[n];
        }
        return arr;
    }

    public float fillShortArray(short[] out) throws Exception {
        try {
            if (this.m_validSampleCount < 1) {
                return 0.0f;
            }
            float max = 1.0E-40f;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                max = Math.max(max, Math.abs(this.m_array[n]));
            }
            float scalar = 30000.0f / max;
            int minCount = Math.min(this.m_validSampleCount, out.length);
            for (int n = 0; n < minCount; ++n) {
                out[n] = (short)(scalar * this.m_array[n]);
            }
            scalar = 1.0f / scalar;
            return scalar;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float fillByteBuffer_Short(ByteBuffer buffer, int offset) throws Exception {
        try {
            float max = 1.0E-40f;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                max = Math.max(max, Math.abs(this.m_array[n]));
            }
            float scalar = 30000.0f / max;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                short v = (short)(scalar * this.m_array[n]);
                buffer.putShort(offset, v);
                offset += 2;
            }
            return scalar;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float[] upArray(int upCount) throws Exception {
        try {
            if (this.m_upArray == null || upCount != this.m_upCount) {
                this.m_upCount = upCount;
                this.prepUpsample();
            }
            return this.m_upArray;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float sampleInterval_Upslope() throws Exception {
        try {
            if (this.m_upArray == null) {
                throw new Exception("m_upArray == null");
            }
            return this.m_sampleInterval / (float)this.m_upCount;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public FloatArrayWrapper() {
    }

    public FloatArrayWrapper(int len) throws Exception {
        try {
            this.m_validSampleCount = Math.max(0, len);
            if (this.m_validSampleCount > 0) {
                this.m_array = new float[this.m_validSampleCount];
                for (int n = 0; n < this.m_validSampleCount; ++n) {
                    this.m_array[n] = 0.0f;
                }
                this.m_min = 0.0f;
                this.m_max = 0.0f;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void prepUpsample() throws Exception {
        try {
            int v;
            this.m_upCount = Math.max(this.m_upCount, 2);
            for (v = 2; v < this.m_upCount; v *= 2) {
            }
            this.m_upCount = v;
            if (this.m_validSampleCount < 4) {
                throw new Exception("m_validSampleCount < 4");
            }
            FFT_1D_Wrapper inputFFT = FFT_Server.fft1D(this.m_validSampleCount);
            inputFFT.forward(this.m_array);
            int inputPowerOfTwo = inputFFT.getPowerOfTwo();
            int outputPowerOfTwo = inputPowerOfTwo * this.m_upCount;
            this.m_upArray = new float[outputPowerOfTwo];
            FFT_1D_Wrapper outputFFT = FFT_Server.fft1D(outputPowerOfTwo);
            outputFFT.clearArrays();
            int inputHalf = inputPowerOfTwo / 2;
            float[] outputReal = outputFFT.real();
            float[] outputImag = outputFFT.imag();
            float[] inputReal = inputFFT.real();
            float[] inputImag = inputFFT.imag();
            int outputLast = outputPowerOfTwo - 1;
            int inputLast = inputPowerOfTwo - 1;
            float scalar = (float)Math.sqrt(this.m_upCount);
            for (int n = 0; n < inputHalf; ++n) {
                outputReal[n] = scalar * inputReal[n];
                outputImag[n] = scalar * inputImag[n];
                outputReal[outputLast - n] = scalar * inputReal[inputLast - n];
                outputImag[outputLast - n] = scalar * inputImag[inputLast - n];
            }
            outputFFT.setForwardInputDataLength(this.m_upArray.length);
            outputFFT.inverse(this.m_upArray);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float getSample(int index) throws Exception {
        try {
            if (index < 0 || index >= this.m_validSampleCount) {
                throw new Exception("bad index");
            }
            return this.m_array[index];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void copyToFloatArrayWrapper(FloatArrayWrapper faw) throws Exception {
        try {
            faw.insertArray(this.m_array, this.m_validSampleCount);
            faw.setFirstSampleCoord(this.m_firstSampleCoord_Initial);
            faw.addShiftToFirstSampleCoord(this.getTotalFirstSampleShifts());
            faw.setSampleInterval(this.m_sampleInterval);
            faw.setPolarity_NoFlip(this.m_currentPolarity);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public FloatArrayWrapper createExactCopy() throws Exception {
        try {
            FloatArrayWrapper faw = new FloatArrayWrapper();
            this.copyToFloatArrayWrapper(faw);
            return faw;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void resetFirstSampleCoord() {
        this.m_firstSampleCoord_WithShifts = this.m_firstSampleCoord_Initial;
    }

    public void setFirstSampleCoord(float firstSampleCoord) {
        this.m_firstSampleCoord_Initial = firstSampleCoord;
        this.m_firstSampleCoord_WithShifts = firstSampleCoord;
    }

    public float getTotalFirstSampleShifts() {
        return this.m_firstSampleCoord_WithShifts - this.m_firstSampleCoord_Initial;
    }

    public float getFirstSampleCoord_Initial() {
        return this.m_firstSampleCoord_Initial;
    }

    public float getFirstSampleCoord_WithShifts() {
        return this.m_firstSampleCoord_WithShifts;
    }

    public float getLastSampleCoord_WithShifts() {
        return this.m_firstSampleCoord_WithShifts + this.m_sampleInterval * (float)(this.length() - 1);
    }

    public void addShiftToFirstSampleCoord(float shift) {
        this.m_firstSampleCoord_WithShifts += shift;
    }

    public void setSampleInterval(float sampleInterval) {
        this.m_sampleInterval = Math.max(sampleInterval, 1.0E-4f);
    }

    public float getSampleInterval() {
        return this.m_sampleInterval;
    }

    public int length() {
        return this.m_validSampleCount;
    }

    public void clear() {
        this.m_validSampleCount = 0;
    }

    public float absoluteMax() throws Exception {
        try {
            return Math.max(this.m_max, Math.abs(this.m_min));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float min() throws Exception {
        try {
            return this.m_min;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float max() throws Exception {
        try {
            return this.m_max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean isDC() {
        try {
            if (this.m_validSampleCount < 2) {
                return false;
            }
            float diff = this.m_max - this.m_min;
            return diff < 1.0E-6f;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public void copyToArray(float[] array, float startTime) throws Exception {
        try {
            if (this.m_validSampleCount < 1) {
                throw new Exception("m_length < 1");
            }
            if (array == null) {
                throw new Exception("array == null");
            }
            if (this.m_validSampleCount > array.length) {
                throw new Exception("m_validSampleCount > array.length");
            }
            int startIndex = (int)(0.5f + (startTime - this.m_firstSampleCoord_WithShifts) / this.m_sampleInterval);
            startIndex = Math.max(0, startIndex);
            for (int n = 0; n < array.length; ++n) {
                int sample = startIndex + n;
                if (sample >= this.m_validSampleCount) continue;
                array[n] = this.m_array[sample];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public String getStringValue(int n) {
        try {
            return Float.toString(this.m_array[n]);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "Error";
        }
    }

    public void copyToArray(float[] array) throws Exception {
        try {
            int n;
            if (this.m_validSampleCount < 1) {
                throw new Exception("m_length < 1");
            }
            if (array == null) {
                throw new Exception("array == null");
            }
            if (this.m_validSampleCount > array.length) {
                throw new Exception("m_validSampleCount > array.length");
            }
            for (n = 0; n < this.m_validSampleCount; ++n) {
                array[n] = this.m_array[n];
            }
            for (n = this.m_validSampleCount; n < array.length; ++n) {
                array[n] = 0.0f;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int lastValidSampleIndex() {
        try {
            if (this.m_validSampleCount < 1) {
                return -99999;
            }
            for (int n = this.m_validSampleCount - 1; n >= 0; --n) {
                if (!(Math.abs(this.m_array[n]) > 1.0E-30f)) continue;
                return n;
            }
            return -99999;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -99999;
        }
    }

    public void resetPolarity() {
        this.m_currentPolarity = 1;
    }

    public void setPolarity_NoFlip(int polarity) {
        try {
            boolean okay;
            if (polarity == this.m_currentPolarity) {
                return;
            }
            boolean bl = okay = polarity == 1 || polarity == -1;
            if (!okay) {
                return;
            }
            this.m_currentPolarity = polarity;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPolarity(int polarity) {
        try {
            boolean okay;
            if (polarity == this.m_currentPolarity) {
                return;
            }
            boolean bl = okay = polarity == 1 || polarity == -1;
            if (!okay) {
                return;
            }
            this.m_currentPolarity = polarity;
            if (this.m_validSampleCount < 1) {
                return;
            }
            float scalar = -1.0f;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                this.m_array[n] = this.m_array[n] * scalar;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int firstValidSampleIndex() {
        try {
            if (this.m_validSampleCount < 1) {
                return -9999;
            }
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                if (!(Math.abs(this.m_array[n]) > 1.0E-20f)) continue;
                return n;
            }
            return -9999;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public float amplitudeSum(float minTime, float maxTime) {
        try {
            if (this.m_validSampleCount < 1) {
                return 0.0f;
            }
            float sum = 0.0f;
            float time = this.m_firstSampleCoord_WithShifts;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                if (time >= minTime && time <= maxTime) {
                    sum += Math.abs(this.m_array[n]);
                }
                if (time > maxTime) {
                    return sum;
                }
                time += this.m_sampleInterval;
            }
            return sum;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public float energy(float maxTime) {
        try {
            if (this.m_validSampleCount < 1) {
                return 0.0f;
            }
            float sum = 0.0f;
            float time = this.m_firstSampleCoord_WithShifts;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                if (time < maxTime) {
                    sum += Math.abs(this.m_array[n]);
                } else {
                    return sum;
                }
                time += this.m_sampleInterval;
            }
            return sum;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public float noise(int window) {
        try {
            double running_sum = 0.0;
            double max_sum = 1.0E-20;
            double min_sum = 1.0E20;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                running_sum += (double)Math.abs(this.m_array[n]);
                if (n >= window) {
                    running_sum -= (double)Math.abs(this.m_array[n - window]);
                }
                if (n < window) continue;
                max_sum = Math.max(max_sum, running_sum);
                min_sum = Math.min(min_sum, running_sum);
            }
            double ratio = min_sum / max_sum;
            ratio = Math.max(ratio, 0.0);
            ratio = Math.min(ratio, 1.0);
            return (float)ratio;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 1.0f;
        }
    }

    public void removeAverageValue() {
        try {
            if (this.m_validSampleCount < 1) {
                return;
            }
            double sum = 0.0;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                sum += (double)this.m_array[n];
            }
            double avg = sum / (double)this.m_validSampleCount;
            int n = 0;
            while (n < this.m_validSampleCount) {
                int n2 = n++;
                this.m_array[n2] = this.m_array[n2] - (float)avg;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float averageAbsoluteAmplitude() {
        try {
            if (this.m_validSampleCount < 1) {
                return 0.0f;
            }
            float sum = 0.0f;
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                sum += Math.abs(this.m_array[n]);
            }
            return sum / (float)this.m_validSampleCount;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public void insertArray(float[] array, int validSampleCount) throws Exception {
        try {
            this.m_totalRange.clearRange();
            this.m_max = 0.0f;
            this.m_min = 0.0f;
            if (array == null) {
                this.m_validSampleCount = 0;
                return;
            }
            if (validSampleCount > array.length) {
                throw new Exception("validSampleCount > array.length");
            }
            this.m_validSampleCount = Math.max(validSampleCount, 0);
            if (this.m_validSampleCount < 1) {
                return;
            }
            if (this.m_array == null) {
                this.m_array = new float[this.m_validSampleCount];
            }
            if (this.m_validSampleCount > this.m_array.length) {
                this.m_array = new float[this.m_validSampleCount];
            }
            for (int n = 0; n < this.m_validSampleCount; ++n) {
                this.m_array[n] = array[n];
                this.m_max = Math.max(this.m_max, this.m_array[n]);
                this.m_min = Math.min(this.m_min, this.m_array[n]);
                this.m_totalRange.expandRange(this.m_array[n]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean columnLocked() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Index";
            }
            if (column == 1) {
                return "Time";
            }
            if (column == 2) {
                return "Value";
            }
            return "ERROR";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        return this.m_validSampleCount;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (column == 0) {
                return Integer.toString(row);
            }
            if (column == 1) {
                float t = this.m_firstSampleCoord_WithShifts + (float)row * this.m_sampleInterval;
                return Tools_Strings.getString(t, 1);
            }
            if (column == 2) {
                return Float.toString(this.m_array[row]);
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }
}

