/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

public enum DataType {
    Short("short", 2),
    Int("int", 4),
    Float("float", 4),
    Bool("bool", 1),
    Double("double", 8),
    Text("string", -9999),
    FloatIBM("float ibm", 4),
    Long("long", 8),
    IntArray("intArray", -9999),
    FloatArray("floatArray", -9999),
    Byte("byte", 1),
    Unknown("unknown", 4);

    public final int Length;
    public final String Description;

    private DataType(String description, int byteCount) {
        this.Length = byteCount;
        this.Description = description;
    }

    public int getTypeIndex() {
        if (this.equals((Object)Short)) {
            return 0;
        }
        if (this.equals((Object)Int)) {
            return 1;
        }
        if (this.equals((Object)Float)) {
            return 2;
        }
        if (this.equals((Object)Bool)) {
            return 3;
        }
        if (this.equals((Object)Double)) {
            return 4;
        }
        if (this.equals((Object)Text)) {
            return 5;
        }
        if (this.equals((Object)FloatIBM)) {
            return 6;
        }
        if (this.equals((Object)Long)) {
            return 7;
        }
        if (this.equals((Object)Byte)) {
            return 10;
        }
        return -1;
    }

    public static DataType typeFromTypeIndex(int i) {
        if (i == 0) {
            return Short;
        }
        if (i == 1) {
            return Int;
        }
        if (i == 2) {
            return Float;
        }
        if (i == 3) {
            return Bool;
        }
        if (i == 4) {
            return Double;
        }
        if (i == 5) {
            return Text;
        }
        if (i == 6) {
            return FloatIBM;
        }
        if (i == 7) {
            return Long;
        }
        if (i == 10) {
            return Byte;
        }
        return null;
    }

    public static DataType typeFromDescription(String s) {
        try {
            DataType[] arr = DataType.values();
            for (int n = 0; n < arr.length; ++n) {
                if (!s.equalsIgnoreCase(arr[n].Description)) continue;
                return arr[n];
            }
            if (s.equalsIgnoreCase("float")) {
                return Float;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Int;
    }

    public static boolean floatingPointType(DataType t) {
        return t == Float || t == Double;
    }
}

