/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Column_Float
extends Column_Abstract
implements Serializable {
    protected float[] m_data;

    public Column_Float() {
    }

    @Override
    public String uniqueID() {
        return "Column_Float";
    }

    public Column_Float(String name) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            this.m_data = new float[100];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Column_Float(String name, int minLength) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            int len = Math.max(100, minLength + 100);
            this.m_data = new float[len];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void remove(int row) {
        try {
            for (int n = row; n < this.m_data.length - 1; ++n) {
                this.m_data[n] = this.m_data[n + 1];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void sort(int count) {
    }

    @Override
    public void save(RandomAccessFile writer) throws Exception {
        try {
            writer.writeInt(92876464);
            writer.writeInt(1000);
            writer.writeUTF(this.m_name);
            writer.writeInt(this.m_data.length);
            int numBytes = 4 * this.m_data.length;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
            for (int n = 0; n < this.m_data.length; ++n) {
                buff.putFloat(this.m_data[n]);
            }
            writer.write(buff.array(), 0, numBytes);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void read(RandomAccessFile reader) throws Exception {
        block5: {
            try {
                int magic = reader.readInt();
                if (magic != 92876464) {
                    throw new Exception("magic != Magic");
                }
                int version = reader.readInt();
                if (version == 1000) {
                    this.m_name = reader.readUTF();
                    int len = reader.readInt();
                    this.m_data = new float[len];
                    int numBytes = 4 * len;
                    ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                    reader.read(buff.array(), 0, numBytes);
                    for (int n = 0; n < this.m_data.length; ++n) {
                        this.m_data[n] = buff.getFloat();
                    }
                    break block5;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    @Override
    public Column_Abstract createExactCopy() {
        try {
            Column_Float col = new Column_Float(this.m_name, this.m_data.length);
            for (int n = 0; n < this.m_data.length; ++n) {
                col.putFloat(n, this.m_data[n]);
            }
            col.clearModificationFlag();
            return col;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public DataType type() {
        return DataType.Float;
    }

    protected void resize(int row) throws Exception {
        try {
            if (row < this.m_data.length) {
                return;
            }
            int newLength = row + this.m_data.length / 2;
            float[] tempArray = Arrays.copyOf(this.m_data, newLength);
            for (int n = this.m_data.length; n < newLength; ++n) {
                tempArray[n] = -999999.0f;
            }
            this.m_data = null;
            this.m_data = tempArray;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void swap(int row1, int row2) throws Exception {
        try {
            float v = this.m_data[row1];
            this.m_data[row1] = this.m_data[row2];
            this.m_data[row2] = v;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putBool(int row, boolean value) throws Exception {
        try {
            if (value) {
                this.putFloat(row, 1.0f);
            } else {
                this.putFloat(row, 0.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean getBool(int row) throws Exception {
        try {
            return Math.abs(this.getFloat(row)) > 0.1f;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putLong(int row, long value) throws Exception {
        try {
            this.putFloat(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public long getLong(int row) throws Exception {
        try {
            return Math.round(this.getFloat(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putInt(int row, int value) throws Exception {
        try {
            this.putFloat(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public int getInt(int row) throws Exception {
        try {
            return Math.round(this.getFloat(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putFloat(int row, float value) throws Exception {
        try {
            this.resize(row);
            this.m_data[row] = value;
            this.setModified(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getFloat(int row) throws Exception {
        try {
            this.resize(row);
            return this.m_data[row];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putDouble(int row, double value) throws Exception {
        try {
            this.putFloat(row, (float)value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public double getDouble(int row) throws Exception {
        try {
            return this.getFloat(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putString(int row, String value) throws Exception {
        try {
            try {
                value = Tools_Strings.removeSpace(value);
                float v = Float.parseFloat(value);
                this.putFloat(row, v);
            }
            catch (Exception error) {
                this.putFloat(row, -999999.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public String getString(int row, int numDecimals) throws Exception {
        try {
            return Tools_Strings.getString(this.getFloat(row), numDecimals);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public String getString(int row) throws Exception {
        try {
            return Tools_Strings.getString(this.getFloat(row), 2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putIntArray(int row, int[] iVals) {
    }

    @Override
    public int[] getIntArray(int row) {
        return null;
    }

    @Override
    public void putFloatArray(int row, float[] fVals) {
    }

    @Override
    public float[] getFloatArray(int row) {
        return null;
    }

    public int getArrayLength() {
        return 0;
    }
}

