/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.Column_Bool;
import com.PecosCore.Data.Column_Double;
import com.PecosCore.Data.Column_Float;
import com.PecosCore.Data.Column_Int;
import com.PecosCore.Data.Column_Text;
import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;

public abstract class Column_Abstract
implements Serializable {
    protected static final int Magic = 92876464;
    protected static final int Version = 1000;
    protected String m_name = null;
    protected boolean[] m_mod = new boolean[100];
    public boolean ColumnInUse = true;
    protected int m_traceHeaderIndex = -999999;

    public String name() throws Exception {
        try {
            if (this.m_name == null) {
                throw new Exception("(m_name == null)");
            }
            return this.m_name;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public abstract String uniqueID();

    public static Column_Abstract getColumnFromID(String uniqueID) {
        try {
            if (uniqueID.equalsIgnoreCase("Column_Int")) {
                return new Column_Int();
            }
            if (uniqueID.equalsIgnoreCase("Column_Text")) {
                return new Column_Text();
            }
            if (uniqueID.equalsIgnoreCase("Column_Bool")) {
                return new Column_Bool();
            }
            if (uniqueID.equalsIgnoreCase("Column_Double")) {
                return new Column_Double();
            }
            if (uniqueID.equalsIgnoreCase("Column_Float")) {
                return new Column_Float();
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static Column_Abstract getColumnFromClassname(String className) {
        try {
            if (className.endsWith("Column_Int")) {
                return new Column_Int();
            }
            if (className.endsWith("Column_Text")) {
                return new Column_Text();
            }
            if (className.endsWith("Column_Bool")) {
                return new Column_Bool();
            }
            if (className.endsWith("Column_Double")) {
                return new Column_Double();
            }
            if (className.endsWith("Column_Float")) {
                return new Column_Float();
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public abstract void save(RandomAccessFile var1) throws Exception;

    public abstract void read(RandomAccessFile var1) throws Exception;

    public abstract void sort(int var1);

    public abstract DataType type();

    public abstract Column_Abstract createExactCopy();

    public abstract void remove(int var1);

    public void clearModificationFlag() {
        for (int n = 0; n < this.m_mod.length; ++n) {
            this.m_mod[n] = false;
        }
    }

    protected void resizeModification(int row) throws Exception {
        try {
            if (row < this.m_mod.length) {
                return;
            }
            int newLength = row + this.m_mod.length / 2;
            boolean[] tempArray = Arrays.copyOf(this.m_mod, newLength);
            for (int n = this.m_mod.length; n < newLength; ++n) {
                tempArray[n] = false;
            }
            this.m_mod = null;
            this.m_mod = tempArray;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void setModified(int row) throws Exception {
        try {
            this.resizeModification(row);
            this.m_mod[row] = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean modified(int row) throws Exception {
        try {
            this.resizeModification(row);
            return this.m_mod[row];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public abstract void putLong(int var1, long var2) throws Exception;

    public abstract long getLong(int var1) throws Exception;

    public abstract void putInt(int var1, int var2) throws Exception;

    public abstract int getInt(int var1) throws Exception;

    public abstract void putBool(int var1, boolean var2) throws Exception;

    public abstract boolean getBool(int var1) throws Exception;

    public abstract void putFloat(int var1, float var2) throws Exception;

    public abstract float getFloat(int var1) throws Exception;

    public abstract void putDouble(int var1, double var2) throws Exception;

    public abstract double getDouble(int var1) throws Exception;

    public abstract void putString(int var1, String var2) throws Exception;

    public abstract String getString(int var1) throws Exception;

    public abstract String getString(int var1, int var2) throws Exception;

    public abstract void putIntArray(int var1, int[] var2);

    public abstract int[] getIntArray(int var1);

    public abstract void putFloatArray(int var1, float[] var2);

    public abstract float[] getFloatArray(int var1);

    public int traceHeader_getIndex() throws Exception {
        try {
            if (this.m_traceHeaderIndex < 0) {
                throw new Exception("Header index not set");
            }
            return this.m_traceHeaderIndex;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void traceHeader_setIndex(int headerIndex) {
        this.m_traceHeaderIndex = headerIndex;
    }
}

