/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Application;

import com.PecosCore.Shared.ChangeLog_Flatirons;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;

public class Environment {
    public static String XT_VERSION = "";
    public static OperatingSystem OS_TYPE = OperatingSystem.OS_NONE;
    public static String XT_EXECUTING_DIR = "";
    public static String XT_LIB_DIR = "";
    public static HashMap<String, String> XT_ARGS;
    public static String LOCAL_MAC_ADDRESS;
    public static String LOCAL_IP_ADDRESS;
    public static String EXT_IP_ADDRESS;
    public static String LOCAL_USER_NAME;
    public static String LOCAL_HOST_NAME;
    private static boolean initialized;
    static String _sExeDir;
    static boolean _bIsDebug;

    public static String getExecuteableDirectory() {
        return _sExeDir;
    }

    public static void setExecutableDirectory(String sExeDir) {
        _sExeDir = sExeDir;
    }

    public static boolean getIsDebug() {
        return _bIsDebug;
    }

    public static void setIsDebug(boolean bDebug) {
        _bIsDebug = bDebug;
    }

    public static String print() {
        if (initialized) {
            Object output = "";
            output = String.format("Running Flatirons version %s\nOn Operating System: %s\nFrom dir: %s\nLibs dir: %s\n", XT_VERSION, OS_TYPE.toString(), XT_EXECUTING_DIR, XT_LIB_DIR);
            output = (String)output + "\n" + XT_ARGS.toString() + "\n";
            System.out.print((String)output);
            return output;
        }
        return "";
    }

    public static void init(String[] args) {
        try {
            XT_ARGS = new HashMap();
            for (int i = 0; i < args.length; ++i) {
                XT_ARGS.put(String.format("arg%s", i), args[i]);
            }
            XT_VERSION = ChangeLog_Flatirons.singleton().currentVersion();
            String osname = System.getProperty("os.name").toUpperCase();
            if (osname.contains("NUX")) {
                OS_TYPE = OperatingSystem.OS_LINUX;
            } else if (osname.contains("WIN")) {
                OS_TYPE = OperatingSystem.OS_WINDOWS;
            } else if (osname.contains("MAC")) {
                OS_TYPE = OperatingSystem.OS_MAC;
            }
            String temp = Environment.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            temp = temp.substring(0, temp.lastIndexOf("/"));
            XT_LIB_DIR = URLDecoder.decode(temp, "UTF-8");
            temp = temp.substring(0, temp.lastIndexOf("/"));
            XT_EXECUTING_DIR = URLDecoder.decode(temp, "UTF-8");
            Boolean foundOne = false;
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                byte[] mac = netint.getHardwareAddress();
                if (mac != null && !foundOne.booleanValue() && !netint.isLoopback()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < mac.length; ++i) {
                        sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                    }
                    LOCAL_MAC_ADDRESS = sb.toString();
                    foundOne = true;
                }
                Enumeration<InetAddress> ina = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(ina)) {
                    if (!inetAddress.isSiteLocalAddress()) continue;
                    LOCAL_IP_ADDRESS = inetAddress.getHostAddress();
                }
            }
            LOCAL_USER_NAME = System.getProperty("user.name");
            LOCAL_HOST_NAME = InetAddress.getLocalHost().getHostName();
            initialized = true;
        }
        catch (UnsupportedEncodingException | SocketException | UnknownHostException ex) {
            ex.printStackTrace();
            ExceptionMonitor.add(ex);
            initialized = false;
        }
    }

    public static void getExtIP() {
        try {
            URL URL2 = new URL("http://checkip.amazonaws.com");
            HttpURLConnection Conn = (HttpURLConnection)URL2.openConnection();
            InputStream InStream = Conn.getInputStream();
            InputStreamReader Isr = new InputStreamReader(InStream);
            BufferedReader Br = new BufferedReader(Isr);
            String line = Br.readLine();
            if (XT_ARGS.containsValue("DEBUG_MODE")) {
                System.out.print("Your IP address is " + line);
            }
            EXT_IP_ADDRESS = line;
        }
        catch (IOException er) {
            ExceptionMonitor.add(er);
            EXT_IP_ADDRESS = LOCAL_IP_ADDRESS;
        }
    }

    static {
        LOCAL_MAC_ADDRESS = "";
        LOCAL_IP_ADDRESS = "";
        EXT_IP_ADDRESS = "";
        LOCAL_USER_NAME = "";
        LOCAL_HOST_NAME = "";
        initialized = false;
        _sExeDir = "";
        _bIsDebug = false;
    }

    public static enum OperatingSystem {
        OS_WINDOWS,
        OS_LINUX,
        OS_MAC,
        OS_NONE;

    }
}

