/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.velocity;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.javaseis.grid.BinGrid;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataDomain;
import org.javaseis.properties.Units;
import org.javaseis.util.SeisException;
import org.javaseis.velocity.UniformModelAdapter;

public class JTestUniformModelAdapter
extends TestCase {
    public void testUniformModel() throws SeisException, IOException {
        int i;
        int j;
        int k;
        float x;
        float y;
        float z;
        File path = File.createTempFile("testUniformModel", ".js", null);
        path.delete();
        AxisDefinition[] axes = new AxisDefinition[3];
        int nx = 201;
        float dx = 6.25f;
        float x1 = 0.5f * dx * (float)(1 - nx);
        int ny = 101;
        float dy = 12.5f;
        float y1 = 0.5f * dy * (float)(1 - ny);
        int nz = 301;
        float dz = 10.0f;
        float z1 = 0.0f;
        axes[0] = new AxisDefinition(AxisLabel.CROSSLINE, Units.METERS, DataDomain.SPACE, nx, 1L, 1L, x1, dx);
        axes[1] = new AxisDefinition(AxisLabel.INLINE, Units.METERS, DataDomain.SPACE, ny, 1L, 2L, y1, dy);
        axes[2] = new AxisDefinition(AxisLabel.DEPTH, Units.METERS, DataDomain.DEPTH, nz, 0L, (long)dz, 0.0, dz);
        GridDefinition gridDefinition = new GridDefinition(3, axes);
        BinGrid binGrid = new BinGrid(x1, y1, x1 + dx * (float)(nx - 1), y1, x1, y1 + dy * (float)(ny - 1), 1L, 1L, nx, 1L, 1L, ny, 1L, 1L, 0.0, 0.0, dx, dy);
        Seisio sio = new Seisio(path.getCanonicalPath(), gridDefinition);
        sio.writeBinGridToFileProperties(binGrid.toParameterSet());
        sio.create();
        float[][] frame = sio.getTraceDataArray();
        float v0 = 1500.0f;
        float gx = 0.1f;
        float gy = 0.2f;
        float gz = 0.3f;
        int[] pos = new int[3];
        int k2 = 0;
        while (k2 < nz) {
            z = z1 + dz * (float)k2;
            for (int j2 = 0; j2 < ny; ++j2) {
                y = y1 + dy * (float)j2;
                for (int i2 = 0; i2 < nx; ++i2) {
                    x = x1 + dx * (float)i2;
                    frame[j2][i2] = v0 + gx * x + gy * y + gz * z;
                }
            }
            pos[2] = k2++;
            sio.writeFrame(pos, ny);
        }
        sio.close();
        sio = null;
        System.gc();
        System.out.println("Test reading exact output data...");
        UniformModelAdapter modelService = new UniformModelAdapter(path.getCanonicalPath());
        modelService.setBinGrid(binGrid);
        float val = 0.0f;
        for (int k3 = 0; k3 < nz; ++k3) {
            z = z1 + dz * (float)k3;
            modelService.interpolateFrame(nx, x1, dx, ny, y1, dy, z, frame);
            for (int j3 = 0; j3 < ny; ++j3) {
                y = y1 + dy * (float)j3;
                for (int i3 = 0; i3 < nx; ++i3) {
                    x = x1 + dx * (float)i3;
                    val = v0 + gx * x + gy * y + gz * z;
                    JTestUniformModelAdapter.assertEquals((String)("At k=" + k3 + ", j=" + j3 + ", i=" + i3), (double)val, (double)frame[j3][i3], (double)1.0E-6);
                }
            }
        }
        System.out.println("Testing using half spacing...");
        float dx2 = dx / 2.0f;
        float dy2 = dy / 2.0f;
        float dz2 = dz / 2.0f;
        for (k = 0; k < nz; ++k) {
            z = z1 + dz2 * (float)k;
            modelService.interpolateFrame(nx, x1, dx2, ny, y1, dy2, z, frame);
            for (j = 0; j < ny; ++j) {
                y = y1 + dy2 * (float)j;
                for (i = 0; i < nx; ++i) {
                    x = x1 + dx2 * (float)i;
                    val = v0 + gx * x + gy * y + gz * z;
                    JTestUniformModelAdapter.assertEquals((String)("At k=" + k + ", j=" + j + ", i=" + i), (double)val, (double)frame[j][i], (double)1.0E-6);
                }
            }
        }
        System.out.println("Testing interpolateSample...");
        dx2 = dx / 2.0f;
        dy2 = dy / 2.0f;
        dz2 = dz / 2.0f;
        for (k = 0; k < nz; ++k) {
            z = z1 + dz2 * (float)k;
            for (j = 0; j < ny; ++j) {
                y = y1 + dy2 * (float)j;
                for (i = 0; i < nx; ++i) {
                    x = x1 + dx2 * (float)i;
                    val = v0 + gx * x + gy * y + gz * z;
                    JTestUniformModelAdapter.assertEquals((String)("At k=" + k + ", j=" + j + ", i=" + i), (double)val, (double)modelService.interpolateSample(x, y, z), (double)1.0E-6);
                }
            }
        }
        Seisio.delete(path.getCanonicalPath());
    }
}

