/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;

public class VDU {
    public static final int SMALLEST = 1;
    public static final int SMALLER = 2;
    public static final int SMALL = 3;
    public static final int MEDIUM = 4;
    public static final int BIG = 5;
    public static final int BIGGER = 6;
    public static final int BIGGEST = 7;
    public static String JP = "/d/geoprog/u/cornkc/SS_WorkSpace_33/javaseis";
    public static String NAME = "volume";
    public static String PATH = ".home.cornkc.jsdata";
    public static String ROOT = ".ptmp.hoepld";
    public static String[] HOSTS = new String[]{"87", "88", "90", "94", "17", "18"};
    public static String LOCATION = "scratch.cornkc.jsdata";
    public static int INITED = VDU.readParameterFile();
    public static ExtentPolicy POLICY = new ExtentPolicyRandom();
    public static DataType TYPE = DataType.STACK;
    public static DataFormat FORMAT = DataFormat.FLOAT;

    public static long size(long[] sizes) {
        long loc_size = 0L;
        if (sizes != null) {
            loc_size = 1L;
            for (int k2 = 0; k2 < sizes.length; ++k2) {
                loc_size *= sizes[k2];
            }
        }
        return loc_size *= (long)FORMAT.getBytesPerSample();
    }

    public static long defaultExtent(int data_node_count, long size) {
        long retval = 0L;
        if (size / 4L / (long)data_node_count < VDU.twoTo(30)) {
            retval = VDU.twoTo(30);
        } else if (size / 4L / (long)data_node_count < VDU.twoTo(31)) {
            retval = VDU.twoTo(31);
        } else {
            retval = VDU.closestPowerOfTwo(size / 4L / (long)data_node_count);
            if (retval < VDU.twoTo(32)) {
                retval = VDU.twoTo(32);
            }
        }
        return retval;
    }

    public static long twoTo(int exp) {
        if (exp >= 63) {
            return Long.MAX_VALUE;
        }
        if (exp < 0) {
            return 0L;
        }
        long result = 1L;
        for (int k2 = 0; k2 < exp; ++k2) {
            result *= 2L;
        }
        return result;
    }

    public static long closestPowerOfTwo(long number) {
        double dexp = Math.log(number) / Math.log(2.0);
        int exp = (int)Math.ceil(dexp - 0.5);
        return VDU.twoTo(exp);
    }

    public static long getTime() {
        Date date = new Date();
        return date.getTime();
    }

    private static int readParameterFile() {
        int retval = 0;
        String jp = System.getenv("JP");
        boolean have_name = false;
        boolean have_path = false;
        boolean have_root = false;
        boolean have_hosts = false;
        boolean have_location = false;
        if (jp != null) {
            JP = jp;
            String fname = JP + File.separator + "test" + File.separator + "data" + File.separator + "VDUparameters.dat";
            File file = new File(fname);
            try {
                FileReader in_stream = new FileReader(file);
                BufferedReader in = new BufferedReader(in_stream);
                String line = null;
                line = in.readLine();
                while (line != null) {
                    String lc_line = line.toLowerCase();
                    int index = lc_line.indexOf("name");
                    if (index > -1) {
                        NAME = lc_line.substring(index + 4).trim();
                        have_name = true;
                    } else {
                        index = lc_line.indexOf("path");
                        if (index > -1) {
                            PATH = lc_line.substring(index + 4).trim();
                            have_path = true;
                        } else {
                            index = lc_line.indexOf("root");
                            if (index > -1) {
                                ROOT = lc_line.substring(index + 4).trim();
                                have_root = true;
                            } else {
                                index = lc_line.indexOf("hosts");
                                if (index > -1) {
                                    String host_list = lc_line.substring(index + 5).replace(" ", "");
                                    int host_count = 0;
                                    for (int k2 = 0; k2 < host_list.length(); ++k2) {
                                        if (!host_list.substring(k2, k2 + 1).equalsIgnoreCase(",")) continue;
                                        ++host_count;
                                    }
                                    if (host_list.length() > 0) {
                                        ++host_count;
                                    }
                                    if (host_count > 0) {
                                        int beg = 0;
                                        int end = 0;
                                        HOSTS = new String[host_count];
                                        int k2 = 0;
                                        while ((end = host_list.indexOf(",", beg)) > -1) {
                                            VDU.HOSTS[k2] = host_list.substring(beg, end);
                                            beg = end + 1;
                                            ++k2;
                                        }
                                        VDU.HOSTS[host_count - 1] = host_list.substring(beg);
                                        have_hosts = true;
                                    }
                                } else {
                                    index = lc_line.indexOf("location");
                                    if (index > -1) {
                                        LOCATION = lc_line.substring(index + 8).trim();
                                        have_location = true;
                                    }
                                }
                            }
                        }
                    }
                    line = in.readLine();
                }
            }
            catch (FileNotFoundException e) {
                retval = -1;
            }
            catch (IOException e) {
                retval = -2;
            }
        }
        if (have_name && have_path && have_root && have_hosts && have_location) {
            retval = 1;
        }
        return retval;
    }
}

