/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import org.javaseis.parallel.IParallelContext;

public class Decomposition {
    public static int NONE = 0;
    public static int BLOCK = 1;
    public static int CIRCULAR = 2;
    private int _type;
    private long _numElements;
    private long _elementsPerTask;
    private long _liveElements;
    private long _paddedLength;
    private long[] _indexRange;
    private long[] _fortranRange;

    public static long liveElements(long numElements, int numTasks, int taskNumber) {
        long nlive;
        long nrem = numElements % (long)numTasks;
        if (nrem > 0L) {
            long npn = numElements / (long)numTasks + 1L;
            long nfull = numElements / npn;
            if ((long)taskNumber >= nfull) {
                nlive = numElements - npn * (long)taskNumber;
                if (nlive < 0L) {
                    nlive = 0L;
                }
            } else {
                nlive = npn;
            }
        } else {
            long npn;
            nlive = npn = numElements / (long)numTasks;
            long nfull = numTasks;
        }
        return nlive;
    }

    public static long paddedLength(long numElements, int numTasks) {
        long nrem = numElements % (long)numTasks;
        long npn = nrem == 0L ? numElements / (long)numTasks : 1L + numElements / (long)numTasks;
        return npn * (long)numTasks;
    }

    public static long elementsPerTask(long numElements, int numTasks) {
        long nrem = numElements % (long)numTasks;
        long npn = nrem == 0L ? numElements / (long)numTasks : 1L + numElements / (long)numTasks;
        return npn;
    }

    public Decomposition(int type, int numElements, int numTasks, int taskNumber) {
        if (type == BLOCK) {
            this.setBlockDecomp(numElements, numTasks, taskNumber);
        } else {
            this.setCircularDecomp(numElements, numTasks, taskNumber);
        }
    }

    public Decomposition(int type, int numElements, IParallelContext pc) {
        if (type == BLOCK) {
            this.setBlockDecomp(numElements, pc.size(), pc.rank());
        } else {
            this.setCircularDecomp(numElements, pc.size(), pc.rank());
        }
    }

    public Decomposition(int type, long numElements, int numTasks, int taskNumber) {
        if (type == BLOCK) {
            this.setBlockDecomp(numElements, numTasks, taskNumber);
        } else {
            this.setCircularDecomp(numElements, numTasks, taskNumber);
        }
    }

    public Decomposition(int type, long numElements, IParallelContext pc) {
        if (type == BLOCK) {
            this.setBlockDecomp(numElements, pc.size(), pc.rank());
        } else {
            this.setCircularDecomp(numElements, pc.size(), pc.rank());
        }
    }

    public Decomposition(Decomposition decomp) {
        this._type = decomp._type;
        this._elementsPerTask = decomp._elementsPerTask;
        this._numElements = decomp._numElements;
        this._liveElements = decomp._liveElements;
        this._paddedLength = decomp._paddedLength;
        this._indexRange = (long[])decomp._indexRange.clone();
        this._fortranRange = (long[])decomp._fortranRange.clone();
    }

    public void setBlockDecomp(long numElements, int numTasks, int taskNumber) {
        long nlive;
        long npn;
        long nrem = numElements % (long)numTasks;
        if (nrem > 0L) {
            npn = numElements / (long)numTasks + 1L;
            long nfull = numElements / npn;
            if ((long)taskNumber >= nfull) {
                nlive = numElements - npn * (long)taskNumber;
                if (nlive < 0L) {
                    nlive = 0L;
                }
            } else {
                nlive = npn;
            }
        } else {
            nlive = npn = numElements / (long)numTasks;
            long nfull = numTasks;
        }
        this._type = BLOCK;
        this._numElements = numElements;
        this._elementsPerTask = npn;
        this._liveElements = nlive;
        this._paddedLength = npn * (long)numTasks;
        this._indexRange = new long[3];
        this._fortranRange = new long[3];
        if (nlive > 0L) {
            this._indexRange[0] = npn * (long)taskNumber;
            this._indexRange[1] = this._indexRange[0] + nlive - 1L;
            this._indexRange[2] = 1L;
            this._fortranRange[0] = this._indexRange[0] + 1L;
            this._fortranRange[1] = this._indexRange[1] + 1L;
            this._fortranRange[2] = 1L;
        } else {
            this._indexRange[0] = 0L;
            this._indexRange[1] = -1L;
            this._indexRange[2] = 0L;
            this._fortranRange[0] = 0L;
            this._fortranRange[1] = -1L;
            this._fortranRange[2] = 0L;
        }
    }

    public void setCircularDecomp(long numElements, int numTasks, int taskNumber) {
        long nlive;
        long npn;
        long nrem = numElements % (long)numTasks;
        if (nrem == 0L) {
            nlive = npn = numElements / (long)numTasks;
        } else {
            npn = 1L + numElements / (long)numTasks;
            nlive = (long)taskNumber >= nrem ? npn - 1L : npn;
        }
        this._type = CIRCULAR;
        this._numElements = numElements;
        this._elementsPerTask = npn;
        this._liveElements = nlive;
        this._paddedLength = npn * (long)numTasks;
        this._indexRange = new long[3];
        this._fortranRange = new long[3];
        if (nlive > 0L) {
            this._indexRange[0] = taskNumber;
            this._indexRange[1] = this._indexRange[0] + (nlive - 1L) * (long)numTasks;
            this._indexRange[2] = numTasks;
            this._fortranRange[0] = this._indexRange[0] + 1L;
            this._fortranRange[1] = this._indexRange[1] + 1L;
            this._fortranRange[2] = numTasks;
        } else {
            this._indexRange[0] = 0L;
            this._indexRange[1] = 0L;
            this._indexRange[2] = 0L;
            this._fortranRange[0] = 0L;
            this._fortranRange[1] = 0L;
            this._fortranRange[2] = 0L;
        }
    }

    public int getDecompType() {
        return this._type;
    }

    public int getOriginalLength() {
        return (int)this._numElements;
    }

    public int getPaddedLength() {
        return (int)this._paddedLength;
    }

    public int getElementsPerTask() {
        return (int)this._elementsPerTask;
    }

    public int getLiveElements() {
        return (int)this._liveElements;
    }

    public long longOriginalLength() {
        return this._numElements;
    }

    public long longPaddedLength() {
        return this._paddedLength;
    }

    public long longElementsPerTask() {
        return this._elementsPerTask;
    }

    public long longLiveElements() {
        return this._liveElements;
    }

    public long[] longIndexRange() {
        return (long[])this._indexRange.clone();
    }

    public int[] getIndexRange() {
        int[] range = new int[3];
        for (int i = 0; i < 3; ++i) {
            range[i] = (int)this._indexRange[i];
        }
        return range;
    }

    public int[] getFortranRange() {
        int[] range = new int[3];
        for (int i = 0; i < 3; ++i) {
            range[i] = (int)this._fortranRange[i];
        }
        return range;
    }
}

