/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import edu.mines.jtk.util.ArrayMath;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import mpi.MPIException;
import org.javaseis.io.SortIOParms;
import org.javaseis.io.SortMapIO;
import org.javaseis.io.test.JTestSortMapIO3D;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.MPIContext;
import org.javaseis.parallel.UniprocessorContext;

public class TestSortmapIOParallel3D {
    private static final Logger LOG = Logger.getLogger(TestSortmapIOParallel3D.class.getName());

    public TestSortmapIOParallel3D(String[] args) throws MPIException, IOException {
        IParallelContext pc = null;
        try {
            pc = new MPIContext();
            pc.init(args);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.warning("MPI libraries not found, using UniProcessorContext");
            pc = new UniprocessorContext();
        }
        pc.masterPrint(LOG, "Parallel Sortmap write Tests");
        int size = pc.size();
        int nFrames = 3 * size;
        int nTracesPerFrame = 97;
        SortIOParms parms = null;
        Object[] strings = new String[2];
        if (pc.rank() == 0) {
            File out = File.createTempFile("sortmap_test", "js");
            out.delete();
            out.mkdir();
            strings[0] = out.getAbsolutePath();
            strings[1] = System.currentTimeMillis() + "";
            parms = JTestSortMapIO3D.createParms((String)strings[0], (String)strings[1], nFrames, nTracesPerFrame);
            LOG.info("Creating sortmap definition");
        }
        pc.barrier();
        int tag = 1121;
        pc.bcast(tag, strings, 0, 2, 0);
        LOG.info("strings = " + Arrays.toString(strings));
        Decomposition decomp = new Decomposition(Decomposition.BLOCK, nFrames, pc);
        int[] range = decomp.getIndexRange();
        LOG.info("range = " + Arrays.toString(range));
        JTestSortMapIO3D.write((String)strings[0], (String)strings[1], range[0], range[1], nTracesPerFrame);
        int[] min = pc.collectInt(range[0]);
        int[] max = pc.collectInt(range[1]);
        int frmMax = ArrayMath.max((int[])max);
        int frmMin = ArrayMath.min((int[])min);
        if (pc.rank() == 0) {
            JTestSortMapIO3D.writeVolumeWrapper((String)strings[0], (String)strings[1], frmMax - frmMin + 1);
        }
        pc.barrier();
        if (pc.rank() == 0) {
            JTestSortMapIO3D.validate((String)strings[0], (String)strings[1], parms);
            SortMapIO.delete((String)strings[0]);
            new File((String)strings[0]).delete();
        }
        pc.barrier();
        pc.finish();
    }

    public static void main(String[] args) throws MPIException, IOException {
        new TestSortmapIOParallel3D(args);
    }
}

