#!/bin/sh
appname=`basename $0 | sed s,\.sh$,,`

dirname=`dirname $0`
tmp="${dirname#?}"

if [ "${dirname%$tmp}" != "/" ]; then
dirname=$PWD
fi

LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$dirname
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$dirname/libtorch
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$dirname/openmpi
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$dirname/vtk

export MKL_NUM_THREADS=$(nproc)
echo $MKL_NUM_THREADS

export LD_LIBRARY_PATH
echo $LD_LIBRARY_PATH

export QT_AUTO_SCREEN_SCALE_FACTOR=0
export QT_ENABLE_HIGHDPI_SCALING=0
export QT_SCALE_FACTOR=1

#ldd Flatirons++

#export QT_QPA_PLATFORM=xcb
#export QT_QPA_PLATFORM=wayland

export QT_PLUGIN_PATH=$dirname/plugins

export PHOENIX_INSTALLDIR=$dirname
echo $PHOENIX_INSTALLDIR

$dirname/Flatirons++
#$dirname/$appname
