/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import org.javaseis.array.ArrayStorage;
import org.javaseis.array.ByteBufferStorage;
import org.javaseis.array.IBackingArray;
import org.javaseis.array.LongArrayStorage;

public class BackingArray {
    public static IBackingArray factory(Class<?> classType, long length, Type type) {
        IBackingArray a = null;
        if (type == Type.JAVA_ARRAY) {
            a = new ArrayStorage(classType, length);
        } else if (type == Type.JAVA_LONG_ARRAY) {
            a = new LongArrayStorage(classType, length);
        } else if (type == Type.BYTE_BUFFER) {
            a = new ByteBufferStorage(classType, length);
        } else {
            throw new UnsupportedOperationException("BackingArray Type not supported: " + (Object)((Object)type));
        }
        return a;
    }

    public static void arraycopy(IBackingArray src, long srcOffset, IBackingArray dest, long destOffset, long count) {
        if (srcOffset < 0L) {
            throw new IllegalArgumentException("srcOffset is not valid " + srcOffset);
        }
        if (destOffset < 0L) {
            throw new IllegalArgumentException("destOffset is not valid " + destOffset);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count is not valid " + count);
        }
        Class classType = src.getClassType();
        if (classType != dest.getClassType()) {
            throw new IllegalArgumentException("Class Types of src and dest BackingArrays do not match");
        }
        int length = (int)count;
        ArrayStorage buf = new ArrayStorage(classType, length);
        if (classType == Byte.TYPE) {
            src.getArray(buf._bytes, 0, length, srcOffset);
            dest.putArray(buf._bytes, 0, length, destOffset);
        } else if (classType == Short.TYPE) {
            src.getArray(buf._shorts, 0, length, srcOffset);
            dest.putArray(buf._shorts, 0, length, destOffset);
        } else if (classType == Integer.TYPE) {
            src.getArray(buf._ints, 0, length, srcOffset);
            dest.putArray(buf._ints, 0, length, destOffset);
        } else if (classType == Long.TYPE) {
            src.getArray(buf._longs, 0, length, srcOffset);
            dest.putArray(buf._longs, 0, length, destOffset);
        } else if (classType == Float.TYPE) {
            src.getArray(buf._floats, 0, length, srcOffset);
            dest.putArray(buf._floats, 0, length, destOffset);
        } else if (classType == Double.TYPE) {
            src.getArray(buf._doubles, 0, length, srcOffset);
            dest.putArray(buf._doubles, 0, length, destOffset);
        } else {
            src.getArray(buf._objects, 0, length, srcOffset);
            dest.putArray(buf._objects, 0, length, destOffset);
        }
        buf = null;
    }

    public static enum Type {
        JAVA_ARRAY,
        JAVA_LONG_ARRAY,
        BYTE_BUFFER,
        NATIVE_ARRAY;

    }
}

