/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.security.interfaces.F2mParams;
import javax.security.spec.ECParameterSpec;

public class F2mParameterSpec
extends ECParameterSpec
implements Serializable,
F2mParams {
    private static final long serialVersionUID = -7363284560829679215L;
    private int b = -1;
    private int c = -1;
    private int d = -1;

    public F2mParameterSpec() {
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, String string) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string);
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int n4, String string) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string);
        this.b = n4;
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int n4, int n5, int n6, String string) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string);
        this.b = n4;
        this.c = n5;
        this.d = n6;
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int[] nArray, String string) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string);
        if (nArray != null) {
            if (nArray.length == 1) {
                this.b = nArray[0];
            } else if (nArray.length == 3) {
                this.b = nArray[0];
                this.c = nArray[1];
                this.d = nArray[2];
            } else {
                throw new IllegalArgumentException("basis not recognized");
            }
        }
    }

    public int[] getBasis() {
        if (this.b == -1) {
            return null;
        }
        if (this.c == -1) {
            return new int[]{this.b};
        }
        return new int[]{this.b, this.c, this.d};
    }

    public void zeroize() throws FIPSException {
        this.b = -1;
        this.c = -1;
        this.d = -1;
        super.zeroize();
    }

    public String toString() {
        byte[] byArray = this.getSeed();
        StringBuffer stringBuffer = new StringBuffer("[ Curve = ");
        return stringBuffer.append(this.getOID()).append(" FieldType: F2m").append(" curveAtA: ").append(Conversion.OS2Hex(this.getA(), 8)).append(" curveAtB: ").append(Conversion.OS2Hex(this.getB(), 8)).append(" seed: ").append(byArray == null ? "NULL" : Conversion.OS2Hex(byArray, 8)).append(" baseAtX: ").append(Conversion.OS2Hex(this.getGx(), 8)).append(" baseAtY: ").append(Conversion.OS2Hex(this.getGy(), 8)).append(" order: ").append(Conversion.OS2Hex(this.getPointOrder(), 8)).append(" cf: ").append(Integer.toString(this.getCofactor())).append(" size: ").append(Integer.toString(this.getSize())).append(" basis: ").append(" k: ").append(this.b == -1 ? "NULL " : Integer.toString(this.b)).append(" k2: ").append(this.c == -1 ? "NULL " : Integer.toString(this.c)).append(" k3: ").append(this.d == -1 ? "NULL " : Integer.toString(this.d)).append(" ]").toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.b);
        objectOutputStream.writeInt(this.c);
        objectOutputStream.writeInt(this.d);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.b = objectInputStream.readInt();
        this.c = objectInputStream.readInt();
        this.d = objectInputStream.readInt();
    }
}

