/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECException;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.ECDH;
import com.certicom.ecc.scheme.ECDSA;
import com.certicom.ecc.scheme.ECKeyDerive;
import com.certicom.ecc.scheme.ECMQV;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.spec.ECPrivateKeySpec;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.spec.PointSpec;
import com.certicom.ecc.util.RandomValue;
import com.certicom.ecc.util.a;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Random;

public class ECKeyGen
extends ECTransform
implements Serializable {
    private static final long serialVersionUID = 5209870863303854858L;
    private ECParams a = null;
    private int b;
    private ECFactory c = null;
    private static Hashtable d = new Hashtable();
    private static Hashtable e = new Hashtable();

    public ECKeyGen() {
        super("ECKeyGen");
        this.reset();
    }

    public void reset() {
        super.reset();
        this.a = null;
        this.b = 0;
        this.c = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n2, objectArray, random);
        boolean bl = true;
        try {
            if (n2 != 5) {
                throw new IllegalArgumentException("mode!=GENKEY");
            }
            if (objectArray == null) {
                throw new IllegalArgumentException("params==null");
            }
            if (objectArray.length != 1) {
                throw new IllegalArgumentException("params.length != 1");
            }
            if (!(objectArray[0] instanceof ECParams)) {
                throw new IllegalArgumentException("params[0] is not ECParams");
            }
            this.a = (ECParams)objectArray[0];
            this.b = this.a.getSize();
            this.c();
            bl = false;
        }
        finally {
            if (bl) {
                this.reset();
            }
        }
    }

    public int outputSize(int n2, boolean bl) {
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.g == null || this.a == null) {
            throw new IllegalStateException("no rnd or no curve");
        }
        BigInteger bigInteger = new BigInteger(1, RandomValue.inRange(this.g, this.a.getPointOrder(), true));
        ECA eCA = this.c.c().a(bigInteger);
        return new ECKey[]{new ECPrivateKeySpec(this.a(), bigInteger, this.a), new ECPublicKeySpec(this.a(), this.b(), new PointSpec(eCA.e().f(), eCA.f().f(), this.a), this.a)};
    }

    private void c() {
        try {
            this.c = ECFactory.a(this.a);
        }
        catch (ECException eCException) {
            throw new IllegalStateException("cannot do cryptography.");
        }
    }

    protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
        ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)((Object[])object)[0];
        ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)((Object[])object)[1];
        ECKeyDerive eCKeyDerive = new ECKeyDerive();
        ((CryptoTransform)eCKeyDerive).init(5, new Object[]{eCPrivateKeySpec}, null);
        ECPublicKey eCPublicKey = (ECPublicKey)((CryptoTransform)eCKeyDerive).transformToObject(null, 0, 0, true);
        byte[] byArray2 = eCPublicKey.getX();
        byte[] byArray3 = eCPublicKey.getY();
        return Arrays.equals(byArray2, eCPublicKeySpec.getX()) && Arrays.equals(byArray3, eCPublicKeySpec.getY());
        {
        }
    }

    protected ECKey[] a(boolean bl, ECParams eCParams) {
        if (eCParams == null) {
            return null;
        }
        Hashtable hashtable = bl ? d : e;
        ECKey[] eCKeyArray = (ECKey[])hashtable.get(eCParams);
        if (eCKeyArray == null) {
            ECKeyGen eCKeyGen = new ECKeyGen();
            eCKeyGen.init(5, new Object[]{eCParams}, this.g);
            eCKeyArray = (ECKey[])this.transformToObject(null, 0, 0, true);
            hashtable.put(eCParams, eCKeyArray);
        }
        return eCKeyArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeInt(this.b);
        objectOutputStream.writeObject(this.c);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (ECParams)objectInputStream.readObject();
        this.b = objectInputStream.readInt();
        this.c = (ECFactory)objectInputStream.readObject();
    }

    public static class ECMQVKeyGen
    extends ECKeyGen {
        protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
            if (super.a(byArray, n2, n3, bl, object)) {
                int n4;
                ECKey[] eCKeyArray = (ECKey[])object;
                ECKey eCKey = eCKeyArray[0];
                ECKey eCKey2 = eCKeyArray[1];
                ECKey[] eCKeyArray2 = this.a(false, eCKey2.getECParams());
                if (eCKeyArray2 == null) {
                    return false;
                }
                ECMQV eCMQV = new ECMQV();
                byte[][] byArrayArray = new byte[2][];
                for (n4 = 0; n4 < 2; ++n4) {
                    Object[] objectArray = n4 == 0 ? new Object[]{eCKey, eCKey2, eCKey, eCKey2, eCKeyArray2[1], eCKeyArray2[1]} : new Object[]{eCKeyArray2[0], eCKeyArray2[1], eCKeyArray2[0], eCKeyArray2[1], eCKey2, eCKey2};
                    eCMQV.init(6, objectArray, this.g);
                    byArrayArray[n4] = eCMQV.transform(null, 0, 0, true);
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    if (byArrayArray[n4] != null && byArrayArray[n4].length >= 1) continue;
                    return false;
                }
                return Arrays.equals(byArrayArray[0], byArrayArray[1]);
            }
            return false;
        }
    }

    public static class ECDSAKeyGen
    extends ECKeyGen {
        protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
            if (super.a(byArray, n2, n3, bl, object)) {
                ECKey[] eCKeyArray = (ECKey[])object;
                ECKey eCKey = eCKeyArray[0];
                ECKey eCKey2 = eCKeyArray[1];
                byte[] byArray2 = "Romanes eunt domus".getBytes();
                ECDSA eCDSA = new ECDSA();
                try {
                    eCDSA.init(1, new Object[]{eCKey}, this.g);
                    byte[] byArray3 = eCDSA.transform(byArray2, 0, byArray2.length, true);
                    if (this.g()) {
                        com.certicom.ecc.util.a.a("EC Keygen: modifying signature 5th byte", byArray3);
                        byArray3[4] = (byte)(byArray3[4] ^ 1);
                        com.certicom.ecc.util.a.a(byArray3);
                    }
                    eCDSA.init(2, new Object[]{eCKey2}, null);
                    eCDSA.transform(byArray2, 0, byArray2.length, true);
                    return eCDSA.verify(byArray3, 0, byArray3.length);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ECDHKeyGen
    extends ECKeyGen {
        protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
            if (super.a(byArray, n2, n3, bl, object)) {
                int n4;
                ECKey[] eCKeyArray = (ECKey[])object;
                ECKey eCKey = eCKeyArray[0];
                ECKey eCKey2 = eCKeyArray[1];
                ECKey[] eCKeyArray2 = this.a(true, eCKey2.getECParams());
                if (eCKeyArray2 == null) {
                    return false;
                }
                ECDH eCDH = new ECDH();
                byte[][] byArrayArray = new byte[2][];
                for (n4 = 0; n4 < 2; ++n4) {
                    eCDH.init(6, new Object[]{n4 == 0 ? eCKey : eCKeyArray2[0], n4 == 0 ? eCKeyArray2[1] : eCKey2, Boolean.FALSE}, null);
                    byArrayArray[n4] = eCDH.transform(null, 0, 0, true);
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    if (byArrayArray[n4] != null && byArrayArray[n4].length >= 1) continue;
                    return false;
                }
                return Arrays.equals(byArrayArray[0], byArrayArray[1]);
            }
            return false;
        }
    }
}

