/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECException;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.FF;
import com.certicom.ecc.FFFactory;
import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.ECKeyGen;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public final class ECDSA
extends ECTransform
implements Serializable {
    private static final long serialVersionUID = 8073799184369550151L;
    private ECKey a;
    private FFFactory b;
    private CryptoTransform c;
    private ECA d;
    private ECA e;
    private byte[] f;
    private CryptoCodec k;
    private boolean l = ECDSA.c();
    private static ThreadLocal m = new ThreadLocal();
    private static boolean n = false;

    public ECDSA() {
        super("ECDSA");
        this.setHashMode(this.getHashMode());
        this.k = CryptoCodec.getInstance("ECDSA", this.a());
    }

    public void reset() {
        super.reset();
        this.a = null;
        this.b = null;
        if (this.c != null) {
            this.c.reset();
        }
        this.d = null;
        this.e = null;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        Object object;
        boolean bl = false;
        this.reset();
        super.init(n2, objectArray, random);
        if (objectArray != null && (n2 == 1 && random != null || n2 == 2)) {
            bl = true;
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        String string = null;
        if (objectArray.length < 2 || objectArray[1] == null) {
            string = "SHA-1";
        } else {
            if (!(objectArray[1] instanceof String)) {
                this.reset();
                throw new IllegalArgumentException("params[1] should be String to represent hash algorithm");
            }
            object = (String)objectArray[1];
            if (((String)object).equals("SHA1") || ((String)object).equals("SHA-1")) {
                string = "SHA-1";
            } else if (((String)object).equals("SHA224") || ((String)object).equals("SHA-224")) {
                string = "SHA-224";
            } else if (((String)object).equals("SHA384") || ((String)object).equals("SHA-384")) {
                string = "SHA-384";
            } else if (((String)object).equals("SHA256") || ((String)object).equals("SHA-256")) {
                string = "SHA-256";
            } else if (((String)object).equals("SHA512") || ((String)object).equals("SHA-512")) {
                string = "SHA-512";
            } else {
                this.reset();
                throw new IllegalArgumentException("message digest algorithm " + (String)object + " is not supported with ECDSA");
            }
        }
        this.c = (CryptoTransform)CryptoManager.getInstance(TYPE, string);
        this.c.init(5, null, random);
        this.a = (ECKey)objectArray[0];
        try {
            object = ECFactory.a(this.a.getECParams());
            this.b = FFFactory.a("FP");
            this.b.a(this.a.getECParams().getPointOrder(), null);
            this.d = ((ECFactory)object).c();
            if (n2 == 2) {
                ECPublicKey eCPublicKey = (ECPublicKey)this.a;
                this.e = ((ECFactory)object).a(eCPublicKey.getX(), eCPublicKey.getY());
            }
        }
        catch (ECException eCException) {
            this.reset();
            throw new IllegalStateException("cannot do ec operations.");
        }
    }

    public boolean isVerifiable() {
        return true;
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        if (this.h != 1 && this.h != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (!bl || bl && this.h == 2) {
            return 0;
        }
        int n3 = (this.a.getECParams().getPointOrderSize() + 7) / 8 * 2;
        if (this.a() == 10) {
            return n3;
        }
        if (this.a() == 11) {
            return n3 + 9;
        }
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        Object object;
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        ECA eCA = null;
        FF fF = null;
        if (this.h != 1 && this.h != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray != null) {
            if (this.getHashMode() == 1) {
                this.f = new byte[n3];
                System.arraycopy(byArray, n2, this.f, 0, n3);
            } else {
                this.c.transform(byArray, n2, n3, false);
            }
        }
        if (!bl || bl && this.h == 2) {
            return 0;
        }
        FF fF2 = this.b.a(this.d());
        try {
            serializable2 = new ECKeyGen();
            ((CryptoTransform)serializable2).init(5, new Object[]{this.a.getECParams()}, this.g);
            object2 = (Object[])((CryptoTransform)serializable2).transformToObject(null, 0, 0, true);
            serializable = FFFactory.a("FP");
            ((FFFactory)serializable).a(this.a.getECParams().getPointOrder(), null);
            fF = ((FFFactory)serializable).a(((ECPrivateKey)object2[0]).getExp());
            object = ECFactory.a(this.a.getECParams());
            eCA = ((ECFactory)object).a(((ECPublicKey)object2[1]).getX(), ((ECPublicKey)object2[1]).getY());
        }
        catch (ECException eCException) {
            this.reset();
            throw new IllegalStateException("cannot do ec operations.");
        }
        serializable2 = this.b.a(eCA.e().f());
        object2 = this.b.a(((ECPrivateKey)this.a).getExp());
        serializable = fF.c().c(((FF)object2).c((FF)serializable2).a(fF2));
        object = ((FF)serializable2).f();
        byte[] byArray3 = ((FF)serializable).f();
        this.k.init(1, null);
        this.k.codecToObject((byte[])object, 0, ((Object)object).length, false);
        Object[] objectArray = this.k.codecToObject(byArray3, 0, byArray3.length, true);
        byte[] byArray4 = (byte[])objectArray[1];
        if (byArray2.length - n4 < byArray4.length) {
            throw new IllegalArgumentException("output buffer too short.");
        }
        System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
        return byArray4.length;
    }

    public boolean verify(byte[] byArray, int n2, int n3) {
        if (this.h != 2) {
            throw new IllegalStateException("wrong mode.");
        }
        try {
            this.k.init(2, null);
            Object[] objectArray = this.k.codecToObject(byArray, n2, n3, true);
            byte[] byArray2 = (byte[])objectArray[1];
            byte[] byArray3 = (byte[])objectArray[2];
            FF fF = this.b.a(this.d());
            FF fF2 = this.b.a(byArray2);
            FF fF3 = this.b.a(byArray3);
            FF fF4 = fF3.c();
            FF fF5 = fF.c(fF4);
            FF fF6 = fF2.c(fF4);
            ECA eCA = this.d.a(fF5.g(), this.e, fF6.g());
            FF fF7 = this.b.a(eCA.e().f());
            return fF7.equals(fF2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private byte[] d() {
        if (this.getHashMode() == 2) {
            this.f = this.c.transform(null, 0, 0, true);
        }
        if (this.l) {
            int n2;
            if (SystemConfig.getConfig().getConformance() == 16 && (n2 = 160 - ECDSA.a(this.a.getECParams().getPointOrder()) + 1) >= 1) {
                int n3;
                for (n3 = 0; n3 < n2 / 8; ++n3) {
                    this.f[n3] = 0;
                }
                if (n2 % 8 != 0) {
                    int n4 = n3;
                    this.f[n4] = (byte)(this.f[n4] & (1 << 8 - n2 % 8) - 1);
                }
            }
            return this.f;
        }
        return ECDSA.a(this.f, this.a.getECParams().getPointOrderSize());
    }

    private static int a(byte[] byArray) {
        int n2;
        if (byArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        if (n2 == byArray.length) {
            return 0;
        }
        int n3 = (byArray.length - n2 - 1) * 8;
        int n4 = 7;
        do {
            if ((byArray[n2] >>> n4 & 1) != 1) continue;
            n3 += n4 + 1;
            break;
        } while (--n4 >= 0);
        return n3;
    }

    static byte[] a(byte[] byArray, int n2) {
        int n3 = byArray.length * 8;
        if (n3 <= n2) {
            return byArray;
        }
        int n4 = (n2 + 7) / 8;
        byte[] byArray2 = new byte[n4];
        int n5 = n2 % 8;
        int n6 = 8 - n5;
        if (n5 == 0) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        } else {
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (i2 != 0) {
                    byArray2[i2] = (byte)(byArray[i2 - 1] << n5);
                }
                int n7 = i2;
                byArray2[n7] = (byte)(byArray2[n7] | (byte)((byArray[i2] & 0xFF) >> n6));
            }
        }
        return byArray2;
    }

    public static void setThreadOldHashTruncate(boolean bl) {
        m.set(new Boolean(bl));
    }

    public static Boolean getThreadOldHashTruncate() {
        return (Boolean)m.get();
    }

    protected static boolean c() {
        Boolean bl = ECDSA.getThreadOldHashTruncate();
        if (bl == null) {
            return ECDSA.getGlobalOldHashTruncate();
        }
        return bl;
    }

    public static boolean getGlobalOldHashTruncate() {
        return n;
    }

    public static void setGlobalOldHashTruncate(boolean bl) {
        n = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeObject(this.d);
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.f);
        objectOutputStream.writeObject(this.k);
        objectOutputStream.writeBoolean(this.l);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (ECKey)objectInputStream.readObject();
        this.b = (FFFactory)objectInputStream.readObject();
        this.c = (CryptoTransform)objectInputStream.readObject();
        this.d = (ECA)objectInputStream.readObject();
        this.e = (ECA)objectInputStream.readObject();
        this.f = (byte[])objectInputStream.readObject();
        this.k = (CryptoCodec)objectInputStream.readObject();
        this.l = objectInputStream.readBoolean();
    }
}

