/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.SecretKeyGenSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class RC2KeyGenSpi
extends SecretKeyGenSpi {
    public RC2KeyGenSpi() {
        super(16, "RC2");
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        if (n2 < 1 || n2 > 1024) {
            throw new InvalidParameterException("Invalid key spec RC2");
        }
        super.engineInit(n2, secureRandom);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid Algorithm parameter for RC2");
        }
        int n2 = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits();
        super.engineInit(n2, secureRandom);
    }
}

