/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

abstract class GenericCipher
extends CipherSpi {
    public static final int ENCRYPT = 1;
    public static final int DECRYPT = 2;
    public static final int WRAP = 3;
    public static final int UNWRAP = 4;
    protected int i = -1;

    public byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.i != 3) {
            throw new IllegalStateException("InvalidState");
        }
        try {
            byte[] byArray = key.getEncoded();
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.toString());
        }
    }

    public Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.i != 4) {
            throw new IllegalStateException("InvalidState");
        }
        if (n2 != 3 && n2 != 1 && n2 != 2) {
            throw new InvalidKeyException("InvalidUnwrapKeyType");
        }
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return this.a(byArray2, string, n2);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.toString());
        }
    }

    protected Key a(byte[] byArray, String string, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        try {
            if (n2 != 3 && n2 != 1 && n2 != 2) {
                throw new InvalidKeyException("Invalid key type " + n2);
            }
            Key key = null;
            if (n2 == 3) {
                SecretKeyFactory secretKeyFactory = null;
                try {
                    secretKeyFactory = SecretKeyFactory.getInstance(string, "Certicom");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    try {
                        secretKeyFactory = SecretKeyFactory.getInstance(string);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                        // empty catch block
                    }
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
                key = secretKeyFactory != null ? secretKeyFactory.generateSecret(secretKeySpec) : secretKeySpec;
            } else {
                KeyFactory keyFactory = null;
                try {
                    keyFactory = KeyFactory.getInstance(string, "Certicom");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    keyFactory = KeyFactory.getInstance(string);
                }
                if (n2 == 1) {
                    X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                    return keyFactory.generatePublic(x509EncodedKeySpec);
                }
                if (n2 == 2) {
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                    key = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                }
            }
            return key;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InvalidKeyException(noSuchProviderException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.getMessage());
        }
    }
}

