/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.DHPrivateKeyImpl;
import com.certicom.ecc.jcae.DHPublicKeyImpl;
import com.certicom.ecc.jcae.X942PrivateKey;
import com.certicom.ecc.spec.X942ParameterSpec;
import com.certicom.ecc.spec.X942PrivateKeySpec;
import com.certicom.ecc.spec.X942PublicKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKeyFactorySpi
extends KeyFactorySpi {
    private static final Class g = a == null ? (a = DHKeyFactorySpi.a("javax.crypto.spec.DHPublicKeySpec")) : a;
    private static final Class h = b == null ? (b = DHKeyFactorySpi.a("javax.crypto.spec.DHPrivateKeySpec")) : b;
    private static final Class i = c == null ? (c = DHKeyFactorySpi.a("com.certicom.ecc.spec.X942PublicKeySpec")) : c;
    private static final Class j = d == null ? (d = DHKeyFactorySpi.a("com.certicom.ecc.spec.X942PrivateKeySpec")) : d;
    private static final Class k = e == null ? (e = DHKeyFactorySpi.a("java.security.spec.X509EncodedKeySpec")) : e;
    private static final Class l = f == null ? (f = DHKeyFactorySpi.a("java.security.spec.PKCS8EncodedKeySpec")) : f;
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            return new DHPrivateKeyImpl((DSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof X942PrivateKeySpec) {
            return new DHPrivateKeyImpl((X942PrivateKeySpec)keySpec);
        }
        if (keySpec instanceof DHPrivateKeySpec) {
            return new DHPrivateKeyImpl((DHPrivateKeySpec)keySpec);
        }
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DHPrivateKeyImpl(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException(exception.getMessage());
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            return new DHPublicKeyImpl((DSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X942PublicKeySpec) {
            return new DHPublicKeyImpl((X942PublicKeySpec)keySpec);
        }
        if (keySpec instanceof DHPublicKeySpec) {
            return new DHPublicKeyImpl((DHPublicKeySpec)keySpec);
        }
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DHPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException(exception.getMessage());
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof DSAPublicKey) {
            if (g.isAssignableFrom(clazz)) {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
                DSAParams dSAParams = dSAPublicKey.getParams();
                return new DHPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getG());
            }
            throw new InvalidKeySpecException("Invalid DSAPublicKey Format");
        }
        if (key instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)key;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            if (i.isAssignableFrom(clazz)) {
                if (!(dHParameterSpec instanceof X942ParameterSpec)) {
                    throw new InvalidKeySpecException("Cannot produce " + clazz + " from " + dHPublicKey.getClass());
                }
                X942ParameterSpec x942ParameterSpec = (X942ParameterSpec)dHParameterSpec;
                return new X942PublicKeySpec(dHPublicKey.getY(), x942ParameterSpec.getP(), x942ParameterSpec.getG(), x942ParameterSpec.getQ(), x942ParameterSpec.getJ(), x942ParameterSpec.getSeed(), x942ParameterSpec.getCounter());
            }
            if (g.isAssignableFrom(clazz)) {
                DHParameterSpec dHParameterSpec2 = dHPublicKey.getParams();
                return new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec2.getP(), dHParameterSpec2.getG());
            }
            if (k.isAssignableFrom(clazz) && key.getFormat().equals("X.509")) {
                return new X509EncodedKeySpec(((DHPublicKey)key).getEncoded());
            }
            throw new InvalidKeySpecException("Invalid DHPublicKey Format");
        }
        if (key instanceof DSAPrivateKey) {
            if (h.isAssignableFrom(clazz)) {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
                DSAParams dSAParams = dSAPrivateKey.getParams();
                return new DHPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getG());
            }
            throw new InvalidKeySpecException("Invalid DSAPrivateKey Format");
        }
        if (key instanceof DHPrivateKey) {
            if (h.isAssignableFrom(clazz)) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
                DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
                return new DHPrivateKeySpec(dHPrivateKey.getX(), dHParameterSpec.getP(), dHParameterSpec.getG());
            }
            if (j.isAssignableFrom(clazz)) {
                X942PrivateKey x942PrivateKey = (X942PrivateKey)key;
                X942ParameterSpec x942ParameterSpec = x942PrivateKey.getX942Params();
                return new X942PrivateKeySpec(x942PrivateKey.getX(), x942ParameterSpec.getP(), x942ParameterSpec.getG(), x942ParameterSpec.getQ(), x942ParameterSpec.getJ(), x942ParameterSpec.getSeed(), x942ParameterSpec.getCounter());
            }
            if (l.isAssignableFrom(clazz) && key.getFormat().equals("PKCS#8")) {
                return new PKCS8EncodedKeySpec(((DHPrivateKey)key).getEncoded());
            }
            throw new InvalidKeySpecException("Invalid DHPrivateKey Format");
        }
        throw new InvalidKeySpecException("do not support " + key.getClass().getName());
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof DHPrivateKeyImpl) {
            return key;
        }
        if (key instanceof DHPublicKeyImpl) {
            return key;
        }
        if (key instanceof DSAPrivateKey) {
            return new DHPrivateKeyImpl((DSAPrivateKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return new DHPublicKeyImpl((DSAPublicKey)key);
        }
        if (key instanceof DHPrivateKey) {
            return new DHPrivateKeyImpl((DHPrivateKey)key);
        }
        if (key instanceof DHPublicKey) {
            return new DHPublicKeyImpl((DHPublicKey)key);
        }
        throw new InvalidKeyException("invalid key" + key.getClass().getName());
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

