/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import org.javaseis.io.Seisio;

public class VolumeEvaluator {
    private long[] _lengths = null;
    private long _num_elems = 0L;
    private long _center = -1L;
    private long _total = 0L;

    public VolumeEvaluator(Seisio seisio) {
        int k2;
        this._lengths = seisio.getGridDefinition().getAxisLengths();
        this._num_elems = 1L;
        for (k2 = 0; k2 < this._lengths.length; ++k2) {
            this._num_elems *= this._lengths[k2];
        }
        this._total = this._num_elems / this._lengths[0];
        long[] cpos = new long[this._lengths.length - 1];
        for (k2 = 1; k2 < this._lengths.length; ++k2) {
            cpos[k2 - 1] = (this._lengths[k2] + 1L) / 2L - 1L;
        }
        this._center = this.getIndex(cpos);
    }

    public long getTotal() {
        return this._total;
    }

    public long getCenter() {
        return this._center;
    }

    public long getNumElements() {
        return this._num_elems;
    }

    public long[] getPosition(long index) {
        int k2;
        long[] retval = new long[this._lengths.length - 1];
        long area = 1L;
        for (k2 = 1; k2 < retval.length; ++k2) {
            area *= this._lengths[k2];
        }
        long loc_index = index;
        for (k2 = retval.length - 1; k2 > -1; --k2) {
            retval[k2] = loc_index / area;
            loc_index -= retval[k2] * area;
            area /= this._lengths[k2];
        }
        return retval;
    }

    public long getIndex(int[] position) {
        long[] loc_position = new long[position.length];
        for (int k2 = 0; k2 < position.length; ++k2) {
            loc_position[k2] = position[k2];
        }
        return this.getIndex(loc_position);
    }

    public long getIndex(long[] position) {
        if (position.length != this._lengths.length - 1) {
            return -1L;
        }
        long retval = 0L;
        long area = 1L;
        for (int k2 = 0; k2 < position.length; ++k2) {
            retval += position[k2] * area;
            area *= this._lengths[k2 + 1];
        }
        return retval;
    }

    public long[] getLengths() {
        return this._lengths;
    }
}

