/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import java.io.File;
import org.javaseis.util.SeisException;
import org.javaseis.util.datavolume.Name;

public class Directory {
    public static final int NO = 0;
    public static final int YES = 1;
    public static final int TMP = 2;
    private int _create_state = 1;
    private String _name;

    public Directory() {
        this._create_state = 1;
    }

    public Directory(int create_status) {
        this._create_state = create_status;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String verifyFolder(String path, String name) throws SeisException {
        String retval = null;
        File f = new File(new FileAndPath(path, name).getPath());
        if (!f.exists()) {
            if (this._create_state != 0) {
                if (!f.mkdirs()) {
                    throw new SeisException(f.getAbsolutePath() + " doesn't exist and can't be created");
                }
                retval = f.getAbsolutePath();
                if (this._create_state == 2) {
                    f.delete();
                }
            } else {
                retval = f.getAbsolutePath();
            }
        } else {
            if (!f.isDirectory()) {
                throw new SeisException(f.getAbsolutePath() + " exists but is not a folder");
            }
            retval = f.getAbsolutePath();
        }
        return retval;
    }

    public boolean recursiveDelete(String path) {
        File f = Directory.validFile(path, this._name);
        if (f == null) {
            return true;
        }
        if (f.isDirectory()) {
            String[] children = f.list();
            for (int k2 = 0; k2 < children.length; ++k2) {
                if (this.recursiveDelete(f.getAbsolutePath() + File.separator + children[k2])) continue;
                return false;
            }
        }
        return f.delete();
    }

    public static File validFile(String path, String name) {
        FileAndPath fp = new FileAndPath(path, name);
        return fp._file;
    }

    public static String validPath(String path, String name) {
        FileAndPath fp = new FileAndPath(path, name);
        return fp.getPath();
    }

    private static class FileAndPath {
        private String _path;
        private File _file;
        private String _extension = "";

        private FileAndPath(String path) {
            this(path, null);
        }

        private FileAndPath(String path, String name) {
            if (name != null) {
                Name nam = new Name(name);
                this._extension = nam.getExtension();
                path = path + "." + nam.getWithoutExtension();
            }
            this.getDeepestPath(path);
        }

        private String getPath() {
            String retval = null;
            retval = this._extension.length() > 0 ? this._path + "." + this._extension : this._path;
            return retval;
        }

        private void getDeepestPath(String path) {
            this._file = new File(path);
            if (!this._file.exists()) {
                this._path = path.replaceFirst("[.]", File.separator);
                if (this._path.equals(path)) {
                    this._file = null;
                } else {
                    this.getDeepestPath(this._path);
                }
            }
        }
    }
}

