/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.access;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.properties.TraceProperties;
import org.javaseis.util.ArrayUtil;
import org.javaseis.util.SeisException;
import org.javaseis.util.access.JSIO;
import org.javaseis.util.access.JavaSeisDescriptor;
import org.javaseis.util.access.JavaSeisValidator;
import org.javaseis.util.access.SeisioCreator;
import org.javaseis.util.access.TraceAccessor;
import org.javaseis.util.datavolume.JSC;
import org.javaseis.util.datavolume.VDU;
import org.javaseis.util.datavolume.VolumeParameters;

public class JavaSeisIO
implements JSIO {
    public static final int ERROR = -1;
    public static final int HAVE_NOTHING = 0;
    public static final int HAVE_TRACE = 1;
    protected static final int FRAME_COUNT = 3;
    protected TraceAccessor _js;
    protected JavaSeisDescriptor _descr;
    protected boolean _opened_before;
    protected String _io_mode;
    protected boolean _read_write;
    protected String _error_message = "Programming error: Init() has not been called yet";
    protected ParameterSet _history;
    protected String _directory;
    protected int _status = -1;
    protected long _trace_num = -1L;
    private float[] _trace;
    private ParameterSet _bingrid;
    private static int X = 1;
    private static int Y = 2;

    protected JavaSeisIO(String directory) {
        this._directory = this.getDirectory(directory);
        this._opened_before = this.openedBefore(directory);
    }

    protected String getDirectory(String path) {
        return path;
    }

    protected boolean openedBefore(String path) {
        return new JavaSeisValidator(path).isAJavaSeisPath();
    }

    protected void openHelper(Seisio seisio) {
        this._status = 0;
        this._error_message = "";
        try {
            if (!this.setIndex(1L)) {
                this.printError("JavaSeisIO: Failed to position to first trace", null);
                return;
            }
        }
        catch (Exception e) {
            this.printError("JavaSeisIO: Open error - ", e);
        }
        this.addOpenHelperProperties(seisio);
    }

    protected void addOpenHelperProperties(Seisio seisio) {
    }

    public Seisio getSeisio() {
        return this._js.getSeisio();
    }

    public TraceProperties getTraceProperties() {
        return this._js.getHeader();
    }

    public TraceAccessor getTraceAccessor() {
        return this._js;
    }

    public int getIntPropertyValue(String name) throws SeisException {
        int retval;
        try {
            retval = this.getTraceProperties().getInt(name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.getIntPropertyValue: Named " + name + ": ", e);
            throw new SeisException(this._error_message);
        }
        return retval;
    }

    public float getFloatPropertyValue(String name) throws SeisException {
        float retval;
        try {
            retval = this.getTraceProperties().getFloat(name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.getFloatPropertyValue: Named " + name + ": ", e);
            throw new SeisException(this._error_message);
        }
        return retval;
    }

    public double getDoublePropertyValue(String name) throws SeisException {
        double retval;
        try {
            retval = this.getTraceProperties().getInt(name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.getDoublePropertyValue: Named " + name + ": ", e);
            throw new SeisException(this._error_message);
        }
        return retval;
    }

    public long getLongPropertyValue(String name) throws SeisException {
        long retval;
        try {
            retval = this.getTraceProperties().getLong(name);
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.getLongPropertyValue: Named " + name + ": ", e);
            throw new SeisException(this._error_message);
        }
        return retval;
    }

    @Override
    public int status() {
        return this._status;
    }

    @Override
    public String errorMessage() {
        return this._error_message;
    }

    public boolean isReadWrite() {
        return this._read_write;
    }

    public boolean setIndex(long trace_num) {
        if (this._status == -1) {
            return false;
        }
        boolean retval = trace_num == this._trace_num ? true : this.init(trace_num);
        return retval;
    }

    public long getIndex() {
        return this._trace_num;
    }

    public int getTrace(float[] trace) {
        float[] trc = this.getTrace();
        if (trc == null || trace == null) {
            return 0;
        }
        int retval = Math.min(trc.length, trace.length);
        ArrayUtil.arraycopy(trc, 0, trace, 0, retval);
        for (int k2 = retval; k2 < trace.length; ++k2) {
            trace[k2] = 0.0f;
        }
        return retval;
    }

    public float[] getTrace() {
        return this.readTrace();
    }

    @Override
    public int putTrace(float[] trace) {
        return this.writeTrace(trace);
    }

    @Override
    public void close() {
        if (this._read_write) {
            this.closeWrite();
        } else {
            this.closeRead();
        }
    }

    private void closeRead() {
        try {
            this._js.flush();
            this.getSeisio().close();
            this.handleError("JavaSeisIO: File not open", null);
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.closeRead: ", e);
        }
    }

    protected float[] readTrace() {
        float[] retval;
        if (this._status == -1) {
            retval = null;
        } else if (this._status == 1) {
            retval = this._trace;
        } else {
            try {
                this._trace = this._js.readTrace();
                this._status = 1;
                this._error_message = "";
                retval = this._trace;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.readTrace: ", e);
                this.init();
                retval = null;
            }
        }
        return retval;
    }

    private int writeTrace(float[] trace) {
        if (this._status == -1 || !this.isReadWrite()) {
            return 0;
        }
        this._trace = trace != null ? (float[])trace.clone() : new float[0];
        int retval = this.writeTrace();
        if (this._status != -1) {
            this._status = 1;
            this._error_message = "";
            retval = this._trace.length;
        }
        return retval;
    }

    protected int writeTrace() {
        int retval;
        try {
            retval = this._js.writeTrace(this._trace);
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.writeTrace: ", e);
            this.init();
            retval = 0;
        }
        return retval;
    }

    protected boolean init(long trace_num) {
        boolean retval;
        try {
            if (this._js.setIndex(trace_num - 1L)) {
                this._status = 0;
                this._error_message = "";
                this.init();
                this._trace_num = trace_num;
                retval = true;
            } else {
                retval = false;
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.init: Unexpected error ", e);
            retval = false;
            this.init();
        }
        return retval;
    }

    private void init() {
        this._trace_num = -1L;
        this._trace = null;
    }

    public long getTraceCount() {
        long retval = 0L;
        if (this._status == -1) {
            return retval;
        }
        try {
            int num_dim = this.getSeisio().getGridDefinition().getNumDimensions();
            retval = 1L;
            for (int k2 = 1; k2 < num_dim; ++k2) {
                retval *= this.getSeisio().getGridDefinition().getAxisLength(k2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public int getSampleCount() {
        int retval = 0;
        if (this._status == -1) {
            return retval;
        }
        try {
            retval = (int)this.getSeisio().getGridDefinition().getAxisLength(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public int getNumDimensions() {
        int retval = 0;
        if (this._status == -1) {
            return retval;
        }
        try {
            retval = this.getSeisio().getGridDefinition().getNumDimensions();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    @Override
    public String getDataType() {
        String retval = null;
        if (this._status == -1) {
            return retval;
        }
        try {
            retval = this.getSeisio().getDataDefinition().getDataTypeString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    @Override
    public String getTraceFormat() {
        String retval = null;
        if (this._status == -1) {
            return retval;
        }
        try {
            retval = this.getSeisio().getDataDefinition().getTraceFormat().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public boolean readHistory() {
        boolean retval = false;
        if (this._status == -1) {
            return retval;
        }
        try {
            this._history = this.getSeisio().readHistory();
        }
        catch (Exception e) {
            this._history = new ParameterSet("");
        }
        retval = true;
        return retval;
    }

    public ParameterSet getHistoryCopy() {
        ParameterSet retval = null;
        if (this._status == -1) {
            return retval;
        }
        if (this._history == null) {
            this.readHistory();
        }
        try {
            retval = (ParameterSet)this._history.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return retval;
    }

    public void createHistory(ParameterSet history) {
        if (history == null) {
            this._history = new ParameterSet("");
        } else {
            try {
                this._history = (ParameterSet)history.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean open() {
        return this.open(null);
    }

    @Override
    public boolean open(IParallelContext pc) {
        boolean retval = this._read_write ? this.openWrite(pc) : this.openRead(pc);
        return retval;
    }

    private boolean openRead(IParallelContext pc) {
        boolean retval = false;
        Seisio seisio = null;
        try {
            seisio = new Seisio(this._directory);
            if (pc != null) {
                seisio.open(this._io_mode, pc);
            } else {
                seisio.open(this._io_mode);
            }
            this._opened_before = true;
            this._js = new TraceAccessor(seisio, pc, this._io_mode, 3);
            this._descr = new JavaSeisDescriptor(seisio);
            this.openHelper(seisio);
            this.readHistory();
            retval = true;
        }
        catch (Exception e) {
            this._status = -1;
            this._error_message = "JavaSeisIO.openRead: could not instantiate Seisio: " + e.getMessage();
            System.out.println(this._error_message);
        }
        if (this._status != -1) {
            try {
                this._bingrid = seisio.getBinGrid().toParameterSet();
            }
            catch (Exception e) {
                this._bingrid = null;
            }
        }
        return retval;
    }

    private boolean openWrite(IParallelContext pc) {
        boolean retval = false;
        if (this._opened_before) {
            retval = this.openRead(pc);
            if (retval) {
                retval = this.openWriteHelper();
            }
            return retval;
        }
        try {
            this.addOpenWriteProperties();
            long[] sizes = this._descr.getLengths();
            boolean sizes_is_null = sizes == null;
            long ext_size = VDU.closestPowerOfTwo(VDU.size(sizes) / 2L / (long)(pc == null ? 1 : pc.size()));
            boolean broadcast_vp = false;
            boolean make_vp = false;
            VolumeParameters vp = null;
            SeisioCreator sc = null;
            Seisio seisio = null;
            Object[] oa = null;
            if (pc != null) {
                if (pc.size() > 1) {
                    broadcast_vp = true;
                }
                if (pc.rank() == 0) {
                    make_vp = true;
                }
            } else {
                make_vp = true;
            }
            if (make_vp) {
                File file = new File(this._directory);
                String name = file.getName();
                String parent = file.getParent();
                vp = new VolumeParameters(ext_size, this._descr.getDataDefinition().getDataType(), this._descr.getDataDefinition().getTraceFormat(), name, parent, JSC.ROOT, JSC.HOSTS, JSC.LOC, JSC.POLICY);
                sc = new SeisioCreator(this._descr, vp, this._bingrid);
                seisio = sc.getSeisio();
                this.openWriteHelper();
            }
            if (broadcast_vp) {
                pc.barrier();
                oa = new Object[1];
                if (vp != null) {
                    oa[0] = vp;
                }
                pc.bcast(99, oa, 0, 1, 0);
                vp = (VolumeParameters)oa[0];
                if (vp == null) {
                    this._status = -1;
                    this._error_message = "JavaSeisIO.openWrite: vp from from broadcast is null";
                    System.out.println(this._error_message);
                    return retval;
                }
                vp.setInitializeFlag(false);
                if (seisio == null) {
                    sc = new SeisioCreator(this._descr, vp, this._bingrid);
                    seisio = sc.getSeisio();
                }
            }
            seisio = new Seisio(this._directory, this._descr.getGridDefinition(), this._descr.getDataDefinition(), this._descr.getHeaderDefinition());
            if (pc != null) {
                seisio.open("rw", pc);
            } else {
                seisio.open("rw");
            }
            this._opened_before = true;
            this._js = new TraceAccessor(seisio, pc, "rw", 3);
            this.openHelper(seisio);
            this.readHistory();
            retval = true;
        }
        catch (Exception e) {
            this.printError("JavaSeisIO.openWrite: failed for " + this._directory + " ", e);
        }
        return retval;
    }

    protected boolean openWriteHelper() {
        return true;
    }

    protected boolean addOpenWriteProperties() {
        return true;
    }

    public JavaSeisDescriptor getDescr() {
        return this._descr;
    }

    protected boolean setIsValid() {
        boolean retval = this._read_write && !this._opened_before;
        return retval;
    }

    @Override
    public boolean preExisted() {
        return this._opened_before;
    }

    public void closeWrite() {
        Seisio.setHasTraces(this._directory, this.getTraceCount() > 0L);
        this.writeHistory();
        this.closeRead();
        this.closeWriteHelper();
    }

    protected void closeWriteHelper() {
    }

    @Override
    public boolean delete() {
        boolean retval = false;
        if (this._js != null && this._js.isReadWrite()) {
            String path = this._js.getSeisio().getBasePath();
            int index = path.lastIndexOf(".js");
            String name = path.substring(0, index);
            try {
                retval = this.deleteHelper(name);
                if (retval) {
                    retval = this.deleteJavaSeisDirectory();
                }
            }
            catch (Exception e) {
                this.printError("JavaSeisIO.delete: ", e);
            }
        }
        return retval;
    }

    protected boolean deleteHelper(String name) {
        return true;
    }

    public boolean getBinGrid(double[] world, double[] grid, long[] logical) {
        boolean retval;
        boolean bl = retval = world.length >= 6 && grid.length >= 4 && logical.length >= 8 && this._bingrid != null;
        if (retval) {
            world[0] = this._bingrid.getDouble("WorldX0", 0.0);
            world[1] = this._bingrid.getDouble("WorldY0", 0.0);
            world[2] = this._bingrid.getDouble("WorldX1", 1.0);
            world[3] = this._bingrid.getDouble("WorldY1", 0.0);
            world[4] = this._bingrid.getDouble("WorldX2", 1.0);
            world[5] = this._bingrid.getDouble("WorldY2", 1.0);
            grid[0] = this._bingrid.getDouble("GridX0", 0.0);
            grid[1] = this._bingrid.getDouble("GridY0", 0.0);
            grid[2] = this._bingrid.getDouble("GridDX", 1.0);
            grid[3] = this._bingrid.getDouble("GridDY", 1.0);
            logical[0] = this._bingrid.getLong("LogicalX0", 0L);
            logical[1] = this._bingrid.getLong("LogicalY0", 0L);
            logical[2] = this._bingrid.getLong("LogicalX1", 1L);
            logical[3] = this._bingrid.getLong("LogicalY1", 0L);
            logical[4] = this._bingrid.getLong("LogicalX2", 1L);
            logical[5] = this._bingrid.getLong("LogicalY2", 1L);
            logical[6] = this._bingrid.getLong("LogicalDX", 1L);
            logical[7] = this._bingrid.getLong("LogicalDY", 1L);
        } else {
            this.handleError("JavaSeisIO.getBinGrid: Bad parameters", null);
        }
        return retval;
    }

    public boolean setBinGrid(JavaSeisIO js) {
        boolean retval;
        double[] world = new double[6];
        double[] grid = new double[4];
        long[] logical = new long[8];
        GridDefinition gdef = null;
        try {
            gdef = js.getSeisio().getGridDefinition();
            boolean bl = retval = gdef.getNumDimensions() == 3 && gdef.getAxisLength(X) > 0L && gdef.getAxisLength(Y) > 0L;
            if (!retval) {
                this.handleError("JavaSeisIO.setBinGrid: Bad parameters", null);
                return false;
            }
            long length = 1L;
            js.setIndex(length);
            TraceProperties prop = js.getTraceAccessor().getHeader();
            world[0] = prop.getDouble("CDP_XD");
            world[1] = prop.getDouble("CDP_YD");
            logical[0] = prop.getInt("XLINE_NO");
            logical[1] = prop.getInt("ILINE_NO");
            length = gdef.getAxisLength(X);
            js.setIndex(length);
            prop = js.getTraceAccessor().getHeader();
            world[2] = prop.getDouble("CDP_XD");
            world[3] = prop.getDouble("CDP_YD");
            logical[2] = prop.getInt("XLINE_NO");
            logical[3] = prop.getInt("ILINE_NO");
            length = gdef.getAxisLength(X) * (gdef.getAxisLength(Y) - 1L) + 1L;
            js.setIndex(length);
            prop = js.getTraceAccessor().getHeader();
            world[4] = prop.getDouble("CDP_XD");
            world[5] = prop.getDouble("CDP_YD");
            logical[4] = prop.getInt("XLINE_NO");
            logical[5] = prop.getInt("ILINE_NO");
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.setBinGrid: ", e);
            retval = false;
        }
        if (retval) {
            grid[0] = 0.0;
            grid[1] = 0.0;
            grid[2] = 1.0;
            grid[3] = 1.0;
            logical[6] = gdef.getAxisLength(X) == 1L ? 1L : (logical[2] - logical[0]) / (gdef.getAxisLength(X) - 1L);
            logical[7] = gdef.getAxisLength(Y) == 1L ? 1L : (logical[5] - logical[1]) / (gdef.getAxisLength(Y) - 1L);
            if (logical[6] != 0L && logical[7] != 0L) {
                this.setBinGrid(world, grid, logical);
            } else {
                this.handleError("JavaSeisIO.setBinGrid: dx and dy cannot be zero", null);
                retval = false;
            }
        }
        return retval;
    }

    @Override
    public boolean setBinGrid(double[] world, double[] grid, long[] logical) {
        boolean retval = false;
        try {
            boolean bl = retval = world.length >= 6 && grid.length >= 4 && logical.length >= 8;
            if (retval) {
                this._bingrid = new ParameterSet();
                this._bingrid.setDouble("WorldX0", world[0]);
                this._bingrid.setDouble("WorldY0", world[1]);
                this._bingrid.setDouble("WorldX1", world[2]);
                this._bingrid.setDouble("WorldY1", world[3]);
                this._bingrid.setDouble("WorldX2", world[4]);
                this._bingrid.setDouble("WorldY2", world[5]);
                this._bingrid.setDouble("GridX0", grid[0]);
                this._bingrid.setDouble("GridY0", grid[1]);
                this._bingrid.setDouble("GridDX", grid[2]);
                this._bingrid.setDouble("GridDY", grid[3]);
                this._bingrid.setLong("LogicalX0", logical[0]);
                this._bingrid.setLong("LogicalY0", logical[1]);
                this._bingrid.setLong("LogicalX1", logical[2]);
                this._bingrid.setLong("LogicalY1", logical[3]);
                this._bingrid.setLong("LogicalX2", logical[4]);
                this._bingrid.setLong("LogicalY2", logical[5]);
                this._bingrid.setLong("LogicalDX", logical[6]);
                this._bingrid.setLong("LogicalDY", logical[7]);
            } else {
                this.handleError("JavaSeisIO.setBinGrid: Bad parameters", null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.setBinGrid: ", e);
        }
        return retval;
    }

    private void writeHistory() {
        if (this._history != null) {
            try {
                this.getSeisio().writeHistory(this._history);
            }
            catch (Exception e) {
                this.printError("JavaSeisIO.writeHistory: ", e);
            }
        }
    }

    private boolean deleteJavaSeisDirectory() {
        boolean retval = false;
        if (this._js != null && this._js.isReadWrite()) {
            this.close();
            retval = this._js.getSeisio().delete();
        }
        return retval;
    }

    @Override
    public boolean setAxis(int dimension, int length, String domain, String units, double physical_origin, double physical_delta) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.setAxis(dimension, length, domain, units, physical_origin, physical_delta);
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.setAxis: ", e);
                retval = false;
            }
        } else {
            this.handleError("JavaSeisIO.setAxis: Invalid", null);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean setAxis(int dimension, int length, String domain, String units, long logical_origin, long logical_delta, double physical_origin, double physical_delta) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.setAxis(dimension, length, domain, units, logical_origin, logical_delta, physical_origin, physical_delta);
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.setAxis: ", e);
                retval = false;
            }
        } else {
            this.handleError("JavaSeisIO.setAxis: Invalid", null);
            retval = false;
        }
        return retval;
    }

    public boolean getAxis(int dimension, int[] length, String[] domain, String[] units, long[] logical_origin, long[] logical_delta, double[] physical_origin, double[] physical_delta) {
        boolean retval;
        try {
            boolean bl = retval = length.length >= 1 && domain.length >= 1 && units.length >= 1 && logical_origin.length >= 1 && logical_delta.length >= 1 && physical_origin.length >= 1 && physical_delta.length >= 1 && dimension < this._descr.getNumDimensions();
            if (retval) {
                length[0] = (int)this._descr.getAxes()[dimension].getLength();
                domain[0] = this._descr.getAxes()[dimension].getDomain().getName();
                units[0] = this._descr.getAxes()[dimension].getUnits().getName();
                logical_origin[0] = this._descr.getAxes()[dimension].getLogicalOrigin();
                logical_delta[0] = this._descr.getAxes()[dimension].getLogicalDelta();
                physical_origin[0] = this._descr.getAxes()[dimension].getPhysicalOrigin();
                physical_delta[0] = this._descr.getAxes()[dimension].getPhysicalDelta();
            } else {
                this.handleError("JavaSeisIO.getAxis: Bad parameters ", null);
            }
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.getAxis: ", e);
            retval = false;
        }
        return retval;
    }

    public boolean setDescr(Seisio seisio) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                JavaSeisDescriptor descr;
                this._descr = descr = new JavaSeisDescriptor(seisio);
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.setDescr: ", e);
                retval = false;
            }
        } else {
            this.handleError("JavaSeisIO.setDescr: Invalid", null);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean addIntProperty(String name, String description) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.addProperty(new PropertyDescription(name, description, 3, 1));
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.addIntProperty: name " + name, e);
                retval = false;
            }
        } else {
            this.handleError("JavaSeisIO.addIntProperty: Invalid name " + name, null);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean addFloatProperty(String name, String description) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.addProperty(new PropertyDescription(name, description, 5, 1));
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.addFloatProperty: name " + name, e);
                retval = false;
            }
        } else {
            this.handleError("JavaSeisIO.addLongProperty: Invalid name " + name, null);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean addDoubleProperty(String name, String description) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.addProperty(new PropertyDescription(name, description, 6, 1));
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.addDoubleProperty: name " + name, e);
                retval = false;
            }
        } else {
            this.handleError("JavaSeisIO.addDoubleProperty: Invalid name " + name, null);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean addLongProperty(String name, String description) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.addProperty(new PropertyDescription(name, description, 4, 1));
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.addLongProperty: name " + name, e);
                retval = false;
            }
        } else {
            this.handleError("JavaSeisIO.addLongProperty: Invalid name " + name, null);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean putIntPropertyValue(String name, int value) {
        boolean retval;
        try {
            this._js.getHeader().putInt(name, value);
            retval = true;
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.putIntPropertyValue: name " + name, e);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean putFloatPropertyValue(String name, float value) {
        boolean retval;
        try {
            this._js.getHeader().putFloat(name, value);
            retval = true;
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.putFloatPropertyValue: name " + name, e);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean putDoublePropertyValue(String name, double value) {
        boolean retval;
        try {
            this._js.getHeader().putDouble(name, value);
            retval = true;
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.putDoublePropertyValue: name " + name, e);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean putLongPropertyValue(String name, long value) {
        boolean retval;
        try {
            this._js.getHeader().putLong(name, value);
            retval = true;
        }
        catch (Exception e) {
            this.handleError("JavaSeisIO.putLongPropertyValue: name " + name, e);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean setDataType(String data_type_name) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.setDataType(data_type_name);
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.setDataType: type " + data_type_name, e);
                retval = false;
            }
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean setTraceFormat(String format_name) {
        boolean retval;
        if (this.setIsValid()) {
            try {
                this._descr.setFormat(format_name);
                retval = true;
            }
            catch (Exception e) {
                this.handleError("JavaSeisIO.setTraceFormat: format " + format_name, e);
                retval = false;
            }
        } else {
            retval = false;
        }
        return retval;
    }

    protected void printError(String prefix, Exception e) {
        this.handleError(prefix, e);
        System.out.println(this._error_message);
    }

    protected void handleError(String prefix, Exception e) {
        this._status = -1;
        String loc_prefix = prefix != null ? prefix : "";
        String loc_suffix = e != null ? e.getMessage() : "";
        String error_message = loc_prefix + loc_suffix;
        if (error_message.length() > 0) {
            this._error_message = error_message;
        }
    }
}

