/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.io.IOException;
import junit.framework.TestCase;
import org.javaseis.fft.SeisFft3d;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.UniprocessorContext;

public class JTestSeisFft3d
extends TestCase {
    private static String[] _args;
    private static final int TEST_DC = 101;
    private static final int TEST_RAMP = 102;
    private static final boolean CHATTY = false;
    private static final boolean VERBOSE = false;
    private static final int NFMAX = 200;
    private static final int NXMAX = 75;
    private static final int NYMAX = 39;
    private static final int NTESTS = 20;
    double FORWARD_INVERSE_TOLERANCE = 1.0E-4;
    double INVERSE_FORWARD_TOLERANCE = 1.0E-6;

    public static void main(String[] args) {
        _args = args;
        JTestSeisFft3d test = new JTestSeisFft3d();
        test.testCoordinates();
        test.testAll();
    }

    public void testCoordinates() {
        UniprocessorContext pc = new UniprocessorContext();
        int[] len = new int[]{70, 100, 200};
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        double[] sampleRates = new double[]{0.004, 10.0, 10.0};
        SeisFft3d fft3d = new SeisFft3d(pc, len, pad);
        fft3d.setTXYSampleRates(sampleRates);
        fft3d.forward();
        int[] shape = fft3d.getShape();
        int[] position = new int[3];
        double[] buf = new double[3];
        position[0] = 1;
        position[1] = 1;
        position[2] = shape[2] - 1;
        fft3d.getKyKxFCoordinatesForPosition(position, buf);
        JTestSeisFft3d.assertEquals((double)4.81E-4, (double)buf[0], (double)1.0E-6);
        JTestSeisFft3d.assertEquals((double)9.62E-4, (double)buf[1], (double)1.0E-6);
        JTestSeisFft3d.assertEquals((double)125.0, (double)buf[2], (double)1.0E-5);
    }

    public void testAll() {
        for (int itest = 0; itest < 20; ++itest) {
            int nf = (int)(196.0 * Math.random() + 4.0);
            int nx = (int)(73.0 * Math.random() + 2.0);
            int ny = (int)(37.0 * Math.random() + 2.0);
            this.doRoundTripForward(101, nf, nx, ny);
            this.doRoundTripForward(102, nf, nx, ny);
            this.doRoundTripInverse(nf, nx, ny);
        }
    }

    private static void debugPause() {
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doRoundTripForward(int testType, int nf, int nx, int ny) {
        int i;
        int j;
        int k;
        UniprocessorContext pc = new UniprocessorContext();
        pc.init(_args);
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        int[] len = new int[]{nf, nx, ny};
        SeisFft3d f3d0 = new SeisFft3d(pc, len, pad);
        SeisFft3d f3d1 = new SeisFft3d(pc, len, pad);
        DistributedArray da0 = f3d0.getArray();
        DistributedArray da1 = f3d1.getArray();
        int[] fftLengths = f3d0.getFftLengths();
        int[] position = new int[]{0, 0, 0};
        int kmax = da0.getLocalLength(2);
        for (k = 0; k < kmax; ++k) {
            position[2] = da0.localToGlobal(2, k);
            if (position[2] >= len[2]) continue;
            for (j = 0; j < len[1]; ++j) {
                position[1] = j;
                float ramp = 0.0f;
                for (i = 0; i < len[0]; ++i) {
                    switch (testType) {
                        case 101: {
                            da0.putSample(1.0f, position);
                            da1.putSample(1.0f, position);
                            break;
                        }
                        case 102: {
                            da0.putSample(ramp, position);
                            da1.putSample(ramp, position);
                        }
                    }
                    ramp += 1.0f;
                }
            }
        }
        f3d0.forward();
        int l = len[0] * len[1] * len[2];
        f3d0.inverse();
        kmax = da0.getLocalLength(2);
        for (k = 0; k < kmax; ++k) {
            position[2] = da0.localToGlobal(2, k);
            if (position[2] >= len[2]) continue;
            for (j = 0; j < len[1]; ++j) {
                position[1] = j;
                for (i = 0; i < len[0]; ++i) {
                    float a0 = da0.getFloat(position);
                    float a1 = da1.getFloat(position);
                    if ((double)Math.abs(a1 - a0) > this.FORWARD_INVERSE_TOLERANCE) {
                        System.out.println("\nTOLERANCE exceeded !!!");
                        System.out.printf("  testType = %d\n", testType);
                        System.out.printf("  nf, nx, ny = %4d %4d %4d\n", nf, nx, ny);
                        System.out.printf("  values being compared were %f and %f\n", Float.valueOf(a1), Float.valueOf(a0));
                        System.out.printf("  position was pos[2], pos[1], ia = %4d %4d %4d\n", position[2], position[1], i);
                    }
                    JTestSeisFft3d.assertEquals((double)a1, (double)a0, (double)this.FORWARD_INVERSE_TOLERANCE);
                }
            }
        }
        pc.finish();
    }

    public void doRoundTripInverse(int nf, int nx, int ny) {
        UniprocessorContext pc = new UniprocessorContext();
        int[] len = SeisFft3d.getTransformShape(new int[]{nf, nx, ny}, new float[]{0.0f, 0.0f, 0.0f}, pc);
        int[] type = new int[]{Decomposition.BLOCK, Decomposition.BLOCK, Decomposition.BLOCK};
        DistributedArray daCopy = new DistributedArray((IParallelContext)pc, Float.TYPE, 3, 2, len, type);
        DistributedArray da = new DistributedArray((IParallelContext)pc, Float.TYPE, 3, 2, len, type);
        SeisFft3d fft3d = new SeisFft3d(da);
        int[] fftlen = fft3d.getFftLengths();
        int nft = 1 + fftlen[0] / 2;
        int nkx = fftlen[1];
        int nky = fftlen[2];
        int[] shape = new int[]{nky, nkx, nft};
        da.setShape(shape);
        daCopy.setShape(shape);
        int[] position = new int[3];
        float[] buf = new float[2 * shape[0]];
        for (int k = 0; k < shape[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < shape[1]; ++j) {
                position[1] = j;
                da.getTrace(buf, position);
                for (int i = 0; i < shape[0]; ++i) {
                    buf[2 * i] = 1.0f;
                }
                da.putTrace(buf, position);
                daCopy.putTrace(buf, position);
            }
        }
        fft3d.inverse();
        fft3d.forward();
        double diffRealMax = 0.0;
        double diffImagMax = 0.0;
        shape = da.getShape();
        buf = new float[2 * shape[0]];
        float[] bufCopy = new float[2 * shape[0]];
        for (int k = 0; k < shape[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < shape[1]; ++j) {
                position[1] = j;
                daCopy.getTrace(bufCopy, position);
                da.getTrace(buf, position);
                for (int i = 0; i < 2 * shape[0]; i += 2) {
                    double diffReal = Math.abs(bufCopy[i] - buf[i]);
                    double diffImag = Math.abs(bufCopy[i + 1] - buf[i + 1]);
                    if (diffReal > diffRealMax) {
                        diffRealMax = diffReal;
                    }
                    if (diffImag > diffImagMax) {
                        diffImagMax = diffImag;
                    }
                    if (diffReal > this.INVERSE_FORWARD_TOLERANCE || diffImag > this.INVERSE_FORWARD_TOLERANCE) {
                        System.out.printf("k=%5d j=%5d\n", k, j);
                        for (int n = 0; n < 2 * shape[0]; ++n) {
                            System.out.printf("%10.5f %10.5f\n", Float.valueOf(bufCopy[n]), Float.valueOf(buf[n]));
                        }
                    }
                    JTestSeisFft3d.assertEquals((double)bufCopy[i], (double)buf[i], (double)this.INVERSE_FORWARD_TOLERANCE);
                    JTestSeisFft3d.assertEquals((double)bufCopy[i + 1], (double)buf[i + 1], (double)this.INVERSE_FORWARD_TOLERANCE);
                }
            }
        }
    }
}

