/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.javaseis.array.BackingArray;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayTraceIterator;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.UniprocessorContext;

public class JTestCopyConstructor
extends TestCase {
    private static final Logger LOG = Logger.getLogger(JTestCopyConstructor.class.getName());

    private int[] getLengths() {
        return new int[]{501, 191, 277};
    }

    public void testFloat() {
        UniprocessorContext pc = new UniprocessorContext();
        int[] lengths = this.getLengths();
        DistributedArray da = this.initArray(pc, Float.TYPE, lengths, BackingArray.Type.JAVA_ARRAY);
        this.fill(da);
        this.validate(da);
        DistributedArray c = this.doCopy(da);
        this.validate(c);
        System.gc();
        da = this.initArray(pc, Float.TYPE, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        this.fill(da);
        this.validate(da);
        c = this.doCopy(da);
        this.validate(c);
    }

    public void testInt() {
        UniprocessorContext pc = new UniprocessorContext();
        int[] lengths = this.getLengths();
        DistributedArray da = this.initArray(pc, Integer.TYPE, lengths, BackingArray.Type.JAVA_ARRAY);
        this.fill(da);
        this.validate(da);
        DistributedArray c = this.doCopy(da);
        this.validate(c);
        System.gc();
        da = this.initArray(pc, Integer.TYPE, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        this.fill(da);
        this.validate(da);
        c = this.doCopy(da);
        this.validate(c);
    }

    public void testShort() {
        UniprocessorContext pc = new UniprocessorContext();
        int[] lengths = this.getLengths();
        DistributedArray da = this.initArray(pc, Short.TYPE, lengths, BackingArray.Type.JAVA_ARRAY);
        this.fill(da);
        this.validate(da);
        DistributedArray c = this.doCopy(da);
        this.validate(c);
        System.gc();
        da = this.initArray(pc, Short.TYPE, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        this.fill(da);
        this.validate(da);
        c = this.doCopy(da);
        this.validate(c);
    }

    public void testLong() {
        UniprocessorContext pc = new UniprocessorContext();
        int[] lengths = this.getLengths();
        DistributedArray da = this.initArray(pc, Long.TYPE, lengths, BackingArray.Type.JAVA_ARRAY);
        this.fill(da);
        this.validate(da);
        DistributedArray c = this.doCopy(da);
        this.validate(c);
        System.gc();
        da = this.initArray(pc, Long.TYPE, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        this.fill(da);
        this.validate(da);
        c = this.doCopy(da);
        this.validate(c);
    }

    public void testDouble() {
        UniprocessorContext pc = new UniprocessorContext();
        int[] lengths = this.getLengths();
        DistributedArray da = this.initArray(pc, Double.TYPE, lengths, BackingArray.Type.JAVA_ARRAY);
        this.fill(da);
        this.validate(da);
        DistributedArray c = this.doCopy(da);
        this.validate(c);
        System.gc();
        da = this.initArray(pc, Double.TYPE, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        this.fill(da);
        this.validate(da);
        c = this.doCopy(da);
        this.validate(c);
    }

    public void testByte() {
        UniprocessorContext pc = new UniprocessorContext();
        int[] lengths = this.getLengths();
        DistributedArray da = this.initArray(pc, Byte.TYPE, lengths, BackingArray.Type.JAVA_ARRAY);
        this.fill(da);
        this.validate(da);
        DistributedArray c = this.doCopy(da);
        this.validate(c);
        System.gc();
        da = this.initArray(pc, Byte.TYPE, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        this.fill(da);
        this.validate(da);
        c = this.doCopy(da);
        this.validate(c);
    }

    public void testMultiple3() {
        int[] lengths = new int[]{1, 1, 1};
        for (int i = 100; i < 300; i += 100) {
            for (int j = 1; j < 75; j += 25) {
                for (int k = 1; k < 75; k += 25) {
                    LOG.fine(Arrays.toString(lengths));
                    lengths[0] = i;
                    lengths[1] = j;
                    lengths[2] = k;
                    this.oneTest(lengths);
                }
            }
        }
    }

    public void testMultiple4() {
        int[] lengths = new int[]{1, 1, 1, 1};
        for (int i = 100; i < 300; i += 100) {
            for (int j = 1; j < 75; j += 25) {
                for (int k = 1; k < 75; k += 25) {
                    for (int l = 1; l < 75; l += 25) {
                        LOG.fine(Arrays.toString(lengths));
                        lengths[0] = i;
                        lengths[0] = i;
                        lengths[1] = j;
                        lengths[2] = k;
                        lengths[3] = l;
                        this.oneTest(lengths);
                    }
                }
            }
        }
    }

    private void oneTest(int[] lengths) {
        UniprocessorContext pc = new UniprocessorContext();
        DistributedArray da = this.initArray(pc, Integer.TYPE, lengths, BackingArray.Type.JAVA_ARRAY);
        this.fill(da);
        this.validate(da);
        DistributedArray c = this.doCopy(da);
        this.validate(c);
        System.gc();
        da = this.initArray(pc, Integer.TYPE, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        this.fill(da);
        this.validate(da);
        c = this.doCopy(da);
        this.validate(c);
    }

    private DistributedArray doCopy(DistributedArray da) {
        long start = System.currentTimeMillis();
        DistributedArray c = new DistributedArray(da);
        long end = System.currentTimeMillis();
        LOG.fine("Copy constructor time = " + (end - start) + " ms");
        return c;
    }

    private void fill(DistributedArray da) {
        long start = System.currentTimeMillis();
        Class type = da.getClassType();
        if (type == Float.TYPE) {
            this.fillFloat(da);
        } else if (type == Integer.TYPE) {
            this.fillInt(da);
        } else if (type == Short.TYPE) {
            this.fillShort(da);
        } else if (type == Long.TYPE) {
            this.fillLong(da);
        } else if (type == Double.TYPE) {
            this.fillDouble(da);
        } else if (type == Byte.TYPE) {
            this.fillByte(da);
        } else {
            throw new IllegalArgumentException("class type is not supported");
        }
        long end = System.currentTimeMillis();
        LOG.fine("Fill completed in " + (end - start) + " ms");
    }

    private void fillFloat(DistributedArray da) {
        int[] shape = da.getShape();
        float[] t = new float[shape[0]];
        DistributedArrayTraceIterator<float[]> it = new DistributedArrayTraceIterator<float[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            Arrays.fill(t, (float)pos[1]);
            it.putData(t);
        }
    }

    private void fillInt(DistributedArray da) {
        int[] shape = da.getShape();
        int[] t = new int[shape[0]];
        DistributedArrayTraceIterator<int[]> it = new DistributedArrayTraceIterator<int[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            Arrays.fill(t, pos[1]);
            it.putData(t);
        }
    }

    private void fillShort(DistributedArray da) {
        int[] shape = da.getShape();
        short[] t = new short[shape[0]];
        DistributedArrayTraceIterator<short[]> it = new DistributedArrayTraceIterator<short[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            Arrays.fill(t, (short)pos[1]);
            it.putData(t);
        }
    }

    private void fillLong(DistributedArray da) {
        int[] shape = da.getShape();
        long[] t = new long[shape[0]];
        DistributedArrayTraceIterator<long[]> it = new DistributedArrayTraceIterator<long[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            Arrays.fill(t, (long)pos[1]);
            it.putData(t);
        }
    }

    private void fillDouble(DistributedArray da) {
        int[] shape = da.getShape();
        double[] t = new double[shape[0]];
        DistributedArrayTraceIterator<double[]> it = new DistributedArrayTraceIterator<double[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            Arrays.fill(t, (double)pos[1]);
            it.putData(t);
        }
    }

    private void fillByte(DistributedArray da) {
        int[] shape = da.getShape();
        byte[] t = new byte[shape[0]];
        DistributedArrayTraceIterator<byte[]> it = new DistributedArrayTraceIterator<byte[]>(da, t);
        while (it.hasNext()) {
            it.next();
            Arrays.fill(t, (byte)101);
            it.putData(t);
        }
    }

    private void validate(DistributedArray da) {
        long start = System.currentTimeMillis();
        Class type = da.getClassType();
        if (type == Float.TYPE) {
            this.validateFloat(da);
        } else if (type == Integer.TYPE) {
            this.validateInt(da);
        } else if (type == Short.TYPE) {
            this.validateShort(da);
        } else if (type == Long.TYPE) {
            this.validateLong(da);
        } else if (type == Double.TYPE) {
            this.validateDouble(da);
        } else if (type == Byte.TYPE) {
            this.validateByte(da);
        } else {
            throw new IllegalArgumentException("class type is not supported");
        }
        long end = System.currentTimeMillis();
        LOG.fine("Validate completed in " + (end - start) + " ms");
    }

    private void validateFloat(DistributedArray da) {
        int[] shape = da.getShape();
        float[] t = new float[shape[0]];
        DistributedArrayTraceIterator<float[]> it = new DistributedArrayTraceIterator<float[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            for (int i = 0; i < t.length; ++i) {
                if (t[0] == (float)pos[1]) continue;
                throw new RuntimeException("Validation failed at " + Arrays.toString(it.getPosition()));
            }
        }
    }

    private void validateInt(DistributedArray da) {
        int[] shape = da.getShape();
        int[] t = new int[shape[0]];
        DistributedArrayTraceIterator<int[]> it = new DistributedArrayTraceIterator<int[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            for (int i = 0; i < t.length; ++i) {
                if (t[0] == pos[1]) continue;
                throw new RuntimeException("Validation failed at " + Arrays.toString(it.getPosition()));
            }
        }
    }

    private void validateShort(DistributedArray da) {
        int[] shape = da.getShape();
        short[] t = new short[shape[0]];
        DistributedArrayTraceIterator<short[]> it = new DistributedArrayTraceIterator<short[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            for (int i = 0; i < t.length; ++i) {
                if (t[0] == pos[1]) continue;
                throw new RuntimeException("Validation failed at " + Arrays.toString(it.getPosition()));
            }
        }
    }

    private void validateLong(DistributedArray da) {
        int[] shape = da.getShape();
        long[] t = new long[shape[0]];
        DistributedArrayTraceIterator<long[]> it = new DistributedArrayTraceIterator<long[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            for (int i = 0; i < t.length; ++i) {
                if (t[0] == (long)pos[1]) continue;
                throw new RuntimeException("Validation failed at " + Arrays.toString(it.getPosition()));
            }
        }
    }

    private void validateDouble(DistributedArray da) {
        int[] shape = da.getShape();
        double[] t = new double[shape[0]];
        DistributedArrayTraceIterator<double[]> it = new DistributedArrayTraceIterator<double[]>(da, t);
        while (it.hasNext()) {
            it.next();
            int[] pos = it.getPosition();
            for (int i = 0; i < t.length; ++i) {
                if (t[0] == (double)pos[1]) continue;
                throw new RuntimeException("Validation failed at " + Arrays.toString(it.getPosition()));
            }
        }
    }

    private void validateByte(DistributedArray da) {
        int[] shape = da.getShape();
        byte[] t = new byte[shape[0]];
        DistributedArrayTraceIterator<byte[]> it = new DistributedArrayTraceIterator<byte[]>(da, t);
        while (it.hasNext()) {
            it.next();
            for (int i = 0; i < t.length; ++i) {
                if (t[i] == 101) continue;
                throw new RuntimeException("Validation failed at " + Arrays.toString(it.getPosition()));
            }
        }
    }

    private DistributedArray initArray(IParallelContext pc, Class clazz, int[] lengths, BackingArray.Type type) {
        LOG.fine("Starting Distributed Array creation");
        long maxArrayLength = 1L;
        int[] decomp = new int[lengths.length];
        for (int i = 0; i < lengths.length; ++i) {
            maxArrayLength *= (long)lengths[i];
            decomp[i] = Decomposition.BLOCK;
        }
        DistributedArray sa = new DistributedArray(pc, clazz, lengths.length, 1, lengths, decomp, maxArrayLength, type);
        sa.setShape(lengths);
        long bytes = maxArrayLength;
        String sType = "";
        if (clazz == Byte.TYPE) {
            bytes *= 1L;
            sType = "Byte";
        } else if (clazz == Short.TYPE) {
            bytes *= 2L;
            sType = "Short";
        } else if (clazz == Integer.TYPE) {
            bytes *= 4L;
            sType = "Int";
        } else if (clazz == Float.TYPE) {
            bytes *= 4L;
            sType = "Float";
        } else if (clazz == Long.TYPE) {
            bytes *= 8L;
            sType = "Long";
        } else if (clazz == Double.TYPE) {
            bytes *= 8L;
            sType = "Double";
        } else if (clazz == Double.TYPE) {
            // empty if block
        }
        double mb = (double)bytes / 1048576.0;
        LOG.fine("Distributed Array of " + sType + " created, size = " + mb + " Mb" + " backing array type = " + (Object)((Object)sa.getBackingArray().getBackingArrayType()));
        return sa;
    }
}

