/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.util.Arrays;
import java.util.Random;
import java.util.logging.Logger;
import mpi.MPIException;
import org.javaseis.array.BackingArray;
import org.javaseis.array.MultiArray;
import org.javaseis.array.TransposeType;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayFrameIterator;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.MPIContext;
import org.javaseis.parallel.UniprocessorContext;

public class DistributedArrayTest {
    private static final Logger LOG = Logger.getLogger(DistributedArrayTest.class.getPackage().getName());
    public IParallelContext _pc;

    public DistributedArrayTest(String[] args) throws MPIException {
        try {
            this._pc = new MPIContext();
            this._pc.init(args);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.warning("Using Uniprocessor context because MPI libraries were not found");
            this._pc = new UniprocessorContext();
        }
        this._pc.masterPrint("DistributedArray Tests");
        this.testSimple();
        this.testTransposeOuter();
        this.testReshape();
        this.testFrameIteratorDouble();
        this.testCreateBigArray();
        this.testCreateLongArray();
        this.testCopyConstructor();
        this._pc.finish();
    }

    public static void main(String[] args) throws MPIException {
        DistributedArrayTest test = new DistributedArrayTest(args);
        LOG.info("*** org.javaseis.tests.DistributedArrayTest SUCCESS ***");
    }

    public void testTransposeOuter() {
        int j;
        int k;
        int kl;
        int rank = this._pc.rank();
        int size = this._pc.size();
        String className = new DistributedArray().getClass().toString();
        if (rank == 0) {
            LOG.info(className);
            LOG.info("DistributedArray transposeOuter Tests");
        }
        System.out.flush();
        this._pc.barrier();
        int[] lengths = new int[]{23, 15, 7};
        int[] decompTypes = new int[]{Decomposition.NONE, Decomposition.BLOCK, Decomposition.BLOCK};
        int[] tshape = DistributedArray.getTransposeShape(this._pc, 3, lengths, decompTypes);
        long maxlen = DistributedArray.getShapeLength(3, 1, tshape);
        DistributedArray a = new DistributedArray(this._pc, Integer.TYPE, 3, 1, tshape, decompTypes, maxlen);
        this._pc.serialPrint("after contsructor rank " + this._pc.rank() + " global shape " + Arrays.toString(a.getShape()));
        int n1 = a.getLength(0);
        int n2 = a.getLength(1);
        int n3 = a.getLength(2);
        int n3local = a.getLocalLength(2);
        int[] position = new int[3];
        for (kl = 0; kl < n3local; ++kl) {
            k = a.localToGlobal(2, kl);
            if (k >= n3) continue;
            position[2] = k;
            for (j = 0; j < n2; ++j) {
                position[1] = j;
                for (int i = 0; i < n1; ++i) {
                    position[0] = i;
                    a.putSample(10 * j + i, position);
                }
            }
        }
        this._pc.serialPrint("rank " + this._pc.rank() + " n1 " + n1 + " n2 " + n2 + " n3 " + n3 + " n3local " + n3local);
        a.transposeOuter();
        this._pc.serialPrint("after transposeOuter rank " + this._pc.rank() + " global shape " + Arrays.toString(a.getShape()));
        n1 = a.getLength(0);
        n2 = a.getLength(1);
        n3 = a.getLength(2);
        n3local = a.getLocalLength(2);
        int ia = 0;
        this._pc.serialPrint("rank " + this._pc.rank() + " n1 " + n1 + " n2 " + n2 + " n3 " + n3 + " n3local " + n3local);
        for (kl = 0; kl < n3local; ++kl) {
            k = a.localToGlobal(2, kl);
            if (k >= n3) continue;
            position[2] = k;
            for (j = 0; j < n2; ++j) {
                position[1] = j;
                for (int i = 0; i < n1; ++i) {
                    position[0] = i;
                    ia = a.getInt(position);
                    this.assertEquals("DistributedArray.transposeOuter failed", 10 * k + i, ia);
                }
            }
        }
        this._pc.masterPrint("Test transposeOuter completed");
    }

    public void testSimple() {
        int j;
        int k;
        int kl;
        int rank = this._pc.rank();
        int size = this._pc.size();
        String className = new DistributedArray().getClass().toString();
        if (rank == 0) {
            LOG.info(className);
            LOG.info("Distributed MultiArray Tests");
        }
        System.out.flush();
        this._pc.barrier();
        int[] lengths = new int[]{4 * size, 3 * size, 2 * size};
        int[] decompTypes = new int[]{Decomposition.NONE, Decomposition.BLOCK, Decomposition.BLOCK};
        int[] tshape = DistributedArray.getTransposeShape(this._pc, 3, lengths, decompTypes);
        long maxlen = DistributedArray.getShapeLength(3, 1, tshape);
        DistributedArray a = new DistributedArray(this._pc, Integer.TYPE, 3, 1, tshape, decompTypes, maxlen);
        this._pc.serialPrint("after contsructor rank " + this._pc.rank() + " global shape " + Arrays.toString(a.getShape()));
        int n1 = a.getLength(0);
        int n2 = a.getLength(1);
        int n3 = a.getLength(2);
        int n3local = a.getLocalLength(2);
        int[] position = new int[3];
        for (kl = 0; kl < n3local; ++kl) {
            k = a.localToGlobal(2, kl);
            if (k >= n3) continue;
            position[2] = k;
            for (j = 0; j < n2; ++j) {
                position[1] = j;
                for (int i = 0; i < n1; ++i) {
                    position[0] = i;
                    a.putSample(10 * j + i, position);
                }
            }
        }
        this._pc.serialPrint("rank " + this._pc.rank() + " n1 " + n1 + " n2 " + n2 + " n3 " + n3 + " n3local " + n3local);
        this._pc.masterPrint("Transpose 132 ... ");
        a.transpose(TransposeType.T132);
        n1 = a.getLength(0);
        n2 = a.getLength(1);
        n3 = a.getLength(2);
        n3local = a.getLocalLength(2);
        int ia = 0;
        this._pc.serialPrint("rank " + this._pc.rank() + " n1 " + n1 + " n2 " + n2 + " n3 " + n3 + " n3local " + n3local);
        for (kl = 0; kl < n3local; ++kl) {
            k = a.localToGlobal(2, kl);
            if (k >= n3) continue;
            position[2] = k;
            for (j = 0; j < n2; ++j) {
                position[1] = j;
                for (int i = 0; i < n1; ++i) {
                    position[0] = i;
                    ia = a.getInt(position);
                    this.assertEquals("DistributedArray.tran132() failed", 10 * k + i, ia);
                }
            }
        }
        this._pc.masterPrint("Test completed");
    }

    public void testReshape() {
        int i;
        DistributedArray sa;
        int ib;
        int ia;
        int itest;
        int ntest = 10;
        int ndim = 3;
        int[] decompTypes = new int[]{Decomposition.NONE, Decomposition.BLOCK, Decomposition.BLOCK};
        int[] maxLengths = DistributedArray.getTransposeShape(this._pc, 3, new int[]{25, 17, 13}, decompTypes);
        int[] lengths = new int[ndim];
        int[] newLengths = new int[ndim];
        this._pc.masterPrint("Shape Contraction Tests:");
        Random r = new Random(12345L);
        for (itest = 0; itest < ntest; ++itest) {
            for (int i2 = 0; i2 < ndim; ++i2) {
                ia = Math.max((int)(r.nextDouble() * (double)maxLengths[i2]), this._pc.size());
                if (ia > (ib = Math.max((int)(r.nextDouble() * (double)maxLengths[i2]), this._pc.size()))) {
                    lengths[i2] = ia;
                    newLengths[i2] = ib;
                    continue;
                }
                lengths[i2] = ib;
                newLengths[i2] = ia;
            }
            this._pc.masterPrint("Contract " + Arrays.toString(lengths) + " to " + Arrays.toString(newLengths));
            sa = DistributedArrayTest.initArrayFloat(this._pc, lengths, lengths);
            sa.reshape(newLengths);
            for (i = 0; i < ndim; ++i) {
                this.assertEquals("Dimension Check Failed: ", sa.getLength(i), newLengths[i]);
            }
            this.checkContents("Shape Contraction iteration " + itest, sa, newLengths);
            sa = null;
            System.gc();
        }
        this._pc.masterPrint("Shape Expansion Tests:");
        for (itest = 0; itest < ntest; ++itest) {
            for (int i3 = 0; i3 < ndim; ++i3) {
                ia = Math.max((int)(r.nextDouble() * (double)maxLengths[i3]), this._pc.size());
                if (ia > (ib = Math.max((int)(r.nextDouble() * (double)maxLengths[i3]), this._pc.size()))) {
                    lengths[i3] = ib;
                    newLengths[i3] = ia;
                    continue;
                }
                lengths[i3] = ia;
                newLengths[i3] = ib;
            }
            this._pc.masterPrint("Expand " + Arrays.toString(lengths) + " to " + Arrays.toString(newLengths));
            sa = DistributedArrayTest.initArrayFloat(this._pc, lengths, maxLengths);
            sa.reshape(newLengths);
            for (i = 0; i < ndim; ++i) {
                this.assertEquals("Dimension Check Failed: ", sa.getLength(i), newLengths[i]);
            }
            this.checkContents("Shape Expansion iteration " + itest, sa, lengths);
            sa = null;
            System.gc();
        }
        this._pc.masterPrint("Arbitrary shape tests:");
        int[] checklen = new int[ndim];
        for (int itest2 = 0; itest2 < ntest; ++itest2) {
            for (int i4 = 0; i4 < ndim; ++i4) {
                ia = Math.max((int)(r.nextDouble() * (double)maxLengths[i4]), this._pc.size());
                ib = Math.max((int)(r.nextDouble() * (double)maxLengths[i4]), this._pc.size());
                lengths[i4] = ia;
                newLengths[i4] = ib;
                checklen[i4] = Math.min(ia, ib);
            }
            this._pc.masterPrint("Reshape " + Arrays.toString(lengths) + " to " + Arrays.toString(newLengths));
            DistributedArray sa2 = DistributedArrayTest.initArrayFloat(this._pc, lengths, maxLengths);
            sa2.reshape(newLengths);
            this.checkContents("Arbitrary Shape iteration " + itest2, sa2, checklen);
            sa2 = null;
            System.gc();
        }
    }

    public void testFrameIteratorDouble() {
        double value;
        int i0;
        int i1;
        int i2;
        int i2l;
        if (this._pc.rank() == 0) {
            System.out.println("Distributed array frame iterator tests (_pc.size()=" + this._pc.size() + ")...");
        }
        int n0 = 2;
        int n1 = 3;
        int n2 = 4;
        DistributedArray xda = new DistributedArray(this._pc, Double.TYPE, 3, 1, new int[]{n0, n1, n2}, new int[]{Decomposition.BLOCK, Decomposition.BLOCK, Decomposition.BLOCK});
        for (i2l = 0; i2l < xda.getLocalShape()[2]; ++i2l) {
            i2 = xda.localToGlobal(2, i2l);
            for (i1 = 0; i1 < n1; ++i1) {
                i0 = 0;
                while (i0 < n0) {
                    value = 1.0 * (double)i2 * (double)n1 * (double)n0 + 1.0 * (double)i1 * (double)n0 + 1.0 * (double)i0;
                    xda.putSample(value, new int[]{i0++, i1, i2});
                }
            }
        }
        double[][] frame = new double[n1][n0];
        DistributedArrayFrameIterator<double[][]> xfi = new DistributedArrayFrameIterator<double[][]>(xda, frame);
        i2l = 0;
        while (xfi.hasNext()) {
            frame = xfi.next();
            i2 = xda.localToGlobal(2, i2l);
            for (i1 = 0; i1 < n1; ++i1) {
                for (i0 = 0; i0 < n0; ++i0) {
                    value = 1.0 * (double)i2 * (double)n1 * (double)n0 + 1.0 * (double)i1 * (double)n0 + 1.0 * (double)i0;
                    this.assertEquals("", value, frame[i1][i0], Double.MIN_VALUE);
                    frame[i1][i0] = value *= 2.0;
                }
            }
            xda.putFrame(frame, new int[]{0, 0, i2});
            ++i2l;
        }
        i2l = 0;
        xfi.reset();
        while (xfi.hasNext()) {
            frame = xfi.next();
            i2 = xda.localToGlobal(2, i2l);
            for (i1 = 0; i1 < n1; ++i1) {
                for (i0 = 0; i0 < n0; ++i0) {
                    value = 2.0 * (double)i2 * (double)n1 * (double)n0 + 2.0 * (double)i1 * (double)n0 + 2.0 * (double)i0;
                    this.assertEquals("", value, frame[i1][i0], Double.MIN_VALUE);
                }
            }
            ++i2l;
        }
        if (this._pc.rank() == 0) {
            System.out.println("...done with DistributedArray frame iterator tests.");
        }
    }

    public void testCreateBigArray() {
        int rank = this._pc.rank();
        long needed = 0x280000000L;
        long heapMaxSize = Runtime.getRuntime().maxMemory();
        if (needed > heapMaxSize) {
            LOG.warning("Max heap size is not large enough for 'testCreateBigArray' unit tests, skipping test");
            return;
        }
        String className = new DistributedArray().getClass().toString();
        if (rank == 0) {
            LOG.info(className);
            LOG.info("DistributedArray CreateBigArray Tests");
        }
        System.out.flush();
        this._pc.barrier();
        int ndim = 3;
        int[] lengths = new int[]{1, 1, 1};
        long maxArrayLength = 2147483747L;
        int[] decomp = new int[]{Decomposition.BLOCK, Decomposition.BLOCK, Decomposition.BLOCK};
        DistributedArray da = new DistributedArray(this._pc, Integer.TYPE, ndim, 1, lengths, decomp, maxArrayLength);
        try {
            da.setShape(new int[]{2, 2, 2});
        }
        catch (AssertionError e) {
            this.fail("Failed to set shape: " + ((Throwable)((Object)e)).getMessage());
        }
        long backingArrayLength = da.getBackingArray().getBackingArrayLength();
        this.assertEquals("Bad BackingArray length: ", maxArrayLength, backingArrayLength);
    }

    public void testCreateLongArray() {
        int rank = this._pc.rank();
        LOG.info("size = " + this._pc.size());
        String className = new DistributedArray().getClass().toString();
        if (rank == 0) {
            LOG.info(className);
            LOG.info("DistributedArray CreateLongArray Tests");
        }
        this._pc.barrier();
        int ndim = 3;
        int[] lengths = new int[]{11, 3, 2};
        long maxArrayLength = lengths[0] * lengths[1] * lengths[2];
        int[] decomp = new int[]{Decomposition.BLOCK, Decomposition.BLOCK, Decomposition.BLOCK};
        DistributedArray da = new DistributedArray(this._pc, Integer.TYPE, ndim, 1, lengths, decomp, maxArrayLength, BackingArray.Type.JAVA_LONG_ARRAY);
        da.transpose(TransposeType.T132);
    }

    public void testCopyConstructor() {
        int rank = this._pc.rank();
        String className = new DistributedArray().getClass().toString();
        if (rank == 0) {
            LOG.info(className);
            LOG.info("DistributedArray CreateLongArray Tests");
        }
        this._pc.barrier();
        int[] lengths = new int[]{11, 3, 2};
        LOG.info("create da");
        DistributedArray da = DistributedArrayTest.initArrayFloat(this._pc, lengths, lengths, BackingArray.Type.JAVA_LONG_ARRAY);
        LOG.info("check contents");
        this.checkContents("before copy constructor", da, lengths);
        LOG.info("call copy constructor");
        DistributedArray copy = new DistributedArray(da);
        LOG.info("check contents");
        this.checkContents("After copy constructor", copy, lengths);
    }

    public static DistributedArray initArray(IParallelContext pc, int[] lengths) {
        int ndim = 3;
        MultiArray sa = MultiArray.factory(ndim, Integer.TYPE, 1, lengths);
        int[] position = new int[]{0, 0, 0};
        for (int k = 0; k < lengths[2]; ++k) {
            position[2] = k;
            for (int j = 0; j < lengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < lengths[0]; ++i) {
                    position[0] = i;
                    sa.putSample(DistributedArrayTest.testFn(i, j, k), position);
                }
            }
        }
        return new DistributedArray(sa, pc);
    }

    public static DistributedArray initArray4(IParallelContext pc, int[] lengths) {
        int ndim = 4;
        MultiArray sa = MultiArray.factory(ndim, Integer.TYPE, 1, lengths);
        int[] position = new int[]{0, 0, 0, 0};
        for (int m = 0; m < lengths[3]; ++m) {
            position[3] = m;
            for (int k = 0; k < lengths[2]; ++k) {
                position[2] = k;
                for (int j = 0; j < lengths[1]; ++j) {
                    position[1] = j;
                    for (int i = 0; i < lengths[0]; ++i) {
                        position[0] = i;
                        sa.putSample(DistributedArrayTest.testFn(i, j, k, m), position);
                    }
                }
            }
        }
        return new DistributedArray(sa, pc);
    }

    public static DistributedArray initArrayFloat(IParallelContext pc, int[] lengths, int[] lengthsMax) {
        DistributedArray sa = new DistributedArray(pc, lengthsMax);
        sa.setShape(lengths);
        int[] position = new int[]{0, 0, 0};
        for (int kl = 0; kl < sa.getLocalLength(2); ++kl) {
            int k = sa.localToGlobal(2, kl);
            if (k >= lengths[2]) continue;
            position[2] = k;
            for (int j = 0; j < lengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < lengths[0]; ++i) {
                    position[0] = i;
                    sa.putSample(DistributedArrayTest.testFloat(i, j, k), position);
                }
            }
        }
        return sa;
    }

    public static DistributedArray initArrayFloat(IParallelContext pc, int[] lengths, int[] lengthsMax, BackingArray.Type type) {
        int ndim = 3;
        long maxArrayLength = lengthsMax[0] * lengthsMax[1] * lengthsMax[2];
        long bytes = maxArrayLength * 4L;
        double gb = (double)bytes / 1.073741824E9;
        LOG.info("Array size = " + gb + " Gb");
        int[] decomp = new int[]{Decomposition.BLOCK, Decomposition.BLOCK, Decomposition.BLOCK};
        DistributedArray sa = new DistributedArray(pc, Float.TYPE, ndim, 1, lengths, decomp, maxArrayLength, type);
        sa.setShape(lengths);
        int[] position = new int[]{0, 0, 0};
        for (int kl = 0; kl < sa.getLocalLength(2); ++kl) {
            int k = sa.localToGlobal(2, kl);
            if (k >= lengths[2]) continue;
            position[2] = k;
            for (int j = 0; j < lengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < lengths[0]; ++i) {
                    position[0] = i;
                    sa.putSample(DistributedArrayTest.testFloat(i, j, k), position);
                }
            }
        }
        return sa;
    }

    public static int testFn(int i, int j) {
        return i + 100 * j;
    }

    public static int testFn(int i, int j, int k) {
        return i + 100 * j + 10000 * k;
    }

    public static int testFn(int i, int j, int k, int m) {
        return i + 100 * j + 10000 * k + 1000000 * m;
    }

    public static float testFloat(int i, int j, int k) {
        return 1.0f * (float)i + 100.0f * (float)j + 10000.0f * (float)k;
    }

    public void checkContents(String title, DistributedArray sa, int[] lengths) {
        int[] position = new int[]{0, 0, 0};
        for (int kl = 0; kl < sa.getLocalLength(2); ++kl) {
            int k = sa.localToGlobal(2, kl);
            if (k >= lengths[2]) continue;
            position[2] = k;
            for (int j = 0; j < lengths[1]; ++j) {
                position[1] = j;
                for (int i = 0; i < lengths[0]; ++i) {
                    position[0] = i;
                    float f2 = sa.getFloat(position);
                    float f1 = DistributedArrayTest.testFloat(i, j, k);
                    this.assertEquals(title, i, j, k, f1, f2, 1.0E-6f);
                }
            }
        }
    }

    private void assertEquals(String title, int i, int j, int k, float arg1, float arg2, float tol) {
        assert (Math.abs(arg2 - arg1) < tol) : title + " " + i + "," + j + "," + k + " Expected " + arg1 + " got " + arg2;
    }

    private void assertEquals(String title, int arg1, int arg2) {
        assert (arg1 == arg2) : title + " Expected " + arg1 + " got " + arg2;
    }

    private void assertEquals(String title, long arg1, long arg2) {
        assert (arg1 == arg2) : title + " Expected " + arg1 + " got " + arg2;
    }

    private void assertEquals(String title, double arg1, double arg2, double tol) {
        assert (Math.abs(arg1 - arg2) <= tol) : title + " Expected " + arg1 + " got " + arg2;
    }

    private void fail(String title) {
        assert (false) : title;
    }
}

