/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import edu.mines.jtk.util.Parameter;
import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.javaseis.io.Seisio;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.properties.SeisTraceProperty;
import org.javaseis.util.SeisException;

public class SeisTraceProperties {
    private static final Logger log = Logger.getLogger("org.javaseis.properties");
    Map _map;
    Seisio _sio;
    ByteBuffer _headers;
    ShortBuffer _shortView;
    IntBuffer _intView;
    FloatBuffer _floatView;
    LongBuffer _longView;
    DoubleBuffer _doubleView;
    int _index;
    int _reclen;

    public SeisTraceProperties() {
        this._map = new LinkedHashMap();
        this._index = 0;
        this._reclen = 0;
    }

    public SeisTraceProperties(ByteBuffer headers) {
        this.setBuffer(headers);
        this._map = new LinkedHashMap();
        this._index = 0;
        this._reclen = 0;
    }

    public void setBuffer(ByteBuffer headers) {
        this._headers = headers;
        this._intView = headers.asIntBuffer();
        this._floatView = headers.asFloatBuffer();
        this._doubleView = headers.asDoubleBuffer();
    }

    public int recordLength() {
        return this._reclen;
    }

    public int size() {
        return this._map.size();
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public void add(SeisTraceProperty prop) {
        SeisTraceProperty tprop = new SeisTraceProperty(prop);
        this._reclen += tprop.getLength();
        this._map.put(tprop.getName(), tprop);
    }

    public SeisTraceProperty get(String name) {
        return (SeisTraceProperty)this._map.get(name);
    }

    public int putInt(String name, int i) {
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        this._intView.put(newPosition, i);
        return i;
    }

    public float putFloat(String name, float f) {
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        this._floatView.put(newPosition, f);
        return f;
    }

    public double putDouble(String name, double d) {
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        this._doubleView.put(newPosition, d);
        return d;
    }

    public int getInt(String name) {
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        return this._intView.get(newPosition);
    }

    public float getFloat(String name) {
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        return this._floatView.get(newPosition);
    }

    public double getDouble(String name) {
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        return this._doubleView.get(newPosition);
    }

    public <T> T getValue(String name) {
        T retval = null;
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        switch (tp._type) {
            case INT: {
                Integer i = new Integer(this._intView.get(newPosition));
                return (T)i;
            }
            case FLOAT: {
                Float f = new Float(this._floatView.get(newPosition));
                return (T)f;
            }
            case DOUBLE: {
                Double d = new Double(this._doubleView.get(newPosition));
                return (T)d;
            }
        }
        return retval;
    }

    public <T> T setValue(String name, T value) {
        SeisTraceProperty tp = this.get(name);
        int newPosition = (this._reclen * this._index + tp._offset) / tp._length;
        if (Integer.class.isInstance(value)) {
            int i = (Integer)value;
            this._intView.put(newPosition, i);
        } else if (Float.class.isInstance(value)) {
            float f = ((Float)value).floatValue();
            this._floatView.put(newPosition, f);
        } else if (Double.class.isInstance(value)) {
            double d = (Double)value;
            this._doubleView.put(newPosition, d);
        } else {
            return null;
        }
        return value;
    }

    public void store(File file) throws IOException {
        ParameterSet ps = new ParameterSet("SeisTraceProperties");
        SeisTraceProperty tp = null;
        for (Object key : this._map.keySet()) {
            tp = (SeisTraceProperty)this._map.get(key);
            ps.setString((String)key, tp.toPropString());
        }
        ParameterSetIO.writeFile(ps, file.getAbsolutePath());
    }

    public void load(File file) throws IOException {
        ParameterSet ps = ParameterSetIO.readFile(file.getAbsolutePath());
        SeisTraceProperty tp = new SeisTraceProperty();
        this._map.clear();
        this._reclen = 0;
        Iterator pe = ps.getParameters();
        while (pe.hasNext()) {
            Parameter p = (Parameter)pe.next();
            tp.set(p.getName(), p.getString());
            this.add(tp.clone());
        }
    }

    public static void main(String[] args) throws SeisException {
        int j;
        String[] names = new String[]{"InLine", "X-Line", "SourceX", "SourceY", "SourceZ", "ReceiverX", "ReceiverY", "ReceiverZ"};
        String[] desc = new String[]{"In-Line number,INT,1,0", "X-Line number,INT,1,4", "Source X coord,DOUBLE,1,8", "Source Y coord,DOUBLE,1,16", "Source Z coord,DOUBLE,1,24", "Receiver X coord,DOUBLE,1,32", "Receiver Y coord,DOUBLE,1,40", "Receiver Z coord,DOUBLE,1,48"};
        int ntrc = 10;
        int reclen = 56;
        int xl = 100;
        int il = 200;
        double x = 0.0;
        double y = 0.0;
        double h = 0.0;
        ByteBuffer buf = ByteBuffer.allocateDirect(ntrc * reclen);
        SeisTraceProperties stp = new SeisTraceProperties();
        SeisTraceProperty prop = new SeisTraceProperty();
        for (j = 0; j < names.length; ++j) {
            prop.set(names[j], desc[j]);
            stp.add(prop);
        }
        stp.setBuffer(buf);
        for (j = 0; j < ntrc; ++j) {
            h = 50.0 * (double)j;
            stp.setIndex(j);
            stp.putInt("InLine", il);
            stp.putInt("X-Line", xl);
            stp.putDouble("SourceX", x + h);
            stp.putDouble("SourceY", 0.0);
            stp.putDouble("SourceZ", 0.0);
            stp.putDouble("ReceiverX", x - h);
            stp.putDouble("ReceiverY", 0.0);
            stp.putDouble("ReceiverZ", 0.0);
        }
        try {
            stp.store(new File("temp.xml"));
        }
        catch (IOException e) {
            // empty catch block
        }
        stp = null;
        System.gc();
        stp = new SeisTraceProperties(buf);
        try {
            stp.load(new File("temp.xml"));
        }
        catch (IOException e) {
            // empty catch block
        }
        stp.setIndex(0);
        System.out.println("InLine,X-Line,Source XYZ, Receiver XYZ");
        for (int j2 = 0; j2 < 10; ++j2) {
            stp.setIndex(j2);
            System.out.println("Index " + j2 + " InLine " + stp.getInt("InLine") + " X-Line " + stp.getInt("X-Line") + " Source X " + stp.getDouble("SourceX") + " Receiver X " + stp.getDouble("ReceiverX"));
        }
    }
}

