/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import edu.mines.jtk.util.ParameterSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.javaseis.io.Seisio;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.properties.PropertiesTree;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.util.SeisException;

public class PropertiesConverter
extends PropertiesTree {
    public static final Logger _logger = Logger.getLogger("org.javaseis.propeties.PropertiesConverter");
    private static final String STACKED = "Stacked";
    private static final String GEOM_MATCHES_FLAG = "GeomMatchesFlag";
    private static final String SYNTHETIC = "Synthetic";
    private static final String TRACENO_MATCHES_FLAG = "TraceNoMatchesFlag";
    private static final String VIRTUAL_FOLDERS_OBS = "VirtualFolders";

    public static boolean needsConversion(String datasetPath) throws SeisException {
        File stubFile = new File(datasetPath + File.separator + "Name.properties");
        if (stubFile.exists()) {
            return false;
        }
        File xmlFile = new File(datasetPath + File.separator + "FileProperties.xml");
        if (xmlFile.exists()) {
            throw new SeisException("JavaSeis dataset '" + datasetPath + "' appears to be a version" + " that only existed for a few days - please remove it or remove" + " the file '" + xmlFile + " if this is an old dataset that was converted");
        }
        File namePropertiesFile = new File(datasetPath + File.separator + PropertiesTree.NAME_PROPERTIES);
        return namePropertiesFile.exists();
    }

    public static void convert(String datasetPath) throws SeisException {
        try {
            File xmlFile;
            PropertiesConverter converter = new PropertiesConverter(datasetPath);
            _logger.info("\nStarting conversion of JavaSeis dataset '" + datasetPath + "'\n  from version 2006.2 to 2006.3 ...");
            File stubFile = new File(datasetPath + File.separator + "Name.properties");
            if (!stubFile.exists()) {
                converter.convertNameProperties();
            }
            if (!(xmlFile = new File(datasetPath + File.separator + "FileProperties.xml")).exists()) {
                converter.convertTraceProperties();
                converter.convertFileProperties();
                converter.convertNameProperties();
                converter.convertUserProperties();
                converter.write();
                converter.convertVirtualFolders();
                converter.convertExtentManagerFile("TraceFile");
                converter.convertExtentManagerFile("TraceHeaders");
                converter.convertExtentManagerFile("TraceMap");
                converter.convertAllSortPropertiesFiles();
            }
            _logger.info("  Finished conversion of JavaSeis dataset '" + datasetPath + "'  :-)\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            if (e instanceof SeisException) {
                throw (SeisException)e;
            }
            throw new SeisException(e.toString());
        }
    }

    private PropertiesConverter(String datasetPath) throws SeisException {
        super(datasetPath, false);
    }

    private HashtableProperties getProperties(String fileName) throws IOException {
        File file = new File(this._datasetPath + File.separator + fileName);
        HashtableProperties properties = new HashtableProperties();
        properties.load(file);
        return properties;
    }

    private void convertFileProperties() throws IOException {
        HashtableProperties properties = null;
        try {
            properties = this.getProperties(PropertiesTree.FILE_PROPERTIES);
        }
        catch (IOException e) {
            _logger.info("  Conversion of FileProperties was not necessary ...");
            return;
        }
        int nDimensions = PropertiesConverter.getFilePropertyInteger(properties, "DataDimensions");
        ParameterSet branchParameterSet = this._rootParameterSet.addParameterSet(PropertiesTree.FILE_PROPERTIES);
        String sep1 = ";";
        String sep2 = " ";
        long[] longValues = new long[nDimensions];
        double[] doubleValues = new double[nDimensions];
        String[] stringValues = new String[nDimensions];
        for (Object key : properties.keySet()) {
            String label = (String)key;
            if (label.equals("DataDimensions") || label.equals("HeaderLength") || label.equals("HeaderLengthBytes")) {
                int ival = PropertiesConverter.getFilePropertyInteger(properties, label);
                branchParameterSet.setInt(label, ival);
                continue;
            }
            if (label.equals("LogicalOrigins") || label.equals("LogicalDeltas") || label.equals("AxisLengths")) {
                int nvals = PropertiesConverter.getFilePropertyLongArray(properties, label, longValues, sep2);
                if (nvals != nDimensions) {
                    throw new SeisException("nvals != nDimensions");
                }
                branchParameterSet.setLongs(label, longValues);
                continue;
            }
            if (label.equals("PhysicalOrigins") || label.equals("PhysicalDeltas")) {
                int nvals = PropertiesConverter.getFilePropertyDoubleArray(properties, label, doubleValues, sep2);
                if (nvals != nDimensions) {
                    throw new SeisException("nvals != nDimensions");
                }
                branchParameterSet.setDoubles(label, doubleValues);
                continue;
            }
            if (label.equals("AxisUnits") || label.equals("AxisLabels") || label.equals("AxisDomains")) {
                int nvals = PropertiesConverter.getFilePropertyStringArray(properties, label, stringValues, sep1);
                if (nvals != nDimensions) {
                    throw new SeisException("nvals != nDimensions");
                }
                branchParameterSet.setStrings(label, stringValues);
                continue;
            }
            if (label.equals("Mapped")) {
                String value = PropertiesConverter.getFilePropertyString(properties, label);
                if (value.equals("TRUE") || value.equals("true")) {
                    branchParameterSet.setBoolean(label, true);
                    continue;
                }
                branchParameterSet.setBoolean(label, false);
                continue;
            }
            String value = PropertiesConverter.getFilePropertyString(properties, label);
            branchParameterSet.setString(label, value);
        }
        _logger.info("  Finished conversion of FileProperties ...");
    }

    private void convertNameProperties() throws IOException {
        HashtableProperties properties = null;
        try {
            properties = this.getProperties(PropertiesTree.NAME_PROPERTIES);
        }
        catch (IOException e) {
            _logger.info("  Conversion of NameProperties was not necessary ...");
            return;
        }
        ParameterSet branchParameterSet = this._rootParameterSet.getParameterSet(PropertiesTree.CUSTOM_PROPERTIES);
        if (branchParameterSet == null) {
            branchParameterSet = this._rootParameterSet.addParameterSet(PropertiesTree.CUSTOM_PROPERTIES);
        }
        for (Object key : properties.keySet()) {
            String value;
            String label = (String)key;
            if (label.equals(STACKED) || label.equals(SYNTHETIC)) {
                value = PropertiesConverter.getFilePropertyString(properties, label);
                if (value.equals("TRUE") || value.equals("true")) {
                    branchParameterSet.setBoolean(label, true);
                    continue;
                }
                branchParameterSet.setBoolean(label, false);
                continue;
            }
            if (label.equals(GEOM_MATCHES_FLAG) || label.equals(TRACENO_MATCHES_FLAG)) {
                value = PropertiesConverter.getFilePropertyString(properties, label);
                if (value.equals("0")) {
                    branchParameterSet.setInt(label, 0);
                    continue;
                }
                branchParameterSet.setInt(label, 1);
                continue;
            }
            if (label.equals("DescriptiveName")) {
                value = PropertiesConverter.getFilePropertyString(properties, label);
                Seisio.createStub(this._datasetPath, value);
                continue;
            }
            value = PropertiesConverter.getFilePropertyString(properties, label);
            branchParameterSet.setString(label, value);
        }
        _logger.info("  Finished conversion of NameProperties ...");
    }

    private void convertUserProperties() throws IOException {
        HashtableProperties properties = null;
        try {
            properties = this.getProperties(PropertiesTree.USER_DEFINED_PROPERTIES);
        }
        catch (IOException e) {
            _logger.info("  Conversion of UserProperties was not necessary ...");
            return;
        }
        ParameterSet branchParameterSet = this._rootParameterSet.getParameterSet(PropertiesTree.CUSTOM_PROPERTIES);
        if (branchParameterSet == null) {
            branchParameterSet = this._rootParameterSet.addParameterSet(PropertiesTree.CUSTOM_PROPERTIES);
        }
        for (Object key : properties.keySet()) {
            String label = (String)key;
            String value = PropertiesConverter.getFilePropertyString(properties, label);
            branchParameterSet.setString(label, value);
        }
        _logger.info("  Finished conversion of UserProperties ...");
    }

    private void convertTraceProperties() throws IOException {
        HashtableProperties properties = null;
        try {
            properties = this.getProperties(PropertiesTree.TRACE_PROPERTIES);
        }
        catch (IOException e) {
            _logger.info("  Conversion of TraceProperties was not necessary ...");
            return;
        }
        ParameterSet branchParameterSet = this._rootParameterSet.addParameterSet(PropertiesTree.TRACE_PROPERTIES);
        PropertyDescription[] propertyDescriptions = new PropertyDescription[properties.size()];
        int n = 0;
        for (Object key : properties.keySet()) {
            String label = (String)key;
            String valueString = properties.getProperty((String)key);
            String[] values = PropertiesConverter.stringToArray(valueString, ";", '\"', '\"');
            if (values.length < 4) {
                throw new SeisException("Could not parse property string: '" + valueString + "' for label='" + label + "' (expecting at least 4 values)");
            }
            if (values.length > 4) {
                String[] temp = new String[]{values[0], values[values.length - 3], values[values.length - 2], values[values.length - 1]};
                values = temp;
            }
            String description = values[0];
            String formatString = values[1];
            int count = Integer.parseInt(values[2]);
            int offset = Integer.parseInt(values[3]);
            propertyDescriptions[n] = new PropertyDescription(label, description, PropertyDescription.getFormat(formatString), count);
            propertyDescriptions[n].setOffset(offset);
            ++n;
        }
        PropertyDescription.sort(propertyDescriptions);
        for (int i = 0; i < propertyDescriptions.length; ++i) {
            ParameterSet parameterSet = branchParameterSet.addParameterSet("entry_" + i);
            parameterSet.setString("label", propertyDescriptions[i].getLabel());
            parameterSet.setString("description", propertyDescriptions[i].getDescription());
            parameterSet.setString("format", propertyDescriptions[i].getFormatString());
            parameterSet.setInt("elementCount", propertyDescriptions[i].getCount());
            parameterSet.setInt("byteOffset", propertyDescriptions[i].getOffset());
        }
        _logger.info("  Finished conversion of TraceProperties ...");
    }

    private void convertVirtualFolders() throws IOException {
        HashtableProperties properties = null;
        try {
            properties = this.getProperties(VIRTUAL_FOLDERS_OBS);
        }
        catch (IOException e) {
            _logger.info("  Conversion of VirtualFolders was not necessary ...");
            return;
        }
        ParameterSet parameterSet = new ParameterSet(VIRTUAL_FOLDERS_OBS);
        for (Object key : properties.keySet()) {
            String label = (String)key;
            if (label.equals("GLOBAL_REQUIRED_FREE_SPACE") || label.equals("MIN_FREE_SPACE") || label.equals("MAX_FREE_SPACE")) {
                long value = PropertiesConverter.getFilePropertyLong(properties, label);
                parameterSet.setLong(label, value);
                continue;
            }
            if (label.equals("NDIR")) {
                int value = PropertiesConverter.getFilePropertyInteger(properties, label);
                parameterSet.setInt(label, value);
                continue;
            }
            String value = PropertiesConverter.getFilePropertyString(properties, label);
            parameterSet.setString(label, value);
        }
        String filePath = this._datasetPath + File.separator + "VirtualFolders.xml";
        try {
            ParameterSetIO.writeFile(parameterSet, filePath);
        }
        catch (IOException e) {
            throw new SeisException("Error writing file XML file '" + filePath + "'");
        }
        _logger.info("  Finished conversion of VirtualFolders ...");
    }

    private void convertAllSortPropertiesFiles() throws IOException {
        File dir = new File(this._datasetPath);
        String[] files = dir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].indexOf("SortProperties.") < 0 || files[i].endsWith(".xml")) continue;
                this.convertSortPropertiesFile(files[i]);
            }
        }
    }

    private void convertSortPropertiesFile(String fileName) throws IOException {
        HashtableProperties properties = null;
        try {
            properties = this.getProperties(fileName);
        }
        catch (IOException e) {
            _logger.info("  Conversion of '" + fileName + "' failed (file not found) ...");
            return;
        }
        ParameterSet parameterSet = new ParameterSet("SortProperties");
        for (Object key : properties.keySet()) {
            String label = (String)key;
            if (label.equals("TotalTracesInSort")) {
                long value = PropertiesConverter.getFilePropertyLong(properties, label);
                parameterSet.setLong(label, value);
                continue;
            }
            if (label.equals("NumberOfVolumes") || label.equals("FramesPerVolume") || label.equals("TracesPerFrame") || label.equals("MinLogicalVolume") || label.equals("MaxLogicalVolume") || label.equals("MinLogicalFrame") || label.equals("MaxLogicalFrame")) {
                int value = PropertiesConverter.getFilePropertyInteger(properties, label);
                parameterSet.setInt(label, value);
                continue;
            }
            String value = PropertiesConverter.getFilePropertyString(properties, label);
            parameterSet.setString(label, value);
        }
        String newPath = this._datasetPath + File.separator + fileName + ".xml";
        try {
            ParameterSetIO.writeFile(parameterSet, newPath);
        }
        catch (IOException e) {
            throw new SeisException("Error writing file XML file '" + newPath + "'");
        }
        _logger.info("  Finished conversion of sort properties file '" + fileName + "' ...");
    }

    private void convertExtentManagerFile(String fileName) throws IOException {
        String oldPath = this._datasetPath + File.separator + fileName;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(oldPath);
        }
        catch (FileNotFoundException ex) {
            _logger.info("  Conversion of " + fileName + " was not necessary ...");
            return;
        }
        char[] cbuf = new char[5];
        int nc = 0;
        try {
            nc = fileReader.read(cbuf, 0, 5);
            fileReader.close();
        }
        catch (IOException ex) {
            _logger.info("  Conversion of " + fileName + " must not be necessary ...");
            return;
        }
        fileReader = null;
        String vfioHeader = "null";
        if (nc == 5) {
            vfioHeader = new String(cbuf, 0, 5);
        }
        if (!vfioHeader.equals("#VFIO")) {
            _logger.info("  Conversion of " + fileName + " was not necessary ...");
            return;
        }
        HashtableProperties properties = null;
        try {
            properties = this.getProperties(fileName);
        }
        catch (IOException e) {
            _logger.info("  Conversion of " + fileName + " was not necessary ...");
            return;
        }
        ParameterSet parameterSet = new ParameterSet("ExtentManager");
        for (Object key : properties.keySet()) {
            String label = (String)key;
            if (label.equals("VFIO_MAXPOS") || label.equals("VFIO_EXTSIZE")) {
                long value = PropertiesConverter.getFilePropertyLong(properties, label);
                parameterSet.setLong(label, value);
                continue;
            }
            if (label.equals("VFIO_MAXFILE")) {
                int value = PropertiesConverter.getFilePropertyInteger(properties, label);
                parameterSet.setInt(label, value);
                continue;
            }
            String value = PropertiesConverter.getFilePropertyString(properties, label);
            parameterSet.setString(label, value);
        }
        String newPath = this._datasetPath + File.separator + fileName + ".xml";
        try {
            ParameterSetIO.writeFile(parameterSet, newPath);
        }
        catch (IOException e) {
            throw new SeisException("Error writing file XML file '" + newPath + "'");
        }
        _logger.info("  Finished conversion of " + fileName + " ...");
    }

    public static String[] stringToArray(String s, String sep, char start, char end) {
        int i2;
        int i1 = 0;
        if (s.charAt(i1) == start) {
            ++i1;
        }
        if (s.charAt((i2 = s.length()) - 1) == end) {
            --i2;
        }
        if (i2 <= i1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(s.substring(i1, i2));
        int arraySize = 1;
        for (int i = 0; i < buffer.length(); ++i) {
            if (sep.indexOf(buffer.charAt(i)) == -1) continue;
            ++arraySize;
        }
        String[] elements = new String[arraySize];
        int z = 0;
        if (buffer.toString().indexOf(sep) != -1) {
            while (buffer.length() > 0) {
                if (buffer.toString().indexOf(sep) == -1) continue;
                int y = buffer.toString().indexOf(sep);
                if (y != buffer.toString().lastIndexOf(sep)) {
                    elements[z] = buffer.toString().substring(0, y);
                    ++z;
                    buffer.delete(0, y + 1);
                    continue;
                }
                if (buffer.toString().lastIndexOf(sep) != y) continue;
                elements[z] = buffer.toString().substring(0, buffer.toString().indexOf(sep));
                buffer.delete(0, buffer.toString().indexOf(sep) + 1);
                elements[++z] = buffer.toString();
                ++z;
                buffer.delete(0, buffer.length());
            }
        } else {
            elements[0] = buffer.toString();
        }
        buffer = null;
        return elements;
    }

    public static int getFilePropertyInteger(HashtableProperties fileProperties, String name) throws SeisException {
        String value = null;
        value = fileProperties.getProperty(name);
        if (value == null) {
            throw new SeisException("Property not found: " + name);
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException ex) {
            throw new SeisException(ex.getMessage());
        }
    }

    public static int getFilePropertyIntegerArray(HashtableProperties fileProperties, String name, int[] values, String sep) throws SeisException {
        String value = fileProperties.getProperty(name);
        if (value == null) {
            throw new SeisException("Property not found: " + name);
        }
        String[] temp = PropertiesConverter.stringToArray(value, sep, '\"', '\"');
        int numValues = temp.length;
        if (numValues > values.length) {
            numValues = values.length;
        }
        try {
            for (int i = 0; i < numValues; ++i) {
                values[i] = Integer.parseInt(temp[i]);
            }
        }
        catch (NumberFormatException ex) {
            throw new SeisException("Error parsing property " + name + ": " + ex.getMessage());
        }
        return numValues;
    }

    public static long getFilePropertyLong(HashtableProperties fileProperties, String name) throws SeisException {
        String value = null;
        value = fileProperties.getProperty(name);
        if (value == null) {
            throw new SeisException("Property not found: " + name);
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException ex) {
            throw new SeisException(ex.getMessage());
        }
    }

    public static int getFilePropertyLongArray(HashtableProperties fileProperties, String name, long[] values, String sep) throws SeisException {
        String value = fileProperties.getProperty(name);
        if (value == null) {
            throw new SeisException("Property not found: " + name);
        }
        String[] temp = PropertiesConverter.stringToArray(value, sep, '\"', '\"');
        int numValues = temp.length;
        if (numValues > values.length) {
            numValues = values.length;
        }
        try {
            for (int i = 0; i < numValues; ++i) {
                values[i] = Long.parseLong(temp[i]);
            }
        }
        catch (NumberFormatException ex) {
            throw new SeisException("Error parsing property " + name + ": " + ex.getMessage());
        }
        return numValues;
    }

    public static int getFilePropertyDoubleArray(HashtableProperties fileProperties, String name, double[] values, String sep) throws SeisException {
        String value = fileProperties.getProperty(name);
        if (value == null) {
            throw new SeisException("Property not found: " + name);
        }
        String[] temp = PropertiesConverter.stringToArray(value, sep, '\"', '\"');
        int numValues = temp.length;
        if (numValues > values.length) {
            numValues = values.length;
        }
        try {
            for (int i = 0; i < numValues; ++i) {
                values[i] = Double.parseDouble(temp[i]);
            }
        }
        catch (NumberFormatException ex) {
            throw new SeisException("Error parsing property " + name + ": " + ex.getMessage());
        }
        return numValues;
    }

    public static String getFilePropertyString(HashtableProperties fileProperties, String name) throws SeisException {
        String value = null;
        value = fileProperties.getProperty(name);
        if (value == null) {
            throw new SeisException("Property not found: " + name);
        }
        return value;
    }

    public static int getFilePropertyStringArray(HashtableProperties fileProperties, String name, String[] values, String sep) throws SeisException {
        String value = fileProperties.getProperty(name);
        if (value == null) {
            throw new SeisException("Property not found: " + name);
        }
        String[] temp = PropertiesConverter.stringToArray(value, sep, '\"', '\"');
        int numValues = temp.length;
        if (numValues > values.length) {
            numValues = values.length;
        }
        try {
            for (int i = 0; i < numValues; ++i) {
                values[i] = new String(temp[i]);
            }
        }
        catch (NumberFormatException ex) {
            throw new SeisException("Error parsing property " + name + ": " + ex.getMessage());
        }
        return numValues;
    }

    private static class HashtableProperties {
        private Properties _properties = new Properties();
        private String _commentsLine = null;
        private String _dateLine = null;

        HashtableProperties() {
        }

        public void load(File file) throws IOException {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            this._commentsLine = reader.readLine();
            this._dateLine = reader.readLine();
            reader.close();
            FileInputStream inStream = new FileInputStream(file);
            this._properties.load(inStream);
            ((InputStream)inStream).close();
        }

        public int size() {
            return this._properties.size();
        }

        public Set keySet() {
            return this._properties.keySet();
        }

        public String getProperty(String key) {
            return this._properties.getProperty(key);
        }
    }
}

