/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import java.io.Serializable;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataDomain;
import org.javaseis.properties.Units;

public class AxisDefinition
implements Serializable {
    protected AxisLabel _label;
    protected Units _units;
    protected DataDomain _domain;
    protected long _length;
    protected long _logicalOrigin;
    protected long _logicalDelta;
    protected double _physicalOrigin;
    protected double _physicalDelta;

    public AxisDefinition(AxisLabel label, Units units, DataDomain domain, long length, long logicalOrigin, long logicalDelta, double physicalOrigin, double physicalDelta) {
        if (label == null) {
            throw new IllegalArgumentException("AxisLabel is null");
        }
        if (units == null) {
            throw new IllegalArgumentException("Units are null");
        }
        if (domain == null) {
            throw new IllegalArgumentException("Domain is null");
        }
        if (logicalDelta == 0L) {
            throw new IllegalArgumentException("logical delta is 0");
        }
        if (physicalDelta == 0.0) {
            throw new IllegalArgumentException("physical delta is 0.0");
        }
        this._label = new AxisLabel(label.getName(), label.getDescription());
        this._units = new Units(units.getName(), units.getDescription());
        this._domain = new DataDomain(domain.getName(), domain.getDescription());
        this._length = length;
        this._logicalOrigin = logicalOrigin;
        this._logicalDelta = logicalDelta;
        this._physicalOrigin = physicalOrigin;
        this._physicalDelta = physicalDelta;
    }

    public static AxisDefinition[] getDefault(int ndim, int[] idim) {
        AxisDefinition[] axes = new AxisDefinition[ndim];
        AxisLabel[] labels = AxisLabel.getDefault(ndim);
        for (int i = 0; i < ndim; ++i) {
            axes[i] = new AxisDefinition(labels[i], Units.NULL, DataDomain.NULL, idim[i], 0L, 1L, 0.0, 1.0);
        }
        return axes;
    }

    public AxisDefinition subRange(long[] range) {
        if (range.length < 3) {
            throw new IllegalArgumentException("Range must have 3 elements");
        }
        if (range[0] < 0L || range[1] >= this._length || range[1] < range[0] || range[2] < 1L) {
            throw new IllegalArgumentException("Input range does not conform with AxisDefintion range");
        }
        int length = 1 + (int)((range[1] - range[0]) / range[2]);
        long logicalOrigin = this._logicalOrigin + this._logicalDelta * range[0];
        long logicalDelta = range[2] * this._logicalDelta;
        double physicalOrigin = this._physicalOrigin + this._physicalDelta * (double)range[0];
        double physicalDelta = (double)range[2] * this._physicalDelta;
        return new AxisDefinition(this._label, this._units, this._domain, length, logicalOrigin, logicalDelta, physicalOrigin, physicalDelta);
    }

    public AxisLabel getLabel() {
        return this._label;
    }

    public Units getUnits() {
        return this._units;
    }

    public DataDomain getDomain() {
        return this._domain;
    }

    public long getLength() {
        return this._length;
    }

    public long getLogicalOrigin() {
        return this._logicalOrigin;
    }

    public long getLogicalDelta() {
        return this._logicalDelta;
    }

    public double getPhysicalOrigin() {
        return this._physicalOrigin;
    }

    public double getPhysicalDelta() {
        return this._physicalDelta;
    }
}

