/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel.test;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javaseis.parallel.IParallelContext;

public class PTestbcast {
    private final IParallelContext _pc;

    public PTestbcast(IParallelContext pc) {
        this._pc = pc;
    }

    public void runTests() {
        this.testbcastSimple();
        this.testbcastScalars();
    }

    private void testbcastSimple() {
        byte defaltValue = (byte)this._pc.rank();
        if (this._pc.isMaster()) {
            defaltValue = 127;
        }
        List<Object> inputData = PTestbcast.getInput(this._pc.size(), defaltValue);
        for (int i = 0; i < inputData.size(); ++i) {
            Object input = inputData.get(i);
            this._pc.masterPrint("Input component type = " + input.getClass().getComponentType());
            Object result = this._pc.bcast(input, 0);
            this._pc.masterPrint("Ouput component type = " + result.getClass().getComponentType());
            int len = Array.getLength(result);
            if (len != this._pc.size()) {
                throw new IllegalArgumentException("return len is incorrect");
            }
            for (int j = 0; j < len; ++j) {
                Number a = (Number)Array.get(result, j);
                if (a.byteValue() == 127) continue;
                throw new IllegalArgumentException("return value at index " + j + " is incorrect");
            }
        }
    }

    private void testbcastScalars() {
        Byte input;
        byte bOut;
        byte defaltValue = (byte)this._pc.rank();
        if (this._pc.isMaster()) {
            defaltValue = 127;
        }
        if ((bOut = this._pc.bcast(Byte.valueOf(input = new Byte(defaltValue)), 0).byteValue()) != 127) {
            throw new RuntimeException();
        }
        short sOut = this._pc.bcast(input.shortValue(), 0);
        if (sOut != 127) {
            throw new RuntimeException();
        }
        int iOut = this._pc.bcast(input.intValue(), 0);
        if (iOut != 127) {
            throw new RuntimeException();
        }
        long lOut = this._pc.bcast(input.longValue(), 0);
        if (lOut != 127L) {
            throw new RuntimeException();
        }
        float fOut = this._pc.bcast(Float.valueOf(input.floatValue()), 0).floatValue();
        if (fOut != 127.0f) {
            throw new RuntimeException();
        }
        double dOut = this._pc.bcast(input.doubleValue(), 0);
        if (dOut != 127.0) {
            throw new RuntimeException();
        }
        Long oOut = this._pc.bcast(new Long(input.longValue()), 0);
        if (oOut != 127L) {
            throw new RuntimeException();
        }
    }

    private static List<Object> getInput(int len, byte defaultValue) {
        ArrayList<Object> data = new ArrayList<Object>();
        byte[] b = new byte[len];
        Arrays.fill(b, defaultValue);
        data.add(b);
        short[] s = new short[len];
        Arrays.fill(s, (short)defaultValue);
        data.add(s);
        int[] i = new int[len];
        Arrays.fill(i, (int)defaultValue);
        data.add(i);
        long[] l = new long[len];
        Arrays.fill(l, (long)defaultValue);
        data.add(l);
        float[] f = new float[len];
        Arrays.fill(f, (float)defaultValue);
        data.add(f);
        double[] d = new double[len];
        Arrays.fill(d, (double)defaultValue);
        data.add(d);
        Integer[] I = new Integer[len];
        for (int j = 0; j < len; ++j) {
            I[j] = new Integer(defaultValue);
        }
        data.add(I);
        return data;
    }
}

