/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import mpi.Datatype;
import mpi.Intracomm;
import mpi.MPI;
import mpi.MPIException;
import mpi.Op;
import mpi.Status;
import org.javaseis.array.ArrayStorage;
import org.javaseis.array.IBackingArray;
import org.javaseis.io.SortMap;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.util.ArrayUtil;

public class MPIContext
implements IParallelContext {
    private int _size = -1;
    private int _rank = -1;
    private int _pmax = 0;
    private Intracomm _intracomm = null;
    private boolean _cleanupMPI = false;
    private static final int MASTER = 0;
    private static final int SHIFT_TAG = 101010;
    private static final int TRANS_TAG = 202020;
    private static final int TREE_TAG = 303030;
    private static final int SUM_TAG = 404040;
    private static Logger _logger = Logger.getLogger("org.javaseis.parallel.MPIContext");

    @Override
    public boolean init(String[] args) {
        boolean bret = false;
        try {
            MPI.Init((String[])args);
            this._cleanupMPI = true;
            Intracomm group = (Intracomm)MPI.COMM_WORLD.clone();
            bret = this.init(group);
        }
        catch (MPIException ex) {
            return bret;
        }
        return bret;
    }

    @Override
    public boolean isMaster() {
        return this._rank == 0;
    }

    @Override
    public boolean failure(boolean test) {
        Boolean[] buf = new Boolean[]{test};
        if (this._rank == 0) {
            buf[0] = test;
        }
        this.bcast(99, buf, 0, 1, 0);
        return buf[0];
    }

    public boolean init(Intracomm commGroup) {
        assert (commGroup != null);
        try {
            this._intracomm = commGroup;
            this._size = this._intracomm.Size();
            this._rank = this._intracomm.Rank();
        }
        catch (MPIException ex) {
            return false;
        }
        this._pmax = 1;
        while (this._pmax < this._size) {
            this._pmax = 2 * this._pmax;
        }
        return true;
    }

    public Intracomm getIntracomm() {
        return this._intracomm;
    }

    @Override
    public void masterPrint(String s) {
        if (this._rank == 0) {
            System.out.println(s);
        }
        System.out.flush();
        this.barrier();
    }

    @Override
    public void serialPrint(String s) {
        System.out.flush();
        this.barrier();
        for (int i = 0; i < this._size; ++i) {
            if (i == this._rank) {
                System.out.println(s);
            }
            System.out.flush();
            this.barrier();
        }
    }

    @Override
    public void masterPrint(Logger log, String s) {
        if (this._rank == 0) {
            log.info(s);
        }
        this.barrier();
    }

    @Override
    public void serialPrint(Logger log, String s) {
        this.barrier();
        for (int i = 0; i < this._size; ++i) {
            if (i == this._rank) {
                log.info(s);
            }
            this.barrier();
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int rank() {
        return this._rank;
    }

    @Override
    public void barrier() {
        try {
            this._intracomm.Barrier();
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public <T> void send(int tag, T buf, int offset, int count, int dest) {
        try {
            this._intracomm.Send(buf, offset, count, MPI.OBJECT, dest, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void sendByte(int tag, byte[] buf, int offset, int count, int dest) {
        try {
            this._intracomm.Send((Object)buf, offset, count, MPI.BYTE, dest, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void sendShort(int tag, short[] buf, int offset, int count, int dest) {
        try {
            this._intracomm.Send((Object)buf, offset, count, MPI.SHORT, dest, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void sendInt(int tag, int[] buf, int offset, int count, int dest) {
        try {
            this._intracomm.Send((Object)buf, offset, count, MPI.INT, dest, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void sendLong(int tag, long[] buf, int offset, int count, int dest) {
        try {
            this._intracomm.Send((Object)buf, offset, count, MPI.LONG, dest, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void sendFloat(int tag, float[] buf, int offset, int count, int dest) {
        try {
            this._intracomm.Send((Object)buf, offset, count, MPI.FLOAT, dest, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void sendDouble(int tag, double[] buf, int offset, int count, int dest) {
        try {
            this._intracomm.Send((Object)buf, offset, count, MPI.DOUBLE, dest, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public <T> void recv(int tag, T buf, int offset, int count) {
        try {
            Status status = this._intracomm.Recv(buf, offset, count, MPI.OBJECT, MPI.ANY_SOURCE, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void recvByte(int tag, byte[] buf, int offset, int count) {
        try {
            Status status = this._intracomm.Recv((Object)buf, offset, count, MPI.BYTE, MPI.ANY_SOURCE, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void recvShort(int tag, short[] buf, int offset, int count) {
        try {
            Status status = this._intracomm.Recv((Object)buf, offset, count, MPI.SHORT, MPI.ANY_SOURCE, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void recvInt(int tag, int[] buf, int offset, int count) {
        try {
            Status status = this._intracomm.Recv((Object)buf, offset, count, MPI.INT, MPI.ANY_SOURCE, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void recvLong(int tag, long[] buf, int offset, int count) {
        try {
            Status status = this._intracomm.Recv((Object)buf, offset, count, MPI.LONG, MPI.ANY_SOURCE, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void recvFloat(int tag, float[] buf, int offset, int count) {
        try {
            Status status = this._intracomm.Recv((Object)buf, offset, count, MPI.FLOAT, MPI.ANY_SOURCE, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void recvDouble(int tag, double[] buf, int offset, int count) {
        try {
            Status status = this._intracomm.Recv((Object)buf, offset, count, MPI.DOUBLE, MPI.ANY_SOURCE, tag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public void sendRecv(Object sendBuf, int sendOffset, int sendCount, int dest, int sendtag, Object recvBuf, int recvOffset, int recvCount, int source, int recvtag) {
        MPIContext.assertIsArray(sendBuf);
        MPIContext.assertIsArray(recvBuf);
        try {
            this._intracomm.Sendrecv(sendBuf, sendOffset, sendCount, MPIContext.getType(sendBuf), dest, sendtag, recvBuf, recvOffset, recvCount, MPIContext.getType(recvBuf), source, recvtag);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public <T> T bcast(T buf, int sender) {
        if (buf.getClass().isArray()) {
            this.bcast(buf, 0, Array.getLength(buf), sender);
        } else {
            Object[] tmpArray = (Object[])Array.newInstance(buf.getClass(), 1);
            tmpArray[0] = buf;
            this.bcast(tmpArray, 0, 1, sender);
            buf = tmpArray[0];
        }
        return buf;
    }

    private void bcast(Object buf, int offset, int count, int sender) {
        MPIContext.assertIsArray(buf);
        MPIContext.assertIsNotZeroLength(buf);
        try {
            this._intracomm.Bcast(buf, offset, count, MPIContext.getType(buf), sender);
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    @Override
    public <T> void bcast(int type, T buf, int offset, int count, int sender) {
        this.bcast(buf, offset, count, sender);
    }

    @Override
    public void bcastByte(int type, byte[] buf, int offset, int count, int sender) {
        this.bcast(buf, offset, count, sender);
    }

    @Override
    public void bcastShort(int type, short[] buf, int offset, int count, int sender) {
        this.bcast(buf, offset, count, sender);
    }

    @Override
    public void bcastInt(int type, int[] buf, int offset, int count, int sender) {
        this.bcast(buf, offset, count, sender);
    }

    @Override
    public void bcastLong(int type, long[] buf, int offset, int count, int sender) {
        this.bcast(buf, offset, count, sender);
    }

    @Override
    public void bcastFloat(int type, float[] buf, int offset, int count, int sender) {
        this.bcast(buf, offset, count, sender);
    }

    @Override
    public void bcastDouble(int type, double[] buf, int offset, int count, int sender) {
        this.bcast(buf, offset, count, sender);
    }

    @Override
    public <T> void shift(int nshift, T a, int offset, int count, T buf) {
        int myswap = (this._rank + nshift) % this._size;
        if (myswap == this._rank) {
            return;
        }
        try {
            if (myswap > this._rank) {
                this._intracomm.Send(a, offset, count, MPI.OBJECT, myswap, 101010 + myswap);
                Status status = this._intracomm.Recv(buf, offset, count, MPI.OBJECT, MPI.ANY_SOURCE, 101010 + this._rank);
            } else {
                Status status = this._intracomm.Recv(buf, offset, count, MPI.OBJECT, MPI.ANY_SOURCE, 101010 + this._rank);
                this._intracomm.Send(a, offset, count, MPI.OBJECT, myswap, 101010 + myswap);
            }
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
        ArrayUtil.arraycopy(buf, 0, a, offset, count);
    }

    public <T> void shiftPrimitive(Datatype type, int nshift, Object a, int offset, int count, Object buf) {
        int myswap = (this._rank + nshift) % this._size;
        if (myswap == this._rank) {
            return;
        }
        try {
            if (myswap > this._rank) {
                this._intracomm.Send(a, offset, count, type, myswap, 101010 + myswap);
                Status status = this._intracomm.Recv(buf, offset, count, type, MPI.ANY_SOURCE, 101010 + this._rank);
            } else {
                Status status = this._intracomm.Recv(buf, offset, count, type, MPI.ANY_SOURCE, 101010 + this._rank);
                this._intracomm.Send(a, offset, count, type, myswap, 101010 + myswap);
            }
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
        ArrayUtil.arraycopy(buf, 0, a, offset, count);
    }

    @Override
    public void shiftByte(int nshift, byte[] a, int offset, int count, byte[] buf) {
        this.shiftPrimitive(MPI.BYTE, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftShort(int nshift, short[] a, int offset, int count, short[] buf) {
        this.shiftPrimitive(MPI.SHORT, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftInt(int nshift, int[] a, int offset, int count, int[] buf) {
        this.shiftPrimitive(MPI.INT, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftLong(int nshift, long[] a, int offset, int count, long[] buf) {
        this.shiftPrimitive(MPI.LONG, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftFloat(int nshift, float[] a, int offset, int count, float[] buf) {
        this.shiftPrimitive(MPI.FLOAT, nshift, a, offset, count, buf);
    }

    @Override
    public void shiftDouble(int nshift, double[] a, int offset, int count, double[] buf) {
        this.shiftPrimitive(MPI.DOUBLE, nshift, a, offset, count, buf);
    }

    @Override
    public <T> void globalSum(T a, int aoffset, T b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.OBJECT, MPI.SUM);
    }

    @Override
    public void globalSumByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.BYTE, MPI.SUM);
    }

    @Override
    public void globalSumShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.SHORT, MPI.SUM);
    }

    @Override
    public void globalSumInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.INT, MPI.SUM);
    }

    @Override
    public void globalSumLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        if (this.isMaster()) {
            long[] buf = new long[count];
            ArrayUtil.arraycopy(a, aoffset, b, boffset, count);
            for (int i = 1; i < this._size; ++i) {
                this.recvLong(404040 + i, buf, 0, count);
                for (int j = 0; j < count; ++j) {
                    b[boffset + j] = b[boffset + j] + buf[j];
                }
            }
        } else {
            this.sendLong(404040 + this._rank, a, aoffset, count, 0);
        }
        this.bcastLong(404040, b, boffset, count, 0);
    }

    @Override
    public void globalSumFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.FLOAT, MPI.SUM);
    }

    @Override
    public void globalSumDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.DOUBLE, MPI.SUM);
    }

    @Override
    public <T> void globalMin(T a, int aoffset, T b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.OBJECT, MPI.MIN);
    }

    @Override
    public void globalMinByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.BYTE, MPI.MIN);
    }

    @Override
    public void globalMinShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.SHORT, MPI.MIN);
    }

    @Override
    public void globalMinInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.INT, MPI.MIN);
    }

    @Override
    public void globalMinLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.LONG, MPI.MIN);
    }

    @Override
    public void globalMinFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.FLOAT, MPI.MIN);
    }

    @Override
    public void globalMinDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.DOUBLE, MPI.MIN);
    }

    @Override
    public <T> void globalMax(T a, int aoffset, T b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.OBJECT, MPI.MAX);
    }

    @Override
    public void globalMaxByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.BYTE, MPI.MAX);
    }

    @Override
    public void globalMaxShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.SHORT, MPI.MAX);
    }

    @Override
    public void globalMaxInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.INT, MPI.MAX);
    }

    @Override
    public void globalMaxLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.LONG, MPI.MAX);
    }

    @Override
    public void globalMaxFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.FLOAT, MPI.MAX);
    }

    @Override
    public void globalMaxDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        this.reducePrimitive(a, aoffset, b, boffset, count, MPI.DOUBLE, MPI.MAX);
    }

    private void reducePrimitive(Object a, int aoffset, Object b, int boffset, int count, Datatype type, Op op) {
        try {
            this._intracomm.Allreduce(a, aoffset, b, boffset, count, type, op);
        }
        catch (MPIException e) {
            throw new RuntimeException("mpiJava Exception: " + e.getMessage());
        }
    }

    @Override
    public <T> void collect(T a, int aoffset, T b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, MPI.OBJECT);
    }

    @Override
    public void collectByte(byte[] a, int aoffset, byte[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, MPI.BYTE);
    }

    @Override
    public void collectShort(short[] a, int aoffset, short[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, MPI.SHORT);
    }

    @Override
    public void collectInt(int[] a, int aoffset, int[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, MPI.INT);
    }

    @Override
    public void collectLong(long[] a, int aoffset, long[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, MPI.LONG);
    }

    @Override
    public void collectFloat(float[] a, int aoffset, float[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, MPI.FLOAT);
    }

    @Override
    public void collectDouble(double[] a, int aoffset, double[] b, int boffset, int count) {
        this.gatherPrimitive(a, aoffset, b, boffset, count, MPI.DOUBLE);
    }

    @Override
    public byte[] collectByte(byte ai) {
        byte[] a = new byte[]{ai};
        byte[] b = new byte[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, MPI.BYTE);
        return b;
    }

    @Override
    public short[] collectShort(short ai) {
        short[] a = new short[]{ai};
        short[] b = new short[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, MPI.SHORT);
        return b;
    }

    @Override
    public int[] collectInt(int ai) {
        int[] a = new int[]{ai};
        int[] b = new int[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, MPI.INT);
        return b;
    }

    @Override
    public long[] collectLong(long ai) {
        long[] a = new long[]{ai};
        long[] b = new long[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, MPI.LONG);
        return b;
    }

    @Override
    public float[] collectFloat(float ai) {
        float[] a = new float[]{ai};
        float[] b = new float[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, MPI.FLOAT);
        return b;
    }

    @Override
    public double[] collectDouble(double ai) {
        double[] a = new double[]{ai};
        double[] b = new double[this._size];
        this.gatherPrimitive(a, 0, b, 0, 1, MPI.DOUBLE);
        return b;
    }

    private void gatherPrimitive(Object a, int aoffset, Object b, int boffset, int count, Datatype type) {
        try {
            this._intracomm.Allgather(a, aoffset, count, type, b, boffset, count, type);
        }
        catch (MPIException e) {
            throw new RuntimeException("mpiJava Exception: " + e.getMessage());
        }
    }

    @Override
    public void ttran(int tileSize, IBackingArray b) {
        int offset = (int)b.getOffset();
        Object a = ((ArrayStorage)b).getArray();
        Class<?> componentType = a.getClass().getComponentType();
        if (componentType.equals(Byte.TYPE)) {
            Datatype type = MPI.BYTE;
            byte[] buf = new byte[tileSize];
            this.ttranPrimitive(type, tileSize, a, offset, buf);
        } else if (componentType.equals(Short.TYPE)) {
            Datatype type = MPI.SHORT;
            short[] buf = new short[tileSize];
            this.ttranPrimitive(type, tileSize, a, offset, buf);
        } else if (componentType.equals(Integer.TYPE)) {
            Datatype type = MPI.INT;
            int[] buf = new int[tileSize];
            this.ttranPrimitive(type, tileSize, a, offset, buf);
        } else if (componentType.equals(Long.TYPE)) {
            Datatype type = MPI.LONG;
            long[] buf = new long[tileSize];
            this.ttranPrimitive(type, tileSize, a, offset, buf);
        } else if (componentType.equals(Float.TYPE)) {
            Datatype type = MPI.FLOAT;
            float[] buf = new float[tileSize];
            this.ttranPrimitive(type, tileSize, a, offset, buf);
        } else if (componentType.equals(Double.TYPE)) {
            Datatype type = MPI.DOUBLE;
            double[] buf = new double[tileSize];
            this.ttranPrimitive(type, tileSize, a, offset, buf);
        } else {
            Datatype type = MPI.OBJECT;
            byte[] buf = new byte[tileSize];
            this.ttranPrimitive(type, tileSize, a, offset, buf);
        }
    }

    @Override
    public <T> void ttran(int tileSize, T a, int startOffset, T buf) {
        if (this._size <= 1) {
            return;
        }
        int offset = startOffset;
        for (int i = 1; i < this._pmax; ++i) {
            int myswap;
            if (this._rank == 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine("Transposing tile " + i + " of " + (this._pmax - 1));
            }
            if ((myswap = this._rank ^ i) >= this._size) continue;
            offset = tileSize * myswap;
            try {
                Status status;
                if (myswap > this._rank) {
                    this._intracomm.Send(a, offset, tileSize, MPI.OBJECT, myswap, 202020 + i);
                    status = this._intracomm.Recv(buf, 0, tileSize, MPI.OBJECT, MPI.ANY_SOURCE, 202020 + i);
                } else {
                    status = this._intracomm.Recv(buf, 0, tileSize, MPI.OBJECT, MPI.ANY_SOURCE, 202020 + i);
                    this._intracomm.Send(a, offset, tileSize, MPI.OBJECT, myswap, 202020 + i);
                }
            }
            catch (MPIException ex) {
                throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
            }
            ArrayUtil.arraycopy(buf, 0, a, offset, tileSize);
        }
    }

    private void ttranPrimitive(Datatype type, int tileSize, Object a, int startOffset, Object buf) {
        if (this._size <= 1) {
            return;
        }
        int offset = startOffset;
        for (int i = 1; i < this._pmax; ++i) {
            int myswap;
            if (this._rank == 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine("Transposing tile " + i + " of " + (this._pmax - 1));
            }
            if ((myswap = this._rank ^ i) >= this._size) continue;
            offset = tileSize * myswap;
            try {
                Status status;
                if (myswap > this._rank) {
                    this._intracomm.Send(a, offset, tileSize, type, myswap, 202020 + i);
                    status = this._intracomm.Recv(buf, 0, tileSize, type, MPI.ANY_SOURCE, 202020 + i);
                } else {
                    status = this._intracomm.Recv(buf, 0, tileSize, type, MPI.ANY_SOURCE, 202020 + i);
                    this._intracomm.Send(a, offset, tileSize, type, myswap, 202020 + i);
                }
            }
            catch (MPIException ex) {
                throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
            }
            ArrayUtil.arraycopy(buf, 0, a, offset, tileSize);
        }
    }

    @Override
    public void ttranByte(int tileSize, byte[] a, int offset, byte[] buf) {
        this.ttranPrimitive(MPI.BYTE, tileSize, a, offset, buf);
    }

    @Override
    public void ttranShort(int tileSize, short[] a, int offset, short[] buf) {
        this.ttranPrimitive(MPI.SHORT, tileSize, a, offset, buf);
    }

    @Override
    public void ttranInt(int tileSize, int[] a, int offset, int[] buf) {
        this.ttranPrimitive(MPI.INT, tileSize, a, offset, buf);
    }

    @Override
    public void ttranLong(int tileSize, long[] a, int offset, long[] buf) {
        this.ttranPrimitive(MPI.LONG, tileSize, a, offset, buf);
    }

    @Override
    public void ttranFloat(int tileSize, float[] a, int offset, float[] buf) {
        this.ttranPrimitive(MPI.FLOAT, tileSize, a, offset, buf);
    }

    @Override
    public void ttranDouble(int tileSize, double[] a, int offset, double[] buf) {
        this.ttranPrimitive(MPI.DOUBLE, tileSize, a, offset, buf);
    }

    @Override
    public <T> void ttranv(int[] lena, int[] aoffset, T[] a, int[] lenb, int[] boffset, T[] b) {
        if (this._size <= 1) {
            return;
        }
        ArrayUtil.arraycopy(a, aoffset[this._rank], b, boffset[this._rank], lena[this._rank]);
        for (int i = 1; i < this._pmax; ++i) {
            int j;
            if (this._rank == 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine("Transposing tile " + i + " of " + (this._pmax - 1));
            }
            if ((j = this._rank ^ i) >= this._size) continue;
            try {
                if (j > this._rank) {
                    if (lena[j] > 0) {
                        this._intracomm.Send(a, aoffset[j], lena[j], MPI.OBJECT, j, 202020 + i);
                    }
                    if (lenb[j] <= 0) continue;
                    Status status = this._intracomm.Recv(b, boffset[j], lenb[j], MPI.OBJECT, MPI.ANY_SOURCE, 202020 + i);
                    continue;
                }
                if (lenb[j] > 0) {
                    Status status = this._intracomm.Recv(b, boffset[j], lenb[j], MPI.OBJECT, MPI.ANY_SOURCE, 202020 + i);
                }
                if (lena[j] <= 0) continue;
                this._intracomm.Send(a, aoffset[j], lena[j], MPI.OBJECT, j, 202020 + i);
                continue;
            }
            catch (MPIException ex) {
                throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
            }
        }
    }

    @Override
    public void ttranvInit(int[] lena, int[] aoffset, int[] lenb, int[] boffset) {
        int[] buf = new int[1];
        ArrayUtil.arraycopy(lena, 0, lenb, 0, this._size);
        this.ttranInt(1, lenb, 0, buf);
        boffset[0] = 0;
        for (int i = 1; i < this._size; ++i) {
            boffset[i] = boffset[i - 1] + lenb[i - 1];
        }
    }

    public <T> void binaryTree(int len, T buf, int startOffset) {
        if (this._size <= 1) {
            return;
        }
        if (this._size % 2 != 0) {
            return;
        }
        int j2 = this._pmax;
        for (int i = 0; i < this._pmax; ++i) {
            int k2 = j2 / 2;
            if (this._rank % j2 == 0) {
                int target = this._rank + k2;
                if (target < this._size) {
                    this.send(303030, buf, startOffset, len, target);
                }
            } else if (this._rank % k2 == 0) {
                int source = this._rank - k2;
                this.recv(303030, buf, startOffset, len);
            }
            j2 = k2;
        }
    }

    @Override
    public void finish() {
        try {
            this._intracomm.Free();
            if (this._cleanupMPI) {
                MPI.Finalize();
            }
        }
        catch (MPIException ex) {
            throw new RuntimeException("mpiJava Exception: " + ex.getMessage());
        }
    }

    public static void main(String[] args) throws MPIException {
        int i;
        int i2;
        MPIContext pc = new MPIContext();
        pc.init(args);
        int rank = pc.rank();
        int size = pc.size();
        String className = pc.getClass().toString();
        pc.masterPrint(className);
        pc.masterPrint("MPI Tests");
        pc.serialPrint(MPI.Get_processor_name() + " Task " + rank);
        int bufsize = 1024;
        int count = 10;
        int[] buf = new int[bufsize];
        if (buf == null) {
            throw new MPIException("Could not allocate memory");
        }
        for (int j = 0; j < count; ++j) {
            int i3;
            if (rank == 0) {
                for (i3 = 0; i3 < bufsize; ++i3) {
                    buf[i3] = i3;
                }
            } else {
                for (i3 = 0; i3 < bufsize; ++i3) {
                    buf[i3] = 0;
                }
            }
            pc.bcastInt(99, buf, 0, bufsize, 0);
            for (i3 = 0; i3 < bufsize; ++i3) {
                if (buf[i3] == i3) continue;
                throw new MPIException("bcast failed");
            }
        }
        pc.masterPrint(className + ".bcast succeeded");
        float[] fbuf = new float[size];
        float[] farray = new float[size];
        for (int j = 0; j < size; ++j) {
            for (int i4 = 0; i4 < size; ++i4) {
                farray[i4] = rank;
            }
            pc.shiftFloat(j, farray, 0, size, fbuf);
            float fval = (size + rank - j) % size;
            for (i2 = 0; i2 < size; ++i2) {
                if (farray[i2] == fval) continue;
                throw new MPIException("shift failed");
            }
            pc.barrier();
        }
        pc.masterPrint(className + ".shift succeeded");
        float[] fa = new float[size];
        float[] fb = new float[size];
        for (i2 = 0; i2 < size; ++i2) {
            fa[i2] = i2 + rank;
            fb[i2] = 0.0f;
        }
        pc.globalMaxFloat(fa, 0, fb, 0, size);
        for (i2 = 0; i2 < size; ++i2) {
            if (fb[i2] == (float)(i2 + size - 1)) continue;
            throw new MPIException("globalMaxFloat failed");
        }
        Arrays.fill(fb, 0.0f);
        pc.globalMinFloat(fa, 0, fb, 0, size);
        for (i2 = 0; i2 < size; ++i2) {
            if (fb[i2] == (float)i2) continue;
            throw new MPIException("globalMinFloat failed");
        }
        pc.masterPrint(className + ".globalMinMax succeeded");
        int[] ia = new int[size];
        int[] ib = new int[size * size];
        for (int i5 = 0; i5 < size; ++i5) {
            ia[i5] = rank * size + i5;
        }
        pc.collectInt(ia, 0, ib, 0, size);
        for (int j = 0; j < size; ++j) {
            for (int i6 = 0; i6 < size; ++i6) {
                int k = size * i6 + j;
                if (ib[k] == k) continue;
                throw new MPIException("collect failed");
            }
        }
        pc.masterPrint(className + ".collect succeeded");
        long[] larray = new long[size];
        long[] lbuf = new long[size];
        for (i = 0; i < size; ++i) {
            larray[i] = i;
        }
        pc.ttranLong(1, larray, 0, lbuf);
        for (i = 0; i < size; ++i) {
            if (larray[i] == (long)rank) continue;
            throw new MPIException("transpose failed");
        }
        pc.masterPrint(className + ".ttran succeeded");
        int[] na = new int[size];
        int[] nb = new int[size];
        int[] oa = new int[size];
        int[] ob = new int[size];
        na[0] = size;
        oa[0] = 0;
        int lena = size;
        for (int i7 = 1; i7 < size; ++i7) {
            na[i7] = size + i7;
            oa[i7] = lena;
            lena += na[i7];
        }
        SortMap[] a = new SortMap[lena];
        SortMap[] b = new SortMap[lena];
        for (int j = 0; j < size; ++j) {
            for (int i8 = 0; i8 < na[j]; ++i8) {
                a[oa[j] + i8] = new SortMap(i8, j, i8 + j);
            }
        }
        pc.ttranv(na, oa, a, nb, ob, b);
        SortMap tmp = new SortMap();
        for (int j = 0; j < size; ++j) {
            for (int i9 = 0; i9 < nb[j]; ++i9) {
                tmp = b[ob[j] + i9];
                if (tmp.trc == (long)(rank + i9)) continue;
                throw new MPIException("ttranv failed");
            }
        }
        pc.masterPrint(className + ".ttranv succeeded");
        pc.finish();
    }

    @Override
    public void ttranIncremental(Serializable[] a, Serializable[] buf, IParallelContext.TileProcesssor tp) {
        if (this._size <= 1) {
            return;
        }
        if (a.length != this._size) {
            throw new IllegalArgumentException("Input array 'a' is required to have the same length as the number of tasks");
        }
        if (buf == null || buf.length != 1) {
            throw new IllegalArgumentException("buf must be an array of the same type as 'a' and have space for one element");
        }
        int tileSize = 1;
        Datatype type = MPI.OBJECT;
        int offset = 0;
        for (int i = 1; i < this._pmax; ++i) {
            int myswap = this._rank ^ i;
            if (myswap >= this._size) continue;
            offset = tileSize * myswap;
            try {
                if (myswap > this._rank) {
                    this._intracomm.Send((Object)a, offset, tileSize, type, myswap, 202020 + i);
                    this._intracomm.Recv((Object)buf, 0, tileSize, type, MPI.ANY_SOURCE, 202020 + i);
                } else {
                    this._intracomm.Recv((Object)buf, 0, tileSize, type, MPI.ANY_SOURCE, 202020 + i);
                    this._intracomm.Send((Object)a, offset, tileSize, type, myswap, 202020 + i);
                }
            }
            catch (MPIException ex) {
                throw new RuntimeException("mpiJava Exception: ", ex);
            }
            tp.processTile(offset, buf[0]);
        }
    }

    private static int getDimensions(Object a) {
        int dim = 0;
        if (!a.getClass().isArray()) {
            return 0;
        }
        char[] name = a.getClass().getName().toCharArray();
        int i = 0;
        while (name[i++] == '[') {
            ++dim;
        }
        return dim;
    }

    private static Datatype getType(Object o) {
        int sendDim = MPIContext.getDimensions(o);
        if (sendDim > 1) {
            return MPI.OBJECT;
        }
        Class<?> type = o.getClass().getComponentType();
        if (type == Byte.TYPE) {
            return MPI.BYTE;
        }
        if (type == Short.TYPE) {
            return MPI.SHORT;
        }
        if (type == Integer.TYPE) {
            return MPI.INT;
        }
        if (type == Long.TYPE) {
            return MPI.LONG;
        }
        if (type == Float.TYPE) {
            return MPI.FLOAT;
        }
        if (type == Double.TYPE) {
            return MPI.DOUBLE;
        }
        return MPI.OBJECT;
    }

    private static void assertIsArray(Object buf) throws IllegalArgumentException {
        if (!buf.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array");
        }
    }

    private static void assertIsNotZeroLength(Object buf) throws IllegalArgumentException {
        int len = Array.getLength(buf);
        if (len == 0) {
            throw new IllegalArgumentException("Array length of Object is 0");
        }
    }
}

