/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayIterator;

public class DistributedArrayFrameIterator<E>
implements DistributedArrayIterator<E> {
    private static final boolean c_tolerateFrameOutOfBounds = false;
    private static final Logger LOG = Logger.getLogger("org.javaseis.parallel");
    private DistributedArray _distributedArray;
    private E _traces;
    private int[] _framePosition;
    private int _ndim;
    private int _nHypercubes;
    private int _nVolumes;
    private int _nFrames;
    private int _hypercubeIndex = 0;
    private int _volumeIndex = 0;
    private int _frameIndex = 0;

    public DistributedArrayFrameIterator(DistributedArray distributedArray, E traces) {
        this(distributedArray, distributedArray.getShape()[2], traces);
    }

    public DistributedArrayFrameIterator(DistributedArray distributedArray, int activeFrameCount, E traces) {
        if (distributedArray == null) {
            throw new IllegalArgumentException("distributedArray is null");
        }
        if (traces == null) {
            throw new IllegalArgumentException("traces is null");
        }
        this._distributedArray = distributedArray;
        this._traces = traces;
        this.init(distributedArray, activeFrameCount);
    }

    private void init(DistributedArray distributedArray, int activeFrameCount) {
        int localLength;
        this._ndim = distributedArray.getDimensions();
        this._nHypercubes = 1;
        if (this._ndim > 4) {
            this._nHypercubes = distributedArray.getLocalLength(4);
        }
        this._nVolumes = 1;
        if (this._ndim > 3) {
            this._nVolumes = distributedArray.getLocalLength(3);
        }
        int rank = distributedArray.getParallelContext().rank();
        int size = distributedArray.getParallelContext().size();
        this._nFrames = localLength = distributedArray.getLocalLength(2);
        if (this._nFrames > 0) {
            int nFramesGlobalPadding = distributedArray.getShape()[2] - activeFrameCount;
            int nTasksInvolved = nFramesGlobalPadding / localLength;
            int testRank = size - nTasksInvolved;
            if (rank >= testRank) {
                this._nFrames = 0;
            } else if (rank >= testRank - 1) {
                this._nFrames = (nTasksInvolved + 1) * localLength - nFramesGlobalPadding;
            }
        }
        LOG.fine("DistributedArrayFrameIterator rank = " + rank + " size = " + size + " localShape = " + Arrays.toString(distributedArray.getLocalShape()));
        LOG.fine("DistributedArrayFrameIterator nHyperCubes = " + this._nHypercubes + " nVolumes = " + this._nVolumes + " nFrames = " + this._nFrames);
        int nDimensions = this._distributedArray.getDimensions();
        this._framePosition = new int[nDimensions];
    }

    @Override
    public boolean hasNext() {
        if (this._nFrames <= 0) {
            return false;
        }
        if (this._volumeIndex >= this._nVolumes) {
            return false;
        }
        return this._hypercubeIndex < this._nHypercubes;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Attempt to use next() after hasNext() returns false");
        }
        RuntimeException re = null;
        try {
            this.getData();
        }
        catch (RuntimeException e) {
            re = e;
        }
        ++this._frameIndex;
        if (this._frameIndex >= this._nFrames) {
            this._frameIndex = 0;
            ++this._volumeIndex;
        }
        if (this._volumeIndex >= this._nVolumes) {
            this._frameIndex = 0;
            this._volumeIndex = 0;
            ++this._hypercubeIndex;
        }
        if (re != null) {
            throw re;
        }
        return this._traces;
    }

    private void getData() throws RuntimeException {
        block7: {
            if (this._ndim > 4) {
                this._framePosition[4] = this._distributedArray.localToGlobal(4, this._hypercubeIndex);
            }
            if (this._ndim > 3) {
                this._framePosition[3] = this._distributedArray.localToGlobal(3, this._volumeIndex);
            }
            this._framePosition[2] = this._distributedArray.localToGlobal(2, this._frameIndex);
            this._framePosition[0] = 0;
            try {
                if (this._traces instanceof float[][]) {
                    this._distributedArray.getFrame((float[][])this._traces, this._framePosition);
                    break block7;
                }
                if (this._traces instanceof double[][]) {
                    this._distributedArray.getFrame((double[][])this._traces, this._framePosition);
                    break block7;
                }
                if (this._traces instanceof int[][]) {
                    this._distributedArray.getFrame((int[][])this._traces, this._framePosition);
                    break block7;
                }
                throw new RuntimeException("Data type not recognized");
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.handleFrameOutOfBounds(this._framePosition, this._distributedArray);
            }
        }
    }

    @Override
    public int[] getPosition() {
        return this._framePosition;
    }

    public void putData(E traces) throws RuntimeException {
        block5: {
            try {
                if (traces instanceof float[][]) {
                    this._distributedArray.putFrame((float[][])traces, this._framePosition);
                    break block5;
                }
                if (traces instanceof double[][]) {
                    this._distributedArray.putFrame((double[][])traces, this._framePosition);
                    break block5;
                }
                if (traces instanceof int[][]) {
                    this._distributedArray.putFrame((int[][])traces, this._framePosition);
                    break block5;
                }
                throw new RuntimeException("Data type not recognized");
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.handleFrameOutOfBounds(this._framePosition, this._distributedArray);
            }
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Optional method Iterator.remove() is not implemented");
    }

    private void handleFrameOutOfBounds(int[] framePosition, DistributedArray distributedArray) throws RuntimeException {
        if (LOG.isLoggable(Level.FINE)) {
            distributedArray.printContents();
        }
        String s = "";
        for (int i = 0; i < framePosition.length; ++i) {
            s = s + " " + framePosition[i];
        }
        throw new RuntimeException("Out-of-bounds frame encountered at frame position " + s);
    }

    @Override
    public void reset() {
        this.init(this._distributedArray, this._distributedArray.getShape()[2]);
    }
}

