/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.javaseis.io.BufferedVirtualIO;
import org.javaseis.io.VirtualFolders;
import org.javaseis.io.VirtualIO;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.SeisException;

public class JTestBufferedVirtualIO
extends TestCase {
    private static final Logger LOG = Logger.getLogger(JTestBufferedVirtualIO.class.getName());

    public void testSimpleTest1() throws SeisException {
        int cache = 8;
        int blockSize = 0;
        int frameSize = 2;
        int nframes = 4;
        int gapCount = 0;
        long[] stats = new JTestBufferedVirtualIO().doWrite("t1", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 4L);
    }

    public void testSimpleTest2() throws SeisException {
        int cache = 12;
        int blockSize = 0;
        int frameSize = 2;
        int nframes = 4;
        int gapCount = 0;
        long[] stats = new JTestBufferedVirtualIO().doWrite("t2", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 4L);
    }

    public void testSimpleTest3() throws SeisException {
        int cache = 16;
        int blockSize = 0;
        int frameSize = 2;
        int nframes = 4;
        int gapCount = 0;
        long[] stats = new JTestBufferedVirtualIO().doWrite("t3", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 2L);
    }

    public void testGapTest1() throws SeisException {
        int cache = 64;
        int blockSize = 32;
        int frameSize = 4;
        int nframes = 4;
        int gapCount = 1;
        long[] stats = new JTestBufferedVirtualIO().doWrite("gt1", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 1L);
    }

    public void testGapTest2() throws SeisException {
        int cache = 12;
        int blockSize = 32;
        int frameSize = 3;
        int nframes = 4;
        int gapCount = 1;
        long[] stats = new JTestBufferedVirtualIO().doWrite("gt2", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 4L);
    }

    public void testGapTest3() throws SeisException {
        int cache = 20;
        int blockSize = 32;
        int frameSize = 2;
        int nframes = 4;
        int gapCount = 1;
        long[] stats = new JTestBufferedVirtualIO().doWrite("gt3", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 2L);
    }

    public void gapTest4() throws SeisException {
        int cache = 64;
        int blockSize = 0;
        int frameSize = 4;
        int nframes = 4;
        int gapCount = 1;
        long[] stats = new JTestBufferedVirtualIO().doWrite("gt4", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 4L);
    }

    public void gapTest5() throws SeisException {
        int cache = 12;
        int blockSize = 0;
        int frameSize = 3;
        int nframes = 4;
        int gapCount = 1;
        long[] stats = new JTestBufferedVirtualIO().doWrite("gt5", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 4L);
    }

    public void gapTest6() throws SeisException {
        int cache = 20;
        int blockSize = 0;
        int frameSize = 2;
        int nframes = 4;
        int gapCount = 1;
        long[] stats = new JTestBufferedVirtualIO().doWrite("gt6", cache, blockSize, frameSize, nframes, gapCount);
        assert (stats[0] == 4L);
        assert (stats[1] == 4L);
    }

    public long[] doWrite(String name, int cache, int blockSize, int frameSize, int count, int underWrite) throws SeisException {
        File l;
        int bufSize = 4 * frameSize;
        long fileLength = bufSize * count;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("VirtualIO file name = " + name + "\n");
        strBuf.append("Buffer cache = " + cache + " bytes\n");
        strBuf.append("Size of block = " + blockSize + " bytes\n");
        strBuf.append("Count of int's in frame = " + frameSize + "\n");
        strBuf.append("Frame size = " + bufSize + " bytes\n");
        strBuf.append("Count of frames to write = " + count + "\n");
        strBuf.append("GapSize (number of int's) = " + underWrite + "\n");
        strBuf.append("File length = " + fileLength + "\n");
        LOG.info(strBuf.toString());
        String baseDir = TestUtil.getDatasetPath(name);
        VirtualFolders vFolders = TestUtil.getVirtualFolders(baseDir);
        String path = baseDir + File.separator + name + ".xml";
        String lock = baseDir + File.separator + name + ".xml.lok";
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        if ((l = new File(lock)).exists()) {
            l.delete();
        }
        int numExtents = 1;
        VirtualIO vio = new VirtualIO(path, name, vFolders, fileLength, numExtents, frameSize);
        vio.close();
        vio = null;
        System.gc();
        vio = new BufferedVirtualIO(path, "rw", vFolders, cache, blockSize);
        ByteBuffer buf = ByteBuffer.allocateDirect(bufSize);
        IntBuffer ibuf = buf.asIntBuffer();
        int[] ival = new int[frameSize];
        long position = 0L;
        vio.trackTime(true);
        for (int i = 0; i < count; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(position);
            Arrays.fill(ival, i);
            ibuf.put(ival);
            int limit = buf.limit() - underWrite * 4;
            buf.limit(limit);
            int bytes = vio.write(buf);
            assert (bytes == limit);
            position += (long)bufSize;
        }
        vio.close();
        long[] stats = ((BufferedVirtualIO)vio).getWriteStats();
        LOG.info("writes = " + stats[0] + " actual disk writes = " + stats[1] + " gaps filled = " + stats[2] + " gaps larger than a single block = " + stats[3]);
        vio = null;
        System.gc();
        vio = new VirtualIO(path, "r", vFolders);
        vio.trackTime(true);
        position = 0L;
        for (int i = 0; i < count; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(position);
            vio.read(buf);
            ibuf.get(ival);
            for (int j = 0; j < frameSize - underWrite; ++j) {
                assert (ival[j] == i) : "VirtualIO Read Verification Failed";
            }
            position += (long)bufSize;
        }
        vio.close();
        assert (vio.delete());
        LOG.info("*** " + vio.getClass().toString() + " Success ***");
        return stats;
    }

    public static void main(String[] args) throws SeisException {
        new JTestBufferedVirtualIO().testSimpleTest1();
        new JTestBufferedVirtualIO().testSimpleTest2();
        new JTestBufferedVirtualIO().testSimpleTest3();
        new JTestBufferedVirtualIO().testGapTest1();
        new JTestBufferedVirtualIO().testGapTest2();
        new JTestBufferedVirtualIO().testGapTest3();
    }
}

