/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.grid;

import java.io.Serializable;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataDomain;
import org.javaseis.properties.Units;

public class GridDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SAMPLE_INDEX = 0;
    public static final int TRACE_INDEX = 1;
    public static final int FRAME_INDEX = 2;
    public static final int VOLUME_INDEX = 3;
    public static final int HYPERCUBE_INDEX = 4;
    public static final int SHOT = 0;
    public static final int CDP = 1;
    public static final int OFFSET = 2;
    public static final int VOLUME = 3;
    protected int _numDimensions;
    protected AxisDefinition[] _axis;

    public static GridDefinition standardGrid(int type, int[] lengths, long[] logicalOrigins, long[] logicalDeltas, double[] origins, double[] deltas) {
        if (lengths.length < 4 || logicalOrigins.length < 4 || logicalDeltas.length < 4 || deltas.length < 4 || origins.length < 4) {
            return null;
        }
        AxisDefinition[] axes = new AxisDefinition[4];
        if (type == 1) {
            axes[0] = new AxisDefinition(AxisLabel.TIME, Units.MS, DataDomain.TIME, lengths[0], logicalOrigins[0], logicalDeltas[0], origins[0], deltas[0]);
            axes[1] = new AxisDefinition(AxisLabel.OFFSET, Units.M, DataDomain.SPACE, lengths[1], logicalOrigins[1], logicalDeltas[1], origins[1], deltas[1]);
            axes[2] = new AxisDefinition(AxisLabel.CROSSLINE, Units.M, DataDomain.SPACE, lengths[2], logicalOrigins[2], logicalDeltas[2], origins[2], deltas[2]);
            axes[3] = new AxisDefinition(AxisLabel.INLINE, Units.M, DataDomain.SPACE, lengths[3], logicalOrigins[3], logicalDeltas[3], origins[3], deltas[3]);
        } else if (type == 0) {
            axes[0] = new AxisDefinition(AxisLabel.TIME, Units.MS, DataDomain.TIME, lengths[0], logicalOrigins[0], logicalDeltas[0], origins[0], deltas[0]);
            axes[1] = new AxisDefinition(AxisLabel.CHANNEL, Units.M, DataDomain.SPACE, lengths[1], logicalOrigins[1], logicalDeltas[1], origins[1], deltas[1]);
            axes[2] = new AxisDefinition(AxisLabel.SOURCE, Units.M, DataDomain.SPACE, lengths[2], logicalOrigins[2], logicalDeltas[2], origins[2], deltas[2]);
            axes[3] = new AxisDefinition(AxisLabel.SAIL_LINE, Units.M, DataDomain.SPACE, lengths[3], logicalOrigins[3], logicalDeltas[3], origins[3], deltas[3]);
        } else if (type == 2) {
            axes[0] = new AxisDefinition(AxisLabel.TIME, Units.MS, DataDomain.TIME, lengths[0], logicalOrigins[0], logicalDeltas[0], origins[0], deltas[0]);
            axes[1] = new AxisDefinition(AxisLabel.CROSSLINE, Units.M, DataDomain.SPACE, lengths[1], logicalOrigins[1], logicalDeltas[1], origins[1], deltas[1]);
            axes[2] = new AxisDefinition(AxisLabel.INLINE, Units.M, DataDomain.SPACE, lengths[2], logicalOrigins[2], logicalDeltas[2], origins[2], deltas[2]);
            axes[3] = new AxisDefinition(AxisLabel.OFFSET_BIN, Units.M, DataDomain.SPACE, lengths[3], logicalOrigins[3], logicalDeltas[3], origins[3], deltas[3]);
        } else if (type == 3) {
            axes[0] = new AxisDefinition(AxisLabel.TIME, Units.MS, DataDomain.TIME, lengths[0], logicalOrigins[0], logicalDeltas[0], origins[0], deltas[0]);
            axes[1] = new AxisDefinition(AxisLabel.CROSSLINE, Units.M, DataDomain.SPACE, lengths[1], logicalOrigins[1], logicalDeltas[1], origins[1], deltas[1]);
            axes[2] = new AxisDefinition(AxisLabel.INLINE, Units.M, DataDomain.SPACE, lengths[2], logicalOrigins[2], logicalDeltas[2], origins[2], deltas[2]);
            axes[3] = new AxisDefinition(AxisLabel.VOLUME, Units.UNKNOWN, DataDomain.UNKNOWN, lengths[3], logicalOrigins[3], logicalDeltas[3], origins[3], deltas[3]);
        } else {
            return null;
        }
        return new GridDefinition(4, axes);
    }

    public GridDefinition(int numDimensions, AxisDefinition[] axis) throws IllegalArgumentException {
        this._numDimensions = numDimensions;
        if (this._numDimensions < 1) {
            throw new IllegalArgumentException("Number of dimensions must be greater than 0.");
        }
        this._axis = axis;
        if (this._axis == null) {
            throw new IllegalArgumentException("No axis definitions specified.");
        }
        if (this._numDimensions != this._axis.length) {
            throw new IllegalArgumentException("Number of dimensions does not match number of axis definitions.");
        }
    }

    public static GridDefinition getDefault(int ndim, int[] idim) {
        return new GridDefinition(ndim, AxisDefinition.getDefault(ndim, idim));
    }

    public int getNumDimensions() {
        return this._numDimensions;
    }

    public AxisDefinition getAxis(int index) {
        return this._axis[index];
    }

    public AxisLabel getAxisLabel(int index) {
        return this._axis[index].getLabel();
    }

    public String getAxisLabelString(int index) {
        return this._axis[index].getLabel().toString();
    }

    public Units getAxisUnits(int index) {
        return this._axis[index].getUnits();
    }

    public String getAxisUnitsString(int index) {
        return this._axis[index].getUnits().toString();
    }

    public DataDomain getAxisDomain(int index) {
        return this._axis[index].getDomain();
    }

    public String getAxisDomainString(int index) {
        return this._axis[index].getDomain().toString();
    }

    public long getAxisLength(int index) {
        return this._axis[index].getLength();
    }

    public long getAxisLogicalOrigin(int index) {
        return this._axis[index].getLogicalOrigin();
    }

    public long getAxisLogicalDelta(int index) {
        return this._axis[index].getLogicalDelta();
    }

    public double getAxisPhysicalOrigin(int index) {
        return this._axis[index].getPhysicalOrigin();
    }

    public double getAxisPhysicalDelta(int index) {
        return this._axis[index].getPhysicalDelta();
    }

    public AxisLabel[] getAxisLabels() {
        AxisLabel[] labels = new AxisLabel[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            labels[index] = this._axis[index].getLabel();
        }
        return labels;
    }

    public String[] getAxisLabelsStrings() {
        String[] labels = new String[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            labels[index] = this._axis[index].getLabel().toString();
        }
        return labels;
    }

    public Units[] getAxisUnits() {
        Units[] units = new Units[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            units[index] = this._axis[index].getUnits();
        }
        return units;
    }

    public String[] getAxisUnitsStrings() {
        String[] units = new String[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            units[index] = this._axis[index].getUnits().toString();
        }
        return units;
    }

    public DataDomain[] getAxisDomains() {
        DataDomain[] domains = new DataDomain[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            domains[index] = this._axis[index].getDomain();
        }
        return domains;
    }

    public String[] getAxisDomainsStrings() {
        String[] domains = new String[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            domains[index] = this._axis[index].getDomain().toString();
        }
        return domains;
    }

    public long[] getAxisLengths() {
        long[] lengths = new long[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            lengths[index] = this._axis[index].getLength();
        }
        return lengths;
    }

    public long[] getAxisLogicalOrigins() {
        long[] logicalOrigins = new long[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            logicalOrigins[index] = this._axis[index].getLogicalOrigin();
        }
        return logicalOrigins;
    }

    public long[] getAxisLogicalDeltas() {
        long[] logicalDeltas = new long[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            logicalDeltas[index] = this._axis[index].getLogicalDelta();
        }
        return logicalDeltas;
    }

    public double[] getAxisPhysicalOrigins() {
        double[] physicalOrigins = new double[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            physicalOrigins[index] = this._axis[index].getPhysicalOrigin();
        }
        return physicalOrigins;
    }

    public double[] getAxisPhysicalDeltas() {
        double[] physicalDeltas = new double[this._numDimensions];
        for (int index = 0; index < this._numDimensions; ++index) {
            physicalDeltas[index] = this._axis[index].getPhysicalDelta();
        }
        return physicalDeltas;
    }

    public long getNumSamplesPerTrace() {
        return this._axis[0].getLength();
    }

    public long getNumTracesPerFrame() {
        return this._axis[1].getLength();
    }

    public long getNumFramesPerVolume() {
        return this._axis[2].getLength();
    }

    public long getNumVolumesPerHypercube() {
        return this._axis[3].getLength();
    }

    public GridDefinition subGrid(int[] dimensionIndices, long[][] dimensionRanges) {
        if (dimensionIndices.length > this._numDimensions) {
            throw new IllegalArgumentException("Requested dimensions exceeds grid size");
        }
        if (dimensionRanges.length < dimensionIndices.length) {
            throw new IllegalArgumentException("Number of ranges does not match number of dimensions");
        }
        int subDims = dimensionIndices.length;
        AxisDefinition[] subAxis = new AxisDefinition[subDims];
        for (int i = 0; i < subDims; ++i) {
            if (dimensionIndices[i] < 0 || dimensionIndices[i] >= this._numDimensions) {
                throw new IllegalArgumentException("Dimension " + i + " = " + dimensionIndices[i] + " is out of range");
            }
            subAxis[i] = this._axis[i].subRange(dimensionRanges[i]);
        }
        return new GridDefinition(subDims, subAxis);
    }

    public GridDefinition subGrid(int[] dimensionIndices) {
        if (dimensionIndices.length > this._numDimensions) {
            throw new IllegalArgumentException("Requested dimensions exceeds grid size");
        }
        int subDims = dimensionIndices.length;
        AxisDefinition[] subAxis = new AxisDefinition[subDims];
        long[] range = new long[3];
        range[0] = 0L;
        range[2] = 1L;
        for (int i = 0; i < subDims; ++i) {
            int j = dimensionIndices[i];
            if (j < 0 || j >= this._numDimensions) {
                throw new IllegalArgumentException("Dimension " + i + " = " + j + " is out of range");
            }
            range[1] = this._axis[j].getLength();
            subAxis[i] = this._axis[j].subRange(range);
        }
        return new GridDefinition(subDims, subAxis);
    }

    public GridDefinition subGrid(int residentDimensions) {
        if (residentDimensions > this._numDimensions) {
            throw new IllegalArgumentException("Requested dimensions exceeds grid size");
        }
        int subDims = residentDimensions;
        AxisDefinition[] subAxis = new AxisDefinition[subDims];
        long[] range = new long[3];
        range[0] = 0L;
        range[2] = 1L;
        for (int i = 0; i < subDims; ++i) {
            range[1] = this._axis[i].getLength();
            subAxis[i] = this._axis[i].subRange(range);
        }
        return new GridDefinition(subDims, subAxis);
    }

    public static String getIndexName(int index) {
        assert (index >= 0);
        assert (index <= 4);
        switch (index) {
            case 0: {
                return "Sample";
            }
            case 1: {
                return "Trace";
            }
            case 2: {
                return "Frame";
            }
            case 3: {
                return "Volume";
            }
            case 4: {
                return "Hypercube";
            }
        }
        return "";
    }
}

