/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.distributed.beta;

import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import org.javaseis.array.beta.ParallelDecomposition;
import org.javaseis.array.beta.PositionIterator;
import org.javaseis.iterators.beta.IPositionIterator;

public class ParallelArrayPositionIterator
implements IPositionIterator<int[]> {
    private static final Logger LOG = Logger.getLogger(ParallelArrayPositionIterator.class.getName());
    private final IPositionIterator<int[]> localPositionIterator;
    private final ParallelDecomposition decomposition;
    private final int[] globalShape;

    public ParallelArrayPositionIterator(ParallelDecomposition decomp, int[] shape) {
        this(decomp, shape, IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.TRACE_AXIS);
    }

    public ParallelArrayPositionIterator(ParallelDecomposition decomp, int[] shape, IPositionIterator.Direction direction, int axisIndex) {
        this.decomposition = decomp;
        this.globalShape = (int[])shape.clone();
        int[] localShape = (int[])shape.clone();
        localShape[localShape.length - 1] = decomp.getElementsPerTask();
        int[] posIn = new int[localShape.length];
        LOG.fine("Constructing ParallelArrayPositionIterator");
        LOG.fine("Decomposition = " + this.decomposition);
        LOG.fine("GlobalShape = " + Arrays.toString(this.globalShape));
        LOG.fine("LocalShape = " + Arrays.toString(localShape));
        this.localPositionIterator = new PositionIterator(localShape, posIn, direction, axisIndex);
    }

    public ParallelArrayPositionIterator(ParallelDecomposition decomp, int[] shape, IPositionIterator.Direction direction, IPositionIterator.Scope scope) {
        this.decomposition = decomp;
        this.globalShape = (int[])shape.clone();
        int[] localShape = (int[])shape.clone();
        localShape[localShape.length - 1] = decomp.getElementsPerTask();
        int[] posIn = new int[localShape.length];
        LOG.fine("Constructing ParallelArrayPositionIterator");
        LOG.fine("Decomposition = " + this.decomposition);
        LOG.fine("GlobalShape = " + Arrays.toString(this.globalShape));
        LOG.fine("LocalShape = " + Arrays.toString(localShape));
        this.localPositionIterator = new PositionIterator(localShape, posIn, direction, scope);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Decomposition = " + this.decomposition + "\n");
        buf.append("GlobalShape = " + Arrays.toString(this.globalShape) + "\n");
        buf.append("Current globalPosition = " + Arrays.toString(this.getPosition()) + "\n");
        buf.append(this.localPositionIterator.toString() + "\n");
        return buf.toString();
    }

    @Override
    public void reset() {
        this.localPositionIterator.reset();
    }

    @Override
    public int[] getPosition() {
        int[] localPosition = this.localPositionIterator.getPosition();
        return this.decomposition.globalPosition(localPosition);
    }

    @Override
    public boolean hasNext() {
        if (!this.localPositionIterator.hasNext()) {
            return false;
        }
        int[] nextPos = (int[])this.localPositionIterator.next();
        this.localPositionIterator.setPosition(nextPos);
        int nLive = this.decomposition.getLiveElements();
        return nextPos[nextPos.length - 1] != nLive;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<int[]> iterator() {
        return new ParallelArrayPositionIterator(this.decomposition, this.getShape(), this.getDirection(), this.getScope());
    }

    @Override
    public IPositionIterator.Direction getDirection() {
        return this.localPositionIterator.getDirection();
    }

    @Override
    public void setDirection(IPositionIterator.Direction direction) {
        this.localPositionIterator.setDirection(direction);
    }

    @Override
    public IPositionIterator.Scope getScope() {
        return this.localPositionIterator.getScope();
    }

    @Override
    public void setScope(IPositionIterator.Scope scope) {
        this.localPositionIterator.setScope(scope);
    }

    @Override
    public void setPosition(int[] position) {
        int[] localPosition = this.decomposition.localPosition(position);
        this.localPositionIterator.setPosition(localPosition);
    }

    @Override
    public int[] next() {
        int[] localPosition = (int[])this.localPositionIterator.next();
        return this.decomposition.globalPosition(localPosition);
    }

    @Override
    public int[] getShape() {
        return (int[])this.globalShape.clone();
    }
}

