/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import junit.framework.Assert;
import org.javaseis.array.beta.DecompositionType;
import org.javaseis.array.beta.ParallelDecomposition;
import org.junit.Test;

public class JTestParallelDecomposition {
    @Test
    public void testBlock1() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 1L, 1, 0);
        Assert.assertEquals((long)1L, (long)d1.getLength());
        Assert.assertEquals((long)1L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)1, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)1, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.BLOCK), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)0, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)0, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)0, (int)d1.globalToLocal(0));
        Assert.assertEquals((int)0, (int)d1.localToGlobal(0));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(0L));
    }

    @Test
    public void testCircular1() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.CIRCULAR, 1L, 1, 0);
        Assert.assertEquals((long)1L, (long)d1.getLength());
        Assert.assertEquals((long)1L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)1, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)1, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.CIRCULAR), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)0, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)0, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)0, (int)d1.globalToLocal(0));
        Assert.assertEquals((int)0, (int)d1.localToGlobal(0));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(0L));
    }

    @Test
    public void testBlock2a() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 4L, 2, 0);
        Assert.assertEquals((long)4L, (long)d1.getLength());
        Assert.assertEquals((long)4L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)2, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)2, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.BLOCK), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)0, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)1, (int)d1.globalToLocal(1));
        Assert.assertEquals((int)1, (int)d1.localToGlobal(1));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(0L));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(1L));
    }

    @Test
    public void testBlock2b() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 4L, 2, 1);
        Assert.assertEquals((long)4L, (long)d1.getLength());
        Assert.assertEquals((long)4L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)2, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)2, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.BLOCK), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)2, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)3, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)1, (int)d1.globalToLocal(3));
        Assert.assertEquals((int)3, (int)d1.localToGlobal(1));
        Assert.assertEquals((int)1, (int)d1.getTaskIndex(2L));
        Assert.assertEquals((int)1, (int)d1.getTaskIndex(3L));
    }

    @Test
    public void testCircular2a() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.CIRCULAR, 4L, 2, 0);
        Assert.assertEquals((long)4L, (long)d1.getLength());
        Assert.assertEquals((long)4L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)2, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)2, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.CIRCULAR), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)0, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)2, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)2, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)0, (int)d1.globalToLocal(0));
        Assert.assertEquals((int)0, (int)d1.localToGlobal(0));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(0L));
        Assert.assertEquals((int)1, (int)d1.getTaskIndex(1L));
    }

    @Test
    public void testCircular2b() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.CIRCULAR, 4L, 2, 1);
        Assert.assertEquals((long)4L, (long)d1.getLength());
        Assert.assertEquals((long)4L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)2, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)2, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.CIRCULAR), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)3, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)2, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)1, (int)d1.globalToLocal(3));
        Assert.assertEquals((int)3, (int)d1.localToGlobal(1));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(2L));
        Assert.assertEquals((int)1, (int)d1.getTaskIndex(3L));
    }

    @Test
    public void testBlock3a() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 5L, 3, 0);
        Assert.assertEquals((long)5L, (long)d1.getLength());
        Assert.assertEquals((long)6L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)2, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)2, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.BLOCK), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)0, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)0, (int)d1.globalToLocal(0));
        Assert.assertEquals((int)0, (int)d1.localToGlobal(0));
        Assert.assertEquals((int)1, (int)d1.globalToLocal(1));
        Assert.assertEquals((int)1, (int)d1.localToGlobal(1));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(0L));
        Assert.assertEquals((int)1, (int)d1.getTaskIndex(2L));
        Assert.assertEquals((int)2, (int)d1.getTaskIndex(4L));
    }

    @Test
    public void testBlock3b() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 5L, 3, 1);
        Assert.assertEquals((long)5L, (long)d1.getLength());
        Assert.assertEquals((long)6L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)2, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)2, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.BLOCK), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)2, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)3, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)0, (int)d1.globalToLocal(2));
        Assert.assertEquals((int)2, (int)d1.localToGlobal(0));
        Assert.assertEquals((int)1, (int)d1.globalToLocal(3));
        Assert.assertEquals((int)3, (int)d1.localToGlobal(1));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(0L));
        Assert.assertEquals((int)1, (int)d1.getTaskIndex(2L));
        Assert.assertEquals((int)2, (int)d1.getTaskIndex(4L));
    }

    @Test
    public void testBlock3c() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 5L, 3, 2);
        Assert.assertEquals((long)5L, (long)d1.getLength());
        Assert.assertEquals((long)6L, (long)d1.getPaddedLength());
        Assert.assertEquals((int)2, (int)d1.getElementsPerTask());
        Assert.assertEquals((int)1, (int)d1.getLiveElements());
        Assert.assertEquals((Object)((Object)DecompositionType.BLOCK), (Object)((Object)d1.getDecompType()));
        Assert.assertEquals((int)4, (int)d1.getIndexRange()[0]);
        Assert.assertEquals((int)4, (int)d1.getIndexRange()[1]);
        Assert.assertEquals((int)1, (int)d1.getIndexRange()[2]);
        Assert.assertEquals((int)0, (int)d1.globalToLocal(4));
        Assert.assertEquals((int)4, (int)d1.localToGlobal(0));
        Assert.assertEquals((int)0, (int)d1.getTaskIndex(0L));
        Assert.assertEquals((int)1, (int)d1.getTaskIndex(2L));
        Assert.assertEquals((int)2, (int)d1.getTaskIndex(4L));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBlockFails() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 1L, 1, 0);
        d1.localToGlobal(1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBlockFails2() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 1L, 1, 0);
        d1.globalToLocal(1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBlockFails3() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 3L, 4, 3);
        Assert.assertEquals((int)0, (int)d1.getLiveElements());
        d1.globalToLocal(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBlockFails4() {
        ParallelDecomposition d1 = new ParallelDecomposition(DecompositionType.BLOCK, 3L, 4, 3);
        Assert.assertEquals((int)0, (int)d1.getLiveElements());
        d1.localToGlobal(0);
    }
}

