/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import org.javaseis.array.ArrayStorage;
import org.javaseis.array.BackingArray;
import org.javaseis.array.IBackingArray;
import org.javaseis.array.IMultiArray;
import org.javaseis.util.ArrayUtil;

public class Transpose {
    public static void transpose21(IMultiArray a) {
        if (a.getDimensions() < 2) {
            throw new IllegalArgumentException("Input MultiArray must have at least 2 dimensions");
        }
        int elementCount = a.getElementCount();
        int n1 = a.getLength(0);
        int n2 = a.getLength(1);
        long offset = 0L;
        long nframe = a.getTotalFrameCount();
        long frameLength = a.getFrameLength();
        IBackingArray b = a.getBackingArray();
        int i = 0;
        while ((long)i < nframe) {
            Transpose.transpose21(b, offset, elementCount, n1, n2);
            offset += frameLength;
            ++i;
        }
    }

    public static void transpose132(IMultiArray a) {
        if (a.getDimensions() < 3) {
            throw new IllegalArgumentException("Input MultiArray must have at least 3 dimensions");
        }
        int elementCount = a.getElementCount();
        int n1 = a.getLength(0);
        int n2 = a.getLength(1);
        int n3 = a.getLength(2);
        long offset = 0L;
        long nvol = a.getTotalVolumeCount();
        long volumeLength = a.getVolumeLength();
        IBackingArray b = a.getBackingArray();
        int i = 0;
        while ((long)i < nvol) {
            Transpose.transpose132(b, offset, elementCount, n1, n2, n3);
            offset += volumeLength;
            ++i;
        }
    }

    public static void transpose1243(IMultiArray a) {
        if (a.getDimensions() < 4) {
            throw new IllegalArgumentException("Input MultiArray must have at least 3 dimensions");
        }
        int n1 = a.getLength(0) * a.getElementCount();
        int n2 = a.getLength(1);
        int n3 = a.getLength(2);
        int n4 = a.getLength(3);
        long offset = 0L;
        long nhc = 1L;
        long hypercubeLength = a.getHypercubeLength();
        IBackingArray b = a.getBackingArray();
        int i = 0;
        while ((long)i < nhc) {
            Transpose.transpose132(b, offset, n1, n2, n3, n4);
            offset += hypercubeLength;
            ++i;
        }
    }

    public static void transpose21(IBackingArray a, long offset, int elementCount, int n1, int n2) {
        if (a.getBackingArrayType() == BackingArray.Type.JAVA_ARRAY) {
            ArrayStorage as = (ArrayStorage)a;
            int ia = (int)(as.getOffset() + offset);
            if (elementCount == 1) {
                Transpose.transpose21(as.getArray(), ia, n1, n2);
            } else {
                Transpose.transpose132(as.getArray(), ia, elementCount, n1, n2);
            }
        } else {
            Transpose.backingArray132(a, offset, elementCount, n1, n2);
        }
    }

    public static void transpose132(IBackingArray a, long offset, int elementCount, int n1, int n2, int n3) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset is not valid " + offset);
        }
        if (a.getBackingArrayType() == BackingArray.Type.JAVA_ARRAY) {
            ArrayStorage as = (ArrayStorage)a;
            int ia = (int)as.getOffset() + (int)offset;
            Transpose.transpose132(as.getArray(), ia, elementCount * n1, n2, n3);
        } else {
            Transpose.backingArray132(a, offset, elementCount * n1, n2, n3);
        }
    }

    public static void transpose21(Object a, int ia, int n1, int n2) {
        int move_size = (n1 + n2) / 2;
        byte[] move = new byte[move_size];
        Class<?> componentType = a.getClass().getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("Input argument must be an array of objects or primitive types");
        }
        if (componentType.equals(Byte.TYPE)) {
            Transpose.byte21a((byte[])a, ia, n1, n2, move, move_size);
        } else if (componentType.equals(Short.TYPE)) {
            Transpose.short21a((short[])a, ia, n1, n2, move, move_size);
        } else if (componentType.equals(Integer.TYPE)) {
            Transpose.int21a((int[])a, ia, n1, n2, move, move_size);
        } else if (componentType.equals(Float.TYPE)) {
            Transpose.float21a((float[])a, ia, n1, n2, move, move_size);
        } else if (componentType.equals(Long.TYPE)) {
            Transpose.long21a((long[])a, ia, n1, n2, move, move_size);
        } else if (componentType.equals(Double.TYPE)) {
            Transpose.double21a((double[])a, ia, n1, n2, move, move_size);
        } else {
            Transpose.object21a((Object[])a, ia, n1, n2, move, move_size);
        }
    }

    public static void transpose132(Object a, int ia, int n1, int n2, int n3) {
        int move_size = (n2 + n3) / 2;
        byte[] move = new byte[move_size];
        Class<?> componentType = a.getClass().getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("Input argument must be an array of objects or primitive types");
        }
        if (componentType.equals(Byte.TYPE)) {
            Transpose.byte132a((byte[])a, ia, n1, n2, n3, move, move_size);
        } else if (componentType.equals(Short.TYPE)) {
            Transpose.short132a((short[])a, ia, n1, n2, n3, move, move_size);
        } else if (componentType.equals(Integer.TYPE)) {
            Transpose.int132a((int[])a, ia, n1, n2, n3, move, move_size);
        } else if (componentType.equals(Float.TYPE)) {
            Transpose.float132a((float[])a, ia, n1, n2, n3, move, move_size);
        } else if (componentType.equals(Long.TYPE)) {
            Transpose.long132a((long[])a, ia, n1, n2, n3, move, move_size);
        } else if (componentType.equals(Double.TYPE)) {
            Transpose.double132a((double[])a, ia, n1, n2, n3, move, move_size);
        } else {
            Transpose.object132a((Object[])a, ia, n1, n2, n3, move, move_size);
        }
    }

    private static int float21a(float[] a, int ia, int n1, int n2, byte[] move, int move_size) {
        int i;
        if (n1 < 0 || n2 < 0) {
            throw new IllegalArgumentException("n2,n1 < 0");
        }
        if (n1 < 2 || n2 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        if (n1 == n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int j = i2 + 1; j < n2; ++j) {
                    float b = a[ia + i2 + j * n2];
                    a[ia + i2 + j * n2] = a[ia + j + i2 * n2];
                    a[ia + j + i2 * n2] = b;
                }
            }
            return 0;
        }
        int ncount = 2;
        int mn = n1 * n2;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n1 >= 3 && n2 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n1 - 1, n2 - 1) - 1L));
        }
        i = 1;
        int im = n1;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            float b = a[ia + i1];
            int i1c = kmi;
            float c = a[ia + i1c];
            while (true) {
                i2 = n1 * i1 - k * (i1 / n2);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    float d = b;
                    b = c;
                    c = d;
                    break;
                }
                a[ia + i1] = a[ia + i2];
                a[ia + i1c] = a[ia + i2c];
                i1 = i2;
                i1c = i2c;
            }
            a[ia + i1] = b;
            a[ia + i1c] = c;
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n1) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n1 * i1 - k * (i1 / n2);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int int21a(int[] a, int ia, int n1, int n2, byte[] move, int move_size) {
        int i;
        if (n1 < 0 || n2 < 0) {
            throw new IllegalArgumentException("n2,n1 < 0");
        }
        if (n1 < 2 || n2 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        if (n1 == n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int j = i2 + 1; j < n2; ++j) {
                    int b = a[ia + i2 + j * n2];
                    a[ia + i2 + j * n2] = a[ia + j + i2 * n2];
                    a[ia + j + i2 * n2] = b;
                }
            }
            return 0;
        }
        int ncount = 2;
        int mn = n1 * n2;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n1 >= 3 && n2 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n1 - 1, n2 - 1) - 1L));
        }
        i = 1;
        int im = n1;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            int b = a[ia + i1];
            int i1c = kmi;
            int c = a[ia + i1c];
            while (true) {
                i2 = n1 * i1 - k * (i1 / n2);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    int d = b;
                    b = c;
                    c = d;
                    break;
                }
                a[ia + i1] = a[ia + i2];
                a[ia + i1c] = a[ia + i2c];
                i1 = i2;
                i1c = i2c;
            }
            a[ia + i1] = b;
            a[ia + i1c] = c;
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n1) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n1 * i1 - k * (i1 / n2);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int short21a(short[] a, int ia, int n1, int n2, byte[] move, int move_size) {
        int i;
        if (n1 < 0 || n2 < 0) {
            throw new IllegalArgumentException("n2,n1 < 0");
        }
        if (n1 < 2 || n2 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        if (n1 == n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int j = i2 + 1; j < n2; ++j) {
                    short b = a[ia + i2 + j * n2];
                    a[ia + i2 + j * n2] = a[ia + j + i2 * n2];
                    a[ia + j + i2 * n2] = b;
                }
            }
            return 0;
        }
        int ncount = 2;
        int mn = n1 * n2;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n1 >= 3 && n2 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n1 - 1, n2 - 1) - 1L));
        }
        i = 1;
        int im = n1;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            short b = a[ia + i1];
            int i1c = kmi;
            short c = a[ia + i1c];
            while (true) {
                i2 = n1 * i1 - k * (i1 / n2);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    short d = b;
                    b = c;
                    c = d;
                    break;
                }
                a[ia + i1] = a[ia + i2];
                a[ia + i1c] = a[ia + i2c];
                i1 = i2;
                i1c = i2c;
            }
            a[ia + i1] = b;
            a[ia + i1c] = c;
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n1) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n1 * i1 - k * (i1 / n2);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int byte21a(byte[] a, int ia, int n1, int n2, byte[] move, int move_size) {
        int i;
        if (n1 < 0 || n2 < 0) {
            throw new IllegalArgumentException("n2,n1 < 0");
        }
        if (n1 < 2 || n2 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        if (n1 == n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int j = i2 + 1; j < n2; ++j) {
                    byte b = a[ia + i2 + j * n2];
                    a[ia + i2 + j * n2] = a[ia + j + i2 * n2];
                    a[ia + j + i2 * n2] = b;
                }
            }
            return 0;
        }
        int ncount = 2;
        int mn = n1 * n2;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n1 >= 3 && n2 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n1 - 1, n2 - 1) - 1L));
        }
        i = 1;
        int im = n1;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            byte b = a[ia + i1];
            int i1c = kmi;
            byte c = a[ia + i1c];
            while (true) {
                i2 = n1 * i1 - k * (i1 / n2);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    byte d = b;
                    b = c;
                    c = d;
                    break;
                }
                a[ia + i1] = a[ia + i2];
                a[ia + i1c] = a[ia + i2c];
                i1 = i2;
                i1c = i2c;
            }
            a[ia + i1] = b;
            a[ia + i1c] = c;
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n1) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n1 * i1 - k * (i1 / n2);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int long21a(long[] a, int ia, int n1, int n2, byte[] move, int move_size) {
        int i;
        if (n1 < 0 || n2 < 0) {
            throw new IllegalArgumentException("n2,n1 < 0");
        }
        if (n1 < 2 || n2 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        if (n1 == n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int j = i2 + 1; j < n2; ++j) {
                    long b = a[ia + i2 + j * n2];
                    a[ia + i2 + j * n2] = a[ia + j + i2 * n2];
                    a[ia + j + i2 * n2] = b;
                }
            }
            return 0;
        }
        int ncount = 2;
        int mn = n1 * n2;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n1 >= 3 && n2 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n1 - 1, n2 - 1) - 1L));
        }
        i = 1;
        int im = n1;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            long b = a[ia + i1];
            int i1c = kmi;
            long c = a[ia + i1c];
            while (true) {
                i2 = n1 * i1 - k * (i1 / n2);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    long d = b;
                    b = c;
                    c = d;
                    break;
                }
                a[ia + i1] = a[ia + i2];
                a[ia + i1c] = a[ia + i2c];
                i1 = i2;
                i1c = i2c;
            }
            a[ia + i1] = b;
            a[ia + i1c] = c;
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n1) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n1 * i1 - k * (i1 / n2);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int double21a(double[] a, int ia, int n1, int n2, byte[] move, int move_size) {
        int i;
        if (n1 < 0 || n2 < 0) {
            throw new IllegalArgumentException("n2,n1 < 0");
        }
        if (n1 < 2 || n2 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        if (n1 == n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int j = i2 + 1; j < n2; ++j) {
                    double b = a[ia + i2 + j * n2];
                    a[ia + i2 + j * n2] = a[ia + j + i2 * n2];
                    a[ia + j + i2 * n2] = b;
                }
            }
            return 0;
        }
        int ncount = 2;
        int mn = n1 * n2;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n1 >= 3 && n2 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n1 - 1, n2 - 1) - 1L));
        }
        i = 1;
        int im = n1;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            double b = a[ia + i1];
            int i1c = kmi;
            double c = a[ia + i1c];
            while (true) {
                i2 = n1 * i1 - k * (i1 / n2);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    double d = b;
                    b = c;
                    c = d;
                    break;
                }
                a[ia + i1] = a[ia + i2];
                a[ia + i1c] = a[ia + i2c];
                i1 = i2;
                i1c = i2c;
            }
            a[ia + i1] = b;
            a[ia + i1c] = c;
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n1) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n1 * i1 - k * (i1 / n2);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static <T> int object21a(T[] a, int ia, int n1, int n2, byte[] move, int move_size) {
        int i;
        if (n1 < 0 || n2 < 0) {
            throw new IllegalArgumentException("n2,n1 < 0");
        }
        if (n1 < 2 || n2 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        if (n1 == n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int j = i2 + 1; j < n2; ++j) {
                    T b = a[ia + i2 + j * n2];
                    a[ia + i2 + j * n2] = a[ia + j + i2 * n2];
                    a[ia + j + i2 * n2] = b;
                }
            }
            return 0;
        }
        int ncount = 2;
        int mn = n1 * n2;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n1 >= 3 && n2 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n1 - 1, n2 - 1) - 1L));
        }
        i = 1;
        int im = n1;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            T b = a[ia + i1];
            int i1c = kmi;
            T c = a[ia + i1c];
            while (true) {
                i2 = n1 * i1 - k * (i1 / n2);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    T d = b;
                    b = c;
                    c = d;
                    break;
                }
                a[ia + i1] = a[ia + i2];
                a[ia + i1c] = a[ia + i2c];
                i1 = i2;
                i1c = i2c;
            }
            a[ia + i1] = b;
            a[ia + i1c] = c;
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n1) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n1 * i1 - k * (i1 / n2);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static long TOMS_gcd(long a, long b) {
        long r;
        do {
            r = a % b;
            a = b;
            b = r;
        } while (r != 0L);
        return a;
    }

    private static int byte132a(byte[] a, int ia, int n1, int n2, int n3, byte[] move, int move_size) {
        int i;
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2 || n3 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        byte[] b = new byte[n1];
        if (b == null) {
            throw new OutOfMemoryError("Could not allocate work array");
        }
        if (n2 == n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int j = i2 + 1; j < n3; ++j) {
                    int ij = ia + n1 * (i2 + j * n3);
                    int ji = ia + n1 * (j + i2 * n3);
                    ArrayUtil.arraycopy(a, ij, b, 0, n1);
                    ArrayUtil.arraycopy(a, ji, a, ij, n1);
                    ArrayUtil.arraycopy(b, 0, a, ji, n1);
                }
            }
            return 0;
        }
        byte[] c = new byte[n1];
        if (c == null) {
            b = null;
            throw new OutOfMemoryError("Could not allocate work array");
        }
        int ncount = 2;
        int mn = n2 * n3;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n2 >= 3 && n3 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n2 - 1, n3 - 1) - 1L));
        }
        i = 1;
        int im = n2;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            ArrayUtil.arraycopy(a, ia + n1 * i1, b, 0, n1);
            int i1c = kmi;
            ArrayUtil.arraycopy(a, ia + n1 * i1c, c, 0, n1);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    for (int l = 0; l < n1; ++l) {
                        byte d = b[l];
                        b[l] = c[l];
                        c[l] = d;
                    }
                    break;
                }
                ArrayUtil.arraycopy(a, ia + n1 * i2, a, ia + n1 * i1, n1);
                ArrayUtil.arraycopy(a, ia + n1 * i2c, a, ia + n1 * i1c, n1);
                i1 = i2;
                i1c = i2c;
            }
            ArrayUtil.arraycopy(b, 0, a, ia + n1 * i1, n1);
            ArrayUtil.arraycopy(c, 0, a, ia + n1 * i1c, n1);
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int short132a(short[] a, int ia, int n1, int n2, int n3, byte[] move, int move_size) {
        int i;
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2 || n3 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        short[] b = new short[n1];
        if (b == null) {
            throw new OutOfMemoryError("Could not allocate work array");
        }
        if (n2 == n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int j = i2 + 1; j < n3; ++j) {
                    int ij = ia + n1 * (i2 + j * n3);
                    int ji = ia + n1 * (j + i2 * n3);
                    ArrayUtil.arraycopy(a, ij, b, 0, n1);
                    ArrayUtil.arraycopy(a, ji, a, ij, n1);
                    ArrayUtil.arraycopy(b, 0, a, ji, n1);
                }
            }
            return 0;
        }
        short[] c = new short[n1];
        if (c == null) {
            b = null;
            throw new OutOfMemoryError("Could not allocate work array");
        }
        int ncount = 2;
        int mn = n2 * n3;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n2 >= 3 && n3 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n2 - 1, n3 - 1) - 1L));
        }
        i = 1;
        int im = n2;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            ArrayUtil.arraycopy(a, ia + n1 * i1, b, 0, n1);
            int i1c = kmi;
            ArrayUtil.arraycopy(a, ia + n1 * i1c, c, 0, n1);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    for (int l = 0; l < n1; ++l) {
                        short d = b[l];
                        b[l] = c[l];
                        c[l] = d;
                    }
                    break;
                }
                ArrayUtil.arraycopy(a, ia + n1 * i2, a, ia + n1 * i1, n1);
                ArrayUtil.arraycopy(a, ia + n1 * i2c, a, ia + n1 * i1c, n1);
                i1 = i2;
                i1c = i2c;
            }
            ArrayUtil.arraycopy(b, 0, a, ia + n1 * i1, n1);
            ArrayUtil.arraycopy(c, 0, a, ia + n1 * i1c, n1);
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int int132a(int[] a, int ia, int n1, int n2, int n3, byte[] move, int move_size) {
        int i;
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2 || n3 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        int[] b = new int[n1];
        if (b == null) {
            throw new OutOfMemoryError("Could not allocate work array");
        }
        if (n2 == n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int j = i2 + 1; j < n3; ++j) {
                    int ij = ia + n1 * (i2 + j * n3);
                    int ji = ia + n1 * (j + i2 * n3);
                    ArrayUtil.arraycopy(a, ij, b, 0, n1);
                    ArrayUtil.arraycopy(a, ji, a, ij, n1);
                    ArrayUtil.arraycopy(b, 0, a, ji, n1);
                }
            }
            return 0;
        }
        int[] c = new int[n1];
        if (c == null) {
            b = null;
            throw new OutOfMemoryError("Could not allocate work array");
        }
        int ncount = 2;
        int mn = n2 * n3;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n2 >= 3 && n3 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n2 - 1, n3 - 1) - 1L));
        }
        i = 1;
        int im = n2;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            ArrayUtil.arraycopy(a, ia + n1 * i1, b, 0, n1);
            int i1c = kmi;
            ArrayUtil.arraycopy(a, ia + n1 * i1c, c, 0, n1);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    for (int l = 0; l < n1; ++l) {
                        int d = b[l];
                        b[l] = c[l];
                        c[l] = d;
                    }
                    break;
                }
                ArrayUtil.arraycopy(a, ia + n1 * i2, a, ia + n1 * i1, n1);
                ArrayUtil.arraycopy(a, ia + n1 * i2c, a, ia + n1 * i1c, n1);
                i1 = i2;
                i1c = i2c;
            }
            ArrayUtil.arraycopy(b, 0, a, ia + n1 * i1, n1);
            ArrayUtil.arraycopy(c, 0, a, ia + n1 * i1c, n1);
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int long132a(long[] a, int ia, int n1, int n2, int n3, byte[] move, int move_size) {
        int i;
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2 || n3 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        long[] b = new long[n1];
        if (b == null) {
            throw new OutOfMemoryError("Could not allocate work array");
        }
        if (n2 == n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int j = i2 + 1; j < n3; ++j) {
                    int ij = ia + n1 * (i2 + j * n3);
                    int ji = ia + n1 * (j + i2 * n3);
                    ArrayUtil.arraycopy(a, ij, b, 0, n1);
                    ArrayUtil.arraycopy(a, ji, a, ij, n1);
                    ArrayUtil.arraycopy(b, 0, a, ji, n1);
                }
            }
            return 0;
        }
        long[] c = new long[n1];
        if (c == null) {
            b = null;
            throw new OutOfMemoryError("Could not allocate work array");
        }
        int ncount = 2;
        int mn = n2 * n3;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n2 >= 3 && n3 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n2 - 1, n3 - 1) - 1L));
        }
        i = 1;
        int im = n2;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            ArrayUtil.arraycopy(a, ia + n1 * i1, b, 0, n1);
            int i1c = kmi;
            ArrayUtil.arraycopy(a, ia + n1 * i1c, c, 0, n1);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    for (int l = 0; l < n1; ++l) {
                        long d = b[l];
                        b[l] = c[l];
                        c[l] = d;
                    }
                    break;
                }
                ArrayUtil.arraycopy(a, ia + n1 * i2, a, ia + n1 * i1, n1);
                ArrayUtil.arraycopy(a, ia + n1 * i2c, a, ia + n1 * i1c, n1);
                i1 = i2;
                i1c = i2c;
            }
            ArrayUtil.arraycopy(b, 0, a, ia + n1 * i1, n1);
            ArrayUtil.arraycopy(c, 0, a, ia + n1 * i1c, n1);
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int float132a(float[] a, int ia, int n1, int n2, int n3, byte[] move, int move_size) {
        int i;
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2 || n3 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        float[] b = new float[n1];
        if (b == null) {
            throw new OutOfMemoryError("Could not allocate work array");
        }
        if (n2 == n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int j = i2 + 1; j < n3; ++j) {
                    int ij = ia + n1 * (i2 + j * n3);
                    int ji = ia + n1 * (j + i2 * n3);
                    ArrayUtil.arraycopy(a, ij, b, 0, n1);
                    ArrayUtil.arraycopy(a, ji, a, ij, n1);
                    ArrayUtil.arraycopy(b, 0, a, ji, n1);
                }
            }
            return 0;
        }
        float[] c = new float[n1];
        if (c == null) {
            b = null;
            throw new OutOfMemoryError("Could not allocate work array");
        }
        int ncount = 2;
        int mn = n2 * n3;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n2 >= 3 && n3 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n2 - 1, n3 - 1) - 1L));
        }
        i = 1;
        int im = n2;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            ArrayUtil.arraycopy(a, ia + n1 * i1, b, 0, n1);
            int i1c = kmi;
            ArrayUtil.arraycopy(a, ia + n1 * i1c, c, 0, n1);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    for (int l = 0; l < n1; ++l) {
                        float d = b[l];
                        b[l] = c[l];
                        c[l] = d;
                    }
                    break;
                }
                ArrayUtil.arraycopy(a, ia + n1 * i2, a, ia + n1 * i1, n1);
                ArrayUtil.arraycopy(a, ia + n1 * i2c, a, ia + n1 * i1c, n1);
                i1 = i2;
                i1c = i2c;
            }
            ArrayUtil.arraycopy(b, 0, a, ia + n1 * i1, n1);
            ArrayUtil.arraycopy(c, 0, a, ia + n1 * i1c, n1);
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int double132a(double[] a, int ia, int n1, int n2, int n3, byte[] move, int move_size) {
        int i;
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2 || n3 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        double[] b = new double[n1];
        if (b == null) {
            throw new OutOfMemoryError("Could not allocate work array");
        }
        if (n2 == n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int j = i2 + 1; j < n3; ++j) {
                    int ij = ia + n1 * (i2 + j * n3);
                    int ji = ia + n1 * (j + i2 * n3);
                    ArrayUtil.arraycopy(a, ij, b, 0, n1);
                    ArrayUtil.arraycopy(a, ji, a, ij, n1);
                    ArrayUtil.arraycopy(b, 0, a, ji, n1);
                }
            }
            return 0;
        }
        double[] c = new double[n1];
        if (c == null) {
            b = null;
            throw new OutOfMemoryError("Could not allocate work array");
        }
        int ncount = 2;
        int mn = n2 * n3;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n2 >= 3 && n3 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n2 - 1, n3 - 1) - 1L));
        }
        i = 1;
        int im = n2;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            ArrayUtil.arraycopy(a, ia + n1 * i1, b, 0, n1);
            int i1c = kmi;
            ArrayUtil.arraycopy(a, ia + n1 * i1c, c, 0, n1);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    for (int l = 0; l < n1; ++l) {
                        double d = b[l];
                        b[l] = c[l];
                        c[l] = d;
                    }
                    break;
                }
                ArrayUtil.arraycopy(a, ia + n1 * i2, a, ia + n1 * i1, n1);
                ArrayUtil.arraycopy(a, ia + n1 * i2c, a, ia + n1 * i1c, n1);
                i1 = i2;
                i1c = i2c;
            }
            ArrayUtil.arraycopy(b, 0, a, ia + n1 * i1, n1);
            ArrayUtil.arraycopy(c, 0, a, ia + n1 * i1c, n1);
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int object132a(Object[] a, int ia, int n1, int n2, int n3, byte[] move, int move_size) {
        int i;
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2 || n3 < 2) {
            return 0;
        }
        if (move_size < 1) {
            throw new IllegalArgumentException("move_size < 1");
        }
        Object[] b = new Object[n1];
        if (b == null) {
            throw new OutOfMemoryError("Could not allocate work array");
        }
        if (n2 == n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int j = i2 + 1; j < n3; ++j) {
                    int ij = ia + n1 * (i2 + j * n3);
                    int ji = ia + n1 * (j + i2 * n3);
                    ArrayUtil.arraycopy(a, ij, b, 0, n1);
                    ArrayUtil.arraycopy(a, ji, a, ij, n1);
                    ArrayUtil.arraycopy(b, 0, a, ji, n1);
                }
            }
            return 0;
        }
        Object[] c = new Object[n1];
        if (c == null) {
            b = null;
            throw new OutOfMemoryError("Could not allocate work array");
        }
        int ncount = 2;
        int mn = n2 * n3;
        int k = mn - 1;
        for (i = 0; i < move_size; ++i) {
            move[i] = 0;
        }
        if (n2 >= 3 && n3 >= 3) {
            ncount = (int)((long)ncount + (Transpose.TOMS_gcd(n2 - 1, n3 - 1) - 1L));
        }
        i = 1;
        int im = n2;
        block3: while (true) {
            int i2;
            int i1 = i;
            int kmi = k - i;
            ArrayUtil.arraycopy(a, ia + n1 * i1, b, 0, n1);
            int i1c = kmi;
            ArrayUtil.arraycopy(a, ia + n1 * i1c, c, 0, n1);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                int i2c = k - i2;
                if (i1 < move_size) {
                    move[i1] = 1;
                }
                if (i1c < move_size) {
                    move[i1c] = 1;
                }
                ncount += 2;
                if (i2 == i) break;
                if (i2 == kmi) {
                    for (int l = 0; l < n1; ++l) {
                        Object d = b[l];
                        b[l] = c[l];
                        c[l] = d;
                    }
                    break;
                }
                ArrayUtil.arraycopy(a, ia + n1 * i2, a, ia + n1 * i1, n1);
                ArrayUtil.arraycopy(a, ia + n1 * i2c, a, ia + n1 * i1c, n1);
                i1 = i2;
                i1c = i2c;
            }
            ArrayUtil.arraycopy(b, 0, a, ia + n1 * i1, n1);
            ArrayUtil.arraycopy(c, 0, a, ia + n1 * i1c, n1);
            if (ncount >= mn) break;
            while (true) {
                int max;
                if (++i > (max = k - i)) {
                    return i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[i] == 0) break;
            }
        }
        return 0;
    }

    private static int backingArray132(IBackingArray a, long ia, int n1i, int n2i, int n3i) {
        long i;
        long n1 = n1i;
        long n3 = n3i;
        long n2 = n2i;
        long move_size = (n3 + n2) / 2L;
        if (move_size > Integer.MAX_VALUE || move_size < 0L) {
            throw new IndexOutOfBoundsException("move_size is not valid " + move_size);
        }
        byte[] move = new byte[(int)move_size];
        if (n2 < 0L || n3 < 0L) {
            throw new IllegalArgumentException("n3,n2 < 0");
        }
        if (n2 < 2L || n3 < 2L) {
            return 0;
        }
        if (move_size < 1L) {
            throw new IllegalArgumentException("move_size < 1");
        }
        long n1l = n1;
        IBackingArray b = BackingArray.factory(a.getClassType(), n1, BackingArray.Type.JAVA_ARRAY);
        if (n2 == n3) {
            for (long i2 = 0L; i2 < n3; ++i2) {
                for (long j = i2 + 1L; j < n3; ++j) {
                    long ij = ia + n1 * (i2 + j * n3);
                    long ji = ia + n1 * (j + i2 * n3);
                    BackingArray.arraycopy(a, ij, b, 0L, n1l);
                    BackingArray.arraycopy(a, ji, a, ij, n1l);
                    BackingArray.arraycopy(b, 0L, a, ji, n1l);
                }
            }
            return 0;
        }
        IBackingArray c = BackingArray.factory(a.getClassType(), n1, BackingArray.Type.JAVA_ARRAY);
        long ncount = 2L;
        long mn = n2 * n3;
        long k = mn - 1L;
        for (i = 0L; i < move_size; ++i) {
            if (i > Integer.MAX_VALUE || i < 0L) {
                throw new IndexOutOfBoundsException("i is not valid " + i);
            }
            move[(int)i] = 0;
        }
        if (n2 >= 3L && n3 >= 3L) {
            ncount += Transpose.TOMS_gcd(n2 - 1L, n3 - 1L) - 1L;
        }
        i = 1L;
        long im = n2;
        block3: while (true) {
            long i2;
            long i1 = i;
            long kmi = k - i;
            long ij = ia + n1 * i1;
            BackingArray.arraycopy(a, ij, b, 0L, n1l);
            long i1c = kmi;
            ij = ia + n1 * i1c;
            BackingArray.arraycopy(a, ij, c, 0L, n1l);
            IBackingArray d = BackingArray.factory(a.getClassType(), n1, BackingArray.Type.JAVA_ARRAY);
            while (true) {
                i2 = n2 * i1 - k * (i1 / n3);
                long i2c = k - i2;
                if (i1 < move_size) {
                    if (i1 > Integer.MAX_VALUE || i1 < 0L) {
                        throw new IndexOutOfBoundsException("i1 is not valid " + i1);
                    }
                    move[(int)i1] = 1;
                }
                if (i1c < move_size) {
                    if (i1c > Integer.MAX_VALUE || i1c < 0L) {
                        throw new IndexOutOfBoundsException("i1c is not valid " + i1c);
                    }
                    move[(int)i1c] = 1;
                }
                ncount += 2L;
                if (i2 == i) break;
                if (i2 == kmi) {
                    BackingArray.arraycopy(b, 0L, d, 0L, n1);
                    BackingArray.arraycopy(c, 0L, b, 0L, n1);
                    BackingArray.arraycopy(d, 0L, c, 0L, n1);
                    break;
                }
                ij = ia + n1 * i2;
                long ji = ia + n1 * i1;
                BackingArray.arraycopy(a, ij, a, ji, n1l);
                ij = ia + n1 * i2c;
                ji = ia + n1 * i1c;
                BackingArray.arraycopy(a, ij, a, ji, n1l);
                i1 = i2;
                i1c = i2c;
            }
            ij = ia + n1 * i1;
            BackingArray.arraycopy(b, 0L, a, ij, n1l);
            ij = ia + n1 * i1c;
            BackingArray.arraycopy(c, 0L, a, ij, n1l);
            if (ncount >= mn) break;
            while (true) {
                long max;
                if (++i > (max = k - i)) {
                    return (int)i;
                }
                if ((im += n2) > k) {
                    im -= k;
                }
                if (i == (i2 = im)) continue;
                if (i >= move_size) {
                    while (i2 > i && i2 < max) {
                        i1 = i2;
                        i2 = n2 * i1 - k * (i1 / n3);
                    }
                    if (i2 != i) continue;
                    continue block3;
                }
                if (move[(int)i] == 0) break;
            }
        }
        return 0;
    }
}

