/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.javaseis.array.IMultiArray;
import org.javaseis.array.JPerfTestShapes;
import org.javaseis.array.MultiArray;
import org.javaseis.array.MultiArrayPositionIterator;

public class JPerfTestMultiArrayGetPut {
    private int _logLevel;
    private boolean _doChecks;

    public JPerfTestMultiArrayGetPut() {
        this(Level.INFO, false);
    }

    public JPerfTestMultiArrayGetPut(Level level, boolean doChecks) {
        this.setLevel(level);
        this._doChecks = doChecks;
    }

    private void testGet(int[] inshape) {
        int j;
        int ndim = inshape.length;
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < inshape.length; ++i) {
            arraySize *= (double)inshape[i];
        }
        MultiArray m = MultiArray.factory(ndim, Integer.TYPE, 1, inshape);
        this.fillArray(m);
        this.logFine("After fill");
        Object buf = new int[1];
        double startTime = JPerfTestMultiArrayGetPut.getTime();
        for (int i = 0; i < inshape[2]; ++i) {
            for (j = 0; j < inshape[1]; ++j) {
                int k = 0;
                while (k < inshape[0]) {
                    m.getSample((int[])buf, new int[]{k++, j, i});
                }
            }
        }
        double elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("Get sample: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter get sample");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
        buf = new int[m.getShape()[0]];
        startTime = JPerfTestMultiArrayGetPut.getTime();
        for (int i = 0; i < inshape[2]; ++i) {
            j = 0;
            while (j < inshape[1]) {
                m.getTrace((int[])buf, new int[]{0, j++, i});
            }
        }
        elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("Get trace: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter get trace");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
        buf = new int[m.getShape()[1]][m.getShape()[0]];
        startTime = JPerfTestMultiArrayGetPut.getTime();
        int i = 0;
        while (i < inshape[2]) {
            m.getFrame((int[][])buf, new int[]{0, 0, i++});
        }
        elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("Get frame: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter get frame");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
        buf = new int[m.getShape()[2]][m.getShape()[1]][m.getShape()[0]];
        startTime = JPerfTestMultiArrayGetPut.getTime();
        elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("Get volume: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter get volume");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
    }

    private void testPut(int[] inshape) {
        int j;
        int ndim = inshape.length;
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < inshape.length; ++i) {
            arraySize *= (double)inshape[i];
        }
        MultiArray m = MultiArray.factory(ndim, Integer.TYPE, 1, inshape);
        this.fillArray(m);
        this.logFine("After fill");
        Object buf = new int[1];
        double startTime = JPerfTestMultiArrayGetPut.getTime();
        for (int i = 0; i < inshape[2]; ++i) {
            for (j = 0; j < inshape[1]; ++j) {
                int k = 0;
                while (k < inshape[0]) {
                    m.putSample((int[])buf, new int[]{k++, j, i});
                }
            }
        }
        double elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("Put sample: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter put sample");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
        buf = new int[m.getShape()[0]];
        startTime = JPerfTestMultiArrayGetPut.getTime();
        for (int i = 0; i < inshape[2]; ++i) {
            j = 0;
            while (j < inshape[1]) {
                m.putTrace((int[])buf, new int[]{0, j++, i});
            }
        }
        elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("put trace: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter put trace");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
        buf = new int[m.getShape()[1]][m.getShape()[0]];
        startTime = JPerfTestMultiArrayGetPut.getTime();
        int i = 0;
        while (i < inshape[2]) {
            m.putFrame((int[][])buf, new int[]{0, 0, i++});
        }
        elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("Put frame: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter put frame");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
        buf = new int[m.getShape()[2]][m.getShape()[1]][m.getShape()[0]];
        startTime = JPerfTestMultiArrayGetPut.getTime();
        elapsedTime = JPerfTestMultiArrayGetPut.getTime() - startTime;
        this.logInfo("Put volume: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter put volume");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
    }

    private int pvalue(int[] position, int is) {
        int value = is;
        int mult = 1;
        for (int i = 0; i < position.length; ++i) {
            value += mult * position[i];
            mult *= 10;
        }
        return value;
    }

    private void fillArray(IMultiArray m) {
        int[] buf = new int[m.getShape()[0]];
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        while (it.hasNext()) {
            int[] pos = it.next();
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = this.pvalue(pos, i);
            }
            m.putTrace(buf, pos);
        }
    }

    private void checkArray(IMultiArray m, int[] checkShape) {
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        int[] bufTrue = new int[m.getShape()[0]];
        int[] buf = new int[m.getShape()[0]];
        while (it.hasNext()) {
            int i;
            int[] pos = it.next();
            m.getTrace(buf, pos);
            boolean ret = false;
            for (i = 1; i < pos.length; ++i) {
                if (pos[i] < checkShape[i]) continue;
                ret = true;
            }
            if (ret) continue;
            for (i = 0; i < buf.length && i < checkShape[0]; ++i) {
                bufTrue[i] = this.pvalue(pos, i);
                if (buf[i] == bufTrue[i]) continue;
                System.err.println("Check failed at position " + Arrays.toString(pos) + " expected " + bufTrue[i] + " actual " + buf[i]);
            }
        }
    }

    private void printArray(IMultiArray m) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        int[] shape = m.getShape();
        int[] buf = new int[m.getShape()[0]];
        while (it.hasNext()) {
            int[] pos = it.next();
            System.out.println("Values at position " + Arrays.toString(pos));
            m.getTrace(buf, pos);
            for (int i0 = 0; i0 < shape[0]; ++i0) {
                System.out.println("val[" + i0 + "] = " + buf[i0]);
            }
        }
    }

    private void logInfo(String message) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        System.out.println(message);
    }

    private void logFine(String message) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        System.out.println(message);
    }

    private void setLevel(Level level) {
        this._logLevel = level.intValue();
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this._logLevel && this._logLevel != Level.OFF.intValue();
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    public static void main(String[] args) {
        JPerfTestMultiArrayGetPut tester = new JPerfTestMultiArrayGetPut(Level.INFO, false);
        Boolean memoryPrint = false;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        List<int[]> shapes3 = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        for (int[] shape : shapes3) {
            tester.testGet(shape);
            tester.testPut(shape);
            System.gc();
        }
    }
}

