/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.lictext.ActivationExpiryDaysLine;
import com.macrovision.flexlm.lictext.ActivationLowwaterLine;
import com.macrovision.flexlm.lictext.AutomaticRereadLine;
import com.macrovision.flexlm.lictext.BorrowLowLine;
import com.macrovision.flexlm.lictext.DebugLogLine;
import com.macrovision.flexlm.lictext.ExcludeAllLine;
import com.macrovision.flexlm.lictext.ExcludeBorrowLine;
import com.macrovision.flexlm.lictext.ExcludeEntitlementLine;
import com.macrovision.flexlm.lictext.ExcludeLine;
import com.macrovision.flexlm.lictext.GroupCaseInsensitiveLine;
import com.macrovision.flexlm.lictext.GroupLine;
import com.macrovision.flexlm.lictext.HostGroupLine;
import com.macrovision.flexlm.lictext.IncludeAllLine;
import com.macrovision.flexlm.lictext.IncludeBorrowLine;
import com.macrovision.flexlm.lictext.IncludeEntitlementLine;
import com.macrovision.flexlm.lictext.IncludeLine;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.LingerLine;
import com.macrovision.flexlm.lictext.MaxBorrowHoursLine;
import com.macrovision.flexlm.lictext.MaxLine;
import com.macrovision.flexlm.lictext.MaxOverdraftLine;
import com.macrovision.flexlm.lictext.NoLogLine;
import com.macrovision.flexlm.lictext.OptionsElement;
import com.macrovision.flexlm.lictext.OtherOptionsLine;
import com.macrovision.flexlm.lictext.ReportLogLine;
import com.macrovision.flexlm.lictext.ReserveLine;
import com.macrovision.flexlm.lictext.TimeoutAllLine;
import com.macrovision.flexlm.lictext.TimeoutLine;
import com.macrovision.flexlm.lictext.TokenizedOptionsLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;

public class OptionsFile
implements FlexlmConstants,
FlexlmInternalConstants {
    private ArrayList elements;
    private ArrayList elementExceptions;
    private String vendor;
    private String filename;
    private static final String LINE_SEP = System.getProperty("line.separator");

    public OptionsFile(String string) {
        this.vendor = string;
        this.elements = new ArrayList();
    }

    public OptionsFile(Reader reader, String string) throws FlexlmException {
        this.vendor = string;
        this.filename = null;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        lineNumberReader.setLineNumber(1);
        ArrayList arrayList = null;
        try {
            arrayList = OptionsFile.parseStream(lineNumberReader, this.filename);
            reader.close();
        }
        catch (IOException iOException) {
            throw new FlexlmException(-42, 4071);
        }
        this.processOptionsLines(arrayList);
    }

    public OptionsFile(String string, String string2) throws FlexlmException {
        this.vendor = string2;
        this.filename = string;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FlexlmException(-1, 4061, fileNotFoundException.getMessage());
        }
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        lineNumberReader.setLineNumber(1);
        ArrayList arrayList = null;
        try {
            arrayList = OptionsFile.parseStream(lineNumberReader, this.filename);
            fileReader.close();
        }
        catch (IOException iOException) {
            throw new FlexlmException(-42, 4071);
        }
        this.processOptionsLines(arrayList);
    }

    public void addElement(OptionsElement optionsElement) {
        this.elements.add(optionsElement);
    }

    public void addElement(String string) throws FlexlmException {
        if (string == null || string.length() < 1) {
            return;
        }
        TokenizedOptionsLine tokenizedOptionsLine = null;
        try {
            tokenizedOptionsLine = new TokenizedOptionsLine(new LineNumberReader(new StringReader(string)), this.filename);
        }
        catch (IOException iOException) {
            throw new FlexlmException(-42, 4073);
        }
        this.addElement(this.createElement(tokenizedOptionsLine));
    }

    public void removeElement(OptionsElement optionsElement) {
        int n = this.elements.indexOf(optionsElement);
        if (n >= 0) {
            this.elements.remove(n);
        }
    }

    public void write() throws FlexlmException {
        this.write(this.filename);
    }

    public void write(String string) throws FlexlmException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            throw new FlexlmException(-528, 4062, iOException.getMessage());
        }
        this.filename = string;
        for (int i = 0; i < this.elements.size(); ++i) {
            try {
                OptionsElement optionsElement = (OptionsElement)this.elements.get(i);
                String string2 = optionsElement.getRawLineText();
                if (string2 == null || optionsElement.isDirty()) {
                    string2 = LicenseElement.printableString(optionsElement.toString()) + LINE_SEP;
                }
                fileWriter.write(string2);
                continue;
            }
            catch (IOException iOException) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException2) {
                    throw new FlexlmException(-528, 4064, iOException2.getMessage());
                }
                throw new FlexlmException(-528, 4063, iOException.getMessage());
            }
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new FlexlmException(-528, 4065, iOException.getMessage());
        }
    }

    public OptionsElement[] getAllElements() {
        OptionsElement[] optionsElementArray = null;
        if (this.elements != null && this.elements.size() > 0) {
            optionsElementArray = this.elements.toArray(new OptionsElement[this.elements.size()]);
        }
        return optionsElementArray;
    }

    public FlexlmException[] getExceptionList() {
        FlexlmException[] flexlmExceptionArray = null;
        if (this.elementExceptions != null && this.elementExceptions.size() > 0) {
            flexlmExceptionArray = this.elementExceptions.toArray(new FlexlmException[this.elementExceptions.size()]);
        }
        return flexlmExceptionArray;
    }

    public Object[] getType(int n) {
        OptionsElement[] optionsElementArray = this.getAllElements();
        if (optionsElementArray != null) {
            Vector<OptionsElement> vector = new Vector<OptionsElement>();
            for (int i = 0; i < optionsElementArray.length; ++i) {
                if (optionsElementArray[i].getElementType() != n) continue;
                vector.add(optionsElementArray[i]);
            }
            if (vector.size() > 0) {
                return vector.toArray();
            }
        }
        return null;
    }

    public BorrowLowLine[] getBorrowLow() {
        Object[] objectArray = this.getType(1000);
        if (objectArray != null && objectArray.length > 0) {
            BorrowLowLine[] borrowLowLineArray = new BorrowLowLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                borrowLowLineArray[i] = (BorrowLowLine)objectArray[i];
            }
            return borrowLowLineArray;
        }
        return null;
    }

    public DebugLogLine[] getDebugLog() {
        Object[] objectArray = this.getType(1001);
        if (objectArray != null && objectArray.length > 0) {
            DebugLogLine[] debugLogLineArray = new DebugLogLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                debugLogLineArray[i] = (DebugLogLine)objectArray[i];
            }
            return debugLogLineArray;
        }
        return null;
    }

    public ExcludeLine[] getExclude() {
        Object[] objectArray = this.getType(1002);
        if (objectArray != null && objectArray.length > 0) {
            ExcludeLine[] excludeLineArray = new ExcludeLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                excludeLineArray[i] = (ExcludeLine)objectArray[i];
            }
            return excludeLineArray;
        }
        return null;
    }

    public ExcludeAllLine[] getExcludeAll() {
        Object[] objectArray = this.getType(1004);
        if (objectArray != null && objectArray.length > 0) {
            ExcludeAllLine[] excludeAllLineArray = new ExcludeAllLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                excludeAllLineArray[i] = (ExcludeAllLine)objectArray[i];
            }
            return excludeAllLineArray;
        }
        return null;
    }

    public ExcludeBorrowLine[] getExcludeBorrow() {
        Object[] objectArray = this.getType(1003);
        if (objectArray != null && objectArray.length > 0) {
            ExcludeBorrowLine[] excludeBorrowLineArray = new ExcludeBorrowLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                excludeBorrowLineArray[i] = (ExcludeBorrowLine)objectArray[i];
            }
            return excludeBorrowLineArray;
        }
        return null;
    }

    public ExcludeEntitlementLine[] getExcludeEntitlement() {
        Object[] objectArray = this.getType(1020);
        if (objectArray != null && objectArray.length > 0) {
            ExcludeEntitlementLine[] excludeEntitlementLineArray = new ExcludeEntitlementLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                excludeEntitlementLineArray[i] = (ExcludeEntitlementLine)objectArray[i];
            }
            return excludeEntitlementLineArray;
        }
        return null;
    }

    public GroupLine[] getGroup() {
        Object[] objectArray = this.getType(1005);
        if (objectArray != null && objectArray.length > 0) {
            GroupLine[] groupLineArray = new GroupLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                groupLineArray[i] = (GroupLine)objectArray[i];
            }
            return groupLineArray;
        }
        return null;
    }

    public GroupCaseInsensitiveLine[] getGroupCaseInsensitive() {
        Object[] objectArray = this.getType(1006);
        if (objectArray != null && objectArray.length > 0) {
            GroupCaseInsensitiveLine[] groupCaseInsensitiveLineArray = new GroupCaseInsensitiveLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                groupCaseInsensitiveLineArray[i] = (GroupCaseInsensitiveLine)objectArray[i];
            }
            return groupCaseInsensitiveLineArray;
        }
        return null;
    }

    public HostGroupLine[] getHostGroup() {
        Object[] objectArray = this.getType(1007);
        if (objectArray != null && objectArray.length > 0) {
            HostGroupLine[] hostGroupLineArray = new HostGroupLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                hostGroupLineArray[i] = (HostGroupLine)objectArray[i];
            }
            return hostGroupLineArray;
        }
        return null;
    }

    public LingerLine[] getLinger() {
        Object[] objectArray = this.getType(1011);
        if (objectArray != null && objectArray.length > 0) {
            LingerLine[] lingerLineArray = new LingerLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                lingerLineArray[i] = (LingerLine)objectArray[i];
            }
            return lingerLineArray;
        }
        return null;
    }

    public MaxLine[] getMax() {
        Object[] objectArray = this.getType(1012);
        if (objectArray != null && objectArray.length > 0) {
            MaxLine[] maxLineArray = new MaxLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                maxLineArray[i] = (MaxLine)objectArray[i];
            }
            return maxLineArray;
        }
        return null;
    }

    public MaxBorrowHoursLine[] getMaxBorrowHours() {
        Object[] objectArray = this.getType(1013);
        if (objectArray != null && objectArray.length > 0) {
            MaxBorrowHoursLine[] maxBorrowHoursLineArray = new MaxBorrowHoursLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                maxBorrowHoursLineArray[i] = (MaxBorrowHoursLine)objectArray[i];
            }
            return maxBorrowHoursLineArray;
        }
        return null;
    }

    public MaxOverdraftLine[] getMaxOverdraft() {
        Object[] objectArray = this.getType(1014);
        if (objectArray != null && objectArray.length > 0) {
            MaxOverdraftLine[] maxOverdraftLineArray = new MaxOverdraftLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                maxOverdraftLineArray[i] = (MaxOverdraftLine)objectArray[i];
            }
            return maxOverdraftLineArray;
        }
        return null;
    }

    public NoLogLine[] getNoLog() {
        Object[] objectArray = this.getType(1015);
        if (objectArray != null && objectArray.length > 0) {
            NoLogLine[] noLogLineArray = new NoLogLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                noLogLineArray[i] = (NoLogLine)objectArray[i];
            }
            return noLogLineArray;
        }
        return null;
    }

    public IncludeLine[] getInclude() {
        Object[] objectArray = this.getType(1008);
        if (objectArray != null && objectArray.length > 0) {
            IncludeLine[] includeLineArray = new IncludeLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                includeLineArray[i] = (IncludeLine)objectArray[i];
            }
            return includeLineArray;
        }
        return null;
    }

    public IncludeAllLine[] getIncludeAll() {
        Object[] objectArray = this.getType(1010);
        if (objectArray != null && objectArray.length > 0) {
            IncludeAllLine[] includeAllLineArray = new IncludeAllLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                includeAllLineArray[i] = (IncludeAllLine)objectArray[i];
            }
            return includeAllLineArray;
        }
        return null;
    }

    public IncludeBorrowLine[] getIncludeBorrow() {
        Object[] objectArray = this.getType(1009);
        if (objectArray != null && objectArray.length > 0) {
            IncludeBorrowLine[] includeBorrowLineArray = new IncludeBorrowLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                includeBorrowLineArray[i] = (IncludeBorrowLine)objectArray[i];
            }
            return includeBorrowLineArray;
        }
        return null;
    }

    public IncludeEntitlementLine[] getIncludeEntitlement() {
        Object[] objectArray = this.getType(1021);
        if (objectArray != null && objectArray.length > 0) {
            IncludeEntitlementLine[] includeEntitlementLineArray = new IncludeEntitlementLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                includeEntitlementLineArray[i] = (IncludeEntitlementLine)objectArray[i];
            }
            return includeEntitlementLineArray;
        }
        return null;
    }

    public ReportLogLine[] getReportLog() {
        Object[] objectArray = this.getType(1016);
        if (objectArray != null && objectArray.length > 0) {
            ReportLogLine[] reportLogLineArray = new ReportLogLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                reportLogLineArray[i] = (ReportLogLine)objectArray[i];
            }
            return reportLogLineArray;
        }
        return null;
    }

    public ReserveLine[] getReserve() {
        Object[] objectArray = this.getType(1017);
        if (objectArray != null && objectArray.length > 0) {
            ReserveLine[] reserveLineArray = new ReserveLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                reserveLineArray[i] = (ReserveLine)objectArray[i];
            }
            return reserveLineArray;
        }
        return null;
    }

    public TimeoutLine[] getTimeout() {
        Object[] objectArray = this.getType(1018);
        if (objectArray != null && objectArray.length > 0) {
            TimeoutLine[] timeoutLineArray = new TimeoutLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                timeoutLineArray[i] = (TimeoutLine)objectArray[i];
            }
            return timeoutLineArray;
        }
        return null;
    }

    public TimeoutAllLine[] getTimeoutAll() {
        Object[] objectArray = this.getType(1019);
        if (objectArray != null && objectArray.length > 0) {
            TimeoutAllLine[] timeoutAllLineArray = new TimeoutAllLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                timeoutAllLineArray[i] = (TimeoutAllLine)objectArray[i];
            }
            return timeoutAllLineArray;
        }
        return null;
    }

    public AutomaticRereadLine[] getAutomatic_reread() {
        Object[] objectArray = this.getType(1022);
        if (objectArray != null && objectArray.length > 0) {
            AutomaticRereadLine[] automaticRereadLineArray = new AutomaticRereadLine[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                automaticRereadLineArray[i] = (AutomaticRereadLine)objectArray[i];
            }
            return automaticRereadLineArray;
        }
        return null;
    }

    private static ArrayList parseStream(LineNumberReader lineNumberReader, String string) throws IOException {
        TokenizedOptionsLine tokenizedOptionsLine;
        ArrayList<TokenizedOptionsLine> arrayList = new ArrayList<TokenizedOptionsLine>();
        while ((tokenizedOptionsLine = new TokenizedOptionsLine(lineNumberReader, string)).hasContent()) {
            arrayList.add(tokenizedOptionsLine);
        }
        return arrayList;
    }

    private void processOptionsLines(ArrayList arrayList) {
        this.elements = new ArrayList();
        this.elementExceptions = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TokenizedOptionsLine tokenizedOptionsLine = (TokenizedOptionsLine)arrayList.get(i);
            OptionsElement optionsElement = null;
            try {
                optionsElement = this.createElement(tokenizedOptionsLine);
            }
            catch (FlexlmException flexlmException) {
                this.elementExceptions.add(flexlmException);
                try {
                    optionsElement = new OtherOptionsLine(tokenizedOptionsLine);
                }
                catch (FlexlmException flexlmException2) {
                    throw new RuntimeException(flexlmException2.getMessage());
                }
            }
            this.elements.add(optionsElement);
        }
    }

    private OptionsElement createElement(TokenizedOptionsLine tokenizedOptionsLine) throws FlexlmException {
        int n = tokenizedOptionsLine.getLineType(tokenizedOptionsLine.getLineText());
        OptionsElement optionsElement = null;
        switch (n) {
            case 1000: {
                BorrowLowLine borrowLowLine;
                optionsElement = borrowLowLine = new BorrowLowLine(tokenizedOptionsLine);
                break;
            }
            case 1001: {
                DebugLogLine debugLogLine = new DebugLogLine(tokenizedOptionsLine);
                optionsElement = debugLogLine;
                break;
            }
            case 1002: {
                ExcludeLine excludeLine = new ExcludeLine(tokenizedOptionsLine);
                optionsElement = excludeLine;
                break;
            }
            case 1004: {
                ExcludeAllLine excludeAllLine = new ExcludeAllLine(tokenizedOptionsLine);
                optionsElement = excludeAllLine;
                break;
            }
            case 1003: {
                ExcludeBorrowLine excludeBorrowLine = new ExcludeBorrowLine(tokenizedOptionsLine);
                optionsElement = excludeBorrowLine;
                break;
            }
            case 1020: {
                ExcludeEntitlementLine excludeEntitlementLine = new ExcludeEntitlementLine(tokenizedOptionsLine);
                optionsElement = excludeEntitlementLine;
                break;
            }
            case 1005: {
                GroupLine groupLine = new GroupLine(tokenizedOptionsLine);
                optionsElement = groupLine;
                break;
            }
            case 1006: {
                GroupCaseInsensitiveLine groupCaseInsensitiveLine = new GroupCaseInsensitiveLine(tokenizedOptionsLine);
                optionsElement = groupCaseInsensitiveLine;
                break;
            }
            case 1007: {
                HostGroupLine hostGroupLine = new HostGroupLine(tokenizedOptionsLine);
                optionsElement = hostGroupLine;
                break;
            }
            case 1008: {
                IncludeLine includeLine = new IncludeLine(tokenizedOptionsLine);
                optionsElement = includeLine;
                break;
            }
            case 1010: {
                IncludeAllLine includeAllLine = new IncludeAllLine(tokenizedOptionsLine);
                optionsElement = includeAllLine;
                break;
            }
            case 1009: {
                IncludeBorrowLine includeBorrowLine = new IncludeBorrowLine(tokenizedOptionsLine);
                optionsElement = includeBorrowLine;
                break;
            }
            case 1021: {
                IncludeEntitlementLine includeEntitlementLine = new IncludeEntitlementLine(tokenizedOptionsLine);
                optionsElement = includeEntitlementLine;
                break;
            }
            case 1011: {
                LingerLine lingerLine = new LingerLine(tokenizedOptionsLine);
                optionsElement = lingerLine;
                break;
            }
            case 1012: {
                MaxLine maxLine = new MaxLine(tokenizedOptionsLine);
                optionsElement = maxLine;
                break;
            }
            case 1013: {
                MaxBorrowHoursLine maxBorrowHoursLine = new MaxBorrowHoursLine(tokenizedOptionsLine);
                optionsElement = maxBorrowHoursLine;
                break;
            }
            case 1014: {
                MaxOverdraftLine maxOverdraftLine = new MaxOverdraftLine(tokenizedOptionsLine);
                optionsElement = maxOverdraftLine;
                break;
            }
            case 1015: {
                NoLogLine noLogLine = new NoLogLine(tokenizedOptionsLine);
                optionsElement = noLogLine;
                break;
            }
            case 1017: {
                ReserveLine reserveLine = new ReserveLine(tokenizedOptionsLine);
                optionsElement = reserveLine;
                break;
            }
            case 1016: {
                ReportLogLine reportLogLine = new ReportLogLine(tokenizedOptionsLine);
                optionsElement = reportLogLine;
                break;
            }
            case 1018: {
                TimeoutLine timeoutLine = new TimeoutLine(tokenizedOptionsLine);
                optionsElement = timeoutLine;
                break;
            }
            case 1019: {
                TimeoutAllLine timeoutAllLine = new TimeoutAllLine(tokenizedOptionsLine);
                optionsElement = timeoutAllLine;
                break;
            }
            case 1022: {
                AutomaticRereadLine automaticRereadLine = new AutomaticRereadLine(tokenizedOptionsLine);
                optionsElement = automaticRereadLine;
                break;
            }
            case 1023: {
                ActivationExpiryDaysLine activationExpiryDaysLine = new ActivationExpiryDaysLine(tokenizedOptionsLine);
                optionsElement = activationExpiryDaysLine;
                break;
            }
            case 1024: {
                ActivationLowwaterLine activationLowwaterLine = new ActivationLowwaterLine(tokenizedOptionsLine);
                optionsElement = activationLowwaterLine;
                break;
            }
            default: {
                OtherOptionsLine otherOptionsLine = new OtherOptionsLine(tokenizedOptionsLine);
                optionsElement = otherOptionsLine;
            }
        }
        return optionsElement;
    }
}

