/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LicenseLine
implements FlexlmConstants,
FlexlmInternalConstants {
    private String line = "";
    private int lineNumber;
    private Vector tokens;
    private int type;
    private String filename;
    private Vector positionalParameters;
    private Hashtable keywordParameters;

    protected LicenseLine(LineNumberReader lineNumberReader, String string) throws IOException {
        this.lineNumber = lineNumberReader.getLineNumber();
        this.filename = string;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            boolean bl2;
            String string2;
            if (bl) {
                lineNumberReader.mark(10000);
            }
            if ((string2 = lineNumberReader.readLine()) == null) {
                this.line = null;
                break;
            }
            int n = LicenseLine.getLineType(string2);
            boolean bl3 = bl2 = n == 0;
            if (bl && !bl2) {
                lineNumberReader.reset();
                break;
            }
            if (!bl && bl2) {
                this.type = n;
                stringBuffer.append(string2);
                break;
            }
            if (n == 8) {
                this.type = n;
                stringBuffer.append(string2);
                break;
            }
            if (!bl && !bl2) {
                this.type = n;
                bl = true;
            }
            if ((string2 = string2.trim()).endsWith("\\")) {
                string2 = string2.substring(0, string2.length() - 1).trim();
            }
            stringBuffer.append(" " + string2);
        }
        if (stringBuffer.length() > 0) {
            this.line = new String(stringBuffer).trim();
            if (this.type != 8 && this.type != 0) {
                this.tokens = LicenseLine.tokenizeLine(this.line);
            }
        }
    }

    protected String getLine() {
        return this.line;
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    protected Vector getTokens() {
        return this.tokens;
    }

    protected int getType() {
        return this.type;
    }

    protected String getFilename() {
        return this.filename;
    }

    protected boolean hasContent() {
        return this.line != null;
    }

    private static int getLineType(String string) {
        int n = 0;
        String string2 = string.trim();
        if (string2.length() > 0) {
            n = string2.startsWith("SERVER ") ? 1 : (string2.startsWith("VENDOR ") || string2.startsWith("DAEMON ") ? 2 : (string2.startsWith("PACKAGE ") ? 3 : (string2.startsWith("FEATURE ") || string2.startsWith("INCREMENT ") ? 4 : (string2.startsWith("UPGRADE ") ? 5 : (string2.equals("USE_SERVER") || string2.startsWith("USE_SERVER ") ? 6 : (string2.startsWith("#") ? 8 : 0))))));
        }
        return n;
    }

    private static Vector tokenizeLine(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = " \"\t\r\n\f";
        String string3 = "\"\\";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n = -2;
        int n2 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            ++n2;
            String string4 = stringTokenizer.nextToken(string2);
            if (!LicenseLine.isDelimiter(string4, string2)) {
                int n3 = string4.indexOf(61);
                if (n3 > 0) {
                    vector.add(string4.substring(0, n3));
                    vector.add("=");
                    vector.add(string4.substring(n3 + 1));
                    n = n2;
                    continue;
                }
                vector.add(string4);
                continue;
            }
            if (!string4.equals("\"")) continue;
            if (n2 == n + 1 && ((String)vector.elementAt(vector.size() - 1)).equals("")) {
                vector.removeElementAt(vector.size() - 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken(string3);
                if (!LicenseLine.isDelimiter(string4, string3)) {
                    stringBuffer.append(string4);
                    continue;
                }
                if (string4.equals("\\")) {
                    String string5 = stringTokenizer.nextToken(string3);
                    if (string5.equals("\"")) {
                        stringBuffer.append(string5);
                        continue;
                    }
                    stringBuffer.append(string4);
                    stringBuffer.append(string5);
                    continue;
                }
                vector.add(new String(stringBuffer));
                bl = true;
                break;
            }
            if (bl) continue;
            vector.add(new String(stringBuffer));
        }
        return vector;
    }

    private static boolean isDelimiter(String string, String string2) {
        return string2.indexOf(string) != -1;
    }

    protected void findPositionalsAndKeywordValues(String[] stringArray) {
        int n = this.nextKeywordPosition(stringArray, 0);
        if (n == -1) {
            this.setPositionalParameters(0, this.tokens.size());
        } else {
            this.setPositionalParameters(0, n);
            this.keywordParameters = new Hashtable();
            int n2 = n;
            do {
                String string;
                if ((string = this.tokenAfter(n2)) == null) {
                    this.keywordParameters.put(this.tokens.elementAt(n2), "");
                    break;
                }
                if (string.equals("=")) {
                    String string2 = this.tokenAfter(n2 + 1);
                    if (string2 == null) {
                        throw new RuntimeException("bad tokens:\n" + this.toString());
                    }
                    this.keywordParameters.put(this.tokens.elementAt(n2), LicenseElement.normalizeWhitespace(string2, true));
                    continue;
                }
                this.keywordParameters.put(this.tokens.elementAt(n2), "");
            } while ((n2 = this.nextKeywordPosition(stringArray, n2 + 1)) != -1);
        }
    }

    private String tokenAfter(int n) {
        if (n + 1 >= this.tokens.size()) {
            return null;
        }
        return (String)this.tokens.elementAt(n + 1);
    }

    private int nextKeywordPosition(String[] stringArray, int n) {
        if (stringArray != null && n < this.tokens.size() - 1) {
            for (int i = n; i < this.tokens.size(); ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!((String)this.tokens.elementAt(i)).equals(stringArray[j])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void setPositionalParameters(int n, int n2) {
        this.positionalParameters = new Vector();
        int n3 = n;
        while (n3 < n2) {
            String string;
            String string2 = (String)this.tokens.elementAt(n3);
            if (this.tokens.size() > n3 + 1) {
                String string3 = (String)this.tokens.elementAt(n3 + 1);
                if (string3.equals("=") && this.tokens.size() > n3 + 2) {
                    string = string2 + "=" + (String)this.tokens.elementAt(n3 + 2);
                    n3 += 3;
                } else {
                    string = string2;
                    ++n3;
                }
            } else {
                string = string2;
                ++n3;
            }
            string = LicenseElement.normalizeWhitespace(string, true);
            this.positionalParameters.add(string);
        }
    }

    protected Vector getPositionalParameters() {
        return this.positionalParameters;
    }

    protected Hashtable getKeywordParameters() {
        return this.keywordParameters;
    }

    public String toString() {
        return "LicenseLine{\nline=" + this.getLine() + "\ntokens=" + this.tokenString() + "\nlineNumber=" + this.getLineNumber() + "\nfilename=" + (this.filename == null ? "null" : this.filename) + "\ntype=" + this.typeString() + "\npositionalParameters=" + this.positionalParametersString() + "\nkeywordParameters=" + this.keywordParametersString() + "\n}";
    }

    private String keywordParametersString() {
        if (this.keywordParameters == null) {
            return "none";
        }
        return this.keywordParameters.toString();
    }

    private String dumpStringVector(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return "none";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append("  " + (String)vector.elementAt(i) + "\n");
        }
        return new String(stringBuffer);
    }

    private String positionalParametersString() {
        if (this.positionalParameters == null) {
            return "none";
        }
        return this.dumpStringVector(this.positionalParameters);
    }

    private String tokenString() {
        return this.dumpStringVector(this.tokens);
    }

    private String typeString() {
        if (this.type == 1) {
            return "SERVER";
        }
        if (this.type == 2) {
            return "VENDOR";
        }
        if (this.type == 3) {
            return "PACKAGE";
        }
        if (this.type == 4) {
            return "FEATURE";
        }
        if (this.type == 6) {
            return "USE_SERVER";
        }
        if (this.type == 0) {
            return "UNKNOWN";
        }
        return "undefined type: " + this.type;
    }
}

