/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.licsource;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FeatureUsage;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.Heartbeat;
import com.macrovision.flexlm.HeartbeatEvent;
import com.macrovision.flexlm.HeartbeatListener;
import com.macrovision.flexlm.HostId;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.LicenseSource;
import com.macrovision.flexlm.ServerInfo;
import com.macrovision.flexlm.Userdata;
import com.macrovision.flexlm.Userlist;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.comm.CheckinMessage;
import com.macrovision.flexlm.comm.CheckoutMessage;
import com.macrovision.flexlm.comm.ClockSettingsMessage;
import com.macrovision.flexlm.comm.CommRev;
import com.macrovision.flexlm.comm.CommRev3;
import com.macrovision.flexlm.comm.CommRev4;
import com.macrovision.flexlm.comm.FeatAvailRespMessage;
import com.macrovision.flexlm.comm.FeatBundleMessage;
import com.macrovision.flexlm.comm.ForceCheckinMessage;
import com.macrovision.flexlm.comm.GenericDaemonInfoMessage;
import com.macrovision.flexlm.comm.HandshakeMessage;
import com.macrovision.flexlm.comm.HeartbeatMessage;
import com.macrovision.flexlm.comm.HeartbeatResponseMessage;
import com.macrovision.flexlm.comm.HelloMessage;
import com.macrovision.flexlm.comm.HostIdMessage;
import com.macrovision.flexlm.comm.LicenseFileDataMessage;
import com.macrovision.flexlm.comm.Message;
import com.macrovision.flexlm.comm.NUsersMessage;
import com.macrovision.flexlm.comm.NeedHostIdMessage;
import com.macrovision.flexlm.comm.NewReportlogMessage;
import com.macrovision.flexlm.comm.OKMessage;
import com.macrovision.flexlm.comm.QueuedMessage;
import com.macrovision.flexlm.comm.ReplyOkChkoutMessage;
import com.macrovision.flexlm.comm.RereadMessage;
import com.macrovision.flexlm.comm.SendLicenseFileDataMessage;
import com.macrovision.flexlm.comm.SendLogMessage;
import com.macrovision.flexlm.comm.ShutdownMessage;
import com.macrovision.flexlm.comm.SimpleMessage;
import com.macrovision.flexlm.comm.SwitchDebuglogMessage;
import com.macrovision.flexlm.comm.SwitchReportlogMessage;
import com.macrovision.flexlm.comm.TryAnotherMessage;
import com.macrovision.flexlm.comm.UserlistMessage;
import com.macrovision.flexlm.comm.Username2Message;
import com.macrovision.flexlm.comm.UsernameMessage;
import com.macrovision.flexlm.comm.VDInfoMessage;
import com.macrovision.flexlm.comm.VdCapacityMessageResp;
import com.macrovision.flexlm.comm.WhatMessage;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.FlexlmVersion;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseGroup;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import com.macrovision.flexlm.misc.FlexlmQueuedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class LicenseServer
extends LicenseSource
implements FlexlmConstants,
FlexlmInternalConstants,
Heartbeat {
    private static final boolean DEBUG_COMM = System.getProperty("FLEXLM_JAVA_DEBUG_COMM") != null;
    private static final boolean DEBUG_HEARTBEAT = System.getProperty("FLEXLM_JAVA_DEBUG_HEARTBEAT") != null;
    private static final boolean ALLOW_SHORT_INTERVALS = System.getProperty("FLEXLM_JAVA_ALLOW_SHORT_INTERVALS") != null;
    private static int SOCKET_READ_TIMEOUT = 20000;
    private boolean heartbeatBlocked;
    private int heartbeatInterval;
    private int retryInterval;
    private int retryLimit;
    private int unAckHeartbeatCount;
    private HeartbeatListener[] heartbeatListeners;
    private long previousHeartbeatSentTime;
    private long latestHeartbeatSentTime;
    private long latestHeartbeatReceivedTime;
    private Thread autoHeartbeatThread;
    private boolean stopHeartbeatFlag;
    private Vector reconnectTimes;
    private Vector licensesToReconnect;
    private int retryAttempts;
    private VendorInfo vInfo;
    private String vendor;
    private boolean isLmgrd;
    private String portAtHost;
    private String[] hostnames;
    private int[] ports;
    private String connectedHostname;
    private int connectedPort;
    private boolean connected;
    private boolean defaultPorts;
    private Socket socket;
    private InputStream inStream;
    private OutputStream outStream;
    private int encryption;
    private boolean handshakeInProgress;
    private long lastHeartbeatResponseTime;
    private Vector receiveMessageQueue;
    private Vector featureAvailableMessageQueue;
    private boolean doHandshake;
    private CommRev commRev;
    private String masterHostname;
    private boolean hadTryAnother;
    private int serverVersion;
    private int serverRevision;
    private String serverPatch;

    public int setTimeout(int n) {
        SOCKET_READ_TIMEOUT = n;
        return SOCKET_READ_TIMEOUT;
    }

    public LicenseServer(String string, VendorInfo vendorInfo, ConnectionData connectionData) throws FlexlmException {
        String string2;
        if (LicenseServer.hasWhite(string) || string.indexOf("@") < 0 || string.length() <= 1) {
            throw new FlexlmException(-14, 3032);
        }
        int n = string.indexOf("&");
        if (n != -1) {
            throw new FlexlmException(-526, 3079, string);
        }
        this.portAtHost = string;
        super.setConnData(connectionData);
        if (string.indexOf(",") >= 0) {
            String[] stringArray = this.splitString(string, ",");
            if (stringArray.length != 3) {
                throw new FlexlmException(-14, 3033);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = this.parsePort(stringArray[i]);
                String string3 = LicenseServer.replaceThisHost(this.parseHostname(stringArray[i]));
                this.setRedundantPortAndHost(i, n2, string3);
            }
            this.init(vendorInfo);
            return;
        }
        int n3 = this.parsePort(string);
        this.masterHostname = string2 = LicenseServer.replaceThisHost(this.parseHostname(string));
        this.setPortAndHost(n3, string2);
        this.init(vendorInfo);
    }

    private String[] splitString(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    protected void setVendorName(String string) {
        this.vendor = string;
        if (this.vendor == null || this.vendor.length() < 1) {
            this.isLmgrd = true;
        }
    }

    private int parsePort(String string) throws FlexlmException {
        int n = string.indexOf(64);
        if (n <= 0) {
            return 0;
        }
        try {
            return Integer.parseInt(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FlexlmException(-500, 3034);
        }
    }

    private String parseHostname(String string) {
        int n = string.indexOf(64);
        return string.substring(n + 1);
    }

    protected void setPortAndHost(int n, String string) {
        this.hostnames = new String[1];
        this.ports = new int[1];
        this.hostnames[0] = string;
        this.ports[0] = n;
    }

    protected void setRedundantPortAndHost(int n, int n2, String string) {
        if (n == 0) {
            this.hostnames = new String[3];
            this.ports = new int[3];
        }
        this.hostnames[n] = string;
        this.ports[n] = n2;
    }

    private static boolean hasWhite(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String replaceThisHost(String string) {
        String string2 = string.equalsIgnoreCase("this_host") ? "localhost" : string;
        return string2;
    }

    protected void init(VendorInfo vendorInfo) {
        this.vInfo = vendorInfo;
        this.vendor = vendorInfo.getVendorName();
        this.heartbeatInterval = 120;
        this.retryInterval = 60;
        this.retryLimit = 5;
        this.heartbeatListeners = new HeartbeatListener[0];
        this.reconnectTimes = new Vector();
        this.receiveMessageQueue = new Vector();
        this.featureAvailableMessageQueue = new Vector();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void connect() throws FlexlmException {
        String string;
        Message message;
        if (this.connected) {
            return;
        }
        IOException iOException = null;
        int n = 0;
        String string2 = this.hostnames[0];
        String string3 = null;
        int n2 = -1;
        HelloMessage helloMessage = this.createHelloMessage(3);
        String string4 = System.getProperty("FLEXLM_TIMEOUT");
        try {
            int n3 = Integer.parseInt(string4);
            if (n3 > 0) {
                SOCKET_READ_TIMEOUT = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (true) {
            Object object;
            if (n2 < 0) {
                n2 = this.ports[n];
                if (n2 == 0) {
                    this.defaultPorts = true;
                    n2 = 27000;
                } else {
                    this.defaultPorts = false;
                }
            }
            if (DEBUG_COMM) {
                System.out.println("Try connecting to " + n2 + "@" + string2);
            }
            try {
                this.socket = new Socket();
                this.socket.bind(null);
                object = new InetSocketAddress(string2, n2);
                this.socket.connect((SocketAddress)object, SOCKET_READ_TIMEOUT);
                this.socket.setSoTimeout(SOCKET_READ_TIMEOUT);
                this.inStream = this.socket.getInputStream();
                this.outStream = this.socket.getOutputStream();
                if (DEBUG_COMM) {
                    System.out.println("Connected to socket " + n2 + "@" + string2);
                }
                helloMessage.send(this.outStream, 0, CommRev3.getInstance());
                message = Message.receive(this.inStream);
            }
            catch (UnknownHostException unknownHostException) {
                if (string3 != null) {
                    string2 = string3;
                    string3 = null;
                    continue;
                }
                iOException = unknownHostException;
                message = null;
            }
            catch (IOException iOException2) {
                message = null;
                iOException = iOException2;
            }
            if (message != null) {
                int n4;
                if (message.getType() == 65561) {
                    int n5;
                    object = (OKMessage)message;
                    this.serverVersion = ((OKMessage)object).getFlexVer();
                    this.serverRevision = ((OKMessage)object).getFlexRev();
                    this.serverPatch = ((OKMessage)object).getFlexPatch();
                    n4 = this.connectionData.getCommunicationsRevision();
                    if (n4 == 3) {
                        n5 = 3;
                    } else {
                        if (n4 != 4) throw new FlexlmException(-12, 3094);
                        byte by = ((OKMessage)object).getCommRev();
                        if (by == 3) {
                            n5 = 3;
                        } else {
                            if (by != 4) throw new FlexlmException(-12, 3093);
                            if (helloMessage.hasLongnames()) {
                                helloMessage = this.createHelloMessage(4);
                                try {
                                    helloMessage.send(this.outStream, 0, CommRev4.getInstance());
                                    message = Message.receive(this.inStream);
                                }
                                catch (IOException iOException3) {
                                    throw new FlexlmException(-12, 3096);
                                }
                                if (message.getType() != 65561) {
                                    throw new FlexlmException(-12, 3095);
                                }
                            }
                            n5 = 4;
                        }
                    }
                    this.commRev = n5 == 3 ? CommRev3.getInstance() : CommRev4.getInstance();
                    this.connectedHostname = string2;
                    this.connectedPort = n2;
                    this.connected = true;
                    if (!DEBUG_COMM) return;
                    System.out.println("Connection completed to " + this.connectedPort + "@" + this.connectedHostname);
                    return;
                }
                if (message.getType() == 65553) {
                    this.closeSocket();
                    object = (TryAnotherMessage)message;
                    if (this.isIp(string2)) {
                        string3 = string2;
                    }
                    string = ((TryAnotherMessage)object).getHost();
                    n4 = 1;
                    this.masterHostname = string;
                    if (!this.isIp(string2) && this.areHostnamesEqual(string2, string)) {
                        string = string2;
                    }
                    if (!this.hadTryAnother) {
                        this.hadTryAnother = true;
                        String string5 = string2;
                        if (string5.equalsIgnoreCase("localhost")) {
                            InetAddress inetAddress = null;
                            try {
                                inetAddress = InetAddress.getLocalHost();
                            }
                            catch (UnknownHostException unknownHostException) {
                                throw new FlexlmException(-12, 3098);
                            }
                            string5 = inetAddress.getHostName();
                        }
                        if (!this.areHostnamesEqual(string5, string)) {
                            n4 = 0;
                        }
                    }
                    string2 = string;
                    n2 = ((TryAnotherMessage)object).getPort();
                    if (n4 == 0) {
                        for (int i = 0; i < this.hostnames.length; ++i) {
                            if (!this.areHostnamesEqual(string, this.hostnames[i])) continue;
                            n2 = this.ports[i];
                            n4 = 1;
                            this.hadTryAnother = false;
                            break;
                        }
                    }
                    if (n2 == 0) {
                        this.defaultPorts = true;
                        n2 = 27000;
                    } else {
                        this.defaultPorts = false;
                    }
                    message = null;
                    continue;
                }
                if (message.getType() == 65570) {
                    this.closeSocket();
                    message = null;
                } else if (message.getType() == 65552) {
                    this.closeSocket();
                } else if (message.getType() == 65889) {
                    this.closeSocket();
                } else {
                    this.closeSocket();
                    throw new FlexlmException(-12, 3004);
                }
            }
            if (this.defaultPorts && ++n2 <= 27009) continue;
            if (++n >= this.hostnames.length) break;
            string2 = this.hostnames[n];
            n2 = -1;
        }
        int n6 = -15;
        string = null;
        if (message != null && message.getType() == 65552) {
            n6 = ((WhatMessage)message).getParameter();
        }
        if (message != null && message.getType() == 65889) {
            n6 = ((VdCapacityMessageResp)message).getParameter();
            throw new FlexlmException(n6, 3108);
        }
        if (iOException == null) throw new FlexlmException(n6, 3002, string);
        string = iOException.getMessage();
        throw new FlexlmException(n6, 3002, string);
    }

    private boolean areHostnamesEqual(String string, String string2) {
        if (this.isIp(string)) {
            return string.equalsIgnoreCase(string2);
        }
        int n = string.indexOf(".");
        String string3 = n > 0 ? string.substring(0, n) : string;
        int n2 = string2.indexOf(".");
        String string4 = n2 > 0 ? string2.substring(0, n2) : string2;
        return string3.equalsIgnoreCase(string4);
    }

    private boolean isIp(String string) {
        HostId hostId = HostId.parseHostId("INTERNET=" + string, this.vInfo);
        return hostId != null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private synchronized void reconnectLicenses(boolean bl) {
        if (this.licensesToReconnect == null || this.licensesToReconnect.size() == 0) {
            this.retryAttempts = 0;
            if (!this.connected) {
                this.stopHeartbeat();
            }
            return;
        }
        Object[] objectArray = new License[this.licensesToReconnect.size()];
        this.licensesToReconnect.copyInto(objectArray);
        int n = ++this.retryAttempts;
        int n2 = this.getRetryLimit();
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (FlexlmException flexlmException) {
                // empty catch block
            }
        }
        if (this.connected) {
            this.recordReconnect();
            this.retryAttempts = 0;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl2;
            Object object;
            block14: {
                object = objectArray[i];
                bl2 = false;
                try {
                    if (this.connected) {
                        ((License)object).reconnect(false);
                        bl2 = true;
                    }
                }
                catch (FlexlmException flexlmException) {
                    if (!DEBUG_COMM) break block14;
                    System.out.println("license.reconnect failed for " + ((License)object).getFeatureSpecifier().getName() + ": " + flexlmException.getMessage());
                }
            }
            if (bl2) {
                this.licensesToReconnect.remove(object);
                if (!bl) continue;
                this.fireReconnectSucceeded((License)object, n);
                continue;
            }
            if (n >= n2 || this.connected) {
                Feature feature = ((License)object).getFeature();
                try {
                    ((License)object).checkin();
                }
                catch (FlexlmException flexlmException) {
                    // empty catch block
                }
                if (!bl) continue;
                this.fireReconnectFailed((License)object, feature, n);
                continue;
            }
            if (!bl) continue;
            this.fireReconnectAttempted((License)object, n);
        }
    }

    protected void recordReconnect() {
        long l = new Date().getTime();
        this.reconnectTimes.addElement(new Long(l));
    }

    public boolean originalIsMaster() {
        return this.isMaster(this.hostnames[0]);
    }

    public boolean isMaster(String string) {
        return this.areHostnamesEqual(this.masterHostname, string);
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public int getServerRevision() {
        return this.serverRevision;
    }

    public String getServerPatch() {
        return this.serverPatch;
    }

    @Override
    public String[] getFeatureList(String string) throws FlexlmException {
        if (this.connected && !this.vendor.equals(string)) {
            throw new FlexlmException(-522, 3085);
        }
        this.vendor = string;
        String string2 = this.getLfData(new VDInfoMessage());
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    @Override
    public String[] getFeatureList() throws FlexlmException {
        return this.getFeatureList(this.vendor);
    }

    private Feature[] getAnyFeatureDetails(String string, boolean bl) throws FlexlmException {
        Feature[] featureArray = null;
        LinkedList linkedList = this.getUnauthenticated(string);
        LinkedList<Feature> linkedList2 = new LinkedList<Feature>();
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            FeatureLine featureLine = (FeatureLine)listIterator.next();
            if (bl) {
                if ((featureLine = this.getAuthenticated(featureLine.getName(), featureLine.getFeatureIdentifier())) == null) continue;
                try {
                    LicenseSource.checkFeatureEnvironmentals(featureLine, this.vInfo, this.connectionData, null);
                }
                catch (FlexlmException flexlmException) {
                    continue;
                }
            }
            linkedList2.add(featureLine.createFeature(this));
        }
        if (linkedList2.size() > 0) {
            featureArray = linkedList2.toArray(new Feature[linkedList2.size()]);
        }
        return featureArray;
    }

    protected Feature[] getUnauthFeatureDetails(String string) throws FlexlmException {
        return this.getAnyFeatureDetails(string, false);
    }

    @Override
    public Feature[] getFeatureDetails(String string) throws FlexlmException {
        return this.getAnyFeatureDetails(string, true);
    }

    @Override
    protected Feature checkout(FeatureSpecifier featureSpecifier, int n, int n2, int n3, byte[] byArray, int n4, License license) throws FlexlmException {
        this.checkForDuplicateLicenses(license, featureSpecifier, byArray);
        this.doHandshake = true;
        try {
            Feature feature;
            while ((feature = this.tryCheckout(featureSpecifier, n, n2, n3, byArray, n4, license)) == null) {
            }
            return feature;
        }
        catch (FlexlmException flexlmException) {
            if (1 == n3) {
                this.removeQueuedLicense(license);
            }
            if (this.getCheckedOutLicenseCount() == 0 && this.getQueuedLicenseCount() == 0) {
                this.closeSocket();
            }
            throw flexlmException;
        }
    }

    private synchronized void checkForDuplicateLicenses(License license, FeatureSpecifier featureSpecifier, byte[] byArray) throws FlexlmException {
        Vector vector = super.getCheckedOutLicenses();
        if (vector != null) {
            String string = featureSpecifier.getName();
            for (int i = 0; i < vector.size(); ++i) {
                License license2 = (License)vector.elementAt(i);
                if (license2.equals(license) || !string.equals(license2.getFeatureSpecifier().getName()) || !Arrays.equals(byArray, license2.getCheckoutData())) continue;
                throw new FlexlmException(-518, 3048);
            }
        }
    }

    private synchronized Feature tryCheckout(FeatureSpecifier featureSpecifier, int n, int n2, int n3, byte[] byArray, int n4, License license) throws FlexlmException {
        Message message;
        Message message2;
        String string = featureSpecifier.getName();
        String string2 = featureSpecifier.getVersion();
        String string3 = featureSpecifier.getFeatureIdentifier();
        String string4 = license.getipaddress();
        String string5 = System.getenv("LM_PROJECT");
        if (string5 != null) {
            message2 = new ClockSettingsMessage();
            ((ClockSettingsMessage)message2).setClockSettingProject(string5);
            this.sendMessage(message2);
            message = this.receiveMessage();
            int n5 = message.getType();
            switch (n5) {
                case 65561: {
                    break;
                }
                default: {
                    throw new FlexlmException(-12, 3106);
                }
            }
        }
        message2 = new CheckoutMessage(string, string2, n, string3);
        ((CheckoutMessage)message2).setQueueMode(n3);
        if (byArray != null) {
            ((CheckoutMessage)message2).setCheckoutData(byArray);
        }
        ((CheckoutMessage)message2).setDupGroup(n2);
        if (n4 != 0) {
            ((CheckoutMessage)message2).setLinger(n4);
        }
        if (string4 != null) {
            ((CheckoutMessage)message2).setipaddress(string4);
        }
        this.sendMessage(message2);
        message = this.receiveMessage();
        Feature feature = null;
        int n6 = message.getType();
        switch (n6) {
            case 65576: {
                feature = this.checkoutOK((ReplyOkChkoutMessage)message, license);
                this.addCheckedOutLicense(license);
                this.removeQueuedLicense(license);
                license.setEffectiveLicenseSource(this);
                this.setupHeartbeat(license);
                break;
            }
            case 65567: {
                this.processNeedHostId((NeedHostIdMessage)message);
                break;
            }
            case 65564: {
                throw new FlexlmException(-4, 3022);
            }
            case 65570: {
                throw new FlexlmException(-5, 3023);
            }
            case 65554: {
                throw new FlexlmException(-20, 3024);
            }
            case 65555: {
                throw new FlexlmException(-23, 3025);
            }
            case 65552: {
                int n7 = ((WhatMessage)message).getParameter();
                if (n7 == -18) {
                    n7 = -5;
                }
                throw new FlexlmException(n7, 3027);
            }
            case 65566: {
                this.addQueuedLicense(license);
                if (2 == n3) {
                    this.setupHeartbeat(license);
                }
                feature = this.processQueuedFeature(n3, string, (QueuedMessage)message);
                if (1 != n3) break;
                this.addCheckedOutLicense(license);
                this.removeQueuedLicense(license);
                license.setEffectiveLicenseSource(this);
                this.setupHeartbeat(license);
                break;
            }
            default: {
                throw new FlexlmException(-506, 3012);
            }
        }
        return feature;
    }

    @Override
    public synchronized void checkin(License license) throws FlexlmException {
        int n;
        if (this.licensesToReconnect != null && this.licensesToReconnect.indexOf(license) >= 0) {
            this.licensesToReconnect.remove(license);
            if (this.getCheckedOutLicenseCount() == 0 && this.getQueuedLicenseCount() == 0 && this.getLicensesToReconnectCount() == 0) {
                this.stopHeartbeat();
            }
            return;
        }
        Feature feature = license.getFeature();
        String string = feature.getName();
        String string2 = feature.getFeatureIdentifier();
        CheckinMessage checkinMessage = new CheckinMessage(string, string2);
        byte[] byArray = license.getCheckoutData();
        if (byArray != null) {
            checkinMessage.setCheckoutData(byArray);
        }
        FlexlmException flexlmException = null;
        Message message = null;
        try {
            this.sendMessage(checkinMessage);
            message = this.receiveMessage();
        }
        catch (FlexlmException flexlmException2) {
            flexlmException = flexlmException2;
        }
        if (flexlmException == null && (n = message.getType()) != 65561) {
            flexlmException = new FlexlmException(-22, 3020);
        }
        this.removeCheckedOutLicense(license);
        if (this.getCheckedOutLicenseCount() == 0 && this.getQueuedLicenseCount() == 0 && this.getLicensesToReconnectCount() == 0) {
            this.stopHeartbeat();
            this.closeSocket();
        }
        if (flexlmException != null) {
            throw flexlmException;
        }
    }

    @Override
    public FeatureUsage getFeatureUsage(FeatureSpecifier featureSpecifier) throws FlexlmException {
        return this.getFeatureUsage(featureSpecifier, this.vendor);
    }

    @Override
    public synchronized FeatureUsage getFeatureUsage(FeatureSpecifier featureSpecifier, String string) throws FlexlmException {
        if (this.connected && !this.vendor.equals(string)) {
            throw new FlexlmException(-522, 3086);
        }
        this.vendor = string;
        if (featureSpecifier == null || featureSpecifier.getName() == null) {
            throw new FlexlmException(-42, 3054);
        }
        if (featureSpecifier.getFeatureIdentifier() == null) {
            if (featureSpecifier.getVersion() == null) {
                throw new FlexlmException(-42, 3055);
            }
            Feature[] featureArray = this.getUnauthFeatureDetails(featureSpecifier.getName());
            FlexlmVersion flexlmVersion = new FlexlmVersion(featureSpecifier.getVersion());
            FeatureUsage featureUsage = new FeatureUsage(featureSpecifier.getName(), featureSpecifier.getFeatureIdentifier());
            if (featureArray != null) {
                for (int i = 0; i < featureArray.length; ++i) {
                    int n = featureArray[i].getVersionObject().compareTo(flexlmVersion);
                    if (n < 0) continue;
                    featureUsage.addUsage(this.getFeatureUsage(new FeatureSpecifier(featureArray[i])), featureArray[i]);
                }
            }
            if (featureUsage.getFeatures() == null) {
                featureUsage = null;
            }
            return featureUsage;
        }
        VDInfoMessage vDInfoMessage = new VDInfoMessage(featureSpecifier.getName(), featureSpecifier.getFeatureIdentifier(), 106);
        this.sendMessage(vDInfoMessage);
        Message message = this.receiveMessage();
        int n = message.getType();
        if (n != 65563 && n != 65552) {
            throw new FlexlmException(-506, 3087);
        }
        FeatureUsage featureUsage = null;
        if (n == 65563) {
            FeatBundleMessage featBundleMessage = (FeatBundleMessage)message;
            Feature[] featureArray = this.getUnauthFeatureDetails(featureSpecifier.getName());
            Feature feature = null;
            for (int i = 0; i < featureArray.length; ++i) {
                if (!featureArray[i].getFeatureIdentifier().equalsIgnoreCase(featureSpecifier.getFeatureIdentifier())) continue;
                feature = featureArray[i];
                break;
            }
            if (feature == null) {
                // empty if block
            }
            featureUsage = new FeatureUsage(featureSpecifier.getName(), featureSpecifier.getFeatureIdentifier(), feature, featBundleMessage.getRev(), featBundleMessage.getTimeout(), featBundleMessage.getLinger(), featBundleMessage.getDupGroup(), featBundleMessage.getReserved(), featBundleMessage.getTotalInUse(), featBundleMessage.getFloatInUse(), featBundleMessage.getUserCount(), featBundleMessage.getNumLicenses(), featBundleMessage.getQueuedCount(), featBundleMessage.getOverdraft());
        }
        return featureUsage;
    }

    @Override
    public synchronized ServerInfo getServerInfo() throws FlexlmException {
        VDInfoMessage vDInfoMessage = new VDInfoMessage(null, null, 105);
        this.sendMessage(vDInfoMessage);
        Message message = this.receiveMessage();
        if (message.getType() != 65565) {
            throw new FlexlmException(-506, 3060);
        }
        GenericDaemonInfoMessage genericDaemonInfoMessage = (GenericDaemonInfoMessage)message;
        return new ServerInfo(genericDaemonInfoMessage.getMinUserTimeout(), genericDaemonInfoMessage.getMinLmRemoveInterval(), genericDaemonInfoMessage.getCompareOnIncrement(), genericDaemonInfoMessage.getCompareOnUpgrade(), genericDaemonInfoMessage.getDaemonVersion(), genericDaemonInfoMessage.getDaemonRevision(), genericDaemonInfoMessage.getLmgrdStart(), genericDaemonInfoMessage.getVendorDaemonStart(), genericDaemonInfoMessage.getServerTime());
    }

    public Userlist getUserlist(String string) throws FlexlmException {
        return this.getUserlist(this.vendor, string);
    }

    @Override
    public synchronized Userlist getUserlist(String string, String string2) throws FlexlmException {
        Userlist userlist = null;
        if (this.connected && !this.vendor.equals(string)) {
            throw new FlexlmException(-522, 3064);
        }
        this.vendor = string;
        Feature[] featureArray = this.getUnauthFeatureDetails(string2);
        if (featureArray == null) {
            return null;
        }
        Vector<Userdata> vector = new Vector<Userdata>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < featureArray.length; ++i) {
            UserlistMessage userlistMessage = new UserlistMessage(featureArray[i].getName(), featureArray[i].getFeatureIdentifier());
            this.sendMessage(userlistMessage);
            Message message = this.receiveMessage();
            if (message.getType() != 65564) {
                throw new FlexlmException(-506, 3062);
            }
            NUsersMessage nUsersMessage = (NUsersMessage)message;
            int n3 = nUsersMessage.getNUsers();
            n += nUsersMessage.getNLicenses();
            byte[] byArray = null;
            while (n3 > 0) {
                Message message2 = this.receiveMessage();
                if (message2.getType() == 65569) {
                    Userdata userdata = LicenseServer.createUserData((UsernameMessage)message2, featureArray[i], byArray);
                    byArray = null;
                    vector.add(userdata);
                    n2 += userdata.getCount();
                    --n3;
                    continue;
                }
                if (message2.getType() == 65568) {
                    byArray = ((Username2Message)message2).getCheckoutData();
                    continue;
                }
                throw new FlexlmException(-506, 3063);
            }
        }
        if (featureArray.length > 0) {
            Userdata[] userdataArray = null;
            if (vector.size() > 0) {
                userdataArray = vector.toArray(new Userdata[vector.size()]);
            }
            userlist = new Userlist(userdataArray, string2, n, n2);
        }
        return userlist;
    }

    private static Userdata createUserData(UsernameMessage usernameMessage, Feature feature, byte[] byArray) {
        Userdata userdata = new Userdata(feature, usernameMessage.getName(), usernameMessage.getNode(), usernameMessage.getDisplay(), byArray, usernameMessage.getNumLicenses(), usernameMessage.getTime(), usernameMessage.getVersion(), usernameMessage.getLinger(), usernameMessage.getHandle(), usernameMessage.getFlags());
        return userdata;
    }

    @Override
    public synchronized void forceCheckin(String string, String string2, String string3, String string4) throws FlexlmException {
        ForceCheckinMessage forceCheckinMessage = new ForceCheckinMessage(string, string2, string3, string4);
        this.sendMessage(forceCheckinMessage);
        this.handleForceResponse(this.receiveMessage());
    }

    @Override
    public synchronized void forceCheckin(String string, int n) throws FlexlmException {
        ForceCheckinMessage forceCheckinMessage = new ForceCheckinMessage(string, n);
        this.sendMessage(forceCheckinMessage);
        this.handleForceResponse(this.receiveMessage());
    }

    private void handleForceResponse(Message message) throws FlexlmException {
        switch (message.getType()) {
            case 65561: {
                break;
            }
            case 65558: {
                throw new FlexlmException(-63, 3066);
            }
            case 65566: {
                throw new FlexlmException(-35, 3067);
            }
            case 65570: {
                throw new FlexlmException(-5, 3068);
            }
            case 65560: {
                throw new FlexlmException(-523, 3069);
            }
            case 65559: {
                throw new FlexlmException(-64, 3070);
            }
            default: {
                throw new FlexlmException(-506, 3071);
            }
        }
    }

    public void shutdownVendor(String string, boolean bl) throws FlexlmException {
        this.shutdown(string, bl);
    }

    public void shutdownVendor(String string) throws FlexlmException {
        this.shutdown(string, false);
    }

    @Override
    public void shutdownServer() throws FlexlmException {
        this.shutdown(null, false);
    }

    public void shutdownServer(boolean bl) throws FlexlmException {
        this.shutdown(null, bl);
    }

    private synchronized void shutdown(String string, boolean bl) throws FlexlmException {
        if (this.connected) {
            throw new FlexlmException(-525, 3078);
        }
        this.vendor = null;
        this.connect();
        ShutdownMessage shutdownMessage = new ShutdownMessage(this.connectionData.getUsername(), this.connectionData.getHostname(), string);
        if (bl) {
            shutdownMessage.setForce(true);
        }
        try {
            this.socket.setSoTimeout(60000 + SOCKET_READ_TIMEOUT);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.sendMessage(shutdownMessage);
        Message message = this.receiveMessage();
        try {
            this.socket.setSoTimeout(SOCKET_READ_TIMEOUT);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        switch (message.getType()) {
            case 65561: {
                break;
            }
            case 65558: {
                throw new FlexlmException(-63, 3074);
            }
            case 65570: {
                throw new FlexlmException(-63, 3075);
            }
            default: {
                throw new FlexlmException(-524, 3076);
            }
        }
        this.finalize();
    }

    public void switchReportLog(String string) throws FlexlmException {
        this.switchReportLog(string, this.vendor);
    }

    public synchronized void switchReportLog(String string, String string2) throws FlexlmException {
        if (this.connected && !this.vendor.equals(string2)) {
            throw new FlexlmException(-522, 3089);
        }
        this.vendor = string2;
        SwitchReportlogMessage switchReportlogMessage = new SwitchReportlogMessage(string);
        this.sendMessage(switchReportlogMessage);
        Message message = this.receiveMessage();
        this.handleSwitchResponse(message);
    }

    public synchronized void sendLog(String string) throws FlexlmException {
        if (this.connected && string.length() <= 0) {
            throw new FlexlmException(-42, 3107);
        }
        SendLogMessage sendLogMessage = new SendLogMessage(string);
        this.sendMessage(sendLogMessage);
    }

    public void newReportLog(String string) throws FlexlmException {
        this.newReportLog(string, this.vendor);
    }

    public synchronized void newReportLog(String string, String string2) throws FlexlmException {
        if (this.connected && !this.vendor.equals(string2)) {
            throw new FlexlmException(-522, 3090);
        }
        this.vendor = string2;
        NewReportlogMessage newReportlogMessage = new NewReportlogMessage(string);
        this.sendMessage(newReportlogMessage);
        Message message = this.receiveMessage();
        this.handleSwitchResponse(message);
    }

    public void switchDebugLog(String string) throws FlexlmException {
        this.switchDebugLog(string, this.vendor);
    }

    public synchronized void switchDebugLog(String string, String string2) throws FlexlmException {
        if (this.connected && !this.vendor.equals(string2)) {
            throw new FlexlmException(-522, 3091);
        }
        this.vendor = string2;
        SwitchDebuglogMessage switchDebuglogMessage = new SwitchDebuglogMessage(string);
        this.sendMessage(switchDebuglogMessage);
        Message message = this.receiveMessage();
        this.handleSwitchResponse(message);
    }

    private void handleSwitchResponse(Message message) throws FlexlmException {
        switch (message.getType()) {
            case 65561: {
                break;
            }
            case 65558: 
            case 65559: 
            case 65560: 
            case 65570: {
                SimpleMessage simpleMessage = (SimpleMessage)message;
                int n = simpleMessage.getIntData();
                if (n < 0 && n >= -92) {
                    throw new FlexlmException(n, 3083);
                }
                throw new FlexlmException(-527, 3084);
            }
            case 65552: {
                int n = ((WhatMessage)message).getParameter();
                if (n >= 0 || n < -92) break;
                throw new FlexlmException(n, 3101);
            }
            default: {
                throw new FlexlmException(-527, 3102);
            }
        }
    }

    public void rereadLicenses() throws FlexlmException {
        this.rereadLicenses("");
    }

    public synchronized void rereadLicenses(String string) throws FlexlmException {
        if (this.connected && !this.vendor.equals(string) && !this.isLmgrd) {
            throw new FlexlmException(-522, 3088);
        }
        if (!this.isLmgrd) {
            this.vendor = string;
        }
        RereadMessage rereadMessage = new RereadMessage(this.connectionData.getUsername(), this.connectionData.getHostname(), string);
        this.sendMessage(rereadMessage);
        Message message = this.receiveMessage();
        switch (message.getType()) {
            case 65561: {
                break;
            }
            case 65558: {
                throw new FlexlmException(-63, 3080);
            }
            case 65553: {
                throw new FlexlmException(-42, 3081);
            }
            default: {
                throw new FlexlmException(-12, 3082);
            }
        }
    }

    protected synchronized String getDaemonList() throws FlexlmException {
        String string = null;
        int n = this.commRev instanceof CommRev3 ? 3 : 4;
        SendLicenseFileDataMessage sendLicenseFileDataMessage = new SendLicenseFileDataMessage(1, n, this.connectionData.getUsername(), this.connectionData.getHostname(), this.connectionData.getDisplay(), "");
        sendLicenseFileDataMessage.setGetDaemonList();
        this.sendMessage(sendLicenseFileDataMessage);
        Message message = this.receiveMessage();
        switch (message.getType()) {
            case 65562: {
                LicenseFileDataMessage licenseFileDataMessage = (LicenseFileDataMessage)message;
                string = new String(licenseFileDataMessage.getLicenseFileData());
                break;
            }
            default: {
                throw new FlexlmException(-12, 3097);
            }
        }
        return string;
    }

    protected synchronized String getLicenseFilePaths() throws FlexlmException {
        String string = null;
        int n = this.commRev instanceof CommRev3 ? 3 : 4;
        SendLicenseFileDataMessage sendLicenseFileDataMessage = new SendLicenseFileDataMessage(1, n, this.connectionData.getUsername(), this.connectionData.getHostname(), this.connectionData.getDisplay(), "");
        sendLicenseFileDataMessage.setGetLicenseFilePaths();
        this.sendMessage(sendLicenseFileDataMessage);
        Message message = this.receiveMessage();
        switch (message.getType()) {
            case 65562: {
                LicenseFileDataMessage licenseFileDataMessage = (LicenseFileDataMessage)message;
                string = new String(licenseFileDataMessage.getLicenseFileData());
                break;
            }
            default: {
                throw new FlexlmException(-12, 3099);
            }
        }
        return string;
    }

    @Override
    public boolean checkoutQueued(FeatureSpecifier featureSpecifier) throws FlexlmException {
        boolean bl = false;
        try {
            FeatAvailRespMessage featAvailRespMessage = this.readFeatAvail(featureSpecifier.getName(), false);
            if (featAvailRespMessage == null) {
                bl = true;
            }
            return bl;
        }
        catch (FlexlmException flexlmException) {
            throw new FlexlmException(-16, 3109, flexlmException.getMessage());
        }
    }

    @Override
    public void enableDateSetbackDetection(boolean bl) {
    }

    private synchronized LinkedList getUnauthenticated(String string) throws FlexlmException {
        String string2 = null;
        LinkedList linkedList = new LinkedList();
        while (true) {
            String string3;
            String string4;
            String string5 = string4 = string2 == null ? "P=" : "P=" + string2;
            if (string2 != null && (string2.equalsIgnoreCase("ffffffff") || string2.equalsIgnoreCase("ffffffffffffffff")) || (string3 = this.getLfData(new VDInfoMessage(string, string4))).equalsIgnoreCase("NOMORE")) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            string2 = stringTokenizer.nextToken();
            String string6 = string3.substring(string2.length());
            LicenseCertificate licenseCertificate = null;
            try {
                licenseCertificate = new LicenseCertificate(new StringReader(string6), null, this.vInfo);
            }
            catch (IOException iOException) {
                throw new FlexlmException(-506, 3044);
            }
            linkedList.addAll(licenseCertificate.getFeatures());
            ListIterator listIterator = linkedList.listIterator(0);
            HashSet<String> hashSet = new HashSet<String>();
            while (listIterator.hasNext()) {
                FeatureLine featureLine = (FeatureLine)listIterator.next();
                if (hashSet.contains(featureLine.getFeatureIdentifier())) {
                    listIterator.remove();
                    continue;
                }
                hashSet.add(featureLine.getFeatureIdentifier());
            }
            linkedList.addAll(licenseCertificate.getUpgrades());
        }
        return linkedList;
    }

    private synchronized FeatureLine getAuthenticated(String string, String string2) throws FlexlmException {
        FeatureLine featureLine = null;
        String string3 = this.getLfData(new VDInfoMessage(string, string2));
        if (string3 == null) {
            return null;
        }
        string3 = this.addServerLine(string3);
        LicenseGroup licenseGroup = new LicenseGroup(new StringReader(string3), this.vInfo, true);
        FeatureLine[] featureLineArray = licenseGroup.getFeaturesAvailable();
        LinkedList linkedList = licenseGroup.getElementExceptions();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            FlexlmException flexlmException = (FlexlmException)listIterator.next();
            if (flexlmException.getMajor() != -514) continue;
            throw flexlmException;
        }
        if (featureLineArray != null) {
            for (int i = 0; i < featureLineArray.length; ++i) {
                if (!featureLineArray[i].getFeatureIdentifier().equals(string2)) continue;
                featureLine = featureLineArray[i];
                featureLineArray[i].setName(string);
                break;
            }
        }
        return featureLine;
    }

    protected void setupHeartbeat(License license) throws FlexlmException {
        if (this.autoHeartbeatThread != null) {
            return;
        }
        this.connectionData.initHeartbeat(this);
        this.startHeartbeat();
    }

    @Override
    public String getName() {
        return this.portAtHost;
    }

    private Feature checkoutOK(ReplyOkChkoutMessage replyOkChkoutMessage, License license) throws FlexlmException {
        FeatureLine featureLine;
        block8: {
            String string = replyOkChkoutMessage.getOldMsgRespBuf();
            if (string == null) {
                throw new FlexlmException(-506, 3013);
            }
            string = string.substring(2);
            LicenseCertificate licenseCertificate = null;
            try {
                licenseCertificate = new LicenseCertificate(new StringReader(string), null, this.vInfo);
            }
            catch (IOException iOException) {
                throw new FlexlmException(-506, 3045);
            }
            LinkedList linkedList = licenseCertificate.getFeatures();
            if (linkedList.size() == 0 && (linkedList = licenseCertificate.getUpgrades()).size() == 0) {
                throw new FlexlmException(-506, 3049);
            }
            FeatureLine featureLine2 = (FeatureLine)linkedList.getFirst();
            String string2 = featureLine2.getName();
            if (string2 == null) {
                throw new FlexlmException(-506, 3016);
            }
            String string3 = featureLine2.getFeatureIdentifier();
            featureLine = null;
            try {
                featureLine = this.getAuthenticated(string2, string3);
            }
            catch (FlexlmException flexlmException) {
                if (flexlmException.getMajor() != -514) break block8;
                throw flexlmException;
            }
        }
        if (featureLine == null) {
            throw new FlexlmException(-8, 3046);
        }
        Feature feature = featureLine.createFeature(this);
        return feature;
    }

    private Feature processQueuedFeature(int n, String string, QueuedMessage queuedMessage) throws FlexlmException {
        FeatureLine featureLine = this.getAuthenticated(string, queuedMessage.getFeatureIdentifier());
        if (featureLine == null) {
            throw new FlexlmException(-510, 3056);
        }
        Feature feature = featureLine.createFeature(this);
        if (n == 2) {
            throw new FlexlmQueuedException(-520, 3057, feature);
        }
        while (this.readFeatAvail(string, true) == null) {
        }
        return feature;
    }

    private String addServerLine(String string) {
        int n = string.indexOf("\n");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("SERVER this_host " + stringTokenizer.nextToken() + "\n");
        }
        stringBuffer.append(string3);
        return new String(stringBuffer);
    }

    private synchronized void processNeedHostId(NeedHostIdMessage needHostIdMessage) throws FlexlmException {
        String string = "NOMORE";
        int n = needHostIdMessage.getHostIdType();
        int n2 = needHostIdMessage.getOffset();
        HostId[] hostIdArray = HostId.getCurrentTypeHostIds(n, this.vInfo, this.connectionData);
        if (hostIdArray != null && n2 < hostIdArray.length) {
            string = hostIdArray[n2].toString();
        }
        HostIdMessage hostIdMessage = new HostIdMessage(n, string);
        this.sendMessage(hostIdMessage);
        Message message = this.receiveMessage();
        if (message.getType() != 65561) {
            throw new FlexlmException(-9, 3047);
        }
    }

    private synchronized void handshake(VendorInfo vendorInfo) throws FlexlmException {
        this.handshakeInProgress = true;
        HandshakeMessage handshakeMessage = LicenseServer.createHandshakeMessage(this.vInfo);
        this.sendMessage(handshakeMessage);
        Message message = this.receiveMessage();
        if (message.getType() != 65537) {
            this.handshakeInProgress = false;
            throw new FlexlmException(-12, 3021);
        }
        HandshakeMessage handshakeMessage2 = (HandshakeMessage)message;
        this.encryption = LicenseServer.getEncryption(handshakeMessage2, handshakeMessage);
        this.handshakeInProgress = false;
    }

    private static HandshakeMessage createHandshakeMessage(VendorInfo vendorInfo) {
        HandshakeMessage handshakeMessage = new HandshakeMessage();
        int[] nArray = vendorInfo.getEncryptionSeeds();
        int n = nArray[0] ^ nArray[1];
        handshakeMessage.setNewKey(n);
        handshakeMessage.setTime(System.currentTimeMillis() / 1000L);
        handshakeMessage.setCrypt('1');
        long l = System.currentTimeMillis() / 1000L & 0xFFFFFFFFFFFFFFFFL;
        Random random = new Random(l);
        long l2 = random.nextInt() ^ random.nextInt() << 8 ^ random.nextInt() << 16 ^ random.nextInt() << 24 & 0xFFFFFFFF;
        long l3 = random.nextInt() ^ random.nextInt() << 8 ^ random.nextInt() << 16 ^ random.nextInt() << 24 & 0xFFFFFFFF;
        long l4 = random.nextInt() ^ random.nextInt() << 8 ^ random.nextInt() << 16 ^ random.nextInt() << 24 & 0xFFFFFFFF;
        handshakeMessage.setData1(CommRev3.encodeEncryptHex((int)(l ^= l4), n));
        handshakeMessage.setData2(CommRev3.encodeEncryptHex((int)l2, n));
        handshakeMessage.setData3(CommRev3.encodeEncryptHex((int)l3, n));
        handshakeMessage.setData4(CommRev3.encodeEncryptHex((int)l4, n));
        int n2 = 300;
        handshakeMessage.setGroupId(n2);
        return handshakeMessage;
    }

    private static int getEncryption(HandshakeMessage handshakeMessage, HandshakeMessage handshakeMessage2) {
        int n = 0;
        int n2 = handshakeMessage2.getNewKey();
        int n3 = CommRev3.decryptDecodeHex(handshakeMessage2.getData1(), n2);
        int n4 = CommRev3.decryptDecodeHex(handshakeMessage2.getData2(), n2);
        int n5 = CommRev3.decryptDecodeHex(handshakeMessage2.getData3(), n2);
        int n6 = CommRev3.decryptDecodeHex(handshakeMessage2.getData4(), n2);
        n3 = LicenseServer.modify(n3);
        n4 = LicenseServer.modify(n4);
        n5 = LicenseServer.modify(n5);
        n6 = LicenseServer.modify(n6);
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        CommRev3.encodeHex(byArray, 0, 8, n3);
        CommRev3.encodeHex(byArray2, 0, 8, n4);
        CommRev3.encodeHex(byArray3, 0, 8, n5);
        CommRev3.encodeHex(byArray4, 0, 8, n6);
        byte[] byArray5 = handshakeMessage.getData1();
        byte[] byArray6 = handshakeMessage.getData2();
        byte[] byArray7 = handshakeMessage.getData3();
        byte[] byArray8 = handshakeMessage.getData4();
        CommRev3.decryptBytes(byArray5, n2);
        CommRev3.decryptBytes(byArray6, n2);
        CommRev3.decryptBytes(byArray7, n2);
        CommRev3.decryptBytes(byArray8, n2);
        if (Arrays.equals(byArray, byArray5) && Arrays.equals(byArray2, byArray6) && Arrays.equals(byArray3, byArray7) && Arrays.equals(byArray4, byArray8)) {
            n = LicenseServer.modify(n3 & 0xFFFFFFFF);
        }
        return n;
    }

    private static int modify(int n) {
        return n ^ 0x12FF210;
    }

    private HelloMessage createHelloMessage(int n) {
        HelloMessage helloMessage = new HelloMessage();
        helloMessage.setVersion(1);
        helloMessage.setRevision(n);
        helloMessage.setVendor(this.vendor);
        helloMessage.setUsername(this.connectionData.getUsername());
        helloMessage.setHost(this.connectionData.getHostname());
        helloMessage.setDisplay(this.connectionData.getDisplay());
        helloMessage.setServerTimeout(this.connectionData.getServerTimeout());
        return helloMessage;
    }

    private synchronized String getLfData(VDInfoMessage vDInfoMessage) throws FlexlmException {
        this.sendMessage(vDInfoMessage);
        Message message = this.receiveMessage();
        int n = message.getType();
        if (n != 65562) {
            return null;
        }
        LicenseFileDataMessage licenseFileDataMessage = (LicenseFileDataMessage)message;
        String string = null;
        try {
            string = new String(licenseFileDataMessage.getLicenseFileData(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("encoding unsupportedISO-8859-1");
        }
        return string;
    }

    protected synchronized void sendMessage(Message message) throws FlexlmException {
        if (!this.connected) {
            this.connect();
        }
        if (this.doHandshake && this.encryption == 0 && !this.handshakeInProgress) {
            this.handshake(this.vInfo);
        }
        try {
            message.send(this.outStream, this.encryption, this.commRev);
        }
        catch (IOException iOException) {
            this.errorDisconnect();
            throw new FlexlmException(-17, 3019, iOException.getMessage());
        }
    }

    protected Message receiveMessage() throws FlexlmException {
        if (this.receiveMessageQueue.size() == 0) {
            this.fillMessageQueue(0, true);
        }
        Message message = (Message)this.receiveMessageQueue.remove(0);
        return message;
    }

    private void fillMessageQueue(int n, boolean bl) throws FlexlmException {
        try {
            Message message;
            while ((message = Message.receiveIfAvailable(this.inStream, this.encryption, bl)) != null) {
                int n2;
                if (message instanceof HeartbeatResponseMessage) {
                    this.lastHeartbeatResponseTime = System.currentTimeMillis();
                    n2 = 65557;
                } else if (message instanceof FeatAvailRespMessage) {
                    this.featureAvailableMessageQueue.addElement(message);
                    n2 = 65881;
                } else {
                    this.receiveMessageQueue.addElement(message);
                    n2 = 0;
                }
                if (!bl || n2 != n) continue;
                bl = false;
            }
        }
        catch (IOException iOException) {
            this.errorDisconnect();
            throw new FlexlmException(-16, 3018, iOException.getMessage());
        }
    }

    public long getLastHeartbeatResponseTime() throws FlexlmException {
        if (this.connected) {
            this.fillMessageQueue(65557, false);
        }
        return this.lastHeartbeatResponseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatAvailRespMessage readFeatAvail(String string, boolean bl) throws FlexlmException {
        FeatAvailRespMessage featAvailRespMessage = null;
        try {
            if (this.featureAvailableMessageQueue.size() == 0) {
                this.fillMessageQueue(65881, bl);
            }
            Vector vector = this.featureAvailableMessageQueue;
            synchronized (vector) {
                for (int i = 0; i < this.featureAvailableMessageQueue.size(); ++i) {
                    FeatAvailRespMessage featAvailRespMessage2 = (FeatAvailRespMessage)this.featureAvailableMessageQueue.elementAt(i);
                    if (!featAvailRespMessage2.getFeature().equals(string) && featAvailRespMessage2.getPkgMsg().isEmpty()) continue;
                    featAvailRespMessage = featAvailRespMessage2;
                    this.featureAvailableMessageQueue.remove(featAvailRespMessage2);
                    break;
                }
            }
        }
        catch (FlexlmException flexlmException) {
            throw new FlexlmException(-16, 3110, flexlmException.getMessage());
        }
        return featAvailRespMessage;
    }

    private synchronized void errorDisconnect() {
        this.closeSocket();
        if (this.getCheckedOutLicenseCount() > 0 || this.getQueuedLicenseCount() > 0) {
            License license;
            if (this.licensesToReconnect == null) {
                this.licensesToReconnect = new Vector();
            }
            while (this.getCheckedOutLicenseCount() > 0) {
                license = (License)this.licensesCheckedOut.remove(0);
                this.licensesToReconnect.add(license);
            }
            while (this.getQueuedLicenseCount() > 0) {
                license = (License)this.queuedLicenses.remove(0);
                this.licensesToReconnect.add(license);
            }
        }
        if (DEBUG_COMM) {
            int n = this.licensesToReconnect == null ? 0 : this.licensesToReconnect.size();
            System.out.println("Lost connection, licenses to reconnect=" + n);
        }
    }

    private void closeSocket() {
        this.connected = false;
        this.encryption = 0;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    protected synchronized void addCheckedOutLicense(License license) {
        super.addCheckedOutLicense(license);
        if (this.licensesToReconnect != null) {
            this.licensesToReconnect.remove(license);
        }
    }

    @Override
    protected synchronized void addQueuedLicense(License license) {
        super.addQueuedLicense(license);
        if (this.licensesToReconnect != null) {
            this.licensesToReconnect.remove(license);
        }
    }

    @Override
    protected synchronized void removeCheckedOutLicense(License license) {
        super.removeCheckedOutLicense(license);
        if (this.licensesToReconnect != null) {
            this.licensesToReconnect.remove(license);
        }
    }

    @Override
    protected synchronized void removeQueuedLicense(License license) {
        super.removeQueuedLicense(license);
        if (this.licensesToReconnect != null) {
            this.licensesToReconnect.remove(license);
        }
    }

    @Override
    protected synchronized int getCheckedOutLicenseCount() {
        return super.getCheckedOutLicenseCount();
    }

    @Override
    protected synchronized int getQueuedLicenseCount() {
        return super.getQueuedLicenseCount();
    }

    protected synchronized int getLicensesToReconnectCount() {
        if (this.licensesToReconnect == null) {
            return 0;
        }
        return this.licensesToReconnect.size();
    }

    @Override
    public void setHeartbeatBlocked(boolean bl) {
        this.heartbeatBlocked = bl;
    }

    @Override
    public boolean isHeartbeatBlocked() {
        return this.heartbeatBlocked;
    }

    @Override
    public int getMinimumHeartbeatInterval() {
        if (ALLOW_SHORT_INTERVALS) {
            return 1;
        }
        return 20;
    }

    @Override
    public void setHeartbeatInterval(int n) throws FlexlmException {
        int n2 = this.heartbeatInterval;
        if (!ALLOW_SHORT_INTERVALS && n < 20 && n > 0) {
            throw new FlexlmException(-42, 3050);
        }
        this.heartbeatInterval = n;
        if (n2 > 0 && n == 0) {
            this.stopHeartbeat();
        } else if (n2 == 0 && n > 0 && this.isConnected()) {
            this.startHeartbeat();
        }
    }

    @Override
    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public void setRetryInterval(int n) throws FlexlmException {
        if (!ALLOW_SHORT_INTERVALS && n < 20 && n > 0) {
            throw new FlexlmException(-42, 3051);
        }
        this.retryInterval = n;
    }

    @Override
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setRetryLimit(int n) {
        if (n < 1) {
            n = 5;
        }
        this.retryLimit = n;
    }

    @Override
    public int getRetryLimit() {
        return this.retryLimit;
    }

    @Override
    public synchronized void addHeartbeatListener(HeartbeatListener heartbeatListener) {
        int n = this.findHeartbeatListener(heartbeatListener);
        if (n >= 0) {
            return;
        }
        int n2 = this.heartbeatListeners.length;
        HeartbeatListener[] heartbeatListenerArray = new HeartbeatListener[n2 + 1];
        System.arraycopy(this.heartbeatListeners, 0, heartbeatListenerArray, 0, n2);
        heartbeatListenerArray[n2] = heartbeatListener;
        this.heartbeatListeners = heartbeatListenerArray;
    }

    @Override
    public synchronized void removeHeartbeatListener(HeartbeatListener heartbeatListener) {
        int n = this.findHeartbeatListener(heartbeatListener);
        if (n < 0) {
            return;
        }
        int n2 = this.heartbeatListeners.length;
        HeartbeatListener[] heartbeatListenerArray = new HeartbeatListener[n2 - 1];
        if (n > 0) {
            System.arraycopy(this.heartbeatListeners, 0, heartbeatListenerArray, 0, n);
        }
        if (n2 > n + 1) {
            System.arraycopy(this.heartbeatListeners, n + 1, heartbeatListenerArray, n, n2 - n - 1);
        }
        this.heartbeatListeners = heartbeatListenerArray;
    }

    @Override
    public HeartbeatListener[] getHeartbeatListeners() {
        return this.heartbeatListeners;
    }

    @Override
    public int doHeartbeat() {
        if (this.cantSendHeartbeat()) {
            return this.unAckHeartbeatCount;
        }
        this.getPreviousHeartbeatResponse();
        this.sendHeartbeatMessage();
        this.reconnectLicenses(true);
        if (this.isConnected()) {
            this.unAckHeartbeatCount = 0;
        }
        return this.unAckHeartbeatCount;
    }

    @Override
    public int sendHeartbeat() {
        if (this.cantSendHeartbeat()) {
            return this.unAckHeartbeatCount;
        }
        this.getPreviousHeartbeatResponse();
        this.sendHeartbeatMessage();
        this.reconnectLicenses(false);
        if (this.isConnected()) {
            this.unAckHeartbeatCount = 0;
        }
        return this.unAckHeartbeatCount;
    }

    private boolean cantSendHeartbeat() {
        if (this.isHeartbeatBlocked()) {
            return true;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.latestHeartbeatSentTime;
        return l2 < (long)(this.getMinimumHeartbeatInterval() * 1000);
    }

    @Override
    public int getReconnects(int n) {
        int n2;
        long l;
        int n3;
        int n4 = n * 60 * 1000;
        long l2 = new Date().getTime();
        long l3 = l2 - (long)n4;
        for (n3 = n2 = this.reconnectTimes.size() - 1; n3 >= 0 && (l = ((Long)this.reconnectTimes.elementAt(n3)).longValue()) >= l3; --n3) {
        }
        return n2 - n3;
    }

    private int findHeartbeatListener(HeartbeatListener heartbeatListener) {
        for (int i = 0; i < this.heartbeatListeners.length; ++i) {
            if (this.heartbeatListeners[i] != heartbeatListener) continue;
            return i;
        }
        return -1;
    }

    protected synchronized void startHeartbeat() {
        if (DEBUG_HEARTBEAT) {
            System.out.println("LicenseServer.startHeartbeat");
            if (this.autoHeartbeatThread != null) {
                System.out.println("  already running");
            }
        }
        this.sendHeartbeatMessage();
        if (this.autoHeartbeatThread != null) {
            return;
        }
        if (this.getHeartbeatInterval() == 0) {
            return;
        }
        this.autoHeartbeatThread = new Thread("FLEXlm Heartbeat"){

            @Override
            public void run() {
                LicenseServer.this.runHeartbeat();
            }
        };
        this.autoHeartbeatThread.setDaemon(true);
        this.autoHeartbeatThread.start();
    }

    protected synchronized void stopHeartbeat() {
        if (DEBUG_HEARTBEAT) {
            System.out.println("LicenseServer.stopHeartbeat");
            if (this.autoHeartbeatThread == null) {
                System.out.println("  already stopped");
            }
        }
        if (this.autoHeartbeatThread == null) {
            return;
        }
        this.stopHeartbeatFlag = true;
        this.autoHeartbeatThread.interrupt();
        try {
            this.autoHeartbeatThread.join(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.autoHeartbeatThread = null;
    }

    protected void runHeartbeat() {
        if (DEBUG_HEARTBEAT) {
            System.out.println("Heartbeat thread starting");
        }
        this.stopHeartbeatFlag = false;
        while (!this.stopHeartbeatFlag) {
            try {
                int n = this.getHeartbeatInterval();
                if (!this.isConnected()) {
                    n = this.getRetryInterval();
                }
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.stopHeartbeatFlag) continue;
            this.doHeartbeat();
        }
        if (DEBUG_HEARTBEAT) {
            System.out.println("Heartbeat thread finishing");
        }
    }

    protected void sendHeartbeatMessage() {
        HeartbeatMessage heartbeatMessage = new HeartbeatMessage();
        this.previousHeartbeatSentTime = this.latestHeartbeatSentTime;
        this.latestHeartbeatSentTime = System.currentTimeMillis();
        try {
            this.sendMessage(heartbeatMessage);
        }
        catch (FlexlmException flexlmException) {
            // empty catch block
        }
    }

    protected void getPreviousHeartbeatResponse() {
        try {
            this.latestHeartbeatReceivedTime = this.getLastHeartbeatResponseTime();
        }
        catch (FlexlmException flexlmException) {
            // empty catch block
        }
        this.unAckHeartbeatCount = this.latestHeartbeatReceivedTime > this.latestHeartbeatSentTime ? 0 : ++this.unAckHeartbeatCount;
    }

    protected void fireReconnectAttempted(License license, int n) {
        HeartbeatEvent heartbeatEvent = new HeartbeatEvent(this, license, license.getFeature(), n);
        if (this.heartbeatListeners.length == 0) {
            this.defaultReconnectAttempted(heartbeatEvent);
            return;
        }
        for (int i = 0; i < this.heartbeatListeners.length; ++i) {
            this.heartbeatListeners[i].reconnectAttempted(heartbeatEvent);
        }
    }

    protected void fireReconnectSucceeded(License license, int n) {
        HeartbeatEvent heartbeatEvent = new HeartbeatEvent(this, license, license.getFeature(), n);
        if (this.heartbeatListeners.length == 0) {
            this.defaultReconnectSucceeded(heartbeatEvent);
            return;
        }
        for (int i = 0; i < this.heartbeatListeners.length; ++i) {
            this.heartbeatListeners[i].reconnectSucceeded(heartbeatEvent);
        }
    }

    protected void fireReconnectFailed(License license, Feature feature, int n) {
        HeartbeatEvent heartbeatEvent = new HeartbeatEvent(this, license, feature, n);
        if (this.heartbeatListeners.length == 0) {
            this.defaultReconnectFailed(heartbeatEvent);
            return;
        }
        for (int i = 0; i < this.heartbeatListeners.length; ++i) {
            this.heartbeatListeners[i].reconnectFailed(heartbeatEvent);
        }
    }

    protected void defaultReconnectAttempted(HeartbeatEvent heartbeatEvent) {
    }

    protected void defaultReconnectSucceeded(HeartbeatEvent heartbeatEvent) {
    }

    protected void defaultReconnectFailed(HeartbeatEvent heartbeatEvent) {
        License license = heartbeatEvent.getLicense();
        FeatureSpecifier featureSpecifier = license == null ? null : license.getFeatureSpecifier();
        String string = featureSpecifier == null ? "(no name)" : featureSpecifier.getName();
        System.out.println("Reconnect failed for " + string);
        this.closeSocket();
        System.exit(1);
    }

    protected void finalize() {
        try {
            this.inStream.close();
            this.outStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeSocket();
    }
}

