/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;

public class LmbEtherId
extends HostId
implements FlexlmConstants {
    private String ethernetAddress;
    private byte[] ethernetBytes;

    public LmbEtherId() throws FlexlmException {
        this("LMB_ETHER=000000000000");
    }

    public LmbEtherId(String string) throws FlexlmException {
        String string2;
        if (string != null && string.startsWith(this.getKeyword() + "=")) {
            String string3 = string.substring(string.indexOf("=") + 1);
            string2 = string3.trim();
            if (string2.length() != 12 || !this.isHex(string2)) {
                throw new FlexlmException(-503, 2112);
            }
        } else {
            throw new FlexlmException(-503, 2113);
        }
        this.ethernetAddress = string2;
        this.ethernetBytes = this.getEtherBytes(this.ethernetAddress);
    }

    @Override
    public HostId createNew(String string) throws FlexlmException {
        return new LmbEtherId(string);
    }

    @Override
    public boolean isCurrentHost() {
        return false;
    }

    @Override
    public HostId[] getCurrentHostIds() {
        return null;
    }

    @Override
    public String getKeyword() {
        return "LMB_ETHER";
    }

    @Override
    public int getType() {
        return 201;
    }

    @Override
    public String toString() {
        return this.getKeyword() + "=" + this.ethernetAddress;
    }

    @Override
    public Object getValue() {
        return this.ethernetBytes;
    }

    private byte[] getEtherBytes(String string) {
        byte[] byArray = new byte[6];
        for (int i = 0; i < 6; ++i) {
            String string2 = string.substring(i * 2, i * 2 + 2);
            byArray[i] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    @Override
    protected int compareValueTo(Object object) {
        byte[] byArray = (byte[])this.getValue();
        byte[] byArray2 = (byte[])object;
        for (int i = 0; i < 6; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
        }
        return 0;
    }
}

