/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.lictext.FlexlmVersion;
import java.util.Hashtable;

public class FeatureSpecifier
implements FlexlmConstants {
    private Hashtable specifier;

    public FeatureSpecifier(String string, String string2) throws FlexlmException {
        if (string == null || string.length() < 1 || string.length() > 30) {
            throw new FlexlmException(-42, 7015);
        }
        new FlexlmVersion(string2);
        this.specifier = new Hashtable();
        this.specifier.put("FEATURENAME", string);
        this.specifier.put("VERSION", string2);
    }

    public FeatureSpecifier(Feature feature) {
        this.specifier = FeatureSpecifier.extractFeatureDetails(feature);
    }

    public String getName() {
        return (String)this.specifier.get("FEATURENAME");
    }

    public String getVersion() {
        return (String)this.specifier.get("VERSION");
    }

    public String getFeatureIdentifier() {
        return (String)this.specifier.get("IDENTIFIER");
    }

    private static Hashtable extractFeatureDetails(Feature feature) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("FEATURENAME", feature.getName());
        hashtable.put("VERSION", feature.getVersion());
        hashtable.put("IDENTIFIER", feature.getFeatureIdentifier());
        return hashtable;
    }

    public String toString() {
        return this.getName() + "," + this.getVersion() + "," + this.getFeatureIdentifier();
    }
}

