/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.io.Serializable;
import org.javaseis.grid.GridDefinition;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.IParallelContext;

public class DistributedGrid
implements Serializable {
    private static final long serialVersionUID = 1L;
    private GridDefinition fullGrid;
    private GridDefinition residentGrid;
    private int nres;
    private int[] position;

    public DistributedGrid(GridDefinition grid, int residentDimensions, int[] gridPosition) {
        int i;
        this.fullGrid = grid;
        this.nres = residentDimensions;
        this.residentGrid = this.fullGrid.subGrid(this.nres);
        this.position = (int[])gridPosition.clone();
        if (this.position.length < this.fullGrid.getNumDimensions()) {
            throw new IndexOutOfBoundsException("Subgrid position is too short");
        }
        for (i = this.nres; i < this.fullGrid.getNumDimensions(); ++i) {
            if (this.position[i] >= 0 && (long)this.position[i] < this.fullGrid.getAxisLength(i)) continue;
            throw new IndexOutOfBoundsException("Subgrid position is out of range");
        }
        for (i = 0; i < this.nres; ++i) {
            this.position[i] = 0;
        }
    }

    public DistributedArray allocateArray(Class classType, int elementCount, IParallelContext pc) {
        int[] lengths = new int[this.nres];
        for (int i = 0; i < this.nres; ++i) {
            lengths[i] = (int)this.residentGrid.getAxis(i).getLength();
        }
        DistributedArray a = new DistributedArray(pc, classType, this.nres, elementCount, lengths, Decomposition.BLOCK);
        return a;
    }

    public DistributedArray allocateArray(Class classType, int elementCount, int[] paddedLengths, int[] decompTypes, IParallelContext pc) {
        DistributedArray a = new DistributedArray(pc, classType, this.nres, elementCount, paddedLengths, decompTypes);
        return a;
    }

    public GridDefinition getFullGrid() {
        return this.fullGrid;
    }

    public GridDefinition getResidentGrid() {
        return this.residentGrid;
    }

    public int[] getPosition() {
        return this.position;
    }
}

