/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.javaseis.io.SortIOParms;
import org.javaseis.io.SortMapIO;

public class JTestSortMapIO
extends TestCase {
    public static SortIOParms createParms(String basePath, String sortMapName, int volumes, int frames, int tpf) throws IOException {
        SortIOParms parms = new SortIOParms();
        parms.sort3_secondary = "NONE";
        parms.sort3_tertiary = "NONE";
        parms.volumes = volumes;
        parms.framesPerVolume = frames;
        parms.tracesPerFrame = tpf;
        parms.tracesInSort = volumes * frames * tpf;
        parms.minLogVol = 1;
        parms.maxLogVol = volumes;
        parms.minLogFrm = 1;
        parms.maxLogFrm = frames;
        parms.minLogTrc = 1;
        parms.maxLogTrc = tpf;
        parms.label4 = "ILINE_NO";
        parms.label3 = "XLINE_NO";
        parms.label2 = "OFB_NO";
        SortMapIO.writeparms(basePath, sortMapName, parms);
        return parms;
    }

    public void testSMCreate() throws IOException {
        File out = File.createTempFile("sortmap_test", "js");
        out.delete();
        out.mkdir();
        String basePath = out.getAbsolutePath();
        String sortmapName = System.currentTimeMillis() + "";
        int nVolumes = 17;
        int nFramesPerVolume = 11;
        int ntracesPerFrame = 97;
        SortIOParms parms = JTestSortMapIO.createParms(basePath, sortmapName, nVolumes, nFramesPerVolume, ntracesPerFrame);
        JTestSortMapIO.write(basePath, sortmapName, 0, nVolumes - 1, nVolumes, nFramesPerVolume, ntracesPerFrame);
        JTestSortMapIO.validate(basePath, sortmapName, parms);
        SortMapIO.delete(basePath);
        new File(basePath).delete();
    }

    public static void write(String basePath, String sortmapName, int minIVol, int maxIVol, int nVolumes, int nFramesPerVolume, int nTracesPerFrame) throws IOException {
        SortMapIO smio = new SortMapIO(basePath, sortmapName);
        smio.open("w");
        long[] _traceList = smio.getCurrentTraceList();
        for (int ivol = minIVol; ivol <= maxIVol; ++ivol) {
            int logicalVolume = ivol + 1;
            smio.appendVolume(ivol, logicalVolume, nFramesPerVolume);
            for (int ifrm = 0; ifrm < nFramesPerVolume; ++ifrm) {
                int locialFrame = ifrm + 1;
                smio.appendFrame(ifrm, locialFrame, nTracesPerFrame);
                for (int i = 0; i < nTracesPerFrame; ++i) {
                    long index;
                    _traceList[i] = index = (long)ivol * (long)nFramesPerVolume * (long)nTracesPerFrame + (long)ifrm * (long)nTracesPerFrame + (long)i;
                }
                smio.writeTraceMap(nTracesPerFrame, ivol, ifrm);
            }
            smio.writeFrameMap(nFramesPerVolume, ivol);
        }
        smio.writeVolumeMap(nVolumes, minIVol);
        smio.close();
    }

    public static void validateParms(SortIOParms parms, SortIOParms parms2) throws IOException {
        JTestSortMapIO.assertTrue((boolean)parms2.sort3_secondary.equalsIgnoreCase(parms.sort3_secondary));
        JTestSortMapIO.assertTrue((boolean)parms2.sort3_tertiary.equalsIgnoreCase(parms.sort3_tertiary));
        JTestSortMapIO.assertTrue((parms2.volumes == parms.volumes ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.framesPerVolume == parms.framesPerVolume ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.tracesPerFrame == parms.tracesPerFrame ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.tracesInSort == parms.tracesInSort ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.minLogVol == parms.minLogVol ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.maxLogVol == parms.maxLogVol ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.minLogFrm == parms.minLogFrm ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.maxLogFrm == parms.maxLogFrm ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.minLogTrc == parms.minLogTrc ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.maxLogTrc == parms.maxLogTrc ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((boolean)parms2.label4.equalsIgnoreCase(parms.label4));
        JTestSortMapIO.assertTrue((boolean)parms2.label3.equalsIgnoreCase(parms.label3));
        JTestSortMapIO.assertTrue((boolean)parms2.label2.equalsIgnoreCase(parms.label2));
        JTestSortMapIO.assertTrue((parms.getDimensions() == 4 ? 1 : 0) != 0);
        JTestSortMapIO.assertTrue((parms2.getDimensions() == parms.getDimensions() ? 1 : 0) != 0);
    }

    public static void validate(String basePath, String sortMapName, SortIOParms parms) throws IOException {
        SortMapIO smio = new SortMapIO(basePath, sortMapName);
        SortIOParms parms2 = smio.getParms();
        JTestSortMapIO.validateParms(parms, parms2);
        smio.open("r");
        int nVolumes = parms2.maxLogVol - parms2.minLogVol + 1;
        int nFramesPerVolume = parms2.maxLogFrm - parms2.minLogFrm + 1;
        int nTracesPerFrame = parms2.tracesPerFrame;
        long counter = 0L;
        for (int ivol = 0; ivol < nVolumes; ++ivol) {
            int framesInVolume = smio.setVolume(ivol);
            JTestSortMapIO.assertTrue((framesInVolume == nFramesPerVolume ? 1 : 0) != 0);
            for (int ifrm = 0; ifrm < framesInVolume; ++ifrm) {
                int tracesInFrame = smio.setFrame(ifrm);
                JTestSortMapIO.assertTrue((tracesInFrame == nTracesPerFrame ? 1 : 0) != 0);
                for (int i = 0; i < tracesInFrame; ++i) {
                    long[] traceList = smio.getCurrentTraceList();
                    JTestSortMapIO.assertTrue((traceList[i] == counter++ ? 1 : 0) != 0);
                }
            }
        }
        smio.close();
    }

    public static void main(String[] args) throws IOException {
        new JTestSortMapIO().testSMCreate();
    }
}

