/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import java.util.Arrays;
import org.javaseis.array.beta.ArraysUtil;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.TraceIterator;
import org.javaseis.iterators.beta.IIterator;
import org.javaseis.iterators.beta.IPositionIterator;
import org.junit.Test;

public class FlexArrayUtil {
    public static <T> void fill(IFlexArray<T> a, Number value) {
        TraceIterator<T> it = new TraceIterator<T>(a);
        FlexArrayUtil.fill(a, it, value);
    }

    public static <T> void fill(IFlexArray<T> a, IIterator<T> it, Number value) {
        while (it.hasNext()) {
            Object t = it.next();
            if (t instanceof int[]) {
                Arrays.fill((int[])t, value.intValue());
                continue;
            }
            if (t instanceof float[]) {
                Arrays.fill((float[])t, value.floatValue());
                continue;
            }
            if (t instanceof short[]) {
                Arrays.fill((short[])t, value.shortValue());
                continue;
            }
            if (t instanceof long[]) {
                Arrays.fill((long[])t, value.longValue());
                continue;
            }
            if (t instanceof double[]) {
                Arrays.fill((double[])t, value.doubleValue());
                continue;
            }
            if (t instanceof byte[]) {
                Arrays.fill((byte[])t, value.byteValue());
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    public static <T> String frameToString(T[] frame) {
        int[] shape = ArraysUtil.getShape(frame);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < shape[1]; ++i) {
            buf.append(ArraysUtil.toString(frame[i]));
            buf.append("\n");
        }
        return buf.toString();
    }

    public static <T> String volumeToString(T[][] volume) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < volume.length; ++i) {
            buf.append(FlexArrayUtil.frameToString(volume[i]));
        }
        return buf.toString();
    }

    public static <T> IFlexArray<T> reIndex(IFlexArray<T> src, int[] targetShape) {
        long targetCount = 1L;
        for (int i = 1; i < targetShape.length; ++i) {
            targetCount *= (long)targetShape[i];
        }
        int[] srcShape = src.getShape();
        long srcCount = 1L;
        for (int i = 1; i < srcShape.length; ++i) {
            srcCount *= (long)srcShape[i];
        }
        if (targetCount != srcCount) {
            throw new IllegalArgumentException("The number traces in the source " + Arrays.toString(srcShape) + " does not match the number of traces in the target shape " + Arrays.toString(targetShape));
        }
        int[] container = (int[])targetShape.clone();
        container[0] = 0;
        FlexArray<T> a = new FlexArray<T>(src.getType(), src.getElementCount(), container);
        IPositionIterator<int[]> itOut = a.newPositionIterator();
        TraceIterator<T> itIn = new TraceIterator<T>(src);
        while (itOut.hasNext()) {
            int[] posOut = (int[])itOut.next();
            T traceIn = itIn.next();
            a.putTrace(traceIn, posOut);
        }
        a.reshape(targetShape);
        return a;
    }

    public static <T> IFlexArray<T> reIndex(IFlexArray<T> src, int ncpu) {
        int ndim;
        int[] inShape = src.getShape();
        if (inShape[(ndim = inShape.length) - 1] % ncpu != 0) {
            throw new IllegalArgumentException("Input IFlexArray shape " + Arrays.toString(inShape) + " can not be divided by input cpu size " + ncpu);
        }
        int[] targetShape = (int[])inShape.clone();
        int n = ndim - 2;
        targetShape[n] = targetShape[n] * ncpu;
        int n2 = ndim - 1;
        targetShape[n2] = targetShape[n2] / ncpu;
        int[] container = (int[])targetShape.clone();
        container[0] = 0;
        FlexArray<T> a = new FlexArray<T>(src.getType(), src.getElementCount(), container);
        IPositionIterator<int[]> itOut = a.newPositionIterator();
        while (itOut.hasNext()) {
            int[] posOut = (int[])itOut.next();
            int[] posIn = (int[])posOut.clone();
            posIn[ndim - 2] = posOut[ndim - 2] % inShape[ndim - 2];
            posIn[ndim - 1] = posOut[ndim - 1] + posOut[ndim - 2] / inShape[ndim - 2] * targetShape[ndim - 1];
            T traceIn = src.getTrace(posIn);
            a.putTrace(traceIn, posOut);
        }
        a.reshape(targetShape);
        return a;
    }

    @Test
    public void testIntFill() {
        int[] shape = new int[]{11, 7};
        IFlexArray<int[]> a = FlexArray.createIntArray(shape);
        FlexArrayUtil.fill(a, -1);
    }
}

