/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.javaseis.array.BackingArray;
import org.javaseis.array.IBackingArray;

public class NativeArrayStorage
implements IBackingArray {
    protected int _length = 1;
    protected int _bufLength = 1;
    protected int _offset = 0;
    protected Class _classType = Float.TYPE;
    protected ByteBuffer _bytes = null;
    protected ShortBuffer _shorts = null;
    protected IntBuffer _ints = null;
    protected LongBuffer _longs = null;
    protected FloatBuffer _floats = null;
    protected DoubleBuffer _doubles = null;

    public NativeArrayStorage() {
        this._classType = null;
        this._length = 0;
        this._bufLength = 0;
        this._offset = 0;
    }

    public NativeArrayStorage(Class classType, long length) {
        this._classType = classType;
        this._length = (int)length;
        this._bufLength = (int)length;
        this._offset = 0;
        this.allocate();
    }

    protected NativeArrayStorage cloneMe() {
        NativeArrayStorage a = new NativeArrayStorage();
        a._bufLength = this._bufLength;
        a._classType = this._classType;
        a._length = this._length;
        a._offset = this._offset;
        if (a._classType == Byte.TYPE) {
            a._bytes = this._bytes.duplicate();
        } else if (a._classType == Short.TYPE) {
            a._shorts = this._shorts.duplicate();
        } else if (a._classType == Integer.TYPE) {
            a._ints = this._ints.duplicate();
        } else if (a._classType == Long.TYPE) {
            a._longs = this._longs.duplicate();
        } else if (a._classType == Float.TYPE) {
            a._floats = this._floats.duplicate();
        } else if (a._classType == Double.TYPE) {
            a._doubles = this._doubles.duplicate();
        } else {
            throw new UnsupportedOperationException("Object BackingArray not supported");
        }
        return a;
    }

    @Override
    public IBackingArray view(long length, long offset) {
        return NativeArrayStorage.view(this, length, offset);
    }

    public static IBackingArray view(NativeArrayStorage a, long length, long offset) {
        if (length > a.getLength() - offset) {
            throw new IndexOutOfBoundsException("Requested offset and length exceed Backing Storage length");
        }
        NativeArrayStorage b = a.cloneMe();
        b.setBufferView(offset, length);
        return b;
    }

    @Override
    public Class getClassType() {
        return this._classType;
    }

    @Override
    public void setClassType(Class classType) {
        this._classType = classType;
    }

    @Override
    public long getLength() {
        return this._length;
    }

    @Override
    public void setLength(long length) {
        if (length > (long)(this._bufLength - this._offset)) {
            throw new IndexOutOfBoundsException("Requested length exceeds Backing Storage length");
        }
        this._length = (int)length;
    }

    @Override
    public long getOffset() {
        return this._offset;
    }

    @Override
    public void setOffset(long offset) {
        if ((long)this._length + offset > (long)this._bufLength) {
            throw new IndexOutOfBoundsException("Requested offset exceeds Backing Storage length");
        }
        this._offset = (int)offset;
    }

    @Override
    public void setBufferView(long offset, long length) {
        if (offset + length > (long)this._bufLength) {
            throw new IndexOutOfBoundsException("Requested offset and length exceeds Backing Storage length");
        }
        this._offset = (int)offset;
        this._length = (int)length;
    }

    @Override
    public long getBackingArrayLength() {
        long result;
        if (this.getClassType().equals(Byte.TYPE)) {
            result = this._bytes.capacity();
        } else if (this.getClassType().equals(Short.TYPE)) {
            result = this._shorts.capacity();
        } else if (this.getClassType().equals(Integer.TYPE)) {
            result = this._ints.capacity();
        } else if (this.getClassType().equals(Float.TYPE)) {
            result = this._floats.capacity();
        } else if (this.getClassType().equals(Long.TYPE)) {
            result = this._longs.capacity();
        } else if (this.getClassType().equals(Double.TYPE)) {
            result = this._doubles.capacity();
        } else {
            throw new UnsupportedOperationException("Object class not supported");
        }
        return result;
    }

    @Override
    public void arraycopy(IBackingArray src, long srcOffset, IBackingArray dest, long destOffset, long count) {
        if (count == 0L) {
            return;
        }
        int length = (int)count;
        Class classType = src.getClassType();
        if (classType != dest.getClassType()) {
            throw new IllegalArgumentException("Class Type Mismatch");
        }
        NativeArrayStorage a = (NativeArrayStorage)src;
        NativeArrayStorage b = (NativeArrayStorage)dest;
        int aoff = (int)srcOffset + (int)src.getOffset();
        int boff = (int)destOffset + (int)dest.getOffset();
        if (classType == Byte.TYPE) {
            ByteBuffer abytes = a._bytes.duplicate();
            abytes.position(aoff);
            abytes.limit(aoff + length);
            ByteBuffer bbytes = b._bytes.duplicate();
            bbytes.position(boff);
            bbytes.limit(boff + length);
            bbytes.put(abytes);
        } else if (classType == Integer.TYPE) {
            IntBuffer aints = a._ints.duplicate();
            aints.position(aoff);
            aints.limit(aoff + length);
            IntBuffer bints = b._ints.duplicate();
            bints.position(boff);
            bints.limit(boff + length);
            bints.put(aints);
        } else if (classType == Long.TYPE) {
            LongBuffer alongs = a._longs.duplicate();
            alongs.position(aoff);
            alongs.limit(aoff + length);
            LongBuffer blongs = b._longs.duplicate();
            blongs.position(boff);
            blongs.limit(boff + length);
            blongs.put(alongs);
        } else if (classType == Short.TYPE) {
            ShortBuffer ashorts = a._shorts.duplicate();
            ashorts.position(aoff);
            ashorts.limit(aoff + length);
            ShortBuffer bshorts = b._shorts.duplicate();
            bshorts.position(boff);
            bshorts.limit(boff + length);
            bshorts.put(ashorts);
        } else if (classType == Float.TYPE) {
            FloatBuffer afloats = a._floats.duplicate();
            afloats.position(aoff);
            afloats.limit(aoff + length);
            FloatBuffer bfloats = b._floats.duplicate();
            bfloats.position(boff);
            bfloats.limit(boff + length);
            bfloats.put(afloats);
        } else if (classType == Double.TYPE) {
            DoubleBuffer adoubles = a._doubles.duplicate();
            adoubles.position(aoff);
            adoubles.limit(aoff + length);
            DoubleBuffer bdoubles = b._doubles.duplicate();
            bdoubles.position(boff);
            bdoubles.limit(boff + length);
            bdoubles.put(adoubles);
        } else {
            throw new IllegalArgumentException("Object class not supported");
        }
    }

    protected void setArray(ByteBuffer buf) {
        this._classType = buf.getClass();
        this._bytes = buf;
        this._length = this._bufLength = buf.capacity();
    }

    protected void setArray(ShortBuffer buf) {
        this._classType = buf.getClass();
        this._shorts = buf;
        this._length = this._bufLength = buf.capacity();
    }

    protected void setArray(IntBuffer buf) {
        this._classType = buf.getClass();
        this._ints = buf;
        this._length = this._bufLength = buf.capacity();
    }

    protected void setArray(LongBuffer buf) {
        this._classType = buf.getClass();
        this._longs = buf;
        this._length = this._bufLength = buf.capacity();
    }

    protected void setArray(FloatBuffer buf) {
        this._classType = buf.getClass();
        this._floats = buf;
        this._length = this._bufLength = buf.capacity();
    }

    protected void setArray(DoubleBuffer buf) {
        this._classType = buf.getClass();
        this._doubles = buf;
        this._length = this._bufLength = buf.capacity();
    }

    @Override
    public void allocate() {
        if (this._classType == Byte.TYPE) {
            this._bytes = ByteBuffer.allocate(this._bufLength);
        } else if (this._classType == Integer.TYPE) {
            this._ints = IntBuffer.allocate(this._bufLength);
        } else if (this._classType == Long.TYPE) {
            this._longs = LongBuffer.allocate(this._bufLength);
        } else if (this._classType == Short.TYPE) {
            this._shorts = ShortBuffer.allocate(this._bufLength);
        } else if (this._classType == Float.TYPE) {
            this._floats = FloatBuffer.allocate(this._bufLength);
        } else if (this._classType == Double.TYPE) {
            this._doubles = DoubleBuffer.allocate(this._bufLength);
        } else {
            throw new RuntimeException("Object array allocation is not supported");
        }
    }

    @Override
    public void getArray(byte[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._bytes.position(pos);
        this._bytes.limit(pos + length);
        this._bytes.get(buf, offset, length);
    }

    @Override
    public void getArray(short[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._shorts.position(pos);
        this._shorts.limit(pos + length);
        this._shorts.get(buf, offset, length);
    }

    @Override
    public void getArray(int[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._ints.position(pos);
        this._ints.limit(pos + length);
        this._ints.get(buf, offset, length);
    }

    @Override
    public void getArray(long[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._longs.position(pos);
        this._longs.limit(pos + length);
        this._longs.get(buf, offset, length);
    }

    @Override
    public void getArray(float[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._floats.position(pos);
        this._floats.limit(pos + length);
        this._floats.get(buf, offset, length);
    }

    @Override
    public void getArray(double[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._doubles.position(pos);
        this._doubles.limit(pos + length);
        this._doubles.get(buf, offset, length);
    }

    @Override
    public <T> void getArray(T[] buf, int offset, int length, long index) {
        throw new UnsupportedOperationException("Object class not supported");
    }

    @Override
    public byte getByte(long index) {
        return this._bytes.get((int)(index + (long)this._offset));
    }

    @Override
    public short getShort(long index) {
        return this._shorts.get((int)(index + (long)this._offset));
    }

    @Override
    public int getInt(long index) {
        return this._ints.get((int)(index + (long)this._offset));
    }

    @Override
    public long getLong(long index) {
        return this._longs.get((int)(index + (long)this._offset));
    }

    @Override
    public float getFloat(long index) {
        return this._floats.get((int)(index + (long)this._offset));
    }

    @Override
    public double getDouble(long index) {
        return this._doubles.get((int)(index + (long)this._offset));
    }

    @Override
    public <T> T getObject(long index) {
        throw new UnsupportedOperationException("Object class not supported");
    }

    @Override
    public void putArray(byte[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._bytes.position(pos);
        this._bytes.limit(pos + length);
        this._bytes.get(buf, offset, length);
    }

    @Override
    public void putArray(short[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._shorts.position(pos);
        this._shorts.limit(pos + length);
        this._shorts.put(buf, offset, length);
    }

    @Override
    public void putArray(int[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._ints.position(pos);
        this._ints.limit(pos + length);
        this._ints.put(buf, offset, length);
    }

    @Override
    public void putArray(long[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._longs.position(pos);
        this._longs.limit(pos + length);
        this._longs.put(buf, offset, length);
    }

    @Override
    public void putArray(float[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._floats.position(pos);
        this._floats.limit(pos + length);
        this._floats.put(buf, offset, length);
    }

    @Override
    public void putArray(double[] buf, int offset, int length, long index) {
        int pos = (int)(index + (long)this._offset);
        this._doubles.position(pos);
        this._doubles.limit(pos + length);
        this._doubles.put(buf, offset, length);
    }

    @Override
    public <T> void putArray(T[] buf, int offset, int length, long index) {
        throw new UnsupportedOperationException("Object class not supported");
    }

    @Override
    public void putByte(byte buf, long index) {
        this._bytes.put((int)(index + (long)this._offset), buf);
    }

    @Override
    public void putDouble(double buf, long index) {
        this._doubles.put((int)(index + (long)this._offset), buf);
    }

    @Override
    public void putFloat(float buf, long index) {
        this._floats.put((int)(index + (long)this._offset), buf);
    }

    @Override
    public void putInt(int buf, long index) {
        this._ints.put((int)(index + (long)this._offset), buf);
    }

    @Override
    public void putLong(long buf, long index) {
        this._longs.put((int)(index + (long)this._offset), buf);
    }

    @Override
    public void putShort(short buf, long index) {
        this._shorts.put((int)(index + (long)this._offset), buf);
    }

    @Override
    public <T> void putObject(T buf, long index) {
        throw new UnsupportedOperationException("Object class not supported");
    }

    @Override
    public void fill(byte value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._bytes.put(ia, value);
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(short value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._shorts.put(ia, value);
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(int value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._ints.put(ia, value);
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(long value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._longs.put(ia, value);
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(float value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._floats.put(ia, value);
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(double value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._doubles.put(ia, value);
            ++i;
            ia += inc;
        }
    }

    @Override
    public <T> void fill(T value, long index, long stride, long count) {
        throw new UnsupportedOperationException("Object class not supported");
    }

    @Override
    public BackingArray.Type getBackingArrayType() {
        return BackingArray.Type.BYTE_BUFFER;
    }
}

