/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.ECKA;
import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.spec.SharedInfoParameterSpec;
import com.certicom.ecc.util.JDKVersion;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class ECDHSpi
extends ECKA {
    protected ECDHSpi() {
        this(null, false);
    }

    protected ECDHSpi(boolean bl) {
        this(null, bl);
    }

    protected ECDHSpi(String string, boolean bl) {
        super("ECDH");
        if (string == null) {
            this.b = new Object[4];
        } else {
            this.b = new Object[5];
            this.b[4] = string;
        }
        this.b[3] = new Boolean(bl);
        this.c = 7;
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        key = JDKVersion.getTranslator().translateECKey_1_5_to_1_3(key);
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("incompatible public key.");
        }
        this.b[1] = key;
        return null;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(key, secureRandom);
        if (algorithmParameterSpec instanceof javax.security.spec.SharedInfoParameterSpec) {
            javax.security.spec.SharedInfoParameterSpec sharedInfoParameterSpec = (javax.security.spec.SharedInfoParameterSpec)algorithmParameterSpec;
            this.b[2] = new SharedInfoParameterSpec(sharedInfoParameterSpec.getSharedInfo());
        }
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        key = JDKVersion.getTranslator().translateECKey_1_5_to_1_3(key);
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("incompatible private key");
        }
        this.b[0] = key;
    }

    protected boolean a() {
        return this.b[0] != null && this.b[1] != null;
    }

    public static class ECDHWithKDFSHA512
    extends ECDHSpi {
        public ECDHWithKDFSHA512() {
            this(false);
        }

        public ECDHWithKDFSHA512(boolean bl) {
            super("SHA512", bl);
            this.d = 64;
        }

        public static class CF
        extends ECDHWithKDFSHA512 {
            public CF() {
                super(true);
            }
        }
    }

    public static class ECDHWithKDFSHA384
    extends ECDHSpi {
        public ECDHWithKDFSHA384() {
            this(false);
        }

        public ECDHWithKDFSHA384(boolean bl) {
            super("SHA384", bl);
            this.d = 48;
        }

        public static class CF
        extends ECDHWithKDFSHA384 {
            public CF() {
                super(true);
            }
        }
    }

    public static class ECDHWithKDFSHA256
    extends ECDHSpi {
        public ECDHWithKDFSHA256() {
            this(false);
        }

        public ECDHWithKDFSHA256(boolean bl) {
            super("SHA256", bl);
            this.d = 32;
        }

        public static class CF
        extends ECDHWithKDFSHA256 {
            public CF() {
                super(true);
            }
        }
    }

    public static class ECDHWithKDFSHA224
    extends ECDHSpi {
        public ECDHWithKDFSHA224() {
            this(false);
        }

        public ECDHWithKDFSHA224(boolean bl) {
            super("SHA224", bl);
            this.d = 28;
        }

        public static class CF
        extends ECDHWithKDFSHA224 {
            public CF() {
                super(true);
            }
        }
    }

    public static class ECDHWithKDFSHA1
    extends ECDHSpi {
        public ECDHWithKDFSHA1() {
            this(false);
        }

        public ECDHWithKDFSHA1(boolean bl) {
            super("SHA1", bl);
            this.d = 20;
        }

        public static class CF
        extends ECDHWithKDFSHA1 {
            public CF() {
                super(true);
            }
        }
    }
}

